/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.VectorOfString;
import org.scilab.modules.xcos.actions.SetContextAction;
import org.scilab.modules.xcos.graph.ScicosParameters;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.utils.XcosMessages;

public class SetContextDialog
extends JDialog {
    private static final Dimension PREFERRED_SIZE = new Dimension(480, 320);
    private static final String SHARED_NEW_LINE = "\n";
    private final ScicosParameters parameters;
    private final XcosDiagram rootGraph;
    private JTextArea contextArea;

    public SetContextDialog(Component component, XcosDiagram xcosDiagram, ScicosParameters scicosParameters) {
        this.parameters = scicosParameters;
        ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"scilab"));
        Image image = imageIcon.getImage();
        this.setLayout(new GridBagLayout());
        this.setIconImage(image);
        this.setTitle(XcosMessages.SET_CONTEXT);
        this.setModal(true);
        this.setLocationRelativeTo(component);
        this.rootGraph = xcosDiagram;
        this.setDefaultCloseOperation(2);
        ScilabSwingUtilities.closeOnEscape((Window)this);
        this.initComponents();
    }

    private void initComponents() {
        JLabel jLabel = new JLabel(XcosMessages.SET_CONTEXT_LABEL_TEXT);
        this.contextArea = new JTextArea();
        VectorOfString vectorOfString = this.parameters.getContext(new JavaController());
        int n = vectorOfString.size();
        for (int i = 0; i < n; ++i) {
            this.contextArea.append(vectorOfString.get(i) + SHARED_NEW_LINE);
        }
        JScrollPane jScrollPane = new JScrollPane(this.contextArea, 20, 30);
        JButton jButton = new JButton(XcosMessages.CANCEL);
        JButton jButton2 = new JButton(XcosMessages.OK);
        jButton2.setMnemonic(10);
        jButton2.setPreferredSize(jButton.getPreferredSize());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 10, 10);
        this.add((Component)jPanel, gridBagConstraints);
        this.installActionListeners(jButton, jButton2);
        this.setPreferredSize(PREFERRED_SIZE);
    }

    private void installActionListeners(JButton jButton, JButton jButton2) {
        jButton.addActionListener(actionEvent -> this.dispose());
        jButton2.addActionListener(new ActionListenerImpl());
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n;
                String string = SetContextDialog.this.contextArea.getText();
                VectorOfString vectorOfString = new VectorOfString();
                if (string.length() > 0 && !string.endsWith(SetContextDialog.SHARED_NEW_LINE)) {
                    string = string + '\n';
                }
                int n2 = 0;
                while ((n = string.indexOf(10, n2)) != -1) {
                    vectorOfString.add(string.substring(n2, n));
                    n2 = n + 1;
                }
                SetContextDialog.this.parameters.setContext(new JavaController(), vectorOfString);
                try {
                    File file = File.createTempFile("context", ".sce");
                    try (FileWriter fileWriter = new FileWriter(file);){
                        fileWriter.write(string, 0, string.length());
                    }
                    ScilabInterpreterManagement.putCommandInScilabQueue((String)("var = script2var(mgetl(\"" + file.getAbsolutePath() + "\"), struct()); mdelete(\"" + file.getAbsolutePath() + "\");"));
                }
                catch (IOException iOException) {
                    Logger.getLogger(SetContextAction.class.getName()).severe(iOException.toString());
                }
                SetContextDialog.this.dispose();
            }
            catch (PropertyVetoException propertyVetoException) {
                Logger.getLogger(SetContextAction.class.getName()).severe(propertyVetoException.toString());
            }
        }
    }
}

