/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.gui.bridge.filechooser.SwingScilabFileChooser;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.io.XcosFileType;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class OpenAction
extends DefaultAction {
    public static final String NAME = XcosMessages.OPEN;
    public static final String SMALL_ICON = "document-open";
    public static final int MNEMONIC_KEY = 79;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public OpenAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return OpenAction.createMenu((ScilabGraph)scilabGraph, OpenAction.class);
    }

    public static JButton createButton(ScilabGraph scilabGraph) {
        return OpenAction.createButton((ScilabGraph)scilabGraph, OpenAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SwingScilabFileChooser swingScilabFileChooser = OpenAction.createFileChooser();
        OpenAction.configureFileFilters((JFileChooser)swingScilabFileChooser);
        ConfigurationManager.configureCurrentDirectory((JFileChooser)swingScilabFileChooser);
        try {
            OpenAction.displayAndOpen(swingScilabFileChooser, (Component)this.getGraph(actionEvent).getAsComponent());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static SwingScilabFileChooser createFileChooser() {
        SwingScilabFileChooser swingScilabFileChooser = (SwingScilabFileChooser)ScilabFileChooser.createFileChooser().getAsSimpleFileChooser();
        swingScilabFileChooser.setTitle(XcosMessages.OPEN);
        swingScilabFileChooser.setUiDialogType(0);
        swingScilabFileChooser.setMultipleSelection(true);
        return swingScilabFileChooser;
    }

    public static void configureFileFilters(JFileChooser jFileChooser) {
        FileFilter[] fileFilterArray;
        jFileChooser.setAcceptAllFileFilterUsed(true);
        for (FileFilter fileFilter : fileFilterArray = XcosFileType.getLoadingFilters()) {
            jFileChooser.addChoosableFileFilter(fileFilter);
        }
        jFileChooser.setFileFilter(fileFilterArray[0]);
    }

    protected static void displayAndOpen(SwingScilabFileChooser swingScilabFileChooser, Component component) throws IOException {
        File[] fileArray;
        int n = swingScilabFileChooser.showOpenDialog(component);
        if (n != 0) {
            return;
        }
        File file = swingScilabFileChooser.getSelectedFile();
        if (file != null) {
            Xcos.getInstance().open(file.getCanonicalPath(), 0L);
        }
        for (File file2 : fileArray = swingScilabFileChooser.getSelectedFiles()) {
            if (file2 == file) continue;
            Xcos.getInstance().open(file2.getCanonicalPath(), 0L);
        }
    }
}

