/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.utils.BlockPositioning;

public final class ExternalAction
extends DefaultAction {
    public static final String NAME = "";
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = 0;
    final String localCommand;

    public ExternalAction(ScilabGraph scilabGraph, String string) {
        super(scilabGraph);
        this.localCommand = string;
    }

    public ExternalAction(ExternalAction externalAction, XcosDiagram xcosDiagram) {
        super((ScilabGraph)xcosDiagram);
        this.putValue("Name", externalAction.getValue("Name"));
        this.localCommand = externalAction.localCommand;
    }

    private static void reset_view(XcosDiagram xcosDiagram, BasicBlock basicBlock, boolean bl) {
        if (basicBlock != null) {
            basicBlock.setLocked(bl);
        }
        int n = bl ? 3 : 0;
        xcosDiagram.getAsComponent().getGraphControl().setCursor(Cursor.getPredefinedCursor(n));
        xcosDiagram.setCellsLocked(bl);
        xcosDiagram.getView().clear(xcosDiagram.getCurrentRoot(), true, true);
    }

    public void actionPerformed(ActionEvent actionEvent2) {
        BasicBlock basicBlock;
        final XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(actionEvent2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("scs_m = scicos_new(\"0x").append(Long.toHexString(xcosDiagram.getUID())).append("\"); \n");
        Object object = xcosDiagram.getSelectionCell();
        if (object instanceof BasicBlock) {
            basicBlock = (BasicBlock)object;
            stringBuilder.append("blk = scicos_new(\"0x").append(Long.toHexString(basicBlock.getUID())).append("\"); \n");
            stringBuilder.append(this.localCommand).append('\n');
            stringBuilder.append("if exists('blk') then xcosCellCreated(blk); end\n");
        } else {
            basicBlock = null;
            stringBuilder.append("blk = [];\n");
            stringBuilder.append(this.localCommand).append('\n');
        }
        ActionListener actionListener = basicBlock != null ? new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                xcosDiagram.getModel().beginUpdate();
                try {
                    JavaController javaController;
                    BasicBlock basicBlock2;
                    ScicosObjectOwner scicosObjectOwner = XcosCellFactory.getLastCreated();
                    if (scicosObjectOwner != null && scicosObjectOwner.getUID() != 0L && (basicBlock2 = XcosCellFactory.createBlock(javaController = new JavaController(), scicosObjectOwner)) != null) {
                        basicBlock.updateBlockSettings(javaController, xcosDiagram, basicBlock2);
                    }
                    BlockPositioning.updateBlockView(xcosDiagram, basicBlock);
                }
                finally {
                    xcosDiagram.getModel().endUpdate();
                    ExternalAction.reset_view(xcosDiagram, basicBlock, false);
                }
            }
        } : actionEvent -> ExternalAction.reset_view(xcosDiagram, basicBlock, false);
        try {
            ExternalAction.reset_view(xcosDiagram, basicBlock, true);
            ScilabInterpreterManagement.asynchronousScilabExec((ActionListener)actionListener, (String)stringBuilder.toString());
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            ExternalAction.reset_view(xcosDiagram, basicBlock, false);
        }
    }
}

