/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.graph.utils.ScilabGraphRenderer;
import org.scilab.modules.gui.bridge.filechooser.FileMask;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.utils.XcosMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class ExportAllAction
extends DefaultAction {
    public static final String NAME = XcosMessages.EXPORT_ALL;
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String HTML = "html";
    private static final String VML = "vml";
    private static final String SVG = "svg";
    private boolean useBackground = true;

    public ExportAllAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return ExportAllAction.createMenu((ScilabGraph)scilabGraph, ExportAllAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram = ((XcosDiagram)this.getGraph(null)).getRootDiagram();
        List<String> list = Arrays.asList(ImageIO.getWriterFileSuffixes());
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.add(SVG);
        treeSet.add(HTML);
        treeSet.add(VML);
        treeSet.addAll(list);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(XcosMessages.EXPORT_ALL + "...");
        jFileChooser.setApproveButtonText(XcosMessages.EXPORT);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        for (String object : treeSet) {
            jFileChooser.addChoosableFileFilter((FileFilter)new FileMask(object, object.toUpperCase()));
        }
        ConfigurationManager.configureCurrentDirectory(jFileChooser);
        int n = jFileChooser.showSaveDialog((Component)this.getGraph(null).getAsComponent());
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = ((FileMask)jFileChooser.getFileFilter()).getExtensionFromFilter();
            if (!string.equalsIgnoreCase("png") || ScilabModalDialog.show((SimpleTab)XcosTab.get((XcosDiagram)this.getGraph(null)), (String)XcosMessages.TRANSPARENT_BACKGROUND, (String)XcosMessages.XCOS, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) != ScilabModalDialog.AnswerOption.YES_OPTION) {
                this.useBackground = true;
            }
            JavaController javaController = new JavaController();
            ArrayList<XcosDiagram> arrayList = new ArrayList<XcosDiagram>();
            arrayList.add(xcosDiagram);
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            this.allocateDiagrams(javaController, arrayList, arrayList2, xcosDiagram.getUID(), Kind.DIAGRAM);
            while (!arrayList2.isEmpty()) {
                long l = arrayList2.remove(arrayList2.size() - 1);
                this.allocateDiagrams(javaController, arrayList, arrayList2, l, Kind.BLOCK);
            }
            try {
                this.export(xcosDiagram, new File(file, xcosDiagram.getTitle() + "." + string), string);
                for (XcosDiagram xcosDiagram2 : arrayList) {
                    this.export(xcosDiagram2, new File(file, xcosDiagram2.getTitle() + "." + string), string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void allocateDiagrams(JavaController javaController, ArrayList<XcosDiagram> arrayList, ArrayList<Long> arrayList2, long l, Kind kind) {
        VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
        javaController.getObjectProperty(l, kind, ObjectProperties.CHILDREN, vectorOfScicosID);
        int n = vectorOfScicosID.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = new String[1];
            long l2 = vectorOfScicosID.get(i);
            if (javaController.getKind(l2) != Kind.BLOCK) continue;
            javaController.getObjectProperty(vectorOfScicosID.get(i), Kind.BLOCK, ObjectProperties.INTERFACE_FUNCTION, stringArray);
            if (!"SUPER_f".equals(stringArray[0]) || !arrayList.stream().noneMatch(xcosDiagram -> xcosDiagram.getUID() == l2)) continue;
            String[] stringArray2 = new String[1];
            javaController.getObjectProperty(l2, Kind.BLOCK, ObjectProperties.UID, stringArray2);
            XcosDiagram xcosDiagram2 = new XcosDiagram(javaController, l2, Kind.BLOCK, stringArray2[0]);
            arrayList.add(xcosDiagram2);
            arrayList2.add(l2);
        }
    }

    private void export(XcosDiagram xcosDiagram, File file, String string) throws IOException {
        file.getParentFile().mkdirs();
        if (string.equalsIgnoreCase(SVG)) {
            ScilabGraphRenderer.createSvgDocument((mxGraph)xcosDiagram, null, (double)1.0, null, null, (String)file.getCanonicalPath());
        } else if (string.equalsIgnoreCase(VML)) {
            Document document = mxCellRenderer.createVmlDocument((mxGraph)xcosDiagram, null, (double)1.0, null, null);
            if (document != null) {
                mxUtils.writeFile((String)mxXmlUtils.getXml((Node)document.getDocumentElement()), (String)file.getCanonicalPath());
            }
        } else if (string.equalsIgnoreCase(HTML)) {
            Document document = mxCellRenderer.createHtmlDocument((mxGraph)xcosDiagram, null, (double)1.0, null, null);
            if (document != null) {
                mxUtils.writeFile((String)mxXmlUtils.getXml((Node)document.getDocumentElement()), (String)file.getCanonicalPath());
            }
        } else {
            this.exportBufferedImage(xcosDiagram, file, string);
        }
    }

    private void exportBufferedImage(XcosDiagram xcosDiagram, File file, String string) throws IOException {
        BufferedImage bufferedImage;
        mxGraphComponent mxGraphComponent2 = xcosDiagram.getAsComponent();
        Color color = null;
        if (this.useBackground) {
            color = mxGraphComponent2.getBackground();
        }
        if ((bufferedImage = mxCellRenderer.createBufferedImage((mxGraph)xcosDiagram, null, (double)1.0, (Color)color, (boolean)mxGraphComponent2.isAntiAlias(), null, (mxGraphics2DCanvas)mxGraphComponent2.getCanvas())) != null) {
            ImageIO.write((RenderedImage)bufferedImage, string, file);
        } else {
            JOptionPane.showMessageDialog((Component)mxGraphComponent2, XcosMessages.NO_IMAGE_DATA);
        }
    }
}

