/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.graph.utils.ScilabGraphRenderer;
import org.scilab.modules.gui.bridge.filechooser.FileMask;
import org.scilab.modules.gui.bridge.filechooser.ImagePreview;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.utils.XcosMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class ExportAction
extends DefaultAction {
    public static final String NAME = XcosMessages.EXPORT;
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 69;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String HTML = "html";
    private static final String VML = "vml";
    private static final String SVG = "svg";

    public ExportAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return ExportAction.createMenu((ScilabGraph)scilabGraph, ExportAction.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(null);
        List<String> list = Arrays.asList(ImageIO.getWriterFileSuffixes());
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.add(SVG);
        treeSet.add(HTML);
        treeSet.add(VML);
        treeSet.addAll(list);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(XcosMessages.EXPORT);
        jFileChooser.setApproveButtonText(XcosMessages.EXPORT);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        for (String string : treeSet) {
            jFileChooser.addChoosableFileFilter((FileFilter)new FileMask(string, string.toUpperCase()));
        }
        ConfigurationManager.configureCurrentDirectory(jFileChooser);
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Messages.gettext((String)"Preview"));
        jPanel.setBorder(titledBorder);
        jPanel.add((Component)new ImagePreview(jFileChooser));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        jPanel2.setVisible(true);
        jFileChooser.setAccessory(jPanel2);
        int n = jFileChooser.showSaveDialog((Component)xcosDiagram.getAsComponent());
        if (n != 0) return;
        File file = jFileChooser.getSelectedFile();
        String string = this.getFormat(xcosDiagram, jFileChooser, file);
        while (string == null) {
            n = jFileChooser.showSaveDialog((Component)xcosDiagram.getAsComponent());
            if (n != 0) return;
            file = jFileChooser.getSelectedFile();
            string = this.getFormat(xcosDiagram, jFileChooser, file);
        }
        try {
            if (FileMask.getExtension((File)file) == null || FileMask.getExtension((File)file).isEmpty()) {
                file = new File(file.getCanonicalPath() + '.' + string);
            }
            if (file.exists()) {
                if (ScilabModalDialog.show((SimpleTab)XcosTab.get(xcosDiagram), (String)XcosMessages.OVERWRITE_EXISTING_FILE, (String)XcosMessages.XCOS, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) != ScilabModalDialog.AnswerOption.YES_OPTION) return;
                boolean bl = true;
                boolean bl2 = bl;
                if (!bl2) return;
                this.export(xcosDiagram, file, string);
                return;
            } else {
                this.export(xcosDiagram, file, string);
            }
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger(ExportAction.class.getName()).severe(actionEvent.toString());
        }
    }

    private String getFormat(XcosDiagram xcosDiagram, JFileChooser jFileChooser, File file) {
        FileFilter fileFilter = jFileChooser.getFileFilter();
        Object object = !(fileFilter instanceof FileMask) ? (FileMask.getExtension((File)file) == null || FileMask.getExtension((File)file).isEmpty() ? null : FileMask.getExtension((File)file)) : ((FileMask)fileFilter).getExtensionFromFilter();
        boolean bl = this.isValidFormat((String)object);
        if (object == null || !bl) {
            JOptionPane.showMessageDialog((Component)xcosDiagram.getAsComponent(), Messages.gettext((String)"Please specify a valid file format"), Messages.gettext((String)"Error on export"), 0);
        }
        if (bl) {
            return object;
        }
        return null;
    }

    private boolean isValidFormat(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix(string);
        List<String> list = Arrays.asList(SVG, HTML, VML);
        return iterator.hasNext() || list.contains(string.toLowerCase());
    }

    private void export(XcosDiagram xcosDiagram, File file, String string) throws IOException {
        if (string.equalsIgnoreCase(SVG)) {
            ScilabGraphRenderer.createSvgDocument((mxGraph)xcosDiagram, null, (double)1.0, null, null, (String)file.getCanonicalPath());
        } else if (string.equalsIgnoreCase(VML)) {
            Document document = mxCellRenderer.createVmlDocument((mxGraph)xcosDiagram, null, (double)1.0, null, null);
            if (document != null) {
                mxUtils.writeFile((String)mxXmlUtils.getXml((Node)document.getDocumentElement()), (String)file.getCanonicalPath());
            }
        } else if (string.equalsIgnoreCase(HTML)) {
            Document document = mxCellRenderer.createHtmlDocument((mxGraph)xcosDiagram, null, (double)1.0, null, null);
            if (document != null) {
                mxUtils.writeFile((String)mxXmlUtils.getXml((Node)document.getDocumentElement()), (String)file.getCanonicalPath());
            }
        } else {
            this.exportBufferedImage(xcosDiagram, file, string);
        }
    }

    private void exportBufferedImage(XcosDiagram xcosDiagram, File file, String string) throws IOException {
        BufferedImage bufferedImage;
        mxGraphComponent mxGraphComponent2 = xcosDiagram.getAsComponent();
        Color color = null;
        if (!string.equalsIgnoreCase("png") || ScilabModalDialog.show((SimpleTab)XcosTab.get(xcosDiagram), (String)XcosMessages.TRANSPARENT_BACKGROUND, (String)XcosMessages.XCOS, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) != ScilabModalDialog.AnswerOption.YES_OPTION) {
            color = mxGraphComponent2.getBackground();
        }
        if ((bufferedImage = mxCellRenderer.createBufferedImage((mxGraph)xcosDiagram, null, (double)1.0, (Color)color, (boolean)mxGraphComponent2.isAntiAlias(), null, (mxGraphics2DCanvas)mxGraphComponent2.getCanvas())) != null) {
            ImageIO.write((RenderedImage)bufferedImage, string, file);
        } else {
            JOptionPane.showMessageDialog((Component)mxGraphComponent2, XcosMessages.NO_IMAGE_DATA);
        }
    }
}

