/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.actions;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.scilab.modules.graph.ScilabComponent;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.xcos.Controller;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.block.SuperBlock;
import org.scilab.modules.xcos.block.TextBlock;
import org.scilab.modules.xcos.block.io.ContextUpdate;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.graph.model.XcosGraphModel;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class EditFormatAction
extends DefaultAction {
    public static final String NAME = XcosMessages.EDIT + "...";
    public static final String SMALL_ICON = "select-by-color";
    public static final int MNEMONIC_KEY = 113;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final Color DEFAULT_BORDERCOLOR = Color.BLACK;
    private static final Color DEFAULT_FILLCOLOR = Color.WHITE;

    public EditFormatAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return EditFormatAction.createMenu((ScilabGraph)scilabGraph, EditFormatAction.class);
    }

    public static void showDialog(ScilabComponent scilabComponent, String string, mxCell mxCell2, XcosDiagram xcosDiagram) {
        Frame frame = JOptionPane.getFrameForComponent((Component)scilabComponent);
        EditFormatDialog editFormatDialog = EditFormatAction.createDialog(mxCell2, xcosDiagram, frame);
        editFormatDialog.setName(string);
        editFormatDialog.setVisible(true);
    }

    private static EditFormatDialog createDialog(mxCell mxCell2, XcosDiagram xcosDiagram, Frame frame) {
        Object object;
        StyleMap styleMap;
        mxCell mxCell3;
        String string = null;
        mxGraphModel mxGraphModel2 = (mxGraphModel)xcosDiagram.getModel();
        StyleMap styleMap2 = new StyleMap(mxCell2.getStyle());
        if (mxCell2 instanceof TextBlock) {
            mxCell3 = mxCell2;
            styleMap = styleMap2;
        } else {
            mxCell3 = xcosDiagram.getOrCreateCellIdentifier(mxCell2);
            styleMap = new StyleMap(mxCell3.getStyle());
        }
        String string2 = (String)styleMap2.get((Object)mxConstants.STYLE_STROKECOLOR);
        Color color = string2 == null ? DEFAULT_BORDERCOLOR : mxUtils.parseColor((String)string2);
        string2 = (String)styleMap2.get((Object)mxConstants.STYLE_FILLCOLOR);
        Color color2 = string2 == null ? DEFAULT_FILLCOLOR : mxUtils.parseColor((String)string2);
        string2 = (String)styleMap.get((Object)mxConstants.STYLE_FONTFAMILY);
        String string3 = string2 == null ? mxConstants.DEFAULT_FONTFAMILY : string2;
        string2 = (String)styleMap.get((Object)mxConstants.STYLE_FONTSIZE);
        int n = string2 == null ? mxConstants.DEFAULT_FONTSIZE : Integer.parseInt(string2);
        string2 = (String)styleMap.get((Object)mxConstants.STYLE_FONTSTYLE);
        int n2 = string2 == null ? 0 : Integer.parseInt(string2);
        string2 = (String)styleMap.get((Object)mxConstants.STYLE_FONTCOLOR);
        Color color3 = string2 == null ? Color.BLACK : mxUtils.parseColor((String)string2);
        string2 = (String)styleMap2.get((Object)mxConstants.STYLE_IMAGE);
        if (string2 != null) {
            string = string2;
        }
        String string4 = (object = mxGraphModel2.getValue((Object)mxCell2)) == null ? "" : object.toString();
        Object object2 = mxGraphModel2.getValue((Object)mxCell3);
        String string5 = object2 == null ? "" : mxUtils.getBodyMarkup((String)object2.toString(), (boolean)false);
        EditFormatDialog editFormatDialog = new EditFormatDialog(frame);
        editFormatDialog.setValues(color, color2, string3, n, n2, color3, string4, string5, string);
        editFormatDialog.setGraph(xcosDiagram);
        editFormatDialog.setCell(mxCell2);
        return editFormatDialog;
    }

    private static void updateFromDialog(EditFormatDialog editFormatDialog, Color color, Color color2, String string, int n, Color color3, boolean bl, boolean bl2, String string2, String string3, String string4) {
        StyleMap styleMap;
        mxCell mxCell2;
        XcosDiagram xcosDiagram = editFormatDialog.getGraph();
        mxGraphModel mxGraphModel2 = (mxGraphModel)xcosDiagram.getModel();
        mxCell mxCell3 = editFormatDialog.getCell();
        StyleMap styleMap2 = new StyleMap(mxCell3.getStyle());
        if (mxCell3 instanceof TextBlock) {
            mxCell2 = mxCell3;
            styleMap = styleMap2;
        } else {
            mxCell2 = xcosDiagram.getOrCreateCellIdentifier(mxCell3);
            styleMap = new StyleMap(mxCell2.getStyle());
        }
        if (!color.equals(DEFAULT_BORDERCOLOR)) {
            styleMap2.put((Object)mxConstants.STYLE_STROKECOLOR, (Object)mxUtils.hexString((Color)color));
        } else {
            styleMap2.remove((Object)mxConstants.STYLE_STROKECOLOR);
        }
        if (!color2.equals(DEFAULT_FILLCOLOR)) {
            styleMap2.put((Object)mxConstants.STYLE_FILLCOLOR, (Object)mxUtils.hexString((Color)color2));
        } else {
            styleMap2.remove((Object)mxConstants.STYLE_FILLCOLOR);
        }
        if (!string.equals(mxConstants.DEFAULT_FONTFAMILY)) {
            styleMap.put((Object)mxConstants.STYLE_FONTFAMILY, (Object)string);
        } else {
            styleMap.remove((Object)mxConstants.STYLE_FONTFAMILY);
        }
        EditFormatAction.applyFontStyle(bl, bl2, styleMap);
        if (n != mxConstants.DEFAULT_FONTSIZE) {
            styleMap.put((Object)mxConstants.STYLE_FONTSIZE, (Object)Integer.toString(n));
        } else {
            styleMap.remove((Object)mxConstants.STYLE_FONTSIZE);
        }
        if (!color3.equals(DEFAULT_BORDERCOLOR)) {
            styleMap.put((Object)mxConstants.STYLE_FONTCOLOR, (Object)mxUtils.hexString((Color)color3));
        } else {
            styleMap.remove((Object)mxConstants.STYLE_FONTCOLOR);
        }
        EditFormatAction.applyImage(string4, styleMap2);
        mxGraphModel2.setStyle((Object)mxCell3, styleMap2.toString());
        if (mxCell3 != mxCell2) {
            mxGraphModel2.setStyle((Object)mxCell2, styleMap.toString());
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (char c : string2.toCharArray()) {
            if ('0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_') {
                stringBuilder.append(c);
            }
            if (c != ' ') continue;
            stringBuilder.append('_');
        }
        if (stringBuilder.length() > 0 && '0' <= stringBuilder.charAt(0) && stringBuilder.charAt(0) <= '9') {
            stringBuilder.insert(0, '_');
        }
        string2 = stringBuilder.toString();
        xcosDiagram.cellLabelChanged(mxCell3, string2, false);
        xcosDiagram.fireEvent(new mxEventObject("labelChanged", new Object[]{"cell", mxCell3, "value", string3, "parent", mxCell3.getParent()}));
        xcosDiagram.cellLabelChanged(mxCell2, string3, false);
        xcosDiagram.fireEvent(new mxEventObject("labelChanged", new Object[]{"cell", mxCell2, "value", string3, "parent", mxCell3}));
        if (mxCell3 instanceof ContextUpdate) {
            Object object = new JavaController();
            VectorOfInt vectorOfInt = new VectorOfInt();
            ((Controller)object).getObjectProperty(((ContextUpdate)mxCell3).getUID(), Kind.BLOCK, ObjectProperties.IPAR, vectorOfInt);
            int n2 = vectorOfInt.size() > 0 ? vectorOfInt.get(0) : 1;
            XcosCell xcosCell = (XcosCell)((Object)xcosDiagram.getDefaultParent());
            XcosDiagram xcosDiagram2 = Xcos.findParent((JavaController)object, xcosCell.getUID(), xcosCell.getKind());
            if (xcosDiagram2 != null) {
                List<mxICell> list;
                String[] stringArray = new String[]{""};
                ((Controller)object).getObjectProperty(xcosCell.getUID(), xcosCell.getKind(), ObjectProperties.UID, stringArray);
                XcosGraphModel xcosGraphModel = (XcosGraphModel)xcosDiagram2.getModel();
                Object object2 = xcosGraphModel.getCell(stringArray[0]);
                if (object2 instanceof SuperBlock && (list = ContextUpdate.IOBlocks.getPorts((SuperBlock)object2, mxCell3.getClass())).size() >= n2) {
                    mxICell mxICell2 = list.get(n2 - 1);
                    xcosDiagram2.cellLabelChanged(mxICell2, string2, false);
                    xcosDiagram2.fireEvent(new mxEventObject("labelChanged", new Object[]{"cell", mxICell2, "value", string3, "parent", object2}));
                }
            }
        }
    }

    private static void reset(EditFormatDialog editFormatDialog) {
        XcosDiagram xcosDiagram = editFormatDialog.getGraph();
        mxGraphModel mxGraphModel2 = (mxGraphModel)xcosDiagram.getModel();
        mxCell mxCell2 = editFormatDialog.getCell();
        StyleMap styleMap = new StyleMap(mxCell2.getStyle());
        if (mxCell2 instanceof TextBlock) {
            mxCell mxCell3 = mxCell2;
        } else {
            mxCell mxCell4 = xcosDiagram.getCellIdentifier(mxCell2);
            if (mxCell4 != null) {
                mxGraphModel2.remove((Object)mxCell4);
            }
        }
        styleMap.clear();
        editFormatDialog.setValues(DEFAULT_BORDERCOLOR, DEFAULT_FILLCOLOR, mxConstants.DEFAULT_FONTFAMILY, mxConstants.DEFAULT_FONTSIZE, 0, DEFAULT_BORDERCOLOR, "", "", null);
        editFormatDialog.updateFont();
    }

    private static void applyImage(String string, StyleMap styleMap) {
        if (string != null && !string.isEmpty()) {
            String string2;
            try {
                URL uRL = new URL(string);
                string2 = uRL.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                string2 = string;
            }
            styleMap.put((Object)mxConstants.STYLE_IMAGE, (Object)string2);
        } else {
            styleMap.remove((Object)mxConstants.STYLE_IMAGE);
        }
    }

    private static void applyFontStyle(boolean bl, boolean bl2, StyleMap styleMap) {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        if (n != 0) {
            styleMap.put((Object)mxConstants.STYLE_FONTSTYLE, (Object)Integer.toString(n));
        } else {
            styleMap.remove((Object)mxConstants.STYLE_FONTSTYLE);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(null);
        Object object = xcosDiagram.getSelectionCell();
        if (object == null) {
            return;
        }
        EditFormatAction.showDialog((ScilabComponent)xcosDiagram.getAsComponent(), NAME, (mxCell)object, xcosDiagram);
        xcosDiagram.getView().clear(object, true, true);
        xcosDiagram.refresh();
    }

    private static final class EditFormatDialog
    extends JDialog {
        private static final int TEXT_AREA_ROWS = 5;
        private static final int TEXT_AREA_COLUMNS = 20;
        private static final SpinnerModel FONTSIZE_MODEL = new SpinnerNumberModel(10, 0, 100, 1);
        private static final int BORDER_SIZE = 10;
        private JColorChooser backgroundColorChooser;
        private JColorChooser borderColorChooser;
        private JColorChooser textColorChooser;
        private JComboBox fontNameComboBox;
        private JLabel fontNameLabel;
        private JSpinner fontSizeSpinner;
        private JLabel fontSizeLabel;
        private JCheckBox fontStyleBold;
        private JCheckBox fontStyleItalic;
        private JLabel fontStyleLabel;
        private JPanel backgroundPane;
        private JLabel imagePathLabel;
        private JTextField imagePath;
        private JButton imageFileChooserBtn;
        private JPanel jPanel2;
        private JScrollPane jScrollPane1;
        private JTabbedPane mainTab;
        private JTextField labelArea;
        private JTextPane textArea;
        private JPanel textFormat;
        private JButton cancelButton;
        private JButton okButton;
        private JButton resetButton;
        private JPanel buttonPane;
        private XcosDiagram graph;
        private mxCell cell;
        private final transient ChangeListener defaultChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                this.updateFont();
            }
        };
        private final transient ActionListener defaultActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.updateFont();
            }
        };

        public EditFormatDialog(Frame frame) {
            super(frame, true);
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(frame);
            ScilabSwingUtilities.closeOnEscape((Window)this);
            this.initComponents();
        }

        public void setValues(Color color, Color color2, String string, int n, int n2, Color color3, String string2, String string3, String string4) {
            this.borderColorChooser.setColor(color);
            this.backgroundColorChooser.setColor(color2);
            this.textColorChooser.setColor(color3);
            this.fontNameComboBox.getModel().setSelectedItem(string);
            this.fontSizeSpinner.getModel().setValue(n);
            this.fontStyleBold.setSelected((n2 & 1) != 0);
            this.fontStyleItalic.setSelected((n2 & 2) != 0);
            this.labelArea.setText(string2);
            this.textArea.setText(string3);
            if (string4 != null) {
                this.imagePath.setText(string4);
            }
        }

        public void setGraph(XcosDiagram xcosDiagram) {
            this.graph = xcosDiagram;
        }

        public XcosDiagram getGraph() {
            return this.graph;
        }

        public void setCell(mxCell mxCell2) {
            this.cell = mxCell2;
            if (mxCell2.isVertex()) {
                this.mainTab.addTab(XcosMessages.FILL_COLOR, this.backgroundPane);
            } else {
                this.mainTab.remove(this.backgroundPane);
            }
            this.pack();
        }

        public mxCell getCell() {
            return this.cell;
        }

        public EditFormatDialog getDialog() {
            return this;
        }

        private void initComponents() {
            this.mainTab = new JTabbedPane();
            this.borderColorChooser = new JColorChooser();
            this.backgroundColorChooser = new JColorChooser();
            this.textColorChooser = new JColorChooser();
            this.textFormat = new JPanel();
            this.jPanel2 = new JPanel();
            this.fontSizeLabel = new JLabel();
            this.fontSizeSpinner = new JSpinner();
            this.fontNameLabel = new JLabel();
            this.fontNameComboBox = new JComboBox();
            this.fontStyleBold = new JCheckBox();
            this.fontStyleItalic = new JCheckBox();
            this.fontStyleLabel = new JLabel();
            this.imageFileChooserBtn = new JButton("...");
            this.imagePathLabel = new JLabel();
            this.imagePath = new JTextField(20);
            this.backgroundPane = new JPanel();
            this.labelArea = new JTextField();
            this.labelArea.setToolTipText(XcosMessages.ONELINE_DESCRIPTION_TOOLTIP);
            this.jScrollPane1 = new JScrollPane();
            this.textArea = new JTextPane();
            this.textArea.setToolTipText(XcosMessages.MULTILINE_DESCRIPTION_TOOLTIP);
            this.textArea.setContentType("text/html");
            this.cancelButton = new JButton(XcosMessages.CANCEL);
            this.okButton = new JButton(XcosMessages.OK);
            this.okButton.setMnemonic(10);
            this.resetButton = new JButton(XcosMessages.RESET);
            this.buttonPane = new JPanel();
            this.backgroundPane.setLayout(new BorderLayout());
            this.textFormat.setLayout(new BorderLayout());
            this.fontSizeLabel.setText(XcosMessages.FONT_SIZE);
            this.fontSizeSpinner.setModel(FONTSIZE_MODEL);
            this.fontSizeSpinner.addChangeListener(this.defaultChangeListener);
            this.fontNameLabel.setText(XcosMessages.FONT_NAME);
            this.fontNameComboBox.setModel(new DefaultComboBoxModel<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
            this.fontNameComboBox.addActionListener(this.defaultActionListener);
            this.fontStyleLabel.setText(XcosMessages.FONT_STYLE);
            this.fontStyleBold.setText(XcosMessages.BOLD);
            this.fontStyleBold.addChangeListener(this.defaultChangeListener);
            this.fontStyleItalic.setText(XcosMessages.ITALIC);
            this.fontStyleItalic.addChangeListener(this.defaultChangeListener);
            this.imagePathLabel.setText(XcosMessages.IMAGE_PATH);
            GroupLayout groupLayout = new GroupLayout(this.jPanel2);
            this.jPanel2.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fontNameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.fontSizeLabel, -1, -2, Short.MAX_VALUE).addComponent(this.fontStyleLabel, -1, -1, Short.MAX_VALUE)).addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fontNameComboBox, 0, -2, Short.MAX_VALUE).addComponent(this.fontSizeSpinner, 0, -2, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.fontStyleBold).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontStyleItalic))).addContainerGap()));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontSizeLabel, -2, -2, -2).addComponent(this.fontSizeSpinner, -2, -1, -2)).addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontNameLabel, -2, -2, -2).addComponent(this.fontNameComboBox, -2, -1, -2)).addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontStyleLabel, -2, -2, -2).addComponent(this.fontStyleBold, -2, -1, -2).addComponent(this.fontStyleItalic, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
            this.textFormat.add((Component)this.jPanel2, "Last");
            this.jScrollPane1.setViewportView(this.textArea);
            this.jScrollPane1.setBackground(Color.WHITE);
            this.textFormat.add((Component)this.labelArea, "First");
            this.textFormat.add((Component)this.jScrollPane1, "Center");
            this.backgroundPane.add((Component)this.backgroundColorChooser, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add(this.imagePathLabel);
            jPanel.add(this.imagePath);
            jPanel.add(this.imageFileChooserBtn);
            this.backgroundPane.add((Component)jPanel, "South");
            this.mainTab.addTab(XcosMessages.TEXT_SETTINGS, this.textFormat);
            this.mainTab.addTab(XcosMessages.BORDER_COLOR, this.borderColorChooser);
            this.mainTab.addTab(XcosMessages.TEXT_COLOR, this.textColorChooser);
            this.mainTab.addChangeListener(this.defaultChangeListener);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.getDialog().dispose();
                }
            });
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    graph.getModel().beginUpdate();
                    EditFormatAction.updateFromDialog(this.getDialog(), borderColorChooser.getColor(), backgroundColorChooser.getColor(), (String)fontNameComboBox.getSelectedItem(), (Integer)fontSizeSpinner.getValue(), textColorChooser.getColor(), fontStyleBold.isSelected(), fontStyleItalic.isSelected(), labelArea.getText(), mxUtils.getBodyMarkup((String)textArea.getText(), (boolean)false), imagePath.getText());
                    graph.getModel().endUpdate();
                    this.getDialog().dispose();
                }
            });
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    graph.getModel().beginUpdate();
                    EditFormatAction.reset(this.getDialog());
                    graph.getModel().endUpdate();
                }
            });
            this.imageFileChooserBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    Object object;
                    JFileChooser jFileChooser = new JFileChooser();
                    FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Images", "jpg", "png", "svg", "gif");
                    jFileChooser.setFileFilter(fileNameExtensionFilter);
                    String string = imagePath.getText();
                    File file = this.getGraph().getSavedFile();
                    if (string != null && !string.isEmpty()) {
                        try {
                            URI uRI = new URI(string);
                            jFileChooser.setSelectedFile(new File(uRI));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            if (file != null) {
                                object = file.getParentFile();
                                jFileChooser.setSelectedFile(new File((File)object, string));
                            }
                        }
                    } else if (file != null) {
                        jFileChooser.setCurrentDirectory(file.getParentFile());
                    }
                    if ((n = jFileChooser.showOpenDialog(mainTab)) == 0) {
                        if (file != null) {
                            object = file.getParentFile().toURI().relativize(jFileChooser.getSelectedFile().toURI()).toASCIIString();
                            imagePath.setText((String)object);
                        } else {
                            object = jFileChooser.getSelectedFile().toURI().toASCIIString();
                            imagePath.setText((String)object);
                        }
                    }
                }
            });
            this.getRootPane().setDefaultButton(this.okButton);
            this.labelArea.requestFocusInWindow();
            this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 2));
            this.buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.buttonPane.add(Box.createHorizontalGlue());
            this.buttonPane.add(this.okButton);
            this.buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            this.buttonPane.add(this.cancelButton);
            this.buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            this.buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            this.buttonPane.add(this.resetButton);
            Container container = this.getContentPane();
            container.add((Component)this.mainTab, "Center");
            container.add((Component)this.buttonPane, "Last");
        }

        protected void updateFont() {
            int n = 0;
            if (this.fontStyleBold.isSelected()) {
                n |= 1;
            }
            if (this.fontStyleItalic.isSelected()) {
                n |= 2;
            }
            Font font = new Font((String)this.fontNameComboBox.getSelectedItem(), n, (Integer)this.fontSizeSpinner.getValue());
            this.textArea.setFont(font);
            this.textArea.setBackground(this.backgroundColorChooser.getColor());
            this.textArea.setForeground(this.textColorChooser.getColor());
            this.jScrollPane1.repaint();
        }
    }
}

