/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos;

import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.CopyAction;
import org.scilab.modules.graph.actions.CutAction;
import org.scilab.modules.graph.actions.DeleteAction;
import org.scilab.modules.graph.actions.InvertSelectionAction;
import org.scilab.modules.graph.actions.PasteAction;
import org.scilab.modules.graph.actions.RedoAction;
import org.scilab.modules.graph.actions.SelectAllAction;
import org.scilab.modules.graph.actions.UndoAction;
import org.scilab.modules.graph.actions.ZoomInAction;
import org.scilab.modules.graph.actions.ZoomOutAction;
import org.scilab.modules.graph.event.ArrowKeyListener;
import org.scilab.modules.gui.bridge.menu.SwingScilabMenu;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.checkboxmenuitem.CheckBoxMenuItem;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.BarUpdater;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.actions.AboutXcosAction;
import org.scilab.modules.xcos.actions.CloseAction;
import org.scilab.modules.xcos.actions.CompileAction;
import org.scilab.modules.xcos.actions.DebugLevelAction;
import org.scilab.modules.xcos.actions.DiagramBackgroundAction;
import org.scilab.modules.xcos.actions.EditFormatAction;
import org.scilab.modules.xcos.actions.ExportAction;
import org.scilab.modules.xcos.actions.ExportAllAction;
import org.scilab.modules.xcos.actions.ExternalAction;
import org.scilab.modules.xcos.actions.FitDiagramToViewAction;
import org.scilab.modules.xcos.actions.InitModelicaAction;
import org.scilab.modules.xcos.actions.NewDiagramAction;
import org.scilab.modules.xcos.actions.NormalViewAction;
import org.scilab.modules.xcos.actions.OpenAction;
import org.scilab.modules.xcos.actions.OpenInSciAction;
import org.scilab.modules.xcos.actions.PrintAction;
import org.scilab.modules.xcos.actions.QuitAction;
import org.scilab.modules.xcos.actions.RecentFileAction;
import org.scilab.modules.xcos.actions.SaveAction;
import org.scilab.modules.xcos.actions.SaveAsAction;
import org.scilab.modules.xcos.actions.SetContextAction;
import org.scilab.modules.xcos.actions.SetupAction;
import org.scilab.modules.xcos.actions.ShowHideShadowAction;
import org.scilab.modules.xcos.actions.StartAction;
import org.scilab.modules.xcos.actions.StopAction;
import org.scilab.modules.xcos.actions.ViewDiagramBrowserAction;
import org.scilab.modules.xcos.actions.ViewDiagramTreeShowAction;
import org.scilab.modules.xcos.actions.ViewGridAction;
import org.scilab.modules.xcos.actions.ViewViewportAction;
import org.scilab.modules.xcos.actions.XcosDemonstrationsAction;
import org.scilab.modules.xcos.actions.XcosDocumentationAction;
import org.scilab.modules.xcos.block.actions.AutoPositionSplitBlockAction;
import org.scilab.modules.xcos.block.actions.BlockDocumentationAction;
import org.scilab.modules.xcos.block.actions.BlockParametersAction;
import org.scilab.modules.xcos.block.actions.BorderColorAction;
import org.scilab.modules.xcos.block.actions.CodeGenerationAction;
import org.scilab.modules.xcos.block.actions.FilledColorAction;
import org.scilab.modules.xcos.block.actions.FlipAction;
import org.scilab.modules.xcos.block.actions.MirrorAction;
import org.scilab.modules.xcos.block.actions.RegionToSuperblockAction;
import org.scilab.modules.xcos.block.actions.RotateAction;
import org.scilab.modules.xcos.block.actions.ViewDetailsAction;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionBottom;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionCenter;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionLeft;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionMiddle;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionRight;
import org.scilab.modules.xcos.block.actions.alignement.AlignBlockActionTop;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.configuration.model.DocumentType;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.link.actions.StyleHorizontalAction;
import org.scilab.modules.xcos.link.actions.StyleOptimalAction;
import org.scilab.modules.xcos.link.actions.StyleStraightAction;
import org.scilab.modules.xcos.link.actions.StyleVerticalAction;
import org.scilab.modules.xcos.palette.actions.ViewPaletteBrowserAction;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.preferences.XcosOptions;
import org.scilab.modules.xcos.utils.XcosMessages;

public class XcosTab
extends SwingScilabDockablePanel
implements SimpleTab {
    public static final String DEFAULT_WIN_UUID = "xcos-default-window";
    public static final String DEFAULT_TAB_UUID = "xcos-default-tab";
    private MenuBar menuBar;
    private Menu fileMenu;
    private Menu recentsMenu;
    private Menu edit;
    private Menu view;
    private Menu simulate;
    private Menu format;
    private Menu alignMenu;
    private Menu blockPosition;
    private Menu linkStyle;
    private Menu tools;
    private Menu help;
    private JCheckBoxMenuItem viewport;
    private JButton openAction;
    private JButton saveAction;
    private JButton saveAsAction;
    private JButton printAction;
    private JButton newDiagramAction;
    private JButton deleteAction;
    private JButton undoAction;
    private JButton redoAction;
    private JButton fitDiagramToViewAction;
    private JButton startAction;
    private JButton stopAction;
    private JButton zoomInAction;
    private JButton zoomOutAction;
    private JButton xcosDemonstrationAction;
    private JButton xcosDocumentationAction;

    private XcosTab(XcosDiagram xcosDiagram, String string) {
        super(XcosMessages.XCOS, string);
        this.setAssociatedXMLIDForHelp("xcos");
        xcosDiagram.setGraphTab(string);
        this.setWindowIcon(Xcos.ICON.getImage());
        this.initComponents(xcosDiagram);
        xcosDiagram.getAsComponent().addKeyListener((KeyListener)new ArrowKeyListener());
        xcosDiagram.getModel().addListener("change", (object, mxEventObject2) -> {
            xcosDiagram.setModified(true);
            xcosDiagram.updateTabTitle();
        });
    }

    public static XcosTab get(XcosDiagram xcosDiagram) {
        String string = xcosDiagram.getGraphTab();
        if (string == null) {
            return null;
        }
        return (XcosTab)ScilabTabFactory.getInstance().getFromCache(string);
    }

    public static void restore(XcosDiagram xcosDiagram) {
        XcosTab.restore(xcosDiagram, true);
    }

    public static void restore(XcosDiagram xcosDiagram, boolean bl) {
        String string = xcosDiagram.getGraphTab();
        if (string == null) {
            string = UUID.randomUUID().toString();
        }
        XcosTab xcosTab = new XcosTab(xcosDiagram, string);
        ScilabTabFactory.getInstance().addToCache((SwingScilabDockablePanel)xcosTab);
        if (bl) {
            xcosTab.createDefaultWindow().setVisible(true);
            xcosDiagram.fireEvent(new mxEventObject(mxEvent.ROOT));
            xcosDiagram.updateTabTitle();
            BarUpdater.updateBars((String)xcosTab.getParentWindowId(), (MenuBar)xcosTab.getMenuBar(), (ToolBar)xcosTab.getToolBar(), (TextBox)xcosTab.getInfoBar(), (String)xcosTab.getName(), (Image)xcosTab.getWindowIcon());
        }
        ClosingOperationsManager.addDependencyWithRoot((SwingScilabDockablePanel)xcosTab);
        ClosingOperationsManager.registerClosingOperation((SwingScilabDockablePanel)xcosTab, (ClosingOperationsManager.ClosingOperation)new ClosingOperation(xcosDiagram));
        WindowsConfigurationManager.registerEndedRestoration((SwingScilabDockablePanel)xcosTab, (WindowsConfigurationManager.EndedRestoration)new EndedRestoration(xcosDiagram));
    }

    private void initComponents(XcosDiagram xcosDiagram) {
        this.menuBar = this.createMenuBar(xcosDiagram);
        this.setMenuBar(this.menuBar);
        ToolBar toolBar = this.createToolBar(xcosDiagram);
        this.setToolBar(toolBar);
        this.setContentPane((Container)xcosDiagram.getAsComponent());
        this.setInfoBar(ScilabTextBox.createTextBox());
    }

    private MenuBar createMenuBar(XcosDiagram xcosDiagram) {
        this.menuBar = ScilabMenuBar.createMenuBar();
        this.fileMenu = ScilabMenu.createMenu();
        this.fileMenu.setText(XcosMessages.FILE);
        this.fileMenu.setMnemonic(70);
        this.fileMenu.add(NewDiagramAction.createMenu(xcosDiagram));
        this.fileMenu.add(OpenAction.createMenu(xcosDiagram));
        this.fileMenu.add(OpenInSciAction.createMenu(xcosDiagram));
        this.recentsMenu = this.createRecentMenu();
        this.fileMenu.add(this.recentsMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(CloseAction.createMenu(xcosDiagram));
        this.fileMenu.add(SaveAction.createMenu(xcosDiagram));
        this.fileMenu.add(SaveAsAction.createMenu(xcosDiagram));
        this.fileMenu.addSeparator();
        this.fileMenu.add(ExportAction.createMenu(xcosDiagram));
        this.fileMenu.add(ExportAllAction.createMenu(xcosDiagram));
        this.fileMenu.addSeparator();
        this.fileMenu.add(PrintAction.createMenu(xcosDiagram));
        this.fileMenu.addSeparator();
        this.fileMenu.add(QuitAction.createMenu(xcosDiagram));
        this.menuBar.add(this.fileMenu);
        this.edit = ScilabMenu.createMenu();
        this.edit.setText(XcosMessages.EDIT);
        this.edit.setMnemonic(69);
        this.menuBar.add(this.edit);
        this.edit.add(UndoAction.undoMenu((ScilabGraph)xcosDiagram));
        this.edit.add(RedoAction.redoMenu((ScilabGraph)xcosDiagram));
        this.edit.addSeparator();
        this.edit.add(CutAction.cutMenu((ScilabGraph)xcosDiagram));
        this.edit.add(CopyAction.copyMenu((ScilabGraph)xcosDiagram));
        this.edit.add(PasteAction.pasteMenu((ScilabGraph)xcosDiagram));
        this.edit.add(DeleteAction.createMenu((ScilabGraph)xcosDiagram));
        this.edit.addSeparator();
        this.edit.add(SelectAllAction.createMenu((ScilabGraph)xcosDiagram));
        this.edit.add(InvertSelectionAction.createMenu((ScilabGraph)xcosDiagram));
        this.edit.addSeparator();
        this.edit.add(BlockParametersAction.createMenu(xcosDiagram));
        this.edit.addSeparator();
        this.edit.add(RegionToSuperblockAction.createMenu(xcosDiagram));
        this.view = ScilabMenu.createMenu();
        this.view.setText(XcosMessages.VIEW);
        this.view.setMnemonic(86);
        this.menuBar.add(this.view);
        this.view.add(ZoomInAction.zoominMenu((ScilabGraph)xcosDiagram));
        this.view.add(ZoomOutAction.zoomoutMenu((ScilabGraph)xcosDiagram));
        this.view.add(FitDiagramToViewAction.createMenu(xcosDiagram));
        this.view.add(NormalViewAction.createMenu(xcosDiagram));
        this.view.addSeparator();
        this.view.add(ViewPaletteBrowserAction.createCheckBoxMenu(xcosDiagram));
        this.view.add(ViewDiagramTreeShowAction.createMenu(xcosDiagram));
        this.view.add(ViewDiagramBrowserAction.createMenu(xcosDiagram));
        CheckBoxMenuItem checkBoxMenuItem = ViewViewportAction.createCheckBoxMenu(xcosDiagram);
        this.viewport = (JCheckBoxMenuItem)checkBoxMenuItem.getAsSimpleCheckBoxMenuItem();
        this.view.add(checkBoxMenuItem);
        this.view.add(ViewDetailsAction.createMenu(xcosDiagram));
        this.simulate = ScilabMenu.createMenu();
        this.simulate.setText(XcosMessages.SIMULATION);
        this.simulate.setMnemonic(83);
        this.menuBar.add(this.simulate);
        MenuItem menuItem = StartAction.createMenu(xcosDiagram);
        MenuItem menuItem2 = StopAction.createMenu(xcosDiagram);
        this.simulate.add(SetupAction.createMenu(xcosDiagram));
        this.simulate.add(DebugLevelAction.createMenu(xcosDiagram));
        this.simulate.add(SetContextAction.createMenu(xcosDiagram));
        this.simulate.add(CompileAction.createMenu(xcosDiagram));
        this.simulate.add(InitModelicaAction.createMenu(xcosDiagram));
        this.simulate.add(menuItem);
        this.simulate.add(menuItem2);
        this.format = ScilabMenu.createMenu();
        this.format.setText(XcosMessages.FORMAT);
        this.format.setMnemonic(79);
        this.menuBar.add(this.format);
        this.format.add(RotateAction.createMenu(xcosDiagram));
        this.format.add(FlipAction.createMenu(xcosDiagram));
        this.format.add(MirrorAction.createMenu(xcosDiagram));
        this.format.add(ShowHideShadowAction.createMenu(xcosDiagram));
        this.format.addSeparator();
        this.alignMenu = ScilabMenu.createMenu();
        this.alignMenu.setText(XcosMessages.ALIGN_BLOCKS);
        this.alignMenu.add(AlignBlockActionLeft.createMenu(xcosDiagram));
        this.alignMenu.add(AlignBlockActionCenter.createMenu(xcosDiagram));
        this.alignMenu.add(AlignBlockActionRight.createMenu(xcosDiagram));
        this.alignMenu.addSeparator();
        this.alignMenu.add(AlignBlockActionTop.createMenu(xcosDiagram));
        this.alignMenu.add(AlignBlockActionMiddle.createMenu(xcosDiagram));
        this.alignMenu.add(AlignBlockActionBottom.createMenu(xcosDiagram));
        this.format.add(this.alignMenu);
        this.format.addSeparator();
        this.format.add(EditFormatAction.createMenu(xcosDiagram));
        this.format.add(BorderColorAction.createMenu(xcosDiagram));
        this.format.add(FilledColorAction.createMenu(xcosDiagram));
        this.format.addSeparator();
        this.blockPosition = ScilabMenu.createMenu();
        this.blockPosition.setText(XcosMessages.BLOCK_AUTO_POSITION);
        this.blockPosition.add(AutoPositionSplitBlockAction.createMenu(xcosDiagram));
        this.format.add(this.blockPosition);
        this.format.addSeparator();
        this.linkStyle = ScilabMenu.createMenu();
        this.linkStyle.setText(XcosMessages.LINK_STYLE);
        this.linkStyle.add(StyleHorizontalAction.createMenu(xcosDiagram));
        this.linkStyle.add(StyleStraightAction.createMenu(xcosDiagram));
        this.linkStyle.add(StyleVerticalAction.createMenu(xcosDiagram));
        this.linkStyle.add(StyleOptimalAction.createMenu(xcosDiagram));
        this.format.add(this.linkStyle);
        this.format.addSeparator();
        this.format.add(DiagramBackgroundAction.createMenu(xcosDiagram));
        CheckBoxMenuItem checkBoxMenuItem2 = ViewGridAction.createCheckBoxMenu(xcosDiagram);
        this.format.add(checkBoxMenuItem2);
        this.tools = ScilabMenu.createMenu();
        this.tools.setText(XcosMessages.TOOLS);
        this.tools.setMnemonic(84);
        this.menuBar.add(this.tools);
        this.tools.add(CodeGenerationAction.createMenu(xcosDiagram));
        List<ExternalAction> list = Xcos.getInstance().getExternalActions();
        for (ExternalAction externalAction : list) {
            MenuItem menuItem3 = ScilabMenuItem.createMenuItem();
            SwingScilabMenuItem swingScilabMenuItem = (SwingScilabMenuItem)menuItem3.getAsSimpleMenuItem();
            swingScilabMenuItem.setAction((Action)((Object)new ExternalAction(externalAction, xcosDiagram)));
            this.tools.add(menuItem3);
        }
        this.help = ScilabMenu.createMenu();
        this.help.setText(XcosMessages.HELP);
        this.help.setMnemonic(63);
        this.menuBar.add(this.help);
        this.help.add(XcosDocumentationAction.createMenu(xcosDiagram));
        this.help.add(BlockDocumentationAction.createMenu(xcosDiagram));
        this.help.addSeparator();
        this.help.add(XcosDemonstrationsAction.createMenu(xcosDiagram));
        this.help.addSeparator();
        this.help.add(AboutXcosAction.createMenu(xcosDiagram));
        return this.menuBar;
    }

    private void populateRecentMenu(Menu menu) {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        List<DocumentType> list = configurationManager.getSettings().getRecent();
        int n = XcosOptions.getPreferences().getNumberOfRecentlyOpen();
        int n2 = Math.min(list.size(), n);
        for (int i = 0; i < n2; ++i) {
            URL uRL;
            try {
                uRL = new URL(list.get(i).getUrl());
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(XcosTab.class.getName()).severe(malformedURLException.toString());
                break;
            }
            menu.add(RecentFileAction.createMenu(uRL));
        }
    }

    private Menu createRecentMenu() {
        final Menu menu = ScilabMenu.createMenu();
        menu.setText(XcosMessages.RECENT_FILES);
        this.populateRecentMenu(menu);
        ConfigurationManager.getInstance().addPropertyChangeListener("recentFilesHasChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                assert (propertyChangeEvent.getPropertyName().equals("recentFilesHasChanged"));
                ((SwingScilabMenu)menu.getAsSimpleMenu()).removeAll();
                XcosTab.this.populateRecentMenu(menu);
            }
        });
        return menu;
    }

    private ToolBar createToolBar(XcosDiagram xcosDiagram) {
        ToolBar toolBar = ScilabToolBar.createToolBar();
        SwingScilabToolBar swingScilabToolBar = (SwingScilabToolBar)toolBar.getAsSimpleToolBar();
        this.newDiagramAction = NewDiagramAction.createButton(xcosDiagram);
        swingScilabToolBar.add((Component)this.newDiagramAction);
        this.openAction = OpenAction.createButton(xcosDiagram);
        swingScilabToolBar.add((Component)this.openAction);
        swingScilabToolBar.add((Component)OpenInSciAction.createButton(xcosDiagram));
        swingScilabToolBar.addSeparator();
        this.saveAction = SaveAction.createButton(xcosDiagram);
        swingScilabToolBar.add((Component)this.saveAction);
        this.saveAsAction = SaveAsAction.createButton(xcosDiagram);
        swingScilabToolBar.add((Component)this.saveAsAction);
        swingScilabToolBar.addSeparator();
        this.printAction = PrintAction.createButton(xcosDiagram);
        swingScilabToolBar.add((Component)this.printAction);
        swingScilabToolBar.addSeparator();
        this.deleteAction = DeleteAction.createButton((ScilabGraph)xcosDiagram);
        swingScilabToolBar.add((Component)this.deleteAction);
        swingScilabToolBar.addSeparator();
        this.undoAction = UndoAction.undoButton((ScilabGraph)xcosDiagram);
        this.redoAction = RedoAction.redoButton((ScilabGraph)xcosDiagram);
        swingScilabToolBar.add((Component)this.undoAction);
        swingScilabToolBar.add((Component)this.redoAction);
        swingScilabToolBar.addSeparator();
        this.fitDiagramToViewAction = FitDiagramToViewAction.createButton(xcosDiagram);
        swingScilabToolBar.add((Component)this.fitDiagramToViewAction);
        swingScilabToolBar.addSeparator();
        this.startAction = StartAction.createButton(xcosDiagram);
        this.stopAction = StopAction.createButton(xcosDiagram);
        swingScilabToolBar.add((Component)this.startAction);
        swingScilabToolBar.add((Component)this.stopAction);
        swingScilabToolBar.addSeparator();
        this.zoomInAction = ZoomInAction.zoominButton((ScilabGraph)xcosDiagram);
        swingScilabToolBar.add((Component)this.zoomInAction);
        this.zoomOutAction = ZoomOutAction.zoomoutButton((ScilabGraph)xcosDiagram);
        swingScilabToolBar.add((Component)this.zoomOutAction);
        swingScilabToolBar.addSeparator();
        this.xcosDemonstrationAction = XcosDemonstrationsAction.createButton(xcosDiagram);
        swingScilabToolBar.add((Component)this.xcosDemonstrationAction);
        this.xcosDocumentationAction = XcosDocumentationAction.createButton(xcosDiagram);
        swingScilabToolBar.add((Component)this.xcosDocumentationAction);
        return toolBar;
    }

    public void setViewportChecked(boolean bl) {
        this.viewport.setSelected(bl);
    }

    public boolean isViewportChecked() {
        return this.viewport.isSelected();
    }

    private SwingScilabWindow createDefaultWindow() {
        SwingScilabWindow swingScilabWindow = WindowsConfigurationManager.createWindow((String)DEFAULT_WIN_UUID, (boolean)false);
        SwingScilabWindow swingScilabWindow2 = swingScilabWindow != null ? swingScilabWindow : SwingScilabWindow.createWindow((boolean)true);
        swingScilabWindow2.addTab((SwingScilabPanel)this);
        return swingScilabWindow2;
    }

    private static class EndedRestoration
    implements WindowsConfigurationManager.EndedRestoration {
        private final WeakReference<XcosDiagram> graph;

        public EndedRestoration(XcosDiagram xcosDiagram) {
            this.graph = new WeakReference<XcosDiagram>(xcosDiagram);
        }

        public void finish() {
            XcosDiagram xcosDiagram = (XcosDiagram)((Object)this.graph.get());
            if (xcosDiagram == null) {
                return;
            }
            xcosDiagram.updateTabTitle();
            ConfigurationManager.getInstance().removeFromRecentTabs(xcosDiagram.getGraphTab());
        }
    }

    private static class ClosingOperation
    implements ClosingOperationsManager.ClosingOperation {
        private final WeakReference<XcosDiagram> graph;

        public ClosingOperation(XcosDiagram xcosDiagram) {
            this.graph = new WeakReference<XcosDiagram>(xcosDiagram);
        }

        public int canClose() {
            XcosDiagram xcosDiagram = (XcosDiagram)((Object)this.graph.get());
            if (xcosDiagram == null) {
                return 1;
            }
            return Xcos.getInstance().canClose(xcosDiagram) ? 1 : 0;
        }

        public void destroy() {
            XcosDiagram xcosDiagram = (XcosDiagram)((Object)this.graph.get());
            if (xcosDiagram == null) {
                return;
            }
            Xcos.getInstance().destroy(xcosDiagram);
        }

        public String askForClosing(List<SwingScilabDockablePanel> list) {
            XcosDiagram xcosDiagram = (XcosDiagram)((Object)this.graph.get());
            if (xcosDiagram == null) {
                return null;
            }
            return Xcos.getInstance().askForClosing(xcosDiagram, list);
        }

        public void updateDependencies(List<SwingScilabDockablePanel> list, ListIterator<SwingScilabDockablePanel> listIterator) {
            PaletteManagerView paletteManagerView = PaletteManagerView.get();
            if (paletteManagerView == null) {
                return;
            }
            if (list.contains((Object)paletteManagerView)) {
                return;
            }
            boolean bl = Xcos.getInstance().wasLastOpened(list);
            if (bl) {
                listIterator.add(paletteManagerView);
            }
        }
    }
}

