/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos;

import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.view.mxStylesheet;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.ScilabCommons;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.core.Scilab;
import org.scilab.modules.graph.actions.base.GraphActionManager;
import org.scilab.modules.graph.utils.ScilabExported;
import org.scilab.modules.gui.bridge.menu.SwingScilabMenu;
import org.scilab.modules.gui.bridge.menubar.SwingScilabMenuBar;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.AbstractScilabTabFactory;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.BarUpdater;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.xcos.BrowserView;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.ViewPortTab;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.XcosView;
import org.scilab.modules.xcos.actions.ExternalAction;
import org.scilab.modules.xcos.actions.StopAction;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.configuration.model.DocumentType;
import org.scilab.modules.xcos.graph.DiagramComparator;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.graph.model.XcosCell;
import org.scilab.modules.xcos.graph.model.XcosGraphModel;
import org.scilab.modules.xcos.io.XcosFileType;
import org.scilab.modules.xcos.palette.PaletteManager;
import org.scilab.modules.xcos.palette.view.PaletteManagerView;
import org.scilab.modules.xcos.preferences.XcosConfiguration;
import org.scilab.modules.xcos.utils.FileUtils;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class Xcos {
    public static final String VERSION = "2.0";
    public static final String TRADENAME = Xcos.class.getSimpleName();
    public static final ImageIcon ICON = new ImageIcon(FindIconHelper.findIcon((String)"utilities-system-monitor", (String)"256x256"));
    private static final String LOAD_XCOS_LIBS_LOAD_SCICOS = "prot=funcprot(); funcprot(0); loadXcosLibs(); loadScicos(); funcprot(prot); clear prot";
    private static final String CALLED_OUTSIDE_THE_EDT_THREAD = "Called outside the EDT thread.";
    private static final Logger LOG = Logger.getLogger(Xcos.class.getName());
    private static volatile Xcos sharedInstance;
    private final Map<ScicosObjectOwner, List<XcosDiagram>> diagrams;
    private XcosView view;
    private BrowserView browser;
    private boolean onDiagramIteration = false;
    private String lastError = null;
    private final PaletteManager palette;
    private final ConfigurationManager configuration;
    private final mxStylesheet styleSheet;
    private final List<ExternalAction> externalActions;
    private final XcosTabFactory factory;

    private Xcos(XcosTabFactory xcosTabFactory) {
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (IOException | SecurityException exception) {
            LOG.severe(exception.toString());
        }
        this.diagrams = new HashMap<ScicosObjectOwner, List<XcosDiagram>>();
        this.view = new XcosView();
        this.browser = null;
        this.palette = PaletteManager.getInstance();
        this.configuration = ConfigurationManager.getInstance();
        this.styleSheet = new mxStylesheet();
        this.externalActions = new ArrayList<ExternalAction>();
        try {
            FileUtils.decodeStyle(this.styleSheet);
        }
        catch (IOException iOException) {
            LOG.severe(iOException.toString());
        }
        this.factory = xcosTabFactory == null ? new XcosTabFactory(false) : xcosTabFactory;
        ScilabTabFactory.getInstance().addTabFactory((AbstractScilabTabFactory)this.factory);
    }

    protected void finalize() throws Throwable {
        if (this.browser != null) {
            JavaController.unregister_view(this.browser);
        }
        JavaController.unregister_view(this.view);
        super.finalize();
    }

    public static synchronized Xcos getInstance() {
        return Xcos.getInstance(null);
    }

    private static synchronized Xcos getInstance(XcosTabFactory xcosTabFactory) {
        if (sharedInstance == null) {
            try {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(() -> {
                        sharedInstance = new Xcos(xcosTabFactory);
                    });
                } else {
                    sharedInstance = new Xcos(xcosTabFactory);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            LOG.finest("Session started");
        }
        return sharedInstance;
    }

    public void quit(boolean bl) {
        if (sharedInstance == null) {
            return;
        }
    }

    private static synchronized void clearInstance() {
        sharedInstance = null;
        LOG.finest("Session ended");
    }

    public List<XcosDiagram> openedDiagrams() {
        ArrayList<XcosDiagram> arrayList = new ArrayList<XcosDiagram>();
        this.diagrams.values().stream().forEach(list -> arrayList.addAll((Collection<XcosDiagram>)list));
        return arrayList;
    }

    public List<XcosDiagram> openedDiagrams(ScicosObjectOwner scicosObjectOwner) {
        return this.diagrams.getOrDefault(scicosObjectOwner, Collections.emptyList());
    }

    public ScicosObjectOwner openedDiagram(File file) {
        ScicosObjectOwner scicosObjectOwner = null;
        if (file == null) {
            return scicosObjectOwner;
        }
        for (ScicosObjectOwner scicosObjectOwner2 : this.diagrams.keySet()) {
            List list = this.diagrams.getOrDefault(scicosObjectOwner2, Collections.emptyList());
            if (list.isEmpty() || !file.equals(((XcosDiagram)((Object)list.get(0))).getSavedFile())) continue;
            scicosObjectOwner = scicosObjectOwner2;
            break;
        }
        return scicosObjectOwner;
    }

    public boolean isModified(ScicosObjectOwner scicosObjectOwner) {
        for (XcosDiagram xcosDiagram : this.diagrams.get(scicosObjectOwner)) {
            if (!xcosDiagram.isModified()) continue;
            return true;
        }
        return false;
    }

    public void setModified(ScicosObjectOwner scicosObjectOwner, boolean bl) {
        for (XcosDiagram xcosDiagram : this.diagrams.get(scicosObjectOwner)) {
            xcosDiagram.setModified(bl);
        }
    }

    public boolean askForFileCreation(XcosDiagram xcosDiagram, File file) {
        ScilabModalDialog.AnswerOption answerOption;
        try {
            answerOption = ScilabModalDialog.show((Component)xcosDiagram.getAsComponent(), (String[])new String[]{String.format(XcosMessages.FILE_DOESNT_EXIST, file.getCanonicalFile())}, (String)XcosMessages.XCOS, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO);
        }
        catch (IOException iOException) {
            LOG.severe(iOException.toString());
            answerOption = ScilabModalDialog.AnswerOption.YES_OPTION;
        }
        if (answerOption == ScilabModalDialog.AnswerOption.YES_OPTION) {
            return xcosDiagram.saveDiagramAs(file);
        }
        return false;
    }

    public mxStylesheet getStyleSheet() {
        return this.styleSheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string, long l) {
        Object object;
        Object object2;
        Object object3;
        ScicosObjectOwner scicosObjectOwner;
        if (!SwingUtilities.isEventDispatchThread()) {
            LOG.severe(CALLED_OUTSIDE_THE_EDT_THREAD);
        }
        boolean bl = this.openedDiagrams().isEmpty();
        JavaController javaController = new JavaController();
        Object object4 = null;
        File file = string != null ? new File(string) : null;
        if (file != null && file.exists()) {
            this.configuration.addToRecentFiles(file);
        }
        if ((scicosObjectOwner = this.openedDiagram(file)) != null) {
            object4 = this.diagrams.get(scicosObjectOwner).iterator().next();
        }
        if (file == null && object4 != null && object4.getModel().getChildCount(object4.getDefaultParent()) > 0) {
            object4 = null;
        }
        if (object4 == null) {
            object3 = this.diagrams.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry entry = (Map.Entry)object3.next();
                object2 = (List)entry.getValue();
                object = (XcosDiagram)((Object)object2.get(0));
                int n = object.countChildren();
                if (n != 0 || object.getSavedFile() != null || object.isModified()) continue;
                object4 = object;
                ((XcosDiagram)((Object)object4)).transformAndLoadFile(javaController, string);
            }
        }
        if (object4 != null && (object3 = XcosTab.get(object4)) != null) {
            object3.setCurrent();
            object3.requestFocus();
        }
        long l2 = l != 0L ? l : javaController.createObject(Kind.DIAGRAM);
        if (object4 != null) {
            object2 = this;
            synchronized (object2) {
                this.setLastError("");
                this.notify();
            }
        }
        object2 = javaController.getKind(l2);
        if (Kind.BLOCK.equals(object2)) {
            object = new long[1];
            javaController.getObjectProperty(l2, (Kind)((Object)object2), ObjectProperties.PARENT_DIAGRAM, (long[])object);
            if (object[0] == 0L) {
                VectorOfScicosID vectorOfScicosID = new VectorOfScicosID();
                javaController.getObjectProperty(l2, (Kind)((Object)object2), ObjectProperties.CHILDREN, vectorOfScicosID);
                object2 = Kind.DIAGRAM;
                l2 = javaController.createObject(Kind.DIAGRAM);
                javaController.setObjectProperty(l2, (Kind)((Object)object2), ObjectProperties.CHILDREN, vectorOfScicosID);
                for (int i = 0; i < vectorOfScicosID.size(); ++i) {
                    javaController.referenceObject(vectorOfScicosID.get(i));
                }
            }
        }
        object4 = new XcosDiagram(javaController, l2, (Kind)((Object)object2), "");
        ((XcosDiagram)((Object)object4)).installListeners();
        scicosObjectOwner = Xcos.findRoot(javaController, (XcosDiagram)((Object)object4));
        this.addDiagram(scicosObjectOwner, (XcosDiagram)((Object)object4));
        if (file != null && !file.exists() && !this.askForFileCreation((XcosDiagram)((Object)object4), file)) {
            object = this;
            synchronized (object) {
                this.setLastError("");
                this.notify();
            }
            this.diagrams.remove(scicosObjectOwner);
            return;
        }
        if (XcosTab.get((XcosDiagram)((Object)object4)) == null) {
            XcosTab.restore((XcosDiagram)((Object)object4));
        }
        if (bl) {
            PaletteManager.setVisible(true);
        }
        ((XcosDiagram)((Object)object4)).transformAndLoadFile(javaController, string);
    }

    public void setLastError(String string) {
        this.lastError = string;
    }

    public XcosView getXcosView() {
        return this.view;
    }

    public BrowserView getBrowser() {
        if (this.browser == null) {
            this.browser = new BrowserView();
            JavaController.register_view(BrowserView.class.getSimpleName(), this.browser);
        }
        return this.browser;
    }

    public void clearBrowser() {
        if (this.browser != null) {
            JavaController.unregister_view(this.browser);
            this.browser = null;
        }
    }

    public Collection<XcosDiagram> getDiagrams(ScicosObjectOwner scicosObjectOwner) {
        Collection collection = this.diagrams.get(scicosObjectOwner);
        if (collection == null) {
            return null;
        }
        return Collections.unmodifiableCollection(collection);
    }

    public void addDiagram(ScicosObjectOwner scicosObjectOwner, XcosDiagram xcosDiagram) {
        if (this.onDiagramIteration) {
            throw new RuntimeException();
        }
        if (scicosObjectOwner == null) {
            throw new IllegalArgumentException();
        }
        List<XcosDiagram> list = this.diagrams.get(scicosObjectOwner);
        if (list == null) {
            list = this.createDiagramCollection();
            this.diagrams.put(scicosObjectOwner, list);
        }
        list.add(xcosDiagram);
    }

    public void addDiagram(XcosDiagram xcosDiagram) {
        ScicosObjectOwner scicosObjectOwner = Xcos.findRoot(xcosDiagram);
        this.addDiagram(scicosObjectOwner, xcosDiagram);
    }

    public List<XcosDiagram> createDiagramCollection() {
        return new ArrayList<XcosDiagram>(){

            @Override
            public boolean add(XcosDiagram xcosDiagram) {
                boolean bl = super.add(xcosDiagram);
                DiagramComparator.sort(this);
                return bl;
            }

            @Override
            public boolean addAll(Collection<? extends XcosDiagram> collection) {
                boolean bl = super.addAll(collection);
                DiagramComparator.sort(this);
                return bl;
            }
        };
    }

    public boolean canClose(XcosDiagram xcosDiagram) {
        boolean bl = false;
        ScicosObjectOwner scicosObjectOwner = Xcos.findRoot(xcosDiagram);
        boolean bl2 = this.openedDiagrams(scicosObjectOwner).size() <= 1;
        boolean bl3 = this.isModified(scicosObjectOwner);
        if (!bl2 || !bl3) {
            bl = true;
        }
        if (!bl) {
            ScilabModalDialog.AnswerOption answerOption = ScilabModalDialog.show((SimpleTab)XcosTab.get(xcosDiagram), (String)XcosMessages.DIAGRAM_MODIFIED, (String)XcosMessages.XCOS, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO_CANCEL);
            switch (answerOption) {
                case YES_OPTION: {
                    bl = this.diagrams.get(scicosObjectOwner).iterator().next().saveDiagram();
                    break;
                }
                case NO_OPTION: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (bl) {
            this.configuration.addToRecentTabs(xcosDiagram);
            this.configuration.saveConfig();
        }
        return bl;
    }

    public void destroy(XcosDiagram xcosDiagram) {
        boolean bl;
        ScicosObjectOwner scicosObjectOwner = Xcos.findRoot(xcosDiagram);
        boolean bl2 = bl = this.openedDiagrams(scicosObjectOwner).size() <= 1;
        if (bl) {
            this.diagrams.remove(scicosObjectOwner);
        } else {
            this.diagrams.get(scicosObjectOwner).remove((Object)xcosDiagram);
        }
        if (this.openedDiagrams().size() <= 0) {
            JavaController.end_simulation();
        }
    }

    public String askForClosing(XcosDiagram xcosDiagram, List<SwingScilabDockablePanel> list) {
        String string = this.wasLastOpened(list) ? TRADENAME : null;
        return string;
    }

    public boolean wasLastOpened(List<SwingScilabDockablePanel> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (XcosDiagram object : this.openedDiagrams()) {
            hashSet.add(object.getGraphTab());
        }
        HashSet hashSet2 = new HashSet();
        for (SwingScilabDockablePanel swingScilabDockablePanel : list) {
            if (swingScilabDockablePanel == null) continue;
            hashSet2.add(swingScilabDockablePanel.getPersistentId());
        }
        hashSet.removeAll(hashSet2);
        return hashSet.isEmpty();
    }

    public List<ExternalAction> getExternalActions() {
        return this.externalActions;
    }

    public static synchronized void closeSession(boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            LOG.severe(CALLED_OUTSIDE_THE_EDT_THREAD);
        }
        if (sharedInstance == null) {
            return;
        }
        Xcos xcos = sharedInstance;
        ArrayList<XcosTab> arrayList = new ArrayList<XcosTab>();
        for (Collection collection : xcos.diagrams.values()) {
            for (XcosDiagram xcosDiagram : collection) {
                XcosTab xcosTab = XcosTab.get(xcosDiagram);
                if (xcosTab == null) continue;
                arrayList.add(xcosTab);
            }
        }
        boolean bl2 = ClosingOperationsManager.startClosingOperation(arrayList, (boolean)bl, (boolean)bl);
        if (bl2) {
            xcos.diagrams.clear();
            JavaController.end_simulation();
            xcos.palette.saveConfig();
            xcos.configuration.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScilabExported(module="xcos", filename="Xcos.giws.xml")
    public static void xcos(final String string, final long l) {
        final Xcos xcos = Xcos.getInstance();
        xcos.lastError = null;
        InterpreterManagement.requestScilabExec((String)LOAD_XCOS_LIBS_LOAD_SCICOS);
        Xcos xcos2 = xcos;
        synchronized (xcos2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    xcos.open(string, l);
                }
            });
        }
        if (xcos.lastError != null && !xcos.lastError.isEmpty()) {
            throw new RuntimeException(xcos.lastError);
        }
    }

    @ScilabExported(module="xcos", filename="Xcos.giws.xml")
    public static void xcosDiagramToScilab(String string, long l, boolean bl) throws Exception {
        XcosFileType xcosFileType = XcosFileType.findFileType(string);
        if (xcosFileType == null) {
            throw new IllegalArgumentException("not handled filetype");
        }
        if (XcosFileType.getAvailableSaveFormats().contains((Object)xcosFileType)) {
            if (bl) {
                xcosFileType.save(string, new XcosDiagram(new JavaController(), l, Kind.DIAGRAM, ""));
            } else {
                xcosFileType.load(string, new XcosDiagram(new JavaController(), l, Kind.DIAGRAM, ""));
            }
        } else {
            throw new IllegalArgumentException("not handled filetype");
        }
    }

    @ScilabExported(module="xcos", filename="Xcos.giws.xml")
    public static void closeXcosFromScilab() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Xcos.closeSession(false);
                    Xcos.clearInstance();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            String string = null;
            for (Throwable throwable = invocationTargetException; throwable != null; throwable = ((Throwable)throwable).getCause()) {
                string = throwable.getLocalizedMessage();
            }
            throw new RuntimeException(string, invocationTargetException);
        }
    }

    @ScilabExported(module="xcos", filename="Xcos.giws.xml")
    public static void warnCellByUID(final String[] stringArray, final String string) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Xcos.getInstance().warnCell(stringArray, string);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            LOG.severe(interruptedException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            String string2 = null;
            for (Throwable throwable = invocationTargetException; throwable != null; throwable = ((Throwable)throwable).getCause()) {
                string2 = throwable.getLocalizedMessage();
            }
            throw new RuntimeException(string2, invocationTargetException);
        }
    }

    private void warnCell(String[] stringArray, String string) {
        mxCell[] mxCellArray = new mxCell[stringArray.length];
        XcosDiagram[] xcosDiagramArray = new XcosDiagram[stringArray.length];
        this.lookupForCells(stringArray, mxCellArray, xcosDiagramArray);
        for (int i = mxCellArray.length - 1; i >= 0; --i) {
            mxCell mxCell2 = mxCellArray[i];
            if (mxCell2 == null) continue;
            XcosDiagram xcosDiagram = xcosDiagramArray[i];
            xcosDiagram.warnCellByUID(mxCell2.getId(), string);
            SwingUtilities.invokeLater(() -> XcosTab.get(xcosDiagram).setCurrent());
            return;
        }
    }

    public void lookupForCells(String[] stringArray, mxCell[] mxCellArray, XcosDiagram[] xcosDiagramArray) {
        List<XcosDiagram> list = this.openedDiagrams();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            xcosDiagramArray[i] = list.stream().filter(xcosDiagram -> ((XcosGraphModel)xcosDiagram.getModel()).getCell(string) != null).findFirst().orElse(null);
            if (xcosDiagramArray[i] == null) continue;
            mxCellArray[i] = (mxCell)((XcosGraphModel)xcosDiagramArray[i].getModel()).getCell(string);
        }
    }

    @ScilabExported(module="xcos", filename="Xcos.giws.xml")
    public static void addToolsMenu(String string, String string2) {
        ExternalAction externalAction = new ExternalAction(null, string2);
        externalAction.putValue("Name", string);
        Xcos xcos = Xcos.getInstance();
        xcos.externalActions.add(externalAction);
        for (XcosDiagram xcosDiagram : xcos.openedDiagrams()) {
            Component[] componentArray;
            String string3 = xcosDiagram.getGraphTab();
            SwingScilabDockablePanel swingScilabDockablePanel = ScilabTabFactory.getInstance().getFromCache(string3);
            if (swingScilabDockablePanel == null) continue;
            SwingScilabMenuBar swingScilabMenuBar = (SwingScilabMenuBar)swingScilabDockablePanel.getMenuBar().getAsSimpleMenuBar();
            for (Component component : componentArray = swingScilabMenuBar.getComponents()) {
                SwingScilabMenu swingScilabMenu;
                if (!(component instanceof SwingScilabMenu) || (swingScilabMenu = (SwingScilabMenu)component).getText() != XcosMessages.TOOLS) continue;
                swingScilabMenu.add((Action)((Object)new ExternalAction(externalAction, xcosDiagram)));
            }
            BarUpdater.updateBars((String)swingScilabDockablePanel.getParentWindowId(), (MenuBar)swingScilabDockablePanel.getMenuBar(), (ToolBar)swingScilabDockablePanel.getToolBar(), (TextBox)swingScilabDockablePanel.getInfoBar(), (String)swingScilabDockablePanel.getName(), (Image)swingScilabDockablePanel.getWindowIcon());
        }
    }

    @ScilabExported(module="xcos", filename="Xcos.giws.xml")
    public static void xcosSimulationStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphActionManager.setEnable(StopAction.class, (boolean)true);
            }
        });
    }

    public static XcosDiagram findDiagram(long l) {
        Xcos xcos = Xcos.getInstance();
        for (Collection collection : xcos.diagrams.values()) {
            for (XcosDiagram xcosDiagram : collection) {
                Object object = xcosDiagram.getDefaultParent();
                if (!(object instanceof XcosCell) || ((XcosCell)((Object)object)).getUID() != l) continue;
                return xcosDiagram;
            }
        }
        return null;
    }

    public static XcosDiagram findParent(JavaController javaController, long l, Kind kind) {
        Xcos xcos = Xcos.getInstance();
        long[] lArray = new long[]{0L};
        javaController.getObjectProperty(l, kind, ObjectProperties.PARENT_BLOCK, lArray);
        if (lArray[0] == 0L) {
            javaController.getObjectProperty(l, kind, ObjectProperties.PARENT_DIAGRAM, lArray);
        }
        for (Collection collection : xcos.diagrams.values()) {
            for (XcosDiagram xcosDiagram : collection) {
                Object object = xcosDiagram.getDefaultParent();
                if (!(object instanceof XcosCell) || ((XcosCell)((Object)object)).getUID() != lArray[0]) continue;
                return xcosDiagram;
            }
        }
        return null;
    }

    public static ScicosObjectOwner findRoot(XcosDiagram xcosDiagram) {
        return Xcos.findRoot(new JavaController(), xcosDiagram);
    }

    public static ScicosObjectOwner findRoot(JavaController javaController, XcosDiagram xcosDiagram) {
        ScicosObjectOwner scicosObjectOwner;
        if (xcosDiagram.getKind() == Kind.DIAGRAM) {
            scicosObjectOwner = new ScicosObjectOwner(javaController, xcosDiagram.getUID(), xcosDiagram.getKind());
        } else {
            long[] lArray = new long[1];
            javaController.getObjectProperty(xcosDiagram.getUID(), xcosDiagram.getKind(), ObjectProperties.PARENT_DIAGRAM, lArray);
            scicosObjectOwner = new ScicosObjectOwner(javaController, lArray[0], Kind.DIAGRAM);
        }
        return scicosObjectOwner;
    }

    static {
        Scilab.registerInitialHook(() -> {
            Timer timer = new Timer(500, null);
            timer.addActionListener(actionEvent -> {
                if (ScilabCommons.getStartProcessing() == 1) {
                    return;
                }
                timer.stop();
                InterpreterManagement.requestScilabExec((String)LOAD_XCOS_LIBS_LOAD_SCICOS);
            });
            timer.start();
        });
        XConfiguration.addXConfigurationListener((XConfigurationListener)new XcosConfiguration());
    }

    public static class XcosTabFactory
    extends AbstractScilabTabFactory {
        private DocumentType cachedDocumentType;

        public XcosTabFactory() {
            this(true);
        }

        private XcosTabFactory(boolean bl) {
            if (bl) {
                Xcos.getInstance(this);
            }
        }

        public synchronized SwingScilabDockablePanel getTab(String string) {
            if (string == null) {
                return null;
            }
            SwingScilabDockablePanel swingScilabDockablePanel = ScilabTabFactory.getInstance().getFromCache(string);
            if (swingScilabDockablePanel == null && "org.scilab.modules.xcos.palette.model".equals(string)) {
                PaletteManagerView.restore(null, false);
                swingScilabDockablePanel = PaletteManagerView.get();
            }
            if (swingScilabDockablePanel == null) {
                boolean bl;
                this.cache(string);
                if (this.cachedDocumentType == null) {
                    return null;
                }
                boolean bl2 = string.equals(this.cachedDocumentType.getUuid());
                XcosDiagram xcosDiagram = this.getDiagram(bl2, bl = string.equals(this.cachedDocumentType.getViewport()));
                if (xcosDiagram != null && bl2) {
                    XcosTab.restore(xcosDiagram, false);
                    xcosDiagram.fireEvent(new mxEventObject(mxEvent.ROOT));
                    swingScilabDockablePanel = XcosTab.get(xcosDiagram);
                } else if (xcosDiagram != null && bl) {
                    ViewPortTab.restore(xcosDiagram, false);
                    swingScilabDockablePanel = ViewPortTab.get(xcosDiagram);
                    ClosingOperationsManager.addDependency((SwingScilabDockablePanel)XcosTab.get(xcosDiagram), (SwingScilabDockablePanel)swingScilabDockablePanel);
                    WindowsConfigurationManager.makeDependency((String)xcosDiagram.getGraphTab(), (String)swingScilabDockablePanel.getPersistentId());
                } else {
                    return null;
                }
            }
            WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)swingScilabDockablePanel);
            ScilabTabFactory.getInstance().addToCache(swingScilabDockablePanel);
            return swingScilabDockablePanel;
        }

        private XcosDiagram getDiagram(boolean bl, boolean bl2) {
            Xcos xcos = Xcos.getInstance();
            XcosDiagram xcosDiagram = null;
            if (bl) {
                xcosDiagram = Xcos.getInstance().configuration.loadDiagram(this.cachedDocumentType);
            } else if (bl2) {
                File file = xcos.configuration.getFile(this.cachedDocumentType);
                ScicosObjectOwner scicosObjectOwner = Xcos.getInstance().openedDiagram(file);
                Collection collection = xcos.diagrams.getOrDefault(scicosObjectOwner, Collections.emptyList());
                for (XcosDiagram xcosDiagram2 : collection) {
                    String string = xcosDiagram2.getGraphTab();
                    if (string == null || !string.equals(this.cachedDocumentType.getUuid())) continue;
                    xcosDiagram = xcosDiagram2;
                    break;
                }
            }
            return xcosDiagram;
        }

        public synchronized boolean isAValidUUID(String string) {
            if ("org.scilab.modules.xcos.palette.model".equals(string)) {
                return true;
            }
            this.cache(string);
            return this.cachedDocumentType != null;
        }

        private void cache(String string) {
            if (this.cachedDocumentType != null) {
                boolean bl = string.equals(this.cachedDocumentType.getUuid());
                boolean bl2 = string.equals(this.cachedDocumentType.getViewport());
                if (bl || bl2) {
                    return;
                }
                this.cachedDocumentType = null;
            }
            ConfigurationManager configurationManager = Xcos.getInstance().configuration;
            List<DocumentType> list = configurationManager.getSettings().getTab();
            for (DocumentType documentType : list) {
                boolean bl = string.equals(documentType.getUuid());
                boolean bl3 = string.equals(documentType.getViewport());
                if (!bl && !bl3) continue;
                this.cachedDocumentType = documentType;
                break;
            }
        }

        public String getPackage() {
            return TRADENAME;
        }

        public String getClassName() {
            return XcosTabFactory.class.getName();
        }

        public String getApplication() {
            return TRADENAME;
        }
    }
}

