/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos;

import com.mxgraph.swing.mxGraphOutline;
import java.awt.Container;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.XcosTab;
import org.scilab.modules.xcos.configuration.ConfigurationManager;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class ViewPortTab
extends SwingScilabDockablePanel
implements SimpleTab {
    public static final String DEFAULT_WIN_UUID = "xcos-viewport-default-window";
    public static final String DEFAULT_TAB_UUID = "xcos-viewport-default-tab";

    private ViewPortTab(XcosDiagram xcosDiagram, String string) {
        super(XcosMessages.VIEWPORT, string);
        xcosDiagram.setViewPortTab(string);
        this.setWindowIcon(Xcos.ICON.getImage());
        this.initComponents(xcosDiagram);
    }

    public static ViewPortTab get(XcosDiagram xcosDiagram) {
        String string = xcosDiagram.getViewPortTab();
        return (ViewPortTab)ScilabTabFactory.getInstance().getFromCache(string);
    }

    public static void restore(XcosDiagram xcosDiagram) {
        ViewPortTab.restore(xcosDiagram, true);
    }

    public static void restore(XcosDiagram xcosDiagram, boolean bl) {
        String string = xcosDiagram.getViewPortTab();
        if (string == null) {
            string = UUID.randomUUID().toString();
        }
        ViewPortTab viewPortTab = new ViewPortTab(xcosDiagram, string);
        if (bl) {
            viewPortTab.createDefaultWindow().setVisible(true);
            viewPortTab.setCurrent();
        }
        ScilabTabFactory.getInstance().addToCache((SwingScilabDockablePanel)viewPortTab);
        ClosingOperationsManager.registerClosingOperation((SwingScilabDockablePanel)viewPortTab, (ClosingOperationsManager.ClosingOperation)new ClosingOperation(xcosDiagram));
        ClosingOperationsManager.addDependency((SwingScilabDockablePanel)XcosTab.get(xcosDiagram), (SwingScilabDockablePanel)viewPortTab);
        WindowsConfigurationManager.registerEndedRestoration((SwingScilabDockablePanel)viewPortTab, (WindowsConfigurationManager.EndedRestoration)new EndedRestoration(xcosDiagram));
    }

    private void initComponents(XcosDiagram xcosDiagram) {
        mxGraphOutline mxGraphOutline2 = new mxGraphOutline(xcosDiagram.getAsComponent());
        mxGraphOutline2.setDrawLabels(true);
        this.setContentPane((Container)mxGraphOutline2);
    }

    private SwingScilabWindow createDefaultWindow() {
        SwingScilabWindow swingScilabWindow = WindowsConfigurationManager.createWindow((String)DEFAULT_WIN_UUID, (boolean)false);
        SwingScilabWindow swingScilabWindow2 = swingScilabWindow != null ? swingScilabWindow : SwingScilabWindow.createWindow((boolean)true);
        swingScilabWindow2.addTab((SwingScilabPanel)this);
        return swingScilabWindow2;
    }

    private static class EndedRestoration
    implements WindowsConfigurationManager.EndedRestoration {
        private final XcosDiagram graph;

        public EndedRestoration(XcosDiagram xcosDiagram) {
            this.graph = xcosDiagram;
        }

        public void finish() {
            ConfigurationManager.getInstance().removeFromRecentTabs(this.graph.getViewPortTab());
        }
    }

    private static class ClosingOperation
    implements ClosingOperationsManager.ClosingOperation {
        private final XcosDiagram graph;

        public ClosingOperation(XcosDiagram xcosDiagram) {
            this.graph = xcosDiagram;
        }

        public int canClose() {
            return 1;
        }

        public void destroy() {
            this.graph.setViewPortTab(null);
            XcosTab xcosTab = XcosTab.get(this.graph);
            xcosTab.setViewportChecked(false);
        }

        public String askForClosing(List<SwingScilabDockablePanel> list) {
            return null;
        }

        public void updateDependencies(List<SwingScilabDockablePanel> list, ListIterator<SwingScilabDockablePanel> listIterator) {
        }
    }
}

