/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.core;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.flexdock.docking.DockableFactory;
import org.flexdock.docking.DockingManager;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.utils.MenuBarBuilder;
import org.scilab.modules.gui.SwingView;
import org.scilab.modules.gui.bridge.console.SwingScilabConsole;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.gui.utils.LookAndFeelManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;

public class Scilab {
    private static final double VISTA_VERSION = 6.0;
    private static final String ENABLE_JAVA2D_OPENGL_PIPELINE = "sun.java2d.opengl";
    private static final String ENABLE = "true";
    private static final String DISABLE = "false";
    private static final String DISABLE_DDRAW = "sun.java2d.noddraw";
    private static final String OSNAME = "os.name";
    private static final String MACOS = "mac";
    private static boolean success;
    private static boolean finish;
    private static boolean exitCalled;
    private static int mode;
    private static List<Runnable> finalhooks;
    private static List<Runnable> initialhooks;
    private SwingScilabWindow mainView;

    public Scilab(int n) {
        Object object;
        Object object2;
        Object object3;
        mode = n;
        ScilabConstants.setMode((int)n);
        DockingManager.setDockableFactory((DockableFactory)ScilabTabFactory.getInstance());
        try {
            if (n != 1) {
                System.setProperty("java.io.tmpdir", ScilabConstants.TMPDIR.getCanonicalPath());
                System.setProperty("user.home", ScilabConstants.SCIHOME.getCanonicalPath());
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot retrieve the variable SCI. Please report on http://bugzilla.scilab.org/");
            System.err.println(exception.getLocalizedMessage());
            System.exit(-1);
        }
        Scilab.setJOGLFlags();
        if (n == 2) {
            SwingView.registerSwingView();
        }
        if (n != 1 && System.getenv("SCI_JAVA_ENABLE_HEADLESS") == null) {
            try {
                object3 = "javax.swing.plaf.metal.MetalLookAndFeel";
                if (OS.get() == OS.WINDOWS) {
                    object3 = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                } else if (System.getProperty(OSNAME).toLowerCase().indexOf(MACOS) != -1) {
                    System.setProperty("heavyweight.dockables", ENABLE);
                    object3 = "apple.laf.AquaLookAndFeel";
                } else {
                    object3 = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                    if (!GraphicsEnvironment.isHeadless()) {
                        try {
                            object2 = Toolkit.getDefaultToolkit();
                            object = object2.getClass().getDeclaredField("awtAppClassName");
                            ((Field)object).setAccessible(true);
                            ((Field)object).set(object2, "Scilab");
                        }
                        catch (Exception exception) {
                            System.err.println("Unable to set WM_CLASS, please report a bug on http://bugzilla.scilab.org/.");
                            System.err.println("Error: " + exception.getLocalizedMessage());
                        }
                    }
                }
                if (!GraphicsEnvironment.isHeadless()) {
                    object2 = new LookAndFeelManager();
                    if (object2.isSupportedLookAndFeel((String)object3)) {
                        object2.setLookAndFeel((String)object3);
                    } else {
                        object2.setSystemLookAndFeel();
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("Could not initialize graphics Environment");
                System.err.println("Scilab Graphical option may not be working correctly.");
                System.err.println("An error occurred: " + noClassDefFoundError.getLocalizedMessage());
            }
        }
        if (n == 2) {
            ConfigManager.createUserCopy();
            object3 = GraphicController.getController().askObject(GraphicObject.Type.JAVACONSOLE);
            MenuBarBuilder.buildConsoleMenuBar((Integer)object3);
            object2 = (SwingScilabConsole)ScilabConsole.getConsole().getAsSimpleConsole();
            object = (SwingScilabDockablePanel)object2.getParent();
            WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)object);
            this.mainView = (SwingScilabWindow)SwingScilabWindow.allScilabWindows.get(object.getParentWindowId());
        } else {
            GraphicController.getController().askObject(GraphicObject.Type.CONSOLE);
        }
    }

    public static int getMode() {
        return mode;
    }

    public void setPrompt(String string) {
        ScilabConsole.getConsole().setPrompt(string);
    }

    public static void setJOGLFlags() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        System.setProperty(ENABLE_JAVA2D_OPENGL_PIPELINE, DISABLE);
        if (OS.get() == OS.WINDOWS) {
            if ((Double)OS.get().getVersion() >= 6.0) {
                System.setProperty(ENABLE_JAVA2D_OPENGL_PIPELINE, DISABLE);
            }
            System.setProperty(DISABLE_DDRAW, ENABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canClose() {
        final Object object = new Object();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                exitCalled = true;
                success = ClosingOperationsManager.startClosingOperationOnRoot();
                exitCalled = false;
                finish = true;
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
            }
        });
        try {
            Object object2 = object;
            synchronized (object2) {
                while (!finish) {
                    object.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
        finish = false;
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceClose() {
        final Object object = new Object();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                exitCalled = true;
                ClosingOperationsManager.forceClosingOperationOnRoot();
                exitCalled = false;
                finish = true;
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
            }
        });
        try {
            Object object2 = object;
            synchronized (object2) {
                while (!finish) {
                    object.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
        finish = false;
    }

    public static boolean getExitCalled() {
        return exitCalled;
    }

    public static void registerFinalHook(Runnable runnable) {
        finalhooks.add(runnable);
    }

    public static void removeFinalHook(Runnable runnable) {
        finalhooks.remove(runnable);
    }

    public static void executeFinalHooks() {
        for (Runnable runnable : finalhooks) {
            runnable.run();
        }
    }

    public static void registerInitialHook(Runnable runnable) {
        initialhooks.add(runnable);
    }

    public static void removeInitialHook(Runnable runnable) {
        initialhooks.remove(runnable);
    }

    public static void executeInitialHooks() {
        ScilabCommonsUtils.registerScilabThread();
        for (Runnable runnable : initialhooks) {
            runnable.run();
        }
    }

    static {
        System.setProperty("java.protocol.handler.pkgs", "org.scilab.modules.commons");
        XConfiguration.getXConfigurationDocument();
        finalhooks = new ArrayList<Runnable>();
        initialhooks = new ArrayList<Runnable>();
    }
}

