/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.core;

import java.awt.Container;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import javax.swing.JTextArea;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.core.Scilab;
import org.scilab.modules.gui.ScilabTermination;
import org.scilab.modules.gui.bridge.CallScilabBridge;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.tab.ScilabTab;
import org.scilab.modules.gui.tab.Tab;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.gui.utils.ToolBarBuilder;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.jvm.LoadClassPath;
import org.scilab.modules.localization.Messages;

public class ConsoleTab {
    private static final String CLASS_NOT_FOUND = "Could not find class: ";
    private static final String SEE_DEFAULT_PATHS = "See SCI/etc/classpath.xml for default paths.";
    private static final String NOCONSOLE = Messages.gettext((String)"No available console !\nPlease use STD mode.");
    private static final String EMPTYTAB = Messages.gettext((String)"Empty tab");
    private static final String MAINTOOLBARXMLFILE = ScilabConstants.SCI + "/modules/gui/etc/main_toolbar.xml";

    public static Tab getConsoleTab(String string) {
        String string2;
        if (Scilab.getMode() != 2) {
            Tab tab = ScilabTab.createTab((String)EMPTYTAB, (String)string);
            JTextArea jTextArea = new JTextArea(NOCONSOLE);
            jTextArea.setEditable(false);
            ((SwingScilabDockablePanel)tab.getAsSimpleTab()).setContentPane((Container)jTextArea);
            ((SwingScilabDockablePanel)tab.getAsSimpleTab()).setAssociatedXMLIDForHelp("console");
            ClosingOperationsManager.registerClosingOperation((Tab)tab, (ClosingOperationsManager.ClosingOperation)new ClosingOperationsManager.ClosingOperation(){

                public int canClose() {
                    return 1;
                }

                public void destroy() {
                }

                public String askForClosing(List<SwingScilabDockablePanel> list) {
                    return null;
                }

                public void updateDependencies(List<SwingScilabDockablePanel> list, ListIterator<SwingScilabDockablePanel> listIterator) {
                }
            });
            ClosingOperationsManager.addDependencyWithRoot((Tab)tab);
            WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)((SwingScilabDockablePanel)tab.getAsSimpleTab()));
            return tab;
        }
        Tab tab = null;
        try {
            LoadClassPath.loadOnUse((String)"Console");
            string2 = String.format(Messages.gettext((String)"Scilab %s Console"), ScilabCommonsUtils.getScilabVersionAsString());
            tab = string == null ? ScilabTab.createTab((String)string2, (String)UUID.randomUUID().toString()) : ScilabTab.createTab((String)string2, (String)string);
            ClosingOperationsManager.registerClosingOperation((Tab)tab, (ClosingOperationsManager.ClosingOperation)new ClosingOperationsManager.ClosingOperation(){

                public int canClose() {
                    CallScilabBridge.unblockConsole();
                    return 1;
                }

                public void destroy() {
                    if (!Scilab.getExitCalled()) {
                        ScilabTermination.ScilabExit();
                    }
                }

                public String askForClosing(List<SwingScilabDockablePanel> list) {
                    return "Scilab";
                }

                public void updateDependencies(List<SwingScilabDockablePanel> list, ListIterator<SwingScilabDockablePanel> listIterator) {
                }
            });
            ClosingOperationsManager.setRoot((Tab)tab);
            ScilabConsole.createConsole();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println("Cannot create Scilab Console.\nCheck if the thirdparties are available (JoGL/JRosetta...).\nSee SCI/etc/classpath.xml for default paths.");
            System.err.println(CLASS_NOT_FOUND + noClassDefFoundError.getLocalizedMessage());
            System.exit(-1);
        }
        ScilabConsole.getConsole().setMaxOutputSize(ConfigManager.getMaxOutputSize());
        tab.addMember(ScilabConsole.getConsole());
        ((SwingScilabDockablePanel)tab.getAsSimpleTab()).setAssociatedXMLIDForHelp("console");
        string2 = ScilabMenuBar.createMenuBar();
        ((SwingScilabDockablePanel)tab.getAsSimpleTab()).setMenuBar((MenuBar)string2);
        ScilabConsole.getConsole().addMenuBar((MenuBar)string2);
        ToolBar toolBar = ToolBarBuilder.buildToolBar((String)MAINTOOLBARXMLFILE);
        TextBox textBox = ScilabTextBox.createTextBox();
        toolBar.setVisible(true);
        ((SwingScilabDockablePanel)tab.getAsSimpleTab()).setToolBar(toolBar);
        ((SwingScilabDockablePanel)tab.getAsSimpleTab()).setInfoBar(textBox);
        ScilabConsole.getConsole().addMenuBar(tab.getMenuBar());
        ScilabConsole.getConsole().addToolBar(toolBar);
        ScilabConsole.getConsole().addInfoBar(textBox);
        return tab;
    }
}

