/*
 * Decompiled with CFR 0.152.
 */
package javax.help.tagext;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.Map;
import javax.help.Merge;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class IndexItemTag
extends BodyTagSupport {
    private Enumeration treeEnum;
    private DefaultMutableTreeNode topNode;
    private String baseID = "root";
    private HelpBroker hb;
    private IndexView view = null;

    public void setIndexView(IndexView view) {
        this.view = view;
    }

    public void setBaseID(String baseID) {
        this.baseID = baseID;
    }

    public void setHelpBroker(HelpBroker hb) {
        this.hb = hb;
    }

    private void initialize() {
        if (this.view == null) {
            return;
        }
        this.topNode = this.view.getDataAsTree();
        this.treeEnum = this.topNode.preorderEnumeration();
        String mergeType = this.view.getMergeType();
        HelpSet hs = this.view.getHelpSet();
        Locale locale = hs.getLocale();
        MergeHelpUtilities.mergeNodeChildren(mergeType, this.topNode);
        this.addSubHelpSets(hs);
    }

    private void addSubHelpSets(HelpSet hs) {
        Enumeration e = hs.getHelpSets();
        while (e.hasMoreElements()) {
            HelpSet ehs = (HelpSet)e.nextElement();
            if (ehs == null) continue;
            NavigatorView[] views = ehs.getNavigatorViews();
            for (int i = 0; i < views.length; ++i) {
                Merge mergeObject;
                if (!(views[i] instanceof IndexView) || (mergeObject = Merge.DefaultMergeFactory.getMerge(this.view, views[i])) == null) continue;
                mergeObject.processMerge(this.topNode);
            }
            this.addSubHelpSets(ehs);
        }
    }

    public int doStartTag() {
        this.initialize();
        if (this.treeEnum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeEnum.nextElement();
            if (node == this.topNode) {
                try {
                    node = (DefaultMutableTreeNode)this.treeEnum.nextElement();
                }
                catch (NoSuchElementException e) {
                    return 0;
                }
            }
            this.setNodeAttributes(node);
            return 2;
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        BodyContent body = this.getBodyContent();
        try {
            body.writeOut((Writer)this.getPreviousOut());
        }
        catch (IOException e) {
            throw new JspTagException("IndexItemTag: " + e.getMessage());
        }
        body.clearBody();
        if (this.treeEnum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeEnum.nextElement();
            this.setNodeAttributes(node);
            return 2;
        }
        return 0;
    }

    private void setNodeAttributes(DefaultMutableTreeNode node) {
        IndexItem item = (IndexItem)node.getUserObject();
        this.pageContext.setAttribute("name", (Object)item.getName());
        String helpID = "";
        if (item.getID() != null) {
            helpID = item.getID().id;
        }
        this.pageContext.setAttribute("helpID", (Object)helpID);
        this.pageContext.setAttribute("parent", (Object)Integer.toHexString(node.getParent().hashCode()));
        String id = this.getID(node.getParent());
        this.pageContext.setAttribute("parentID", (Object)id);
        this.pageContext.setAttribute("node", (Object)Integer.toHexString(node.hashCode()));
        id = this.getID(node);
        this.pageContext.setAttribute("nodeID", (Object)id);
        String content = this.getContentURL(item);
        this.pageContext.setAttribute("contentURL", (Object)content);
        String expansionType = Integer.toString(item.getExpansionType());
        this.pageContext.setAttribute("expansionType", (Object)expansionType);
    }

    private String getID(TreeNode node) {
        if (node == this.topNode) {
            return this.baseID;
        }
        TreeNode parent = node.getParent();
        if (parent == null) {
            return "";
        }
        String id = this.getID(parent);
        id = id.concat("." + Integer.toString(parent.getIndex(node)));
        return id;
    }

    private String getContentURL(IndexItem item) {
        URL url = null;
        Map.ID id = item.getID();
        if (id != null) {
            HelpSet hs = id.hs;
            Map map = hs.getLocalMap();
            try {
                url = map.getURLFromID(id);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (url == null) {
            return "";
        }
        return url.toExternalForm();
    }
}

