/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.scilab.modules.preferences.Component.Table;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.scilab.modules.preferences.XWizardManager;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSentinel
implements MouseListener,
ActionListener,
TableModelListener,
KeyListener,
DocumentListener,
PropertyChangeListener {
    private static final Set<String> LAYOUT = new TreeSet<String>(Arrays.asList("listener", "gridx", "gridy", "gridwidth", "gridheight", "weightx", "weighty", "anchor", "ipadx", "ipday", "insets", "fill", "border-side", "fixed-height", "fixed-width"));
    protected Node peer;
    protected String[] actuators;
    public String reduced;
    private long timestamp = 0L;
    private XComponent xComponent;

    public XSentinel(Component component, Node node) {
        this.peer = node;
        if (component instanceof XComponent) {
            this.xComponent = (XComponent)((Object)component);
            this.actuators = this.xComponent.actuators();
        } else {
            this.actuators = new String[0];
        }
    }

    public static String signature(Node node, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(node.getNodeName());
        if (!node.hasAttributes()) {
            return stringBuilder.toString();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
        treeSet.addAll(LAYOUT);
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            String string = node2.getNodeName();
            if (treeSet.contains(string)) continue;
            String string2 = node2.getNodeValue().replaceAll("[ \t\n]+", " ");
            stringBuilder.append(" ");
            stringBuilder.append(string);
            stringBuilder.append("='");
            stringBuilder.append(string2);
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }

    public void setPeer(Node node) {
        this.peer = node;
    }

    public boolean checks(Node node) {
        String string = XSentinel.signature(node, this.actuators);
        if (this.reduced == null) {
            this.reduced = XSentinel.signature(this.peer, this.actuators);
        }
        return this.reduced.equals(string);
    }

    boolean triggerEventNodes(Component component, Node[] nodeArray) {
        if (XConfigManager.active) {
            return XConfigManager.xEvent(nodeArray, component);
        }
        if (XWizardManager.active) {
            return XWizardManager.xEvent(nodeArray, component);
        }
        return false;
    }

    Node[] getEventNodes(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        long l = mouseEvent.getWhen();
        if (l != this.timestamp) {
            Node[] nodeArray = this.getEventNodes(this.peer, "mouseClicked");
            this.triggerEventNodes((Component)mouseEvent.getSource(), nodeArray);
            this.timestamp = l;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        long l = actionEvent.getWhen();
        if (l != this.timestamp) {
            Node[] nodeArray = this.getEventNodes(this.peer, "actionPerformed");
            if (nodeArray.length == 0) {
                nodeArray = this.getEventNodes(this.peer, actionEvent.getActionCommand());
            }
            if (nodeArray.length != 0) {
                this.triggerEventNodes((Component)actionEvent.getSource(), nodeArray);
                this.timestamp = l;
            }
        } else {
            System.out.println(" |  dummy actionPerformed discarded!");
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        long l = keyEvent.getWhen();
        if (l != this.timestamp) {
            Node[] nodeArray = this.getEventNodes(this.peer, "keyTyped");
            this.triggerEventNodes((Component)keyEvent.getSource(), nodeArray);
            this.timestamp = l;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        Node[] nodeArray = this.getEventNodes(this.peer, "entryChanged");
        this.triggerEventNodes((Component)((Object)this.xComponent), nodeArray);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        Node[] nodeArray = this.getEventNodes(this.peer, "entryChanged");
        this.triggerEventNodes((Component)((Object)this.xComponent), nodeArray);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Node[] nodeArray = this.getEventNodes(this.peer, "tableChanged");
        Table.processModelEvent(tableModelEvent, nodeArray);
        this.triggerEventNodes(null, nodeArray);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Node[] nodeArray = this.getEventNodes(this.peer, "propertyChange");
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length);
        for (Node node : nodeArray) {
            String string = XCommonManager.getAttribute(node, "name", null);
            if (string != null && !string.equals(propertyChangeEvent.getPropertyName())) continue;
            arrayList.add(node);
        }
        this.triggerEventNodes((Component)((Object)this.xComponent), arrayList.toArray(new Node[arrayList.size()]));
    }
}

