/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.commons.xml.ScilabTransformerFactory;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.localization.WindowsDefaultLanguage;
import org.scilab.modules.preferences.ScilabPreferences;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XConfigManager;
import org.scilab.modules.preferences.XSentinel;
import org.scilab.modules.preferences.XUpdateVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class XCommonManager {
    public static final boolean performances = true;
    public static final boolean differential = true;
    protected static final String ERROR_READ = "Could not load file: ";
    protected static final String ERROR_WRITE = "Could not save file: ";
    protected static final int BUFSIZE = 1024;
    protected static JDialog dialog;
    protected static Document document;
    protected static String documentAddress;
    protected static boolean updated;
    protected static Node topDOM;
    protected static Container topSwing;
    protected static Map<Component, XSentinel> correspondance;
    protected static XUpdateVisitor visitor;
    protected static long time;
    protected static TransformerFactory factory;
    protected static DocumentBuilderFactory builder;
    protected static Transformer transformer;
    private static final String SCI;
    private static final String SCILAB_CONFIG_FILE;
    private static String XSLCODE;
    public static final String INCREMENT = "    ";
    public static final String NAV = "\"not an value'";

    public static void printTimeStamp(String string) {
        long l = System.currentTimeMillis();
        long l2 = l - time;
        System.out.println((string.startsWith("*") ? "" : " |  ") + string + " in " + l2 + " ms.");
        time = l;
    }

    public static boolean refreshDisplay() {
        topDOM = XCommonManager.generateViewDOM().getNode().getFirstChild();
        if (topDOM == null) {
            System.err.println("XSL does not give a node!");
            return false;
        }
        visitor = new XUpdateVisitor(correspondance);
        visitor.visit(topSwing, topDOM);
        boolean bl = XCommonManager.setDimension(dialog, topDOM);
        if (bl) {
            dialog.pack();
        }
        return true;
    }

    private static String viewDOM(Node node, String string) {
        Object object;
        String string2 = string;
        if (node.hasAttributes()) {
            string2 = string2 + XSentinel.signature(node, new String[0]);
        } else {
            object = node.getNodeName() + ": " + node.getNodeValue();
            string2 = string2 + ((String)object).replaceAll("[ \t\n]+", " ");
        }
        string2 = string2 + "\n";
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            string2 = string2 + XCommonManager.viewDOM(node2, string + INCREMENT);
        }
        return string2;
    }

    protected static String viewDOM() {
        return XCommonManager.viewDOM(topDOM, "");
    }

    private static String swingComposite(Component component, String string) {
        String string2 = string;
        string2 = string2 + component.toString() + "\n";
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component2 = componentArray[i];
                string2 = string2 + XCommonManager.swingComposite(component2, string + INCREMENT);
            }
        }
        return string2;
    }

    protected static String swingComposite() {
        return XCommonManager.swingComposite(topSwing, "");
    }

    private static List<File> getEtcDir() {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(SCI + "/modules/");
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            File file3 = new File(file2, "/etc/");
            if (!file3.exists() || !file3.isDirectory()) continue;
            arrayList.add(file3);
        }
        return arrayList;
    }

    protected static String createXSLFile() {
        if (XSLCODE == null) {
            Object object;
            Object object22;
            List list = XConfiguration.getEtcDir();
            StringBuilder stringBuilder = new StringBuilder("<?xml version='1.0' encoding='utf-8'?>\n");
            stringBuilder.append("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n");
            stringBuilder.append("<xsl:param name=\"OS\"/>\n");
            stringBuilder.append("<xsl:param name=\"SCILAB_LANGUAGE\"/>\n");
            stringBuilder.append("<xsl:import href=\"").append(SCI).append("/modules/preferences/src/xslt/XConfiguration.xsl").append("\"/>\n");
            FilenameFilter filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".xsl") && string.startsWith("XConfiguration");
                }
            };
            for (Object object22 : list) {
                for (File file : object = ((File)object22).listFiles(filenameFilter)) {
                    try {
                        stringBuilder.append("<xsl:import href=\"").append(file.getCanonicalPath()).append("\"/>\n");
                    }
                    catch (IOException iOException) {
                        stringBuilder.append("<xsl:import href=\"").append(file.getAbsolutePath()).append("\"/>\n");
                    }
                }
            }
            List<ScilabPreferences.ToolboxInfos> list2 = ScilabPreferences.getToolboxesInfos();
            filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".xsl");
                }
            };
            object22 = list2.iterator();
            while (object22.hasNext()) {
                File[] fileArray;
                object = (ScilabPreferences.ToolboxInfos)object22.next();
                File file = new File(((ScilabPreferences.ToolboxInfos)object).getPrefFile()).getParentFile();
                for (File file2 : fileArray = file.listFiles(filenameFilter)) {
                    try {
                        stringBuilder.append("<xsl:import href=\"").append(file2.getCanonicalPath()).append("\"/>\n");
                    }
                    catch (IOException iOException) {
                        stringBuilder.append("<xsl:import href=\"").append(file2.getAbsolutePath()).append("\"/>\n");
                    }
                }
            }
            stringBuilder.append("</xsl:stylesheet>");
            XSLCODE = stringBuilder.toString();
        }
        return XSLCODE;
    }

    public static void invalidateXSL() {
        XSLCODE = null;
    }

    protected static void reloadTransformer(String string) {
        try {
            StreamSource streamSource = new StreamSource(new StringReader(XCommonManager.createXSLFile()));
            transformer = factory.newTransformer(streamSource);
            transformer.setParameter("OS", OS.getVersionName());
            if (OS.get() == OS.WINDOWS) {
                transformer.setParameter("SCILAB_LANGUAGE", WindowsDefaultLanguage.getdefaultlanguage());
            } else {
                transformer.setParameter("SCILAB_LANGUAGE", "");
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println(ERROR_READ + string);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            System.err.println(ERROR_READ + string);
        }
    }

    private static DOMResult generateViewDOM() {
        DOMResult dOMResult = new DOMResult();
        DOMSource dOMSource = new DOMSource(document);
        try {
            transformer.transform(dOMSource, dOMResult);
        }
        catch (TransformerException transformerException) {
            System.out.println("\n");
        }
        return dOMResult;
    }

    public static Element getElementByContext(String string) {
        String[] stringArray = string.split("/");
        Element element = document.getDocumentElement();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = Integer.parseInt(stringArray[i]);
            NodeList nodeList = element.getChildNodes();
            Node node = null;
            for (int j = 0; n > 0 && j < nodeList.getLength(); ++j) {
                node = nodeList.item(j);
                if (node.getNodeName().equals("#text") || node.getNodeName().equals("#comment")) continue;
                --n;
            }
            if (n != 0) {
                System.err.println("'" + string + "' out of document!");
                return null;
            }
            element = (Element)node;
        }
        return element;
    }

    public static String getPath(String string) {
        String[] stringArray = string.split("/");
        Element element = document.getDocumentElement();
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            int n2 = 1;
            NodeList nodeList = element.getChildNodes();
            Node node = null;
            int n3 = nodeList.getLength();
            for (n = 0; n < n3; ++n) {
                node = nodeList.item(n);
                String string3 = node.getNodeName();
                if (string3.equalsIgnoreCase(stringArray[i])) {
                    string2 = string2 + n2 + "/";
                    element = (Element)node;
                    break;
                }
                if (node.getNodeName().equals("#text") || node.getNodeName().equals("#comment")) continue;
                ++n2;
            }
            if (n != n3) continue;
            System.err.println("Invalid path: " + string);
            return "1/";
        }
        return string2;
    }

    protected static boolean generixEvent(Node[] nodeArray, Component component) {
        boolean bl;
        if (nodeArray.length == 0) {
            return false;
        }
        Node node = nodeArray[0];
        boolean bl2 = bl = XCommonManager.getAttribute(node, "enable").equals(NAV) || XCommonManager.getAttribute(node, "enable").equals("true");
        if (!XCommonManager.getAttribute(node, "set").equals(NAV) && bl) {
            for (int i = 0; i < nodeArray.length; ++i) {
                node = nodeArray[i];
                String string = XCommonManager.getAttribute(node, "context");
                Element element = XCommonManager.getElementByContext(string);
                String string2 = XCommonManager.getAttribute(node, "value");
                String string3 = XCommonManager.getAttribute(node, "set");
                if (string3.equals("path") && string.equals("/") && !Character.isDigit(string2.charAt(0))) {
                    string2 = XCommonManager.getPath(string2);
                }
                if (element == null) continue;
                element.setAttribute(string3, string2);
                XConfiguration.addModifiedPath((String)XCommonManager.getNodePath(element));
            }
            XCommonManager.refreshDisplay();
            updated = true;
            return true;
        }
        if (!XCommonManager.getAttribute(node, "insert").equals(NAV) && bl) {
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node2;
                Object object;
                node = nodeArray[i];
                String string = XCommonManager.getAttribute(node, "context");
                Element element = XCommonManager.getElementByContext(string);
                String string4 = XCommonManager.getAttribute(node, "insert");
                int n = 0;
                try {
                    n = Integer.decode(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    object = (XChooser)((Object)component);
                    string4 = object.choose().toString();
                    n = Integer.decode(string4) + 1;
                }
                Node node3 = null;
                object = element.getChildNodes();
                for (int j = 0; j < object.getLength(); ++j) {
                    node2 = object.item(j);
                    if (node2.getNodeName().equals("#text") || node2.getNodeName().equals("#comment")) continue;
                    if (n == 1) {
                        node3 = node2;
                        break;
                    }
                    --n;
                }
                DocumentFragment documentFragment = document.createDocumentFragment();
                while (node.hasChildNodes()) {
                    node2 = node.getFirstChild();
                    node.removeChild(node2);
                    node2 = document.importNode(node2, true);
                    documentFragment.appendChild(node2);
                }
                if (element == null) continue;
                element.insertBefore(documentFragment, node3);
            }
            XCommonManager.refreshDisplay();
            updated = true;
            return true;
        }
        if (!XCommonManager.getAttribute(node, "delete").equals(NAV) && bl) {
            for (int i = 0; i < nodeArray.length; ++i) {
                Object object;
                node = nodeArray[i];
                String string = XCommonManager.getAttribute(node, "context");
                Element element = XCommonManager.getElementByContext(string);
                String string5 = XCommonManager.getAttribute(node, "delete");
                int n = 0;
                try {
                    n = Integer.decode(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    if (component == null) {
                        return false;
                    }
                    object = (XChooser)((Object)component);
                    string5 = object.choose().toString();
                    n = Integer.decode(string5);
                }
                Node node4 = null;
                object = element.getChildNodes();
                for (int j = 0; j < object.getLength(); ++j) {
                    Node node5 = object.item(j);
                    if (node5.getNodeName().equals("#text") || node5.getNodeName().equals("#comment")) continue;
                    if (n == 1) {
                        node4 = node5;
                        break;
                    }
                    --n;
                }
                if (element == null || node4 == null) continue;
                element.removeChild(node4);
            }
            XCommonManager.refreshDisplay();
            updated = true;
            return true;
        }
        if (!XCommonManager.getAttribute(node, "choose").equals(NAV) && bl) {
            if (component == null) {
                return false;
            }
            String string = XCommonManager.getAttribute(node, "context");
            Element element = XCommonManager.getElementByContext(string);
            if (component instanceof XChooser) {
                XChooser xChooser = (XChooser)((Object)component);
                Object object = xChooser.choose();
                if (object != null) {
                    String string6 = XCommonManager.getAttribute(node, "choose");
                    if (element != null) {
                        if (object instanceof String[]) {
                            String[] stringArray = (String[])object;
                            StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                            int n = Math.min(stringTokenizer.countTokens(), stringArray.length);
                            for (int i = 0; i < n; ++i) {
                                String string7 = stringTokenizer.nextToken().trim();
                                element.setAttribute(string7, stringArray[i]);
                            }
                        } else {
                            element.setAttribute(string6, object.toString());
                        }
                        XConfiguration.addModifiedPath((String)XCommonManager.getNodePath(element));
                    }
                    XCommonManager.refreshDisplay();
                    updated = true;
                }
            } else {
                System.err.println("@choose attribute only valid on choosers (SELECT, COLOR, FILE, ENTRY,...)");
            }
            return true;
        }
        if (!XCommonManager.getAttribute(node, "choose-child").equals(NAV) && bl) {
            if (component == null) {
                return false;
            }
            int n = Integer.parseInt(XCommonManager.getAttribute(node, "choose-child")) - 1;
            String string = XCommonManager.getAttribute(node, "context");
            Element element = XCommonManager.getElementByContext(string);
            NodeList nodeList = element.getChildNodes();
            if (element == null || n < 0 || n >= nodeList.getLength()) {
                return false;
            }
            Node node6 = nodeList.item(n);
            if (component instanceof XChooser) {
                XChooser xChooser = (XChooser)((Object)component);
                Object object = xChooser.choose();
                if (object != null) {
                    node6.setTextContent(object.toString());
                    XConfiguration.addModifiedPath((String)XCommonManager.getNodePath(element));
                    XCommonManager.refreshDisplay();
                    updated = true;
                }
            } else {
                System.err.println("@choose-child attribute only valid on choosers (SELECT, COLOR, FILE, ENTRY,...)");
            }
            return true;
        }
        return false;
    }

    public static final String getNodePath(Node node) {
        StringBuilder stringBuilder = new StringBuilder("/");
        Stack<String> stack = new Stack<String>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            Node node3;
            String string = node2.getNodeName();
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap != null && namedNodeMap.getLength() != 0 && (node3 = namedNodeMap.getNamedItem("xconf-uid")) != null) {
                string = string + "[@xconf-uid=\"" + node3.getNodeValue() + "\"]";
            }
            stack.push(string);
        }
        if (stack.size() >= 3) {
            stack.pop();
            stack.pop();
        } else {
            return null;
        }
        while (!stack.empty()) {
            stringBuilder.append("/");
            stringBuilder.append((String)stack.pop());
        }
        return stringBuilder.toString();
    }

    public static String getAttribute(Node node, String string, String string2) {
        String string3 = XCommonManager.getAttribute(node, string);
        if (string3 == NAV) {
            return string2;
        }
        return string3;
    }

    public static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return NAV;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return NAV;
        }
        String string2 = node2.getNodeValue();
        if (string2.startsWith("_(") && string2.endsWith(")")) {
            string2 = Messages.gettext((String)string2.substring(2, string2.length() - 1));
        }
        if (string2.startsWith("_d(") && string2.endsWith(")")) {
            int n = string2.indexOf(",");
            String string3 = string2.substring(3, n).trim();
            String string4 = string2.substring(n + 2, string2.length() - 1).trim();
            System.out.println("domain : !" + string3 + "! text : !" + string4 + "!");
            string2 = Messages.dgettext((String)string3, (String)string4);
        }
        return string2;
    }

    public static int getInt(Node node, String string, int n) {
        String string2 = XCommonManager.getAttribute(node, string);
        if (string2.equals(NAV) || string2.equals("")) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static double getDouble(Node node, String string, double d) {
        String string2 = XCommonManager.getAttribute(node, string);
        if (string2.equals(NAV) || string2.equals("")) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static boolean getBoolean(Node node, String string, boolean bl) {
        String string2 = XCommonManager.getAttribute(node, string);
        if (string2.equals(NAV) || string2.equals("")) {
            return bl;
        }
        return string2.equalsIgnoreCase("true");
    }

    public static String getColor(Color color) {
        if (color == null) {
            return "#000000";
        }
        String string = Integer.toHexString(color.getRGB());
        return "#" + string.substring(2);
    }

    public static Color getColor(String string) {
        return Color.decode(string);
    }

    public static Frame getTopLevel() {
        if (ScilabConsole.isExistingConsole()) {
            Container container = (Container)ScilabConsole.getConsole().getAsSimpleConsole();
            return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, container);
        }
        return null;
    }

    public static boolean setDimension(Component component, Node node) {
        int n = XConfigManager.getInt(node, "height", 0);
        int n2 = XConfigManager.getInt(node, "width", 0);
        if (n > 0 && n2 > 0) {
            Dimension dimension = component.getPreferredSize();
            if (dimension.width != n2 || dimension.height != n) {
                component.setPreferredSize(new Dimension(n2, n));
                return true;
            }
        }
        return false;
    }

    public static void createUserCopy(String string, String string2) {
        File file = new File(string2);
        if (!file.exists()) {
            XCommonManager.refreshUserCopy(string, string2);
        }
    }

    public static void refreshUserCopy(String string, String string2) {
        try {
            XCommonManager.copyFile(new File(string), new File(string2));
        }
        catch (IOException iOException) {
            System.err.println(ERROR_READ + string2);
        }
    }

    protected static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected static Document readDocument(String string) {
        File file = new File(string);
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = ScilabDocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(ERROR_READ + string);
        }
        catch (SAXException sAXException) {
            System.err.println(ERROR_READ + string);
        }
        catch (IOException iOException) {
            System.err.println(ERROR_READ + string);
        }
        return null;
    }

    protected static void writeDocument(String string, Node node) {
        Transformer transformer = null;
        try {
            transformer = ScilabTransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println(ERROR_WRITE + string);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            System.err.println(ERROR_WRITE + string);
        }
        transformer.setOutputProperty("indent", "yes");
        StreamResult streamResult = new StreamResult(new File(string));
        DOMSource dOMSource = new DOMSource(node);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            System.err.println(ERROR_WRITE + string);
        }
    }

    static {
        updated = false;
        time = System.currentTimeMillis();
        builder = ScilabDocumentBuilderFactory.newInstance();
        transformer = null;
        SCI = System.getenv("SCI");
        SCILAB_CONFIG_FILE = SCI + "/modules/preferences/etc/XConfiguration.xml";
        factory = ScilabTransformerFactory.newInstance();
        factory.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String string, String string2) throws TransformerException {
                if (string.startsWith("$SCI")) {
                    string = string.replace("$SCI", SCI);
                    string2 = null;
                }
                try {
                    File file;
                    File file2 = null;
                    if (string2 != null && !string2.isEmpty()) {
                        file2 = new File(new URI(string2)).getParentFile();
                    }
                    if ((file = file2 != null ? new File(file2, string) : new File(string)).exists() && file.canRead()) {
                        return new StreamSource(file);
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                throw new TransformerException("Cannot find the file " + string + "::" + string2);
            }
        });
    }
}

