/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.preferences.Component.Scroll;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

class ComponentFactory {
    private static final String X_PACKAGE = "org.scilab.modules.preferences.Component.";
    private static final int SPACE = 5;
    private static final Map<String, Constructor<? extends Component>> cache = new HashMap<String, Constructor<? extends Component>>();
    private static final Map<String, MyAction> actions = new HashMap<String, MyAction>();

    ComponentFactory() {
    }

    public static final Component getComponent(Node node) {
        Component component;
        String string = node.getNodeName();
        MyAction myAction = actions.get(string);
        if (myAction != null) {
            Component component2 = myAction.getComponent(node);
            return component2;
        }
        Constructor<? extends Component> constructor = cache.get(string);
        if (constructor == null) {
            Class<Component> clazz;
            if ("PreviewCode".equals(string)) {
                ScilabCommonsUtils.loadOnUse((String)"SciNotes");
            }
            try {
                clazz = Class.forName(X_PACKAGE + string).asSubclass(Component.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException);
                return new XStub(node, "ClassNotFoundException");
            }
            try {
                Class[] classArray = new Class[]{Node.class};
                constructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("NoSuchMethodException:" + noSuchMethodException);
                return new XStub(node, "NoSuchMethodException");
            }
            catch (SecurityException securityException) {
                System.err.println("SecurityException:" + securityException);
                return new XStub(node, "SecurityException");
            }
            cache.put(string, constructor);
        }
        try {
            component = constructor.newInstance(node);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("InstantiationException:" + instantiationException);
            return new XStub(node, "InstantiationException");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("IllegalAccessException:" + illegalAccessException);
            return new XStub(node, "IllegalAccessException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("IllegalArgumentException:" + illegalArgumentException);
            return new XStub(node, "IllegalArgumentException");
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("InvocationTargetException:" + invocationTargetException.getTargetException());
            invocationTargetException.getTargetException().printStackTrace();
            return new XStub(node, "InvocationTargetException");
        }
        return component;
    }

    static {
        actions.put("Scroll", new MyAction(){

            @Override
            public Component getComponent(Node node) {
                return new Scroll(node, new JPanel());
            }
        });
        actions.put("#text", new MyAction(){

            @Override
            public Component getComponent(Node node) {
                return new JLabel(node.getNodeValue());
            }
        });
        actions.put("VSpace", new MyAction(){

            @Override
            public Component getComponent(Node node) {
                return Box.createVerticalStrut(XConfigManager.getInt(node, "height", 5));
            }
        });
        actions.put("HSpace", new MyAction(){

            @Override
            public Component getComponent(Node node) {
                return Box.createHorizontalStrut(XConfigManager.getInt(node, "width", 5));
            }
        });
        actions.put("Glue", new MyAction(){

            @Override
            public Component getComponent(Node node) {
                return Box.createGlue();
            }
        });
    }

    private static class XStub
    extends JPanel {
        private static final long serialVersionUID = -6540983459186007758L;
        private static final int D_HEIGHT = 50;
        private static final int D_WIDTH = 100;

        public XStub(Node node, String string) {
            Border border = BorderFactory.createLineBorder(Color.RED);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, node.getNodeName() + " " + string);
            Dimension dimension = new Dimension(100, 50);
            this.setPreferredSize(dimension);
            this.setOpaque(false);
            XConfigManager.setDimension(this, node);
            titledBorder.setTitleColor(Color.RED);
            this.setBorder(titledBorder);
            this.setLayout(new FlowLayout());
        }

        @Override
        public String toString() {
            return "STUB";
        }
    }

    private static interface MyAction {
        public Component getComponent(Node var1);
    }
}

