/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.scilab.modules.preferences.Component.Icon;
import org.scilab.modules.preferences.Component.Model;
import org.scilab.modules.preferences.Component.Panel;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Table
extends Panel
implements XComponent,
XChooser,
ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = -6127289363733321914L;
    private final CustomTableCellRenderer customTableCellRenderer = new CustomTableCellRenderer();
    private Model model;
    private JTable table;
    private JScrollPane scrollPane;
    private String column;
    private ImageIcon[] icons = new ImageIcon[]{new ImageIcon(Icon.SCILAB_XICONS + "list-add.png"), new ImageIcon(Icon.SCILAB_XICONS + "go-up.png"), new ImageIcon(Icon.SCILAB_XICONS + "media-playback-stop.png"), new ImageIcon(Icon.SCILAB_XICONS + "go-down.png"), new ImageIcon(Icon.SCILAB_XICONS + "list-remove.png")};
    JButton[] controls = new JButton[]{new JButton(this.icons[0]), new JButton(this.icons[1]), new JButton(this.icons[2]), new JButton(this.icons[3]), new JButton(this.icons[4])};
    boolean[] openMask = new boolean[]{true, true, true, true, true};
    private ActionListener actionListener = null;
    boolean externalChange;

    public Table(Node node) {
        super(node);
        this.model = new Model(node);
        this.table = new JTable(this.model);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDragEnabled(false);
        this.setupOpenMask(node);
        this.setupControls(node);
        this.column = XCommonManager.getAttribute(node, "column");
        if (XCommonManager.getAttribute(node, "mode").equals("select")) {
            this.table.setSelectionMode(0);
        }
        if (XCommonManager.getAttribute(node, "mode").equals("cell")) {
            this.table.setCellSelectionEnabled(true);
            this.table.setColumnSelectionAllowed(false);
            this.table.setRowSelectionAllowed(true);
        }
        this.scrollPane = new JScrollPane(this.table);
        this.add(this.scrollPane);
    }

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"item"};
        return stringArray;
    }

    public void setupOpenMask(Node node) {
        if (XCommonManager.getAttribute(node, "location").equals("fixed")) {
            this.openMask[1] = false;
        } else {
            boolean bl = this.openMask[1] = this.model.getRowCount() > 1;
        }
        if (XCommonManager.getAttribute(node, "mode").equals("select")) {
            this.openMask[2] = false;
        }
        this.openMask[3] = XCommonManager.getAttribute(node, "location").equals("fixed") ? false : this.model.getRowCount() > 1;
        this.openMask[4] = this.model.getRowCount() != 0;
    }

    public void setupControls(Node node) {
        if (XCommonManager.getAttribute(node, "size").equals("dynamic")) {
            JPanel jPanel = new JPanel(new GridLayout(5, 1));
            for (int i = 0; i < this.controls.length; ++i) {
                jPanel.add(this.controls[i]);
                this.controls[i].addActionListener(this);
                this.controls[i].setEnabled(false);
            }
            if (this.model.getRowCount() == 0) {
                this.controls[0].setEnabled(true);
            }
            this.add((Component)jPanel, "East");
        }
    }

    public void openControls() {
        for (int i = 0; i < this.controls.length; ++i) {
            this.controls[i].setEnabled(this.openMask[i]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        JButton jButton = (JButton)actionEvent.getSource();
        for (n = 0; n < this.controls.length && this.controls[n] != jButton; ++n) {
        }
        switch (n) {
            case 0: {
                if (this.actionListener == null) break;
                ActionEvent actionEvent2 = new ActionEvent(this, 0, "tableAdd", actionEvent.getWhen(), 0);
                this.actionListener.actionPerformed(actionEvent2);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.table.getSelectionModel().clearSelection();
                for (int i = 0; i < this.controls.length; ++i) {
                    this.controls[i].setEnabled(false);
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                System.out.println("[DEBUG] calling actionPerformed(deleteRow)");
                if (this.actionListener == null) break;
                ActionEvent actionEvent3 = new ActionEvent(this, 0, "tableDel", actionEvent.getWhen(), 0);
                this.actionListener.actionPerformed(actionEvent3);
            }
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.model.addTableModelListener(tableModelListener);
        this.addActionListener((ActionListener)((Object)tableModelListener));
    }

    private void checkContent() {
        int n;
        for (n = 0; n < this.model.getColumnCount(); ++n) {
            System.out.print("  " + this.model.getColumnName(n));
        }
        System.out.print("\n");
        if (this.model.getRowCount() == 0) {
            System.out.println("-- no tableRow items!");
        }
        for (n = 0; n < this.model.getRowCount(); ++n) {
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                System.out.print("  " + this.model.getValueAt(n, i));
            }
            System.out.print("\n");
        }
    }

    @Override
    public final void refresh(Node node) {
        this.model.setNodeList(node.getChildNodes());
        String string = XCommonManager.getAttribute(node, "item", "-1");
        this.setupOpenMask(node);
        if (!string.equals(this.item())) {
            this.item(string);
        }
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(new CustomTableCellRenderer());
        }
        this.repaint();
    }

    @Override
    public final Object choose() {
        if (!this.column.equals("\"not an value'")) {
            int n = this.table.getSelectedRow();
            Node node = this.model.getRowRecord(n);
            String string = XCommonManager.getAttribute(node, this.column);
            return string;
        }
        return this.item();
    }

    @Override
    public final void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.externalChange && !listSelectionEvent.getValueIsAdjusting()) {
            this.openControls();
            if (this.actionListener != null) {
                ActionEvent actionEvent = new ActionEvent(this, 0, "tableSelect", System.currentTimeMillis(), 0);
                this.actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public final String item() {
        return "" + (this.table.getSelectedRow() + 1);
    }

    public final void item(String string) {
        int n = Integer.parseInt(string);
        this.externalChange = false;
        if (n != -1 && n != this.table.getSelectedRow() + 1) {
            this.table.setRowSelectionInterval(n - 1, n - 1);
            this.openControls();
        }
        this.externalChange = true;
    }

    @Override
    public final String toString() {
        String string = "Table ...";
        return string;
    }

    public static void processModelEvent(TableModelEvent tableModelEvent, Node[] nodeArray) {
        Model model = (Model)tableModelEvent.getSource();
        for (int i = 0; i < nodeArray.length; ++i) {
            Element element = (Element)nodeArray[i];
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getColumn();
            String string = model.getValueAt(n, n2).toString();
            String string2 = model.getColumnAttr(n2);
            String string3 = element.getAttribute("context");
            element.setAttribute("set", string2);
            element.setAttribute("value", string);
            element.setAttribute("context", string3 + (n + 1) + "/");
        }
    }

    private final class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Color) {
                component.setBackground((Color)object);
                component.setForeground((Color)object);
            }
            return component;
        }
    }
}

