/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class Label
extends JLabel
implements XComponent {
    private static final long serialVersionUID = -4842434795956015957L;

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"text", "foreground", "background", "tooltip", "font-family", "font-face", "font-size", "enable"};
        return stringArray;
    }

    public Label(Node node) {
        String string = XConfigManager.getAttribute(node, "text");
        this.text(string);
        String string2 = XConfigManager.getAttribute(node, "tooltip");
        this.tooltip(string2);
        String string3 = XConfigManager.getAttribute(node, "background");
        this.background(string3);
        String string4 = XConfigManager.getAttribute(node, "foreground");
        this.foreground(string4);
        String string5 = XConfigManager.getAttribute(node, "font-family", this.fontFamily());
        this.fontFamily(string5);
        String string6 = XConfigManager.getAttribute(node, "font-face", this.fontFace());
        this.fontFace(string6);
        String string7 = XConfigManager.getAttribute(node, "font-size", this.fontSize());
        this.fontSize(string7);
        String string8 = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string8.equals("true"));
    }

    @Override
    public void refresh(Node node) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = XConfigManager.getAttribute(node, "text");
        if (!string8.equals(this.text())) {
            this.text(string8);
        }
        if (!(string7 = XConfigManager.getAttribute(node, "tooltip")).equals(this.tooltip())) {
            this.tooltip(string7);
        }
        if (!(string6 = XConfigManager.getAttribute(node, "background")).equals(this.background())) {
            this.background(string6);
        }
        if (!(string5 = XConfigManager.getAttribute(node, "foreground")).equals(this.foreground())) {
            this.foreground(string5);
        }
        if (!(string4 = XConfigManager.getAttribute(node, "font-family", this.fontFamily())).equals(this.fontFamily())) {
            this.fontFamily(string4);
        }
        if (!(string3 = XConfigManager.getAttribute(node, "font-face", this.fontFace())).equals(this.fontFace())) {
            this.fontFace(string3);
        }
        if (!(string2 = XConfigManager.getAttribute(node, "font-size", this.fontSize())).equals(this.fontSize())) {
            this.fontSize(string2);
        }
        if ((string = XConfigManager.getAttribute(node, "halign", "left")).equals("left")) {
            this.setHorizontalAlignment(2);
        }
        if (string.equals("right")) {
            this.setHorizontalAlignment(4);
        }
        String string9 = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string9.equals("true"));
    }

    public final String text() {
        return this.getText();
    }

    public final String tooltip() {
        String string = this.getToolTipText();
        if (string == null) {
            return "";
        }
        return string;
    }

    public final String foreground() {
        return XConfigManager.getColor(this.getForeground());
    }

    public final String background() {
        Color color = this.getForeground();
        if (color != null && color.equals(this.getParent().getBackground())) {
            return "\"not an value'";
        }
        return XConfigManager.getColor(this.getBackground());
    }

    public final String fontFamily() {
        return this.getFont().getFamily();
    }

    public final String fontSize() {
        return "" + this.getFont().getSize();
    }

    public final String fontFace() {
        switch (this.getFont().getStyle()) {
            case 0: {
                return "plain";
            }
            case 2: {
                return "italic";
            }
            case 1: {
                return "bold";
            }
            case 3: {
                return "bold italic";
            }
        }
        return "\"not an value'";
    }

    public final void fontFamily(String string) {
        Font font = new Font(string, this.getFont().getStyle(), this.getFont().getSize());
        this.setFont(font);
    }

    public final void fontSize(String string) {
        Font font = new Font(this.getFont().getFamily(), this.getFont().getStyle(), Integer.parseInt(string));
        this.setFont(font);
    }

    private int getStyle(String string) {
        if (string.equals("plain")) {
            return 0;
        }
        if (string.equals("italic")) {
            return 2;
        }
        if (string.equals("bold")) {
            return 1;
        }
        if (string.equals("bold italic")) {
            return 3;
        }
        return -1;
    }

    public final void fontFace(String string) {
        Font font = new Font(this.getFont().getFamily(), this.getStyle(string), this.getFont().getSize());
        this.setFont(font);
    }

    public final void text(String string) {
        this.setText(string);
    }

    public final void tooltip(String string) {
        if (string.equals("\"not an value'") || string.equals("")) {
            string = null;
        }
        this.setToolTipText(string);
    }

    public final void foreground(String string) {
        if (string.equals("\"not an value'")) {
            this.setForeground(null);
        } else {
            Color color = XConfigManager.getColor(string);
            this.setForeground(color);
        }
    }

    public final void background(String string) {
        if (string.equals("\"not an value'")) {
            this.setOpaque(false);
            this.setBackground(null);
        } else {
            Color color = XConfigManager.getColor(string);
            this.setOpaque(true);
            this.setBackground(color);
        }
    }

    @Override
    public final String toString() {
        String string = "Label";
        if (!this.text().equals("\"not an value'")) {
            string = string + " text='" + this.text() + "'";
        }
        if (!this.background().equals("\"not an value'")) {
            string = string + " background='" + this.background() + "'";
        }
        if (!this.foreground().equals("\"not an value'")) {
            string = string + " foreground='" + this.foreground() + "'";
        }
        if (!this.fontFamily().equals("\"not an value'")) {
            string = string + " font-family='" + this.fontFamily() + "'";
        }
        if (!this.fontFace().equals("\"not an value'")) {
            string = string + " font-face='" + this.fontFace() + "'";
        }
        if (!this.fontSize().equals("\"not an value'")) {
            string = string + " font-size='" + this.fontSize() + "'";
        }
        return string;
    }
}

