/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.scilab.modules.gui.bridge.colorchooser.SwingScilabColorChooser;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.scilab.modules.preferences.XSentinel;
import org.w3c.dom.Node;

public class Color
extends JButton
implements XComponent,
XChooser {
    private static final long serialVersionUID = 5598263085800128888L;
    private static final int ICONDIM = 16;
    private ActionListener actionListener = null;
    private SwingScilabColorChooser colorChooser;

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"enable", "color"};
        return stringArray;
    }

    public Color(Node node) {
        super(new Icon(){

            @Override
            public final int getIconHeight() {
                return 16;
            }

            @Override
            public final int getIconWidth() {
                return 32;
            }

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                if (component.isEnabled()) {
                    graphics.setColor(component.getForeground());
                    graphics.fillRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                    graphics.setColor(java.awt.Color.BLACK);
                    graphics.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                } else {
                    java.awt.Color color = component.getForeground();
                    float[] fArray = new float[3];
                    java.awt.Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
                    graphics.setColor(java.awt.Color.getHSBColor(fArray[0], fArray[1] * 0.2f, fArray[2] * 0.95f));
                    graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
                }
            }
        });
        String string = XCommonManager.getAttribute(node, "color", "000000");
        this.color(string);
        this.setOpaque(true);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                java.awt.Color color = XCommonManager.getColor(Color.this.color());
                ActionEvent actionEvent2 = new ActionEvent(Color.this, actionEvent.getID(), "Color change", actionEvent.getWhen() + 1L, actionEvent.getModifiers());
                Color.this.colorChooser = new SwingScilabColorChooser(color);
                JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, Color.this);
                Color.this.colorChooser.setLocationRelativeTo((Component)jFrame);
                Color.this.colorChooser.displayAndWait();
                if (Color.this.actionListener != null) {
                    Color.this.actionListener.actionPerformed(actionEvent2);
                }
            }
        });
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        String string2 = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string2.equals("true"));
    }

    @Override
    public final void refresh(Node node) {
        String string = XCommonManager.getAttribute(node, "color", "000000");
        if (!string.equals(this.color())) {
            this.color(string);
        }
        String string2 = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string2.equals("true"));
    }

    public final String color() {
        java.awt.Color color = this.getForeground();
        return XCommonManager.getColor(color);
    }

    public final void color(String string) {
        java.awt.Color color = XCommonManager.getColor(string);
        this.setForeground(color);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        if (actionListener instanceof XSentinel) {
            this.actionListener = actionListener;
        } else {
            super.addActionListener(actionListener);
        }
    }

    @Override
    public Object choose() {
        java.awt.Color color = this.colorChooser.getSelectedColor();
        if (color != null) {
            return XCommonManager.getColor(color);
        }
        return this.color();
    }

    @Override
    public final String toString() {
        String string = "Color";
        string = string + " color='" + this.color() + "'";
        return string;
    }
}

