/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import org.scilab.modules.gui.bridge.checkbox.SwingScilabCheckBox;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class Checkbox
extends SwingScilabCheckBox
implements XComponent,
XChooser {
    private static final long serialVersionUID = -7007541669965737408L;
    private String selectedValue;
    private String unselectedValue;

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"enable", "text", "checked", "selected-value", "unselected-value"};
        return stringArray;
    }

    public Checkbox(Node node) {
        this.setOpaque(false);
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.refresh(node);
    }

    @Override
    public final void refresh(Node node) {
        String string;
        String string2;
        String string3;
        String string4 = XConfigManager.getAttribute(node, "text");
        if (!string4.equals(this.text())) {
            this.text(string4);
        }
        if (!(string3 = XConfigManager.getAttribute(node, "selected-value")).equals(this.selected())) {
            this.selected(string3);
        }
        if (!(string2 = XConfigManager.getAttribute(node, "unselected-value")).equals(this.unselected())) {
            this.unselected(string2);
        }
        if (!(string = XConfigManager.getAttribute(node, "checked")).equals(this.checked())) {
            this.checked(string);
        }
        String string5 = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string5.equals("true"));
    }

    public final String text() {
        String string = this.getText();
        if (string != null) {
            return string;
        }
        return "\"not an value'";
    }

    public final void text(String string) {
        if (string != "\"not an value'") {
            this.setText(string);
        } else {
            this.setText(null);
        }
    }

    public final String checked() {
        boolean bl = this.isSelected();
        if (bl) {
            return "checked";
        }
        return "unchecked";
    }

    public final void checked(String string) {
        boolean bl = string.equals("checked") || string.equals("true");
        this.setSelected(bl);
    }

    public final String selected() {
        return this.selectedValue;
    }

    public final void selected(String string) {
        this.selectedValue = !string.equals("\"not an value'") ? string : null;
    }

    public final String unselected() {
        return this.unselectedValue;
    }

    public final void unselected(String string) {
        this.unselectedValue = !string.equals("\"not an value'") ? string : null;
    }

    @Override
    public final Object choose() {
        if (this.isSelected()) {
            if (this.selectedValue != null) {
                return this.selectedValue;
            }
            return "checked";
        }
        if (this.unselectedValue != null) {
            return this.unselectedValue;
        }
        return "unchecked";
    }

    public final String toString() {
        String string = "CHECKBOX";
        if (!this.text().equals("\"not an value'")) {
            string = string + " text='" + this.text() + "'";
        }
        if (!this.checked().equals("\"not an value'")) {
            string = string + " checked='" + this.checked() + "'";
        }
        return string;
    }
}

