/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_export.convertToPPM;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.scilab.modules.graphic_export.convertToPPM.ImageEncoder;

public class PPMEncoder
extends ImageEncoder {
    private List comments = new ArrayList();

    public PPMEncoder(Image image, OutputStream outputStream) throws IOException {
        super(image, (DataOutput)new DataOutputStream(outputStream));
    }

    public PPMEncoder(Image image, DataOutput dataOutput) throws IOException {
        super(image, dataOutput);
    }

    public PPMEncoder(ImageProducer imageProducer, OutputStream outputStream) throws IOException {
        super(imageProducer, (DataOutput)new DataOutputStream(outputStream));
    }

    public PPMEncoder(ImageProducer imageProducer, DataOutput dataOutput) throws IOException {
        super(imageProducer, dataOutput);
    }

    public void addComment(String string) {
        this.comments.add(string);
    }

    @Override
    public void encodeStart(int n, int n2) throws IOException {
        this.writeString("P6\n");
        for (String string : this.comments) {
            this.writeString("# " + string + "\n");
        }
        this.writeString(n + " " + n2 + "\n");
        this.writeString("255\n");
    }

    void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.out.write(byArray);
    }

    @Override
    public void encodePixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        byte[] byArray = new byte[n3 * 3];
        for (int i = 0; i < n4; ++i) {
            int n7 = n5 + i * n6;
            for (int j = 0; j < n3; ++j) {
                int n8 = n7 + j;
                int n9 = j * 3;
                byArray[n9] = (byte)((nArray[n8] & 0xFF0000) >> 16);
                byArray[n9 + 1] = (byte)((nArray[n8] & 0xFF00) >> 8);
                byArray[n9 + 2] = (byte)(nArray[n8] & 0xFF);
            }
            this.out.write(byArray);
        }
    }

    @Override
    protected void encodeDone() throws IOException {
    }
}

