/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_export;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.fop.Version;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.AbstractPSDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.ps.PSDocumentGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.Drawer;
import org.scilab.forge.scirenderer.implementation.g2d.G2DCanvas;
import org.scilab.forge.scirenderer.implementation.g2d.G2DCanvasFactory;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvasFactory;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.graphic_export.ExportBitmap;
import org.scilab.modules.graphic_export.ExportParams;
import org.scilab.modules.graphic_export.Utils;
import org.scilab.modules.graphic_export.convertToPPM.PPMEncoder;
import org.scilab.modules.graphic_objects.axes.AxesContainer;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicView.GraphicView;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class Export {
    public static final int SUCCESS = 0;
    public static final int IOEXCEPTION_ERROR = 1;
    public static final int INVALID_FILE = 2;
    public static final int MEMORY_ERROR = 3;
    public static final int UNKNOWN_ERROR = 4;
    public static final int FILENOTFOUND_ERROR = 5;
    public static final int NOWRITER_ERROR = 5;
    private static final float DEFAULT_JPEG_COMPRESSION = 0.95f;
    private static final String CLASSPATH_PDF_PS_EPS_EXPORT_NAME = "pdf_ps_eps_graphic_export";
    private static final String CLASSPATH_SVG_EXPORT_NAME = "svg_graphic_export";
    private static final String CLASSPATH_EMF_EXPORT_NAME = "emf_graphic_export";
    private static final Map<DrawerVisitor, Exporter> visitorsToExp = new WeakHashMap<DrawerVisitor, Exporter>();
    private static final Map<String, Integer> extToType = new HashMap<String, Integer>();
    private static boolean emfLoaded;
    private static boolean svgLoaded;
    private static boolean pdfLoaded;
    private static final TYPE[] types;

    public static boolean isBitmapFormat(TYPE tYPE) {
        return tYPE == TYPE.PNG || tYPE == TYPE.JPEG || tYPE == TYPE.GIF || tYPE == TYPE.BMP || tYPE == TYPE.PPM;
    }

    public static int getType(String string) {
        Integer n = extToType.get(string.toLowerCase());
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static int export(int n, int n2, String string, ExportParams exportParams, boolean bl) {
        Canvas canvas;
        String[] stringArray;
        int n3 = string.lastIndexOf(46);
        boolean bl2 = false;
        if (n3 > 0 && n3 <= string.length() - 2) {
            bl2 = true;
        }
        String string2 = string;
        if (!bl2) {
            stringArray = new String[]{"png", "bmp", "gif", "jpeg", "png", "ppm", "eps", "pdf", "svg", "ps", "emf"};
            string2 = string + "." + stringArray[n2];
        }
        if ((stringArray = DrawerVisitor.getVisitor((Integer)n)) != null && (canvas = stringArray.getCanvas()) instanceof JoGLCanvas && Export.isBitmapFormat(types[n2]) && stringArray.getFigure().getVisible().booleanValue()) {
            try {
                return Export.exportBitmap(n, n2, string2, true, exportParams);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                return 3;
            }
            catch (Throwable throwable) {
                return 4;
            }
        }
        return Export.exportVectorial(n, n2, string2, exportParams, bl);
    }

    public static int exportVectorial(int n, int n2, String string, ExportParams exportParams, boolean bl) {
        if (string == null) {
            return 2;
        }
        File file = new File(string);
        int n3 = Utils.checkWritePermission(file);
        if (n3 != 0) {
            return n3;
        }
        try {
            return Export.exportVectorial(n, types[n2], file, exportParams, bl);
        }
        catch (IOException iOException) {
            if (iOException instanceof FileNotFoundException) {
                return 5;
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int exportVectorial(int n, TYPE tYPE, File file, ExportParams exportParams, boolean bl) throws IOException {
        Figure figure = (Figure)GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        if (!bl) {
            int n2;
            Integer[] integerArray;
            int n3;
            Exporter exporter = Export.getExporter(tYPE);
            Graphics2D graphics2D = exporter.getGraphics2D(n3 = (integerArray = figure.getAxesSize())[0].intValue(), n2 = integerArray[1].intValue(), file, exportParams);
            if (graphics2D == null) {
                return 5;
            }
            exportParams.setParamsOnGraphics(graphics2D);
            G2DCanvas g2DCanvas = G2DCanvasFactory.createCanvas((Graphics2D)graphics2D, (int)n3, (int)n2);
            DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor((Integer)n);
            DrawerVisitor drawerVisitor2 = new DrawerVisitor(null, (Canvas)g2DCanvas, (AxesContainer)figure){

                public void updateObject(Integer n, int n2) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visit(Figure figure) {
                    Figure figure2 = figure;
                    synchronized (figure2) {
                        super.visit(figure);
                        if (!figure.getVisible().booleanValue()) {
                            this.askAcceptVisitor(figure.getChildren());
                        }
                    }
                }
            };
            try {
                g2DCanvas.setMainDrawer((Drawer)drawerVisitor2);
                g2DCanvas.redraw();
                exporter.write();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                int n4 = 3;
                return n4;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                int n5 = 4;
                return n5;
            }
            finally {
                GraphicController.getController().unregister((GraphicView)drawerVisitor2);
                DrawerVisitor.changeVisitor((AxesContainer)figure, (DrawerVisitor)drawerVisitor);
                exporter.dispose();
                exporter = null;
                visitorsToExp.remove(drawerVisitor2);
                g2DCanvas.destroy();
            }
        }
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor((Integer)n);
        if (drawerVisitor.getCanvas() instanceof G2DCanvas) {
            G2DCanvas g2DCanvas = (G2DCanvas)drawerVisitor.getCanvas();
            g2DCanvas.enableDraw();
            Exporter exporter = null;
            try {
                g2DCanvas.redraw();
                exporter = visitorsToExp.get(drawerVisitor);
                if (exporter != null) {
                    exporter.file = file;
                    exporter.write();
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                int n6 = 3;
                return n6;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                int n7 = 4;
                return n7;
            }
            finally {
                if (exporter != null) {
                    exporter.dispose();
                    exporter = null;
                    visitorsToExp.remove(drawerVisitor);
                }
                DrawerVisitor.changeVisitor((AxesContainer)figure, null);
                GraphicController.getController().unregister((GraphicView)drawerVisitor);
                g2DCanvas.destroy();
            }
        }
        return 0;
    }

    public static int exportBitmap(int n, int n2, String string, boolean bl, ExportParams exportParams) {
        if (string == null) {
            return 2;
        }
        File file = new File(string);
        int n3 = Utils.checkWritePermission(file);
        if (n3 != 0) {
            return n3;
        }
        try {
            Export.exportBitmap(n, types[n2], file, bl, exportParams);
        }
        catch (IOException iOException) {
            if (iOException instanceof FileNotFoundException) {
                return 5;
            }
            return 1;
        }
        return 0;
    }

    public static void exportBitmap(int n, TYPE tYPE, File file, boolean bl, ExportParams exportParams) throws IOException {
        if (Export.isBitmapFormat(tYPE)) {
            Object object;
            Object object2;
            JoGLCanvas joGLCanvas = null;
            if (bl) {
                object2 = DrawerVisitor.getVisitor((Integer)n);
                object = object2.getCanvas();
                if (object instanceof JoGLCanvas) {
                    joGLCanvas = (JoGLCanvas)object;
                }
            } else {
                object2 = (Figure)GraphicController.getController().getObjectFromId(Integer.valueOf(n));
                object = object2.getAxesSize();
                DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor((Integer)n);
                joGLCanvas = (JoGLCanvas)JoGLCanvasFactory.createCanvas((int)object[0], (int)object[1]);
                DrawerVisitor drawerVisitor2 = new DrawerVisitor(null, (Canvas)joGLCanvas, (AxesContainer)object2){

                    public void updateObject(Integer n, int n2) {
                    }

                    public void deleteObject(Integer n) {
                    }
                };
                joGLCanvas.setMainDrawer((Drawer)drawerVisitor2);
                joGLCanvas.redraw();
                GraphicController.getController().unregister((GraphicView)drawerVisitor2);
                DrawerVisitor.changeVisitor((AxesContainer)object2, (DrawerVisitor)drawerVisitor);
            }
            if (joGLCanvas != null) {
                object2 = joGLCanvas.getImage();
                object = (PNGExporter)Export.getExporter(tYPE);
                ((PNGExporter)object).setImage(file, (BufferedImage)object2, exportParams);
                int n2 = ((PNGExporter)object).write();
                ((PNGExporter)object).dispose();
                if (Export.isBitmapFormat(tYPE) && n2 == 5) {
                    object2 = joGLCanvas.getImage(false);
                    object = (PNGExporter)Export.getExporter(tYPE);
                    ((PNGExporter)object).setImage(file, (BufferedImage)object2, exportParams);
                    ((PNGExporter)object).write();
                    ((PNGExporter)object).dispose();
                }
            }
        }
    }

    public static void setVisitor(int n, int n2, final ExportParams exportParams) {
        final Exporter exporter = Export.getExporter(types[n2]);
        Figure figure = (Figure)GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        final Integer[] integerArray = figure.getAxesSize();
        int n3 = integerArray[0];
        int n4 = integerArray[1];
        final Graphics2D graphics2D = exporter.getGraphics2D(n3, n4, null, exportParams);
        exportParams.setParamsOnGraphics(graphics2D);
        final G2DCanvas g2DCanvas = G2DCanvasFactory.createCanvas((Graphics2D)graphics2D, (int)n3, (int)n4);
        g2DCanvas.disableDraw();
        DrawerVisitor drawerVisitor = new DrawerVisitor(null, (Canvas)g2DCanvas, (AxesContainer)figure){

            public void deleteObject(Integer n) {
            }

            public void updateObject(Integer n, int n2) {
                if (this.needUpdate(n, n2)) {
                    this.axesDrawer.update(n, n2);
                    if (n2 == 85) {
                        Integer[] integerArray2 = this.getFigure().getAxesSize();
                        if (integerArray2[0] != integerArray[0] || integerArray2[1] != integerArray[1]) {
                            Graphics2D graphics2D2 = exporter.getGraphics2D(integerArray2[0], integerArray2[1], null, exportParams);
                            exportParams.setParamsOnGraphics(graphics2D2);
                            g2DCanvas.setGraphics(graphics2D2, integerArray2[0].intValue(), integerArray2[1].intValue());
                            integerArray[0] = integerArray2[0];
                            integerArray[1] = integerArray2[1];
                            graphics2D.dispose();
                        }
                    } else if (n2 == 94) {
                        g2DCanvas.setAntiAliasingLevel(this.getFigure().getAntialiasing().intValue());
                    }
                }
            }
        };
        drawerVisitor.setDrawingTools(g2DCanvas.getDrawingTools());
        g2DCanvas.setMainDrawer((Drawer)drawerVisitor);
        visitorsToExp.put(drawerVisitor, exporter);
    }

    private static Exporter getExporter(TYPE tYPE) {
        switch (tYPE) {
            case PNG: {
                return new PNGExporter();
            }
            case GIF: {
                return new GIFExporter();
            }
            case JPEG: {
                return new JPEGExporter();
            }
            case BMP: {
                return new BMPExporter();
            }
            case PPM: {
                return new PPMExporter();
            }
            case SVG: {
                if (!svgLoaded) {
                    ScilabCommonsUtils.loadOnUse((String)CLASSPATH_SVG_EXPORT_NAME);
                    svgLoaded = true;
                }
                return new SVGExporter();
            }
            case PDF: {
                Export.loadPDF();
                return new PDFExporter();
            }
            case PS: {
                Export.loadPDF();
                return new PSExporter();
            }
            case EPS: {
                Export.loadPDF();
                return new EPSExporter();
            }
            case EMF: {
                if (!emfLoaded) {
                    ScilabCommonsUtils.loadOnUse((String)CLASSPATH_EMF_EXPORT_NAME);
                    emfLoaded = true;
                }
                return new EMFExporter();
            }
        }
        return null;
    }

    private static final void loadPDF() {
        if (!pdfLoaded) {
            ScilabCommonsUtils.loadOnUse((String)CLASSPATH_PDF_PS_EPS_EXPORT_NAME);
            pdfLoaded = true;
        }
    }

    static {
        extToType.put("bmp", 1);
        extToType.put("gif", 2);
        extToType.put("jpeg", 3);
        extToType.put("jpg", 3);
        extToType.put("png", 4);
        extToType.put("ppm", 5);
        extToType.put("eps", 6);
        extToType.put("pdf", 7);
        extToType.put("svg", 8);
        extToType.put("ps", 9);
        extToType.put("pos", 9);
        extToType.put("emf", 10);
        types = new TYPE[]{TYPE.PNG, TYPE.BMP, TYPE.GIF, TYPE.JPEG, TYPE.PNG, TYPE.PPM, TYPE.EPS, TYPE.PDF, TYPE.SVG, TYPE.PS, TYPE.EMF};
    }

    private static class EMFExporter
    extends Exporter {
        private OutputStream out;
        private Class<Graphics2D> g2dClass;
        private Constructor<Graphics2D> g2dCtor;
        private Graphics2D g2d;
        private ByteArrayOutputStream buffer;

        public EMFExporter() {
            try {
                this.g2dClass = Class.forName("org.freehep.graphicsio.emf.EMFGraphics2D");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("This Scilab build does not provide EMF support");
            }
            Constructor<?>[] constructorArray = this.g2dClass.getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (int i = 0; i < constructorArray.length; ++i) {
                constructor = constructorArray[i];
                Type[] typeArray = constructor.getGenericParameterTypes();
                if (typeArray.length != 2 || typeArray[0] != OutputStream.class || typeArray[1] != Dimension.class) continue;
                this.g2dCtor = constructor;
                break;
            }
        }

        @Override
        public Graphics2D getGraphics2D(int n, int n2, File file, ExportParams exportParams) {
            this.file = file;
            try {
                if (file == null) {
                    this.buffer = new ByteArrayOutputStream();
                    this.out = new BufferedOutputStream(this.buffer);
                } else {
                    this.out = new BufferedOutputStream(new FileOutputStream(file));
                }
                if (exportParams.orientation == 1) {
                    this.g2d = this.g2dCtor.newInstance(this.out, new Dimension(n2, n));
                    this.g2dClass.getMethod("startExport", new Class[0]).invoke((Object)this.g2d, new Object[0]);
                    AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
                    affineTransform.preConcatenate(AffineTransform.getTranslateInstance(n2, 0.0));
                    this.g2d.setTransform(affineTransform);
                } else {
                    this.g2d = this.g2dCtor.newInstance(this.out, new Dimension(n, n2));
                    this.g2dClass.getMethod("startExport", new Class[0]).invoke((Object)this.g2d, new Object[0]);
                }
            }
            catch (IOException iOException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return this.g2d;
        }

        @Override
        public int write() throws IOException {
            if (this.g2d != null) {
                try {
                    this.g2dClass.getMethod("endExport", new Class[0]).invoke((Object)this.g2d, new Object[0]);
                    this.g2dClass.getMethod("closeStream", new Class[0]).invoke((Object)this.g2d, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (this.buffer != null && this.file != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                this.buffer.writeTo(fileOutputStream);
                this.buffer.close();
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            return 0;
        }

        @Override
        public void dispose() {
            if (this.g2d != null) {
                this.g2d.dispose();
            }
        }
    }

    private static class EPSExporter
    extends PSExporter {
        @Override
        public Graphics2D getGraphics2D(int n, int n2, File file, final ExportParams exportParams) {
            this.file = file;
            this.params = exportParams;
            try {
                if (file == null) {
                    this.buffer = new ByteArrayOutputStream();
                    this.out = new BufferedOutputStream(this.buffer);
                } else {
                    this.out = new BufferedOutputStream(new FileOutputStream(file));
                }
                this.g2d = new EPSDocumentGraphics2D(true){

                    protected void writePageHeader() throws IOException {
                        super.writePageHeader();
                        if (exportParams.orientation == 1) {
                            this.gen.writeDSCComment("PageOrientation", (Object)"Landscape");
                        } else {
                            this.gen.writeDSCComment("PageOrientation", (Object)"Portrait");
                        }
                        this.gen.writeln("/ReEncode { /MyEncoding exch def exch findfont dup length dict begin {def} forall /Encoding MyEncoding def currentdict end definefont } def");
                        this.gen.writeln("/Helvetica /HelveticaLatin1 ISOLatin1Encoding ReEncode");
                        this.gen.writeln("/Times /TimesLatin1 ISOLatin1Encoding ReEncode");
                        this.gen.writeln("/DP {/Points exch def Points 0 get Points 1 get M 2 2 Points length 1 sub {/i exch def Points i get Points i 1 add get L}for} def");
                    }

                    public boolean shouldBeClipped(Shape shape, Shape shape2) {
                        if (shape == null || shape2 == null) {
                            return false;
                        }
                        return shape.getBounds2D().intersects(shape2.getBounds2D());
                    }

                    public void drawString(String string, float f, float f2) {
                        if (string != null && !string.isEmpty()) {
                            CharsetEncoder charsetEncoder = Charset.forName("ISO-8859-1").newEncoder();
                            if (charsetEncoder.canEncode(string)) {
                                Font font = this.getFont();
                                boolean bl = font.getName().equals("SansSerif");
                                boolean bl2 = font.getName().equals("Serif");
                                if (bl || bl2) {
                                    try {
                                        boolean bl3;
                                        this.preparePainting();
                                        this.establishColor(this.getColor());
                                        this.gen.writeln((bl ? "/HelveticaLatin1" : "/TimesLatin1") + " " + this.gen.formatDouble((double)this.getFont().getSize()) + " F");
                                        this.gen.saveGraphicsState();
                                        Shape shape = this.getClip();
                                        this.writeClip(shape);
                                        AffineTransform affineTransform = this.getTransform();
                                        boolean bl4 = bl3 = this.gen.getCurrentState().checkTransform(affineTransform) && !affineTransform.isIdentity();
                                        if (bl3) {
                                            this.gen.concatMatrix(affineTransform);
                                        }
                                        this.gen.writeln(this.gen.formatDouble((double)f) + " " + this.gen.formatDouble((double)f2) + " M 1 -1 scale");
                                        StringBuffer stringBuffer = new StringBuffer("(");
                                        for (int i = 0; i < string.length(); ++i) {
                                            PSGenerator.escapeChar((char)string.charAt(i), (StringBuffer)stringBuffer);
                                        }
                                        stringBuffer.append(") t");
                                        this.gen.writeln(stringBuffer.toString());
                                        this.gen.restoreGraphicsState();
                                    }
                                    catch (IOException iOException) {
                                        System.err.println(iOException);
                                    }
                                    return;
                                }
                            }
                            super.drawString(string, f, f2);
                        }
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public int processShape(Shape shape, boolean bl) throws IOException {
                        if (shape instanceof Ellipse2D.Double) {
                            Ellipse2D.Double double_ = (Ellipse2D.Double)shape;
                            if (double_.height != double_.width) return super.processShape(shape, bl);
                            this.gen.writeln(this.gen.formatDouble(double_.x + double_.width / 2.0) + " " + this.gen.formatDouble(double_.y + double_.height / 2.0) + " " + this.gen.formatDouble(double_.width / 2.0) + " " + this.gen.formatDouble(0.0) + " " + this.gen.formatDouble(360.0) + " arc cp");
                            return 1;
                        }
                        if (!(shape instanceof Path2D)) return super.processShape(shape, bl);
                        StringBuilder stringBuilder = new StringBuilder();
                        double[] dArray = new double[6];
                        PathIterator pathIterator = ((Path2D)shape).getPathIterator(new AffineTransform());
                        if (pathIterator.isDone()) return super.processShape(shape, bl);
                        int n = pathIterator.currentSegment(dArray);
                        if (n != 0) return super.processShape(shape, bl);
                        stringBuilder.append("[").append(this.gen.formatDouble(dArray[0])).append(" ").append(this.gen.formatDouble(dArray[1]));
                        pathIterator.next();
                        while (!pathIterator.isDone()) {
                            n = pathIterator.currentSegment(dArray);
                            if (n != 1) {
                                return super.processShape(shape, bl);
                            }
                            stringBuilder.append(" ").append(this.gen.formatDouble(dArray[0])).append(" ").append(this.gen.formatDouble(dArray[1]));
                            pathIterator.next();
                        }
                        stringBuilder.append("] DP");
                        this.gen.writeln(stringBuilder.toString());
                        return 1;
                    }
                };
                this.g2d.setupDocument(this.out, n, n2);
                this.g2d.setGraphicContext(new GraphicContext());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.g2d;
        }
    }

    private static class PSExporter
    extends Exporter {
        protected OutputStream out;
        protected AbstractPSDocumentGraphics2D g2d;
        protected ExportParams params;
        protected ByteArrayOutputStream buffer;

        @Override
        public Graphics2D getGraphics2D(int n, int n2, File file, final ExportParams exportParams) {
            this.file = file;
            this.params = exportParams;
            try {
                if (file == null) {
                    this.buffer = new ByteArrayOutputStream();
                    this.out = new BufferedOutputStream(this.buffer);
                } else {
                    this.out = new BufferedOutputStream(new FileOutputStream(file));
                }
                this.g2d = new PSDocumentGraphics2D(true, this.out, n, n2){

                    protected void writePageHeader() throws IOException {
                        super.writePageHeader();
                        if (exportParams.orientation == 1) {
                            this.gen.writeDSCComment("PageOrientation", (Object)"Landscape");
                        } else {
                            this.gen.writeDSCComment("PageOrientation", (Object)"Portrait");
                        }
                        this.gen.writeln("/ReEncode { /MyEncoding exch def exch findfont dup length dict begin {def} forall /Encoding MyEncoding def currentdict end definefont } def");
                        this.gen.writeln("/Helvetica /HelveticaLatin1 ISOLatin1Encoding ReEncode");
                        this.gen.writeln("/Times /TimesLatin1 ISOLatin1Encoding ReEncode");
                        this.gen.writeln("/DP {/Points exch def N Points 0 get Points 1 get M 2 2 Points length 1 sub {/i exch def Points i get Points i 1 add get L}for} def");
                    }

                    public void drawString(String string, float f, float f2) {
                        if (string != null && !string.isEmpty()) {
                            CharsetEncoder charsetEncoder = Charset.forName("ISO-8859-1").newEncoder();
                            if (charsetEncoder.canEncode(string)) {
                                Font font = this.getFont();
                                boolean bl = font.getName().equals("SansSerif");
                                boolean bl2 = font.getName().equals("Serif");
                                if (bl || bl2) {
                                    try {
                                        boolean bl3;
                                        this.preparePainting();
                                        this.establishColor(this.getColor());
                                        this.gen.writeln((bl ? "/HelveticaLatin1" : "/TimesLatin1") + " " + this.gen.formatDouble((double)this.getFont().getSize()) + " F");
                                        this.gen.saveGraphicsState();
                                        Shape shape = this.getClip();
                                        this.writeClip(shape);
                                        AffineTransform affineTransform = this.getTransform();
                                        boolean bl4 = bl3 = this.gen.getCurrentState().checkTransform(affineTransform) && !affineTransform.isIdentity();
                                        if (bl3) {
                                            this.gen.concatMatrix(affineTransform);
                                        }
                                        this.gen.writeln(this.gen.formatDouble((double)f) + " " + this.gen.formatDouble((double)f2) + " M 1 -1 scale");
                                        StringBuffer stringBuffer = new StringBuffer("(");
                                        for (int i = 0; i < string.length(); ++i) {
                                            PSGenerator.escapeChar((char)string.charAt(i), (StringBuffer)stringBuffer);
                                        }
                                        stringBuffer.append(") t");
                                        this.gen.writeln(stringBuffer.toString());
                                        this.gen.restoreGraphicsState();
                                    }
                                    catch (IOException iOException) {
                                        System.err.println(iOException);
                                    }
                                    return;
                                }
                            }
                            super.drawString(string, f, f2);
                        }
                    }

                    public boolean shouldBeClipped(Shape shape, Shape shape2) {
                        if (shape == null || shape2 == null) {
                            return false;
                        }
                        return shape.getBounds2D().intersects(shape2.getBounds2D());
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public int processShape(Shape shape, boolean bl) throws IOException {
                        if (shape instanceof Ellipse2D.Double) {
                            Ellipse2D.Double double_ = (Ellipse2D.Double)shape;
                            if (double_.height != double_.width) return super.processShape(shape, bl);
                            this.gen.writeln(this.gen.formatDouble(double_.x + double_.width / 2.0) + " " + this.gen.formatDouble(double_.y + double_.height / 2.0) + " " + this.gen.formatDouble(double_.width / 2.0) + " " + this.gen.formatDouble(0.0) + " " + this.gen.formatDouble(360.0) + " arc cp");
                            return 1;
                        }
                        if (!(shape instanceof Path2D)) return super.processShape(shape, bl);
                        StringBuilder stringBuilder = new StringBuilder();
                        double[] dArray = new double[6];
                        PathIterator pathIterator = ((Path2D)shape).getPathIterator(new AffineTransform());
                        if (pathIterator.isDone()) return super.processShape(shape, bl);
                        int n = pathIterator.currentSegment(dArray);
                        if (n != 0) return super.processShape(shape, bl);
                        stringBuilder.append("[").append(this.gen.formatDouble(dArray[0])).append(" ").append(this.gen.formatDouble(dArray[1]));
                        pathIterator.next();
                        while (!pathIterator.isDone()) {
                            n = pathIterator.currentSegment(dArray);
                            if (n != 1) {
                                return super.processShape(shape, bl);
                            }
                            stringBuilder.append(" ").append(this.gen.formatDouble(dArray[0])).append(" ").append(this.gen.formatDouble(dArray[1]));
                            pathIterator.next();
                        }
                        stringBuilder.append("] DP");
                        this.gen.writeln(stringBuilder.toString());
                        return 1;
                    }
                };
                this.g2d.setGraphicContext(new GraphicContext());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.g2d;
        }

        @Override
        public int write() throws IOException {
            if (this.g2d != null) {
                this.g2d.finish();
            }
            if (this.buffer != null && this.file != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                this.buffer.writeTo(fileOutputStream);
                this.buffer.close();
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            return 0;
        }

        @Override
        public void dispose() {
            if (this.g2d != null) {
                this.g2d.dispose();
            }
        }
    }

    private static class PDFExporter
    extends Exporter {
        private OutputStream out;
        private PDFDocumentGraphics2D g2d;
        private ExportParams params;
        private ByteArrayOutputStream buffer;

        @Override
        public Graphics2D getGraphics2D(int n, int n2, File file, ExportParams exportParams) {
            this.file = file;
            this.params = exportParams;
            try {
                if (file == null) {
                    this.buffer = new ByteArrayOutputStream();
                    this.out = new BufferedOutputStream(this.buffer);
                } else {
                    this.out = new BufferedOutputStream(new FileOutputStream(file));
                }
                this.g2d = new PDFDocumentGraphics2D(true);
                this.g2d.setupDefaultFontInfo();
                this.g2d.getPDFDocument().getInfo().setProducer("Generated by Scilab with Apache FOP Version " + Version.getVersion());
                this.g2d.setGraphicContext(new GraphicContext());
                if (exportParams.orientation == 1) {
                    this.g2d.setupDocument(this.out, n2, n);
                    this.g2d.setSVGDimension((float)n2, (float)n);
                    double d = 72.0f / this.g2d.getDeviceDPI();
                    AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
                    affineTransform.preConcatenate(AffineTransform.getTranslateInstance((double)n2 / d, 0.0));
                    this.g2d.setTransform(affineTransform);
                } else {
                    this.g2d.setupDocument(this.out, n, n2);
                    this.g2d.setSVGDimension((float)n, (float)n2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.g2d;
        }

        @Override
        public int write() throws IOException {
            if (this.g2d != null) {
                this.g2d.finish();
            }
            if (this.buffer != null && this.file != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                this.buffer.writeTo(fileOutputStream);
                this.buffer.close();
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            return 0;
        }

        @Override
        public void dispose() {
            this.g2d.dispose();
        }
    }

    private static class SVGExporter
    extends Exporter {
        private SVGGraphics2D g2d;
        private ExportParams params;

        @Override
        public Graphics2D getGraphics2D(int n, int n2, File file, ExportParams exportParams) {
            this.file = file;
            this.params = exportParams;
            DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
            Document document = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
            SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
            sVGGeneratorContext.setComment("Generated by Scilab with Batik SVG Generator");
            sVGGeneratorContext.setEmbeddedFontsOn(true);
            this.g2d = new SVGGraphics2D(sVGGeneratorContext, false){

                public void drawString(String string, float f, float f2) {
                    this.textAsShapes = this.getFont().getFontName().startsWith("jlm");
                    super.drawString(string, f, f2);
                }

                public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
                    this.textAsShapes = this.getFont().getFontName().startsWith("jlm");
                    super.drawString(attributedCharacterIterator, f, f2);
                }
            };
            if (exportParams.orientation == 1) {
                this.g2d.setSVGCanvasSize(new Dimension(n2, n));
                AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
                affineTransform.preConcatenate(AffineTransform.getTranslateInstance(n2, 0.0));
                this.g2d.setTransform(affineTransform);
            } else {
                this.g2d.setSVGCanvasSize(new Dimension(n, n2));
            }
            return this.g2d;
        }

        @Override
        public int write() throws IOException {
            boolean bl = true;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
            this.g2d.stream((Writer)outputStreamWriter, bl);
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            return 0;
        }

        @Override
        public void dispose() {
            if (this.g2d != null) {
                this.g2d.dispose();
            }
        }
    }

    private static class PPMExporter
    extends BMPExporter {
        @Override
        public int write() throws IOException {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            PPMEncoder pPMEncoder = new PPMEncoder((Image)this.image, (OutputStream)bufferedOutputStream);
            int[] nArray = this.image.getRGB(0, 0, this.image.getWidth(), this.image.getHeight(), null, 0, this.image.getWidth());
            pPMEncoder.encodeStart(this.image.getWidth(), this.image.getHeight());
            pPMEncoder.encodePixels(0, 0, this.image.getWidth(), this.image.getHeight(), nArray, 0, this.image.getWidth());
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            return 0;
        }
    }

    private static class JPEGExporter
    extends BMPExporter {
        @Override
        public int write() throws IOException {
            if (this.params.compressionQuality == -1.0f) {
                return ExportBitmap.writeJPEG(this.image, 0.95f, this.file);
            }
            return ExportBitmap.writeJPEG(this.image, this.params.compressionQuality, this.file);
        }
    }

    private static class BMPExporter
    extends PNGExporter {
        @Override
        public Graphics2D getGraphics2D(int n, int n2, File file, ExportParams exportParams) {
            this.file = file;
            this.params = exportParams;
            this.image = new BufferedImage(n, n2, 1);
            this.g2d = this.image.createGraphics();
            return this.g2d;
        }

        @Override
        public int write() throws IOException {
            return ExportBitmap.writeFile(this.image, "bmp", this.file);
        }
    }

    private static class GIFExporter
    extends PNGExporter {
        @Override
        public int write() throws IOException {
            return ExportBitmap.writeFile(this.image, "gif", this.file);
        }
    }

    private static class PNGExporter
    extends Exporter {
        protected BufferedImage image;
        protected Graphics2D g2d;
        protected ExportParams params;

        public void setImage(File file, BufferedImage bufferedImage, ExportParams exportParams) {
            this.file = file;
            this.image = bufferedImage;
            this.params = exportParams;
        }

        @Override
        public Graphics2D getGraphics2D(int n, int n2, File file, ExportParams exportParams) {
            this.file = file;
            this.params = exportParams;
            this.image = new BufferedImage(n, n2, 2);
            this.g2d = this.image.createGraphics();
            return this.g2d;
        }

        @Override
        public int write() throws IOException {
            return ExportBitmap.writeFile(this.image, "png", this.file);
        }

        @Override
        public void dispose() {
            if (this.g2d != null) {
                this.g2d.dispose();
            }
        }
    }

    private static abstract class Exporter {
        protected File file;

        private Exporter() {
        }

        abstract Graphics2D getGraphics2D(int var1, int var2, File var3, ExportParams var4);

        abstract int write() throws IOException;

        abstract void dispose();
    }

    public static enum TYPE {
        PNG,
        JPEG,
        GIF,
        BMP,
        PPM,
        SVG,
        PS,
        EPS,
        PDF,
        EMF;

    }
}

