/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.io;

import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxCodecRegistry;
import java.util.Map;
import java.util.logging.Logger;
import org.scilab.modules.graph.io.ScilabObjectCodec;
import org.scilab.modules.types.ScilabInteger;
import org.scilab.modules.types.ScilabIntegerTypeEnum;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ScilabIntegerCodec
extends ScilabObjectCodec {
    private static final String BUNSIGNED = "bUnsigned";
    private static final String VALUE = "value";
    private static final String PREC = "precision";
    private static final String PRECISION = "intPrecision";

    public ScilabIntegerCodec(Object object, String[] stringArray, String[] stringArray2, Map<String, String> map) {
        super(object, stringArray, stringArray2, map);
    }

    public Node encode(mxCodec mxCodec2, Object object) {
        String string = mxCodecRegistry.getName((Object)object);
        Element element = mxCodec2.getDocument().createElement(string);
        ScilabInteger scilabInteger = (ScilabInteger)object;
        if (binary) {
            int n = binaryObjects.size();
            binaryObjects.add((Object)scilabInteger);
            mxCodec.setAttribute((Node)element, (String)"binary", (Object)"true");
            mxCodec.setAttribute((Node)element, (String)"position", (Object)n);
            return element;
        }
        mxCodec.setAttribute((Node)element, (String)"width", (Object)scilabInteger.getWidth());
        mxCodec.setAttribute((Node)element, (String)"height", (Object)scilabInteger.getHeight());
        mxCodec.setAttribute((Node)element, (String)PRECISION, (Object)scilabInteger.getPrec().name());
        for (int i = 0; i < scilabInteger.getHeight(); ++i) {
            for (int j = 0; j < scilabInteger.getWidth(); ++j) {
                Element element2 = mxCodec2.getDocument().createElement("data");
                mxCodec.setAttribute((Node)element2, (String)"line", (Object)i);
                mxCodec.setAttribute((Node)element2, (String)"column", (Object)j);
                mxCodec.setAttribute((Node)element2, (String)VALUE, (Object)scilabInteger.getData()[i][j]);
                element.appendChild(element2);
            }
        }
        return element;
    }

    public Object decode(mxCodec mxCodec2, Node node, Object object) {
        ScilabInteger scilabInteger = null;
        try {
            Object object2;
            int n;
            if (node.getNodeType() != 1) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            if (this.getBooleanAttribute(namedNodeMap, "binary")) {
                return binaryObjects.get(this.getIntegerAttribute(namedNodeMap, "position"));
            }
            scilabInteger = (ScilabInteger)this.cloneTemplate(node);
            int n2 = this.getHeight(namedNodeMap);
            if (n2 * (n = this.getWidth(namedNodeMap)) == 0) {
                return scilabInteger;
            }
            Node node2 = namedNodeMap.getNamedItem(PRECISION);
            ScilabIntegerTypeEnum scilabIntegerTypeEnum = node2 != null ? ScilabIntegerTypeEnum.valueOf((String)node2.getNodeValue()) : ScilabIntegerTypeEnum.sci_uint8;
            Node node3 = namedNodeMap.getNamedItem(PREC);
            if (node3 != null) {
                object2 = namedNodeMap.getNamedItem(BUNSIGNED);
                boolean bl = object2 != null;
                scilabIntegerTypeEnum = ScilabInteger.convertOldType((String)node3.getNodeValue(), (boolean)bl);
            }
            switch (scilabIntegerTypeEnum) {
                case sci_int8: 
                case sci_uint8: {
                    object2 = new byte[n2][n];
                    this.fillData(node, (byte[][])object2);
                    scilabInteger.setData((byte[][])object2, scilabIntegerTypeEnum == ScilabIntegerTypeEnum.sci_uint8);
                    break;
                }
                case sci_int16: 
                case sci_uint16: {
                    short[][] sArray = new short[n2][n];
                    this.fillData(node, sArray);
                    scilabInteger.setData(sArray, scilabIntegerTypeEnum == ScilabIntegerTypeEnum.sci_uint16);
                    break;
                }
                case sci_int32: 
                case sci_uint32: {
                    int[][] nArray = new int[n2][n];
                    this.fillData(node, nArray);
                    scilabInteger.setData(nArray, scilabIntegerTypeEnum == ScilabIntegerTypeEnum.sci_uint32);
                    break;
                }
                default: {
                    long[][] lArray = new long[n2][n];
                    this.fillData(node, lArray);
                    scilabInteger.setData(lArray, scilabIntegerTypeEnum == ScilabIntegerTypeEnum.sci_uint64);
                    break;
                }
            }
        }
        catch (ScilabObjectCodec.UnrecognizeFormatException unrecognizeFormatException) {
            Logger.getLogger(ScilabIntegerCodec.class.getName()).severe(unrecognizeFormatException.toString());
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(ScilabIntegerCodec.class.getName()).severe(numberFormatException.toString());
        }
        return scilabInteger;
    }

    private void fillData(Node node, byte[][] byArray) throws ScilabObjectCodec.UnrecognizeFormatException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            int n = this.getColumnIndex(namedNodeMap);
            int n2 = this.getLineIndex(namedNodeMap);
            Node node3 = namedNodeMap.getNamedItem(VALUE);
            if (node3 == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            byArray[n2][n] = Byte.parseByte(node3.getNodeValue());
        }
    }

    private void fillData(Node node, short[][] sArray) throws ScilabObjectCodec.UnrecognizeFormatException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            int n = this.getColumnIndex(namedNodeMap);
            int n2 = this.getLineIndex(namedNodeMap);
            Node node3 = namedNodeMap.getNamedItem(VALUE);
            if (node3 == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            sArray[n2][n] = Short.parseShort(node3.getNodeValue());
        }
    }

    private void fillData(Node node, int[][] nArray) throws ScilabObjectCodec.UnrecognizeFormatException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            int n = this.getColumnIndex(namedNodeMap);
            int n2 = this.getLineIndex(namedNodeMap);
            Node node3 = namedNodeMap.getNamedItem(VALUE);
            if (node3 == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            nArray[n2][n] = Integer.parseInt(node3.getNodeValue());
        }
    }

    private void fillData(Node node, long[][] lArray) throws ScilabObjectCodec.UnrecognizeFormatException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            int n = this.getColumnIndex(namedNodeMap);
            int n2 = this.getLineIndex(namedNodeMap);
            Node node3 = namedNodeMap.getNamedItem(VALUE);
            if (node3 == null) {
                throw new ScilabObjectCodec.UnrecognizeFormatException(this);
            }
            lArray[n2][n] = Long.parseLong(node3.getNodeValue());
        }
    }
}

