/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.actions;

import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUndoManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.JButton;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.ActionConstraint;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.graph.utils.ScilabGraphMessages;
import org.scilab.modules.gui.menuitem.MenuItem;

public class UndoAction
extends DefaultAction {
    public static final String NAME = ScilabGraphMessages.UNDO;
    public static final String SMALL_ICON = "edit-undo";
    public static final int MNEMONIC_KEY = 90;
    public static final int ACCELERATOR_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public UndoAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
        UndoConstraint undoConstraint = new UndoConstraint(scilabGraph);
        undoConstraint.install(this, scilabGraph);
    }

    public static JButton undoButton(ScilabGraph scilabGraph) {
        return UndoAction.createButton(scilabGraph, UndoAction.class);
    }

    public static MenuItem undoMenu(ScilabGraph scilabGraph) {
        return UndoAction.createMenu(scilabGraph, UndoAction.class);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ScilabGraph scilabGraph = this.getGraph(actionEvent);
        scilabGraph.removeUndoHandler();
        scilabGraph.getUndoManager().undo();
        scilabGraph.registerUndoHandler();
        scilabGraph.getAsComponent().clearCellOverlays();
        scilabGraph.getAsComponent().validateGraph();
    }

    private final class UndoConstraint
    extends ActionConstraint {
        private final WeakReference<ScilabGraph> scilabGraph;

        public UndoConstraint(ScilabGraph scilabGraph) {
            this.scilabGraph = new WeakReference<ScilabGraph>(scilabGraph);
        }

        @Override
        public void install(DefaultAction defaultAction, ScilabGraph scilabGraph) {
            super.install(defaultAction, scilabGraph);
            this.registerAsListener(scilabGraph.getUndoManager());
        }

        private void registerAsListener(mxUndoManager mxUndoManager2) {
            mxUndoManager2.addListener("undo", (mxEventSource.mxIEventListener)this);
            mxUndoManager2.addListener("redo", (mxEventSource.mxIEventListener)this);
            mxUndoManager2.addListener("add", (mxEventSource.mxIEventListener)this);
            mxUndoManager2.addListener("clear", (mxEventSource.mxIEventListener)this);
        }

        public void invoke(Object object, mxEventObject mxEventObject2) {
            ScilabGraph scilabGraph = (ScilabGraph)((Object)this.scilabGraph.get());
            if (scilabGraph == null) {
                return;
            }
            boolean bl = scilabGraph.getUndoManager().canUndo();
            super.setEnabled(bl);
        }
    }
}

