/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxITextShape;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.batik.gvt.GraphicsNode;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.modules.graph.shape.LatexTextShape;
import org.scilab.modules.graph.shape.MathMLTextShape;
import org.scilab.modules.graph.shape.SvgShape;
import org.scilab.modules.graph.utils.MathMLRenderUtils;
import org.scilab.modules.graph.utils.ScilabGraphUtils;
import org.scilab.modules.graph.view.SupportedLabelType;
import org.xml.sax.SAXException;

public class ScilabCanvas
extends mxInteractiveCanvas {
    public static final int ROTATION_STEP = 90;
    public static final int MAX_ROTATION = 360;
    private static final double BORDER_RATIO = 0.9;
    private URL urlBasePath;

    public mxITextShape getTextShape(String string, Map<String, Object> map, boolean bl) {
        mxITextShape mxITextShape2;
        SupportedLabelType supportedLabelType = bl ? SupportedLabelType.getFromHTML(string) : SupportedLabelType.getFromText(string);
        switch (supportedLabelType) {
            case Latex: {
                try {
                    new TeXFormula(SupportedLabelType.Latex.escape(string));
                    mxITextShape2 = (mxITextShape)textShapes.get(supportedLabelType.name());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    return super.getTextShape(map, bl);
                }
            }
            case MathML: {
                try {
                    MathMLRenderUtils.getMathMLComponent(string);
                    mxITextShape2 = (mxITextShape)textShapes.get(supportedLabelType.name());
                    break;
                }
                catch (SAXException sAXException) {
                    return super.getTextShape(map, bl);
                }
            }
            default: {
                mxITextShape2 = super.getTextShape(map, bl);
            }
        }
        return mxITextShape2;
    }

    private void applyFlipAndMirror(Graphics2D graphics2D, Map<String, Object> map, mxRectangle mxRectangle2) {
        if (mxRectangle2 == null) {
            return;
        }
        boolean bl = mxUtils.isTrue(map, (String)"flip", (boolean)false);
        boolean bl2 = mxUtils.isTrue(map, (String)"mirror", (boolean)false);
        double d = mxRectangle2.getCenterX();
        double d2 = mxRectangle2.getCenterY();
        graphics2D.translate(d, d2);
        if (bl) {
            graphics2D.scale(1.0, -1.0);
        }
        if (bl2) {
            graphics2D.scale(-1.0, 1.0);
        }
        graphics2D.translate(-d, -d2);
    }

    public Graphics2D createTemporaryGraphics(Map<String, Object> map, float f, mxRectangle mxRectangle2) {
        Graphics2D graphics2D = super.createTemporaryGraphics(map, f, mxRectangle2);
        this.applyFlipAndMirror(graphics2D, map, mxRectangle2);
        return graphics2D;
    }

    public Object drawLabel(String string, mxCellState mxCellState2, boolean bl) {
        Map map = mxCellState2.getStyle();
        mxITextShape mxITextShape2 = this.getTextShape(string, map, bl);
        if (this.g != null && mxITextShape2 != null && this.drawLabels && string != null && string.length() > 0) {
            float f = mxUtils.getFloat((Map)map, (String)mxConstants.STYLE_TEXT_OPACITY, (float)100.0f);
            Graphics2D graphics2D = this.g;
            this.g = this.createTemporaryGraphics(map, f, null);
            Color color = mxUtils.getColor((Map)map, (String)mxConstants.STYLE_LABEL_BACKGROUNDCOLOR);
            Color color2 = mxUtils.getColor((Map)map, (String)mxConstants.STYLE_LABEL_BORDERCOLOR);
            this.paintRectangle(mxCellState2.getLabelBounds().getRectangle(), color, color2);
            mxITextShape2.paintShape((mxGraphics2DCanvas)this, string, mxCellState2, map);
            this.g.dispose();
            this.g = graphics2D;
        }
        return mxITextShape2;
    }

    public void paintSvgForegroundImage(int n, int n2, String string) {
        double d;
        double d2;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(ScilabCanvas.class.getName()).severe(malformedURLException.toString());
            return;
        }
        GraphicsNode graphicsNode = ScilabGraphUtils.getSVGComponent(uRL);
        if (graphicsNode == null || graphicsNode.getBounds() == null) {
            return;
        }
        Dimension2D dimension2D = ScilabGraphUtils.getSVGDocumentSizes(uRL);
        double d3 = dimension2D.getHeight();
        double d4 = (double)n2 / d3;
        double d5 = d4 > (d2 = (double)n / (d = dimension2D.getWidth())) ? d2 : d4;
        double d6 = (d5 *= 0.9) * d3;
        double d7 = d5 * d;
        double d8 = ((double)n - d7) / 2.0;
        double d9 = ((double)n2 - d6) / 2.0;
        this.g.translate(d8, d9);
        this.g.scale(d5, d5);
        try {
            graphicsNode.paint(this.g);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setImageBasePath(String string) {
        super.setImageBasePath(string);
        try {
            this.urlBasePath = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(ScilabCanvas.class.getName()).severe(malformedURLException.toString());
        }
    }

    public String getImageForStyle(Map<String, Object> map) {
        String string = mxUtils.getString(map, (String)mxConstants.STYLE_IMAGE);
        if (string == null) {
            return null;
        }
        try {
            return new URL(this.urlBasePath, string).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    static {
        ScilabCanvas.putShape((String)"label", (mxIShape)new SvgShape());
        ScilabCanvas.putTextShape((String)SupportedLabelType.Latex.name(), (mxITextShape)new LatexTextShape());
        ScilabCanvas.putTextShape((String)SupportedLabelType.MathML.name(), (mxITextShape)new MathMLTextShape());
    }
}

