/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphicsio.font.CharstringEncoder;
import org.freehep.graphicsio.font.FontEmbedder;
import org.freehep.util.io.ASCIIHexOutputStream;
import org.freehep.util.io.CountedByteOutputStream;
import org.freehep.util.io.EEXECEncryption;

public class FontEmbedderType1
extends FontEmbedder {
    private static final boolean ENCRYPT = true;
    private static final boolean HEX_ENC = true;
    private static final boolean HEX_ENC_CHARSTRINGS = false;
    private PrintStream fontFile;
    private PrintStream encrypted;
    private CountedByteOutputStream byteCounter;
    private int asciiEnd;
    private int encEnd;
    private boolean addZeros;

    public FontEmbedderType1(FontRenderContext context, OutputStream out, boolean addZeros) {
        super(context);
        this.byteCounter = new CountedByteOutputStream(out);
        this.fontFile = new PrintStream((OutputStream)this.byteCounter);
        this.addZeros = addZeros;
        this.encEnd = -1;
        this.asciiEnd = -1;
    }

    protected void writeWidths(double[] w) throws IOException {
    }

    protected void writeEncoding(CharTable t) throws IOException {
        this.fontFile.println("/Encoding 256 array");
        this.fontFile.println("0 1 255 {1 index exch /.notdef put} for");
        for (int i = 0; i < 256; ++i) {
            String charName = t.toName(i);
            if (charName == null) continue;
            this.fontFile.println("dup " + i + " /" + charName + " put");
        }
        this.fontFile.println("readonly def");
    }

    protected void openIncludeFont() throws IOException {
        this.fontFile.println("%!FontType1-1.0: " + this.getFont().getName());
        this.fontFile.println("% Generated by: " + this.getClass().getName());
        this.fontFile.println("11 dict begin");
        this.fontFile.println("/FontInfo 8 dict dup begin");
        this.fontFile.println("/FullName (" + this.getFont().getPSName() + ") readonly def");
        this.fontFile.println("/FamilyName (" + this.getFont().getFamily() + ") readonly def");
        this.fontFile.println("end readonly def");
        this.fontFile.println("/FontName /" + this.getFontName() + " def");
        this.fontFile.println("/PaintType 0 def");
        this.fontFile.println("/FontType 1 def");
        this.fontFile.println("/FontMatrix [0.001 0.0 0.0 0.001 0.0 0.0] readonly def");
    }

    protected void closeIncludeFont() {
        Rectangle2D boundingBox = this.getFontBBox();
        int llx = (int)Math.round(boundingBox.getX());
        int lly = (int)Math.round(boundingBox.getY());
        int urx = (int)Math.round(boundingBox.getX() + boundingBox.getWidth());
        int ury = (int)Math.round(boundingBox.getY() + boundingBox.getHeight());
        this.fontFile.println("/FontBBox {" + llx + " " + lly + " " + urx + " " + ury + "} readonly def");
        this.fontFile.println("currentdict end");
        this.fontFile.print("currentfile eexec ");
        this.asciiEnd = this.byteCounter.getCount();
        this.fontFile.flush();
    }

    protected void openGlyphs() throws IOException {
        this.encrypted = new PrintStream((OutputStream)new EEXECEncryption((OutputStream)new ASCIIHexOutputStream((OutputStream)this.fontFile), 55665));
        this.encrypted.println("dup /Private 8 dict dup begin");
        this.encrypted.println("/RD {string currentfile exch readstring pop} executeonly def");
        this.encrypted.println("/ND {noaccess def} executeonly def");
        this.encrypted.println("/NP {noaccess put} executeonly def");
        this.encrypted.println("/BlueValues [] def");
        this.encrypted.println("/MinFeature {16 16} def");
        this.encrypted.println("/password 5839 def");
        this.encrypted.print("2 index ");
        this.encrypted.println("/CharStrings " + (this.getNODefinedChars() + 1) + " dict dup begin");
    }

    protected void closeGlyphs() throws IOException {
        this.encrypted.println("end");
        this.encrypted.println("end");
    }

    protected void closeEmbedFont() throws IOException {
        this.encrypted.println("readonly put");
        this.encrypted.println("noaccess put");
        this.encrypted.println("dup /FontName get exch definefont pop");
        this.encrypted.print("mark");
        this.encrypted.print(" currentfile closefile ");
        this.encrypted.flush();
        this.encEnd = this.byteCounter.getCount();
        if (this.addZeros) {
            this.fontFile.println();
            for (int i = 0; i < 16; ++i) {
                this.fontFile.println("00000000000000000000000000000000");
            }
            this.fontFile.println("cleartomark");
        }
    }

    protected void writeGlyph(String characterName, Shape glyph, GlyphMetrics glyphMetrics) throws IOException {
        double sidebearing = glyphMetrics != null ? (double)glyphMetrics.getLSB() : 0.0;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        CharstringEncoder charString = new CharstringEncoder((OutputStream)new EEXECEncryption((OutputStream)bytes, 4330));
        charString.startChar(sidebearing, glyphMetrics != null ? (double)glyphMetrics.getAdvance() : this.getUndefinedWidth());
        charString.drawPath(glyph);
        charString.endchar();
        byte[] binaryString = bytes.toByteArray();
        this.encrypted.print("/" + characterName + " " + binaryString.length + " RD ");
        for (int i = 0; i < binaryString.length; ++i) {
            this.encrypted.write(binaryString[i] & 0xFF);
        }
        this.encrypted.println("ND");
        this.encrypted.flush();
    }

    public int getAsciiLength() {
        return this.asciiEnd;
    }

    public int getEncryptedLength() {
        return this.encEnd - this.asciiEnd;
    }
}

