/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.external_objects_java;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.external_objects_java.ScilabClassLoader;
import org.scilab.modules.external_objects_java.ScilabJavaException;
import org.scilab.modules.external_objects_java.ScilabJavaObject;

public class ScilabJavaCompiler {
    private static final String JAVACOMPILER = "javax.tools.JavaCompiler";
    private static final String BINPATH = System.getProperty("java.io.tmpdir") + File.separator + "JIMS" + File.separator + "bin";
    private static JavaCompiler compiler;
    private static boolean ecjLoaded;
    private static boolean isECJ;

    private static void findCompiler() throws ScilabJavaException {
        if (compiler == null) {
            try {
                compiler = ToolProvider.getSystemJavaCompiler();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (compiler == null) {
                ServiceLoader<JavaCompiler> serviceLoader = ServiceLoader.load(JavaCompiler.class);
                for (JavaCompiler javaCompiler : serviceLoader) {
                    if (javaCompiler == null) continue;
                    compiler = javaCompiler;
                    break;
                }
            }
            if (compiler == null) {
                if (ecjLoaded) {
                    throw new ScilabJavaException("No java compiler in the classpath\nCheck for tools.jar (comes from JDK) or ecj-4.4.x.jar (Eclipse Compiler for Java)");
                }
                ScilabCommonsUtils.loadOnUse((String)"external_objects_java");
                ecjLoaded = true;
                ScilabJavaCompiler.findCompiler();
            }
            isECJ = compiler.getClass().getSimpleName().indexOf("Eclipse") != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compileCode(String string, String[] stringArray) throws ScilabJavaException {
        Object object;
        if (SwingUtilities.isEventDispatchThread()) {
            ScilabJavaCompiler.findCompiler();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ScilabJavaCompiler.findCompiler();
                        }
                        catch (ScilabJavaException scilabJavaException) {
                            scilabJavaException.printStackTrace();
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
        StandardJavaFileManager standardJavaFileManager = compiler.getStandardFileManager(null, Locale.getDefault(), null);
        String string2 = null;
        if (isECJ) {
            string2 = ScilabJavaCompiler.getClasspath();
            System.setProperty("java.class.path", string2 + File.pathSeparatorChar + System.getProperty("java.class.path"));
        } else {
            try {
                standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, ScilabJavaCompiler.getClasspathFiles());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ClassFileManager classFileManager = new ClassFileManager(standardJavaFileManager);
        ArrayList<SimpleJavaFileObject> arrayList = new ArrayList<SimpleJavaFileObject>();
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(charArrayWriter);
        boolean bl = true;
        SourceString sourceString = null;
        for (String string3 : stringArray) {
            object = new File(string3);
            if (((File)object).exists() && ((File)object).canRead()) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (String string3 : stringArray) {
                object = new File(string3);
                arrayList.add(new SourceFile((File)object));
            }
        } else {
            sourceString = new SourceString(string, stringArray);
            arrayList.add(sourceString);
        }
        String[] stringArray2 = new String[]{"-d", BINPATH};
        List<String> list = Arrays.asList(stringArray2);
        try {
            standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(new File(BINPATH)));
        }
        catch (IOException iOException) {
            Logger.getLogger(ScilabJavaCompiler.class.getName()).log(Level.SEVERE, null, iOException);
        }
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(bufferedWriter, classFileManager, diagnosticCollector, list, null, arrayList);
        boolean bl2 = compilationTask.call();
        if (string2 != null) {
            object = System.getProperty("java.class.path").replace(string2 + File.pathSeparatorChar, "");
            System.setProperty("java.class.path", (String)object);
        }
        object = "";
        try {
            bufferedWriter.flush();
            object = charArrayWriter.toString();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
        if (bl2) {
            if (bl) {
                return -1;
            }
            if (classFileManager.className != null && !classFileManager.className.isEmpty()) {
                return ScilabClassLoader.loadJavaClass(BINPATH, classFileManager.className);
            }
            return -1;
        }
        if (!isECJ) {
            object = ScilabJavaCompiler.getCompilerErrors(diagnosticCollector);
        }
        throw new ScilabJavaException((String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCompilerErrors(DiagnosticCollector<JavaFileObject> diagnosticCollector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        stringBuffer.append("----------\n");
        for (Diagnostic<JavaFileObject> diagnostic : diagnosticCollector.getDiagnostics()) {
            stringBuffer.append(Integer.toString(n++)).append(". ").append((Object)diagnostic.getKind());
            if (diagnostic.getSource() != null) {
                stringBuffer.append(" in ").append(diagnostic.getSource().toUri().getPath()).append(" (at line ").append(Long.toString(diagnostic.getLineNumber())).append(")\n");
                Reader reader = null;
                try {
                    reader = diagnostic.getSource().openReader(true);
                    reader.skip(diagnostic.getStartPosition());
                    char[] cArray = new char[(int)(diagnostic.getEndPosition() - diagnostic.getStartPosition() + 1L)];
                    reader.read(cArray);
                    stringBuffer.append("        ").append(cArray).append('\n');
                    Arrays.fill(cArray, '^');
                    stringBuffer.append("        ").append(cArray).append('\n');
                }
                catch (IOException iOException) {
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                stringBuffer.append('\n');
            }
            stringBuffer.append(diagnostic.getMessage(Locale.getDefault())).append('\n');
        }
        stringBuffer.append("----------\n");
        return stringBuffer.toString();
    }

    public static String getClasspath() {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] uRLArray = uRLClassLoader.getURLs();
        StringBuffer stringBuffer = new StringBuffer();
        for (URL uRL : uRLArray) {
            stringBuffer.append(uRL.getPath()).append(File.pathSeparatorChar);
        }
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    public static List<File> getClasspathFiles() {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] uRLArray = uRLClassLoader.getURLs();
        ArrayList<File> arrayList = new ArrayList<File>(uRLArray.length);
        for (URL uRL : uRLArray) {
            try {
                arrayList.add(new File(uRL.toURI()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static void addURLToClassPath(URL uRL) {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)uRLClassLoader, uRL);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Error: Cannot find the declared method: " + noSuchMethodException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Error: Illegal access: " + illegalAccessException.getLocalizedMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Error: Could not invocate target: " + invocationTargetException.getLocalizedMessage());
        }
    }

    static {
        ecjLoaded = false;
        new File(System.getProperty("java.io.tmpdir") + File.separator + "JIMS").mkdir();
        new File(BINPATH).mkdir();
        try {
            URL uRL = new File(BINPATH).toURI().toURL();
            ScilabJavaCompiler.addURLToClassPath(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException);
        }
    }

    private static class ClassFileManager
    extends ForwardingJavaFileManager {
        String className;

        public ClassFileManager(StandardJavaFileManager standardJavaFileManager) {
            super(standardJavaFileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
            if (fileObject instanceof SourceString && string != null && string.indexOf(36) == -1) {
                this.className = string.replace('/', '.');
            }
            if (ScilabJavaObject.debug) {
                ScilabJavaObject.logger.log(Level.INFO, "Compilation of class '" + string + "'");
            }
            return super.getJavaFileForOutput(location, string, kind, fileObject);
        }
    }

    private static class SourceFile
    extends SimpleJavaFileObject {
        final File f;

        private SourceFile(File file) {
            super(file.toURI(), JavaFileObject.Kind.SOURCE);
            this.f = file;
        }

        @Override
        public CharSequence getCharContent(boolean bl) {
            try {
                int n;
                FileReader fileReader = new FileReader(this.f);
                char[] cArray = new char[1024];
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = fileReader.read(cArray, 0, 1024)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
                fileReader.close();
                return stringBuffer;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static class SourceString
    extends SimpleJavaFileObject {
        private final String code;

        private SourceString(String string, String[] stringArray) {
            super(new File(BINPATH + "/" + string.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension).toURI(), JavaFileObject.Kind.SOURCE);
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : stringArray) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            this.code = stringBuffer.toString();
        }

        @Override
        public CharSequence getCharContent(boolean bl) {
            return this.code;
        }
    }
}

