/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.external_objects_java;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.scilab.modules.external_objects_java.FunctionArguments;
import org.scilab.modules.external_objects_java.ScilabClassLoader;
import org.scilab.modules.external_objects_java.ScilabJavaException;
import org.scilab.modules.external_objects_java.ScilabJavaObject;

public final class ScilabJavaArray {
    static final Map<Class, Class> mappings = new HashMap<Class, Class>(8);
    private static final Map<String, Class> baseType = new HashMap<String, Class>(8);

    public static int newInstance(String string, int[] nArray) throws ScilabJavaException {
        Class clazz = null;
        if (ScilabJavaObject.debug) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            if (nArray.length > 0) {
                int n;
                for (n = 0; n < nArray.length - 1; ++n) {
                    stringBuffer.append(Integer.toString(nArray[n]));
                    stringBuffer.append(",");
                }
                stringBuffer.append(Integer.toString(nArray[n]));
            }
            stringBuffer.append(")");
            ScilabJavaObject.logger.log(Level.INFO, "Array creation: base class is '" + string + "' with dims=" + stringBuffer.toString());
        }
        if ((clazz = baseType.get(string)) == null) {
            try {
                int n = ScilabClassLoader.loadJavaClass(string, false);
                clazz = n == 0 ? (Class)ScilabJavaObject.arraySJO[n].object : Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ScilabJavaException("Cannot find the class " + string);
            }
        }
        return new ScilabJavaObject((Object)Array.newInstance(clazz, (int[])nArray)).id;
    }

    public static Object get(Object object, int[] nArray) throws ScilabJavaException {
        Object object2 = object;
        for (int i = 0; i < nArray.length; ++i) {
            if (object2 != null && object2.getClass().isArray()) {
                if (nArray[i] >= 0 && nArray[i] < Array.getLength(object2)) {
                    object2 = Array.get(object2, nArray[i]);
                    continue;
                }
                throw new ScilabJavaException("Problem in retrieving " + i + "-th element: " + nArray[i] + ">" + (Array.getLength(object2) - 1));
            }
            if (object2 instanceof List) {
                List list = (List)object2;
                if (nArray[i] >= 0 && nArray[i] < list.size()) {
                    object2 = list.get(nArray[i]);
                    continue;
                }
                throw new ScilabJavaException("Problem in retrieving " + i + "-th element: " + nArray[i] + ">" + (list.size() - 1));
            }
            throw new ScilabJavaException("Problem in retrieving " + i + "-th element: it is not an array");
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void set(Object object, int[] nArray, Object object2) throws ScilabJavaException {
        List list;
        int n;
        Object object3 = object;
        for (n = 0; n < nArray.length - 1; ++n) {
            if (object3 != null && object3.getClass().isArray()) {
                if (nArray[n] < 0 || nArray[n] >= Array.getLength(object3)) throw new ScilabJavaException("Problem in retrieving " + n + "-th element: " + nArray[n] + ">" + (Array.getLength(object3) - 1));
                object3 = Array.get(object3, nArray[n]);
                continue;
            }
            if (!(object3 instanceof List)) throw new ScilabJavaException("Problem in retrieving " + n + "-th element: it is not an array");
            list = (List)object3;
            if (nArray[n] < 0 || nArray[n] >= list.size()) throw new ScilabJavaException("Problem in retrieving " + n + "-th element: " + nArray[n] + ">" + (list.size() - 1));
            object3 = list.get(nArray[n]);
        }
        if (object3 != null && object3.getClass().isArray()) {
            if (nArray[n] < 0 || nArray[n] >= Array.getLength(object3)) throw new ScilabJavaException("Problem in setting " + nArray[n] + "-th element: " + nArray[n] + ">" + (Array.getLength(object3) - 1));
            try {
                Array.set(object3, nArray[n], FunctionArguments.convert(object2, object3.getClass().getComponentType()));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ScilabJavaException("Array " + object3 + " cannot contain object which is an instance of " + object2.getClass());
            }
        } else {
            if (!(object3 instanceof List)) throw new ScilabJavaException("Problem in retrieving " + n + "-th element: it is not an array");
            list = (List)object3;
            if (nArray[n] >= 0 && nArray[n] < list.size()) {
                list.set(nArray[n], object2);
                return;
            } else {
                if (nArray[n] != list.size()) throw new ScilabJavaException("Problem in retrieving " + n + "-th element: " + nArray[n] + ">" + (list.size() - 1));
                list.add(object2);
            }
        }
    }

    public static double[] toPrimitive(Double[] doubleArray) {
        double[] dArray = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray[i] = doubleArray[i];
        }
        return dArray;
    }

    public static float[] toPrimitive(Float[] floatArray) {
        float[] fArray = new float[floatArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            fArray[i] = floatArray[i].floatValue();
        }
        return fArray;
    }

    public static int[] toPrimitive(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public static char[] toPrimitive(Character[] characterArray) {
        char[] cArray = new char[characterArray.length];
        for (int i = 0; i < characterArray.length; ++i) {
            cArray[i] = characterArray[i].charValue();
        }
        return cArray;
    }

    public static byte[] toPrimitive(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return byArray;
    }

    public static short[] toPrimitive(Short[] shortArray) {
        short[] sArray = new short[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            sArray[i] = shortArray[i];
        }
        return sArray;
    }

    public static long[] toPrimitive(Long[] longArray) {
        long[] lArray = new long[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            lArray[i] = longArray[i];
        }
        return lArray;
    }

    public static boolean[] toPrimitive(Boolean[] booleanArray) {
        boolean[] blArray = new boolean[booleanArray.length];
        for (int i = 0; i < booleanArray.length; ++i) {
            blArray[i] = booleanArray[i];
        }
        return blArray;
    }

    public static Object toPrimitive(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            Class[] classArray = ScilabJavaArray.getPrimClasses(clazz);
            if (classArray == null) {
                return object;
            }
            if (classArray.length == 0) {
                try {
                    Method method = ScilabJavaArray.class.getDeclaredMethod("toPrimitive", clazz);
                    return method.invoke(null, object);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return ScilabJavaArray.toPrimitive(object, classArray.length - 1, classArray);
        }
        return object;
    }

    private static Object toPrimitive(Object object, int n, Class[] classArray) {
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])Array.newInstance(classArray[n], objectArray.length);
        if (n != 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = ScilabJavaArray.toPrimitive(objectArray[i], n - 1, classArray);
            }
        } else {
            try {
                Method method = ScilabJavaArray.class.getDeclaredMethod("toPrimitive", object.getClass().getComponentType());
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = method.invoke(null, objectArray[i]);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return objectArray2;
    }

    public static int[] toIntArray(double[] dArray) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)dArray[i];
        }
        return nArray;
    }

    public static Double[] fromPrimitive(double[] dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        return doubleArray;
    }

    public static Float[] fromPrimitive(float[] fArray) {
        Float[] floatArray = new Float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            floatArray[i] = Float.valueOf(fArray[i]);
        }
        return floatArray;
    }

    public static Integer[] fromPrimitive(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public static Character[] fromPrimitive(char[] cArray) {
        Character[] characterArray = new Character[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            characterArray[i] = Character.valueOf(cArray[i]);
        }
        return characterArray;
    }

    public static Byte[] fromPrimitive(byte[] byArray) {
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    public static Short[] fromPrimitive(short[] sArray) {
        Short[] shortArray = new Short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            shortArray[i] = sArray[i];
        }
        return shortArray;
    }

    public static Long[] fromPrimitive(long[] lArray) {
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            longArray[i] = lArray[i];
        }
        return longArray;
    }

    public static Boolean[] fromPrimitive(boolean[] blArray) {
        Boolean[] booleanArray = new Boolean[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            booleanArray[i] = blArray[i];
        }
        return booleanArray;
    }

    public static Object fromPrimitive(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            Class[] classArray = ScilabJavaArray.getFromPrimClasses(clazz);
            if (classArray == null) {
                return object;
            }
            if (classArray.length == 0) {
                try {
                    Method method = ScilabJavaArray.class.getDeclaredMethod("fromPrimitive", clazz);
                    return method.invoke(null, object);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return ScilabJavaArray.fromPrimitive(object, classArray.length - 1, classArray);
        }
        return object;
    }

    private static Object fromPrimitive(Object object, int n, Class[] classArray) {
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])Array.newInstance(classArray[n], objectArray.length);
        if (n != 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = ScilabJavaArray.fromPrimitive(objectArray[i], n - 1, classArray);
            }
        } else {
            try {
                Method method = ScilabJavaArray.class.getDeclaredMethod("fromPrimitive", object.getClass().getComponentType());
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = method.invoke(null, objectArray[i]);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return objectArray2;
    }

    public static Class getArrayBaseType(Class clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        return clazz2;
    }

    public static Object[] getArrayInfo(Class clazz) {
        Class<?> clazz2 = clazz;
        int n = 0;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            ++n;
        }
        return new Object[]{clazz2, new Integer(n)};
    }

    private static Class[] getFromPrimClasses(Class clazz) {
        int n = 0;
        Class clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            ++n;
        }
        if ((clazz2 = ScilabJavaObject.primTypes.get(clazz2)) == null) {
            return null;
        }
        Class[] classArray = new Class[n - 1];
        if (classArray.length != 0) {
            classArray[0] = Array.newInstance(clazz2, 0).getClass();
            for (int i = 1; i < n - 1; ++i) {
                classArray[i] = Array.newInstance(classArray[i - 1], 0).getClass();
            }
        }
        return classArray;
    }

    private static Class[] getPrimClasses(Class clazz) {
        int n = 0;
        Class clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            ++n;
        }
        if ((clazz2 = mappings.get(clazz2)) == null) {
            return null;
        }
        Class[] classArray = new Class[n - 1];
        if (classArray.length != 0) {
            classArray[0] = Array.newInstance(clazz2, 0).getClass();
            for (int i = 1; i < n - 1; ++i) {
                classArray[i] = Array.newInstance(classArray[i - 1], 0).getClass();
            }
        }
        return classArray;
    }

    public static byte[] toOneDim(byte[][] byArray) {
        if (byArray.length == 0 || byArray[0].length == 0) {
            return new byte[0];
        }
        int n = byArray[0].length;
        byte[] byArray2 = new byte[byArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            System.arraycopy(byArray[n2], 0, byArray2, n3, n);
            ++n2;
            n3 += n;
        }
        return byArray2;
    }

    public static short[] toOneDim(short[][] sArray) {
        if (sArray.length == 0 || sArray[0].length == 0) {
            return new short[0];
        }
        int n = sArray[0].length;
        short[] sArray2 = new short[sArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < sArray.length) {
            System.arraycopy(sArray[n2], 0, sArray2, n3, n);
            ++n2;
            n3 += n;
        }
        return sArray2;
    }

    public static int[] toOneDim(int[][] nArray) {
        if (nArray.length == 0 || nArray[0].length == 0) {
            return new int[0];
        }
        int n = nArray[0].length;
        int[] nArray2 = new int[nArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length) {
            System.arraycopy(nArray[n2], 0, nArray2, n3, n);
            ++n2;
            n3 += n;
        }
        return nArray2;
    }

    public static long[] toOneDim(long[][] lArray) {
        if (lArray.length == 0 || lArray[0].length == 0) {
            return new long[0];
        }
        int n = lArray[0].length;
        long[] lArray2 = new long[lArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < lArray.length) {
            System.arraycopy(lArray[n2], 0, lArray2, n3, n);
            ++n2;
            n3 += n;
        }
        return lArray2;
    }

    public static float[] toOneDim(float[][] fArray) {
        if (fArray.length == 0 || fArray[0].length == 0) {
            return new float[0];
        }
        int n = fArray[0].length;
        float[] fArray2 = new float[fArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < fArray.length) {
            System.arraycopy(fArray[n2], 0, fArray2, n3, n);
            ++n2;
            n3 += n;
        }
        return fArray2;
    }

    public static double[] toOneDim(double[][] dArray) {
        if (dArray.length == 0 || dArray[0].length == 0) {
            return new double[0];
        }
        int n = dArray[0].length;
        double[] dArray2 = new double[dArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < dArray.length) {
            System.arraycopy(dArray[n2], 0, dArray2, n3, n);
            ++n2;
            n3 += n;
        }
        return dArray2;
    }

    public static char[] toOneDim(char[][] cArray) {
        if (cArray.length == 0 || cArray[0].length == 0) {
            return new char[0];
        }
        int n = cArray[0].length;
        char[] cArray2 = new char[cArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            System.arraycopy(cArray[n2], 0, cArray2, n3, n);
            ++n2;
            n3 += n;
        }
        return cArray2;
    }

    static Object toOneDim(Object object) {
        Class clazz = ScilabJavaArray.getArrayBaseType(object.getClass());
        if (clazz.isPrimitive()) {
            try {
                Method method = ScilabJavaArray.class.getDeclaredMethod("toOneDim", object.getClass());
                return method.invoke(null, object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        Object[][] objectArray = (Object[][])object;
        if (objectArray.length == 0 || objectArray[0].length == 0) {
            return Array.newInstance(clazz, 0);
        }
        int n = objectArray[0].length;
        Object object2 = Array.newInstance(clazz, objectArray.length * n);
        int n2 = 0;
        int n3 = 0;
        while (n2 < objectArray.length) {
            System.arraycopy(objectArray[n2], 0, object2, n3, n);
            ++n2;
            n3 += n;
        }
        return object2;
    }

    static Object toBiDim(Object object) {
        Object object2 = Array.newInstance(object.getClass(), 1);
        Array.set(object2, 0, object);
        return object2;
    }

    static Object singleToOneDim(Class clazz, Object object) {
        Object object2 = Array.newInstance(clazz, 1);
        Array.set(object2, 0, object);
        return object2;
    }

    public static double[] toDoubleArray(List<Double> list) {
        double[] dArray = new double[list.size()];
        int n = 0;
        for (Double d : list) {
            dArray[n++] = d;
        }
        return dArray;
    }

    public static float[] toFloatArray(List<Float> list) {
        float[] fArray = new float[list.size()];
        int n = 0;
        for (Float f : list) {
            fArray[n++] = f.floatValue();
        }
        return fArray;
    }

    public static byte[] toByteArray(List<Byte> list) {
        byte[] byArray = new byte[list.size()];
        int n = 0;
        for (Byte by : list) {
            byArray[n++] = by;
        }
        return byArray;
    }

    public static short[] toShortArray(List<Short> list) {
        short[] sArray = new short[list.size()];
        int n = 0;
        for (Short s : list) {
            sArray[n++] = s;
        }
        return sArray;
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        int n = 0;
        for (Integer n2 : list) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public static long[] toLongArray(List<Long> list) {
        long[] lArray = new long[list.size()];
        int n = 0;
        for (Long l : list) {
            lArray[n++] = l;
        }
        return lArray;
    }

    public static String[] toStringArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static boolean[] toBooleanArray(List<Boolean> list) {
        boolean[] blArray = new boolean[list.size()];
        int n = 0;
        for (Boolean bl : list) {
            blArray[n++] = bl;
        }
        return blArray;
    }

    public static char[] toCharArray(List<Character> list) {
        char[] cArray = new char[list.size()];
        int n = 0;
        for (Character c : list) {
            cArray[n++] = c.charValue();
        }
        return cArray;
    }

    public static List toList(Object object) {
        if (object.getClass().isArray()) {
            Class<?> clazz = object.getClass().getComponentType();
            if (ScilabJavaObject.primTypes.containsKey(clazz)) {
                object = ScilabJavaArray.fromPrimitive(object);
            }
            ArrayList arrayList = new ArrayList();
            try {
                Field field = ArrayList.class.getDeclaredField("elementData");
                Field field2 = ArrayList.class.getDeclaredField("size");
                field.setAccessible(true);
                field2.setAccessible(true);
                field.set(arrayList, object);
                field2.set(arrayList, ((Object[])object).length);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return arrayList;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        return linkedList;
    }

    static {
        mappings.put(Double.class, Double.TYPE);
        mappings.put(Integer.class, Integer.TYPE);
        mappings.put(Boolean.class, Boolean.TYPE);
        mappings.put(Short.class, Short.TYPE);
        mappings.put(Byte.class, Byte.TYPE);
        mappings.put(Character.class, Character.TYPE);
        mappings.put(Long.class, Long.TYPE);
        mappings.put(Float.class, Float.TYPE);
        baseType.put("double", Double.TYPE);
        baseType.put("int", Integer.TYPE);
        baseType.put("boolean", Boolean.TYPE);
        baseType.put("short", Short.TYPE);
        baseType.put("long", Long.TYPE);
        baseType.put("float", Float.TYPE);
        baseType.put("char", Character.TYPE);
        baseType.put("byte", Byte.TYPE);
    }
}

