/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.external_objects_java;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.scilab.modules.external_objects_java.ScilabJavaException;

public class ScilabJarCreator {
    public static int createJarArchive(String string, String[] stringArray, String string2, String string3, boolean bl) throws ScilabJavaException {
        JarOutputStream jarOutputStream = null;
        try {
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            for (String object2 : stringArray) {
                stringArray2[n++] = new File(object2).getCanonicalPath();
            }
            Object object3 = null;
            if (string2 == null || string2.isEmpty()) {
                if (!bl) {
                    object3 = ScilabJarCreator.getCommonPath(stringArray2);
                }
            } else {
                object3 = new File(string2).getCanonicalPath();
            }
            List<String> list = ScilabJarCreator.expandPaths(stringArray2);
            Manifest manifest = null;
            if (string3 == null || string3.isEmpty()) {
                string3 = (String)object3 + File.separator + "META-INF" + File.separator + "MANIFEST.MF";
            }
            if (new File(string3).exists()) {
                FileInputStream fileInputStream = new FileInputStream(string3);
                manifest = new Manifest(fileInputStream);
                fileInputStream.close();
            } else {
                manifest = new Manifest();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, manifest);
            for (String string4 : list) {
                File file = new File(string4);
                String string5 = object3 != null && !((String)object3).isEmpty() ? ScilabJarCreator.getRelativePath((String)object3, string4) : (bl ? file.getPath() : file.getName());
                if (string5.equals("META-INF/MANIFEST.MF")) continue;
                ScilabJarCreator.addFileToJarArchive(file, string5, jarOutputStream);
            }
            ScilabJarCreator.closeJarArchive(jarOutputStream);
            jarOutputStream = null;
            return 0;
        }
        catch (IOException iOException) {
            try {
                ScilabJarCreator.closeJarArchive(jarOutputStream);
                ScilabJarCreator.deleteJarArchive(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ScilabJavaException(String.format("Cannot create jar archive %s: %s", string, iOException.getMessage()));
        }
    }

    private static List<String> expandPaths(String ... stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            File file = new File(string);
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    arrayList.addAll(ScilabJarCreator.expandPaths(file2.getPath()));
                }
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToJarArchive(File file, String string, JarOutputStream jarOutputStream) throws IOException {
        try (BufferedInputStream bufferedInputStream = null;){
            int n;
            string.replace("\\", "/");
            JarEntry jarEntry = new JarEntry(string);
            jarEntry.setTime(file.lastModified());
            jarOutputStream.putNextEntry(jarEntry);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[4096];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                jarOutputStream.write(byArray, 0, n);
            }
            jarOutputStream.closeEntry();
        }
    }

    private static String getCommonPath(String[] stringArray) throws IOException {
        int n = stringArray.length;
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            File file = new File(stringArray[0]);
            if (file.isDirectory()) {
                return file.getAbsolutePath();
            }
            return file.getParentFile().getAbsolutePath();
        }
        String string = Pattern.quote(System.getProperty("file.separator"));
        String string2 = "";
        String[][] stringArrayArray = new String[n][];
        int n2 = 0;
        for (String string3 : stringArray) {
            stringArrayArray[n2++] = string3.split(string);
        }
        for (int i = 0; i < stringArrayArray[0].length; ++i) {
            String string4 = stringArrayArray[0][i];
            int n3 = 1;
            for (int j = 1; j < stringArrayArray.length && n3 != 0; n3 &= new File(stringArrayArray[j][i]).compareTo(new File(string4)) == 0 ? 1 : 0, ++j) {
                if (i < stringArrayArray[j].length) continue;
                return string2;
            }
            if (n3 == 0) {
                return string2;
            }
            string2 = string2 + string4 + File.separator;
        }
        return string2;
    }

    private static String getRelativePath(String string, String string2) {
        return new File(string).toURI().relativize(new File(string2).toURI()).getPath();
    }

    private static void closeJarArchive(JarOutputStream jarOutputStream) throws ScilabJavaException {
        try {
            if (jarOutputStream != null) {
                jarOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ScilabJavaException(String.format("Cannot close jar stream: %s\n", iOException.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void deleteJarArchive(String string) throws ScilabJavaException {
        File file = new File(string);
        if (!file.exists()) throw new ScilabJavaException(String.format("Cannot delete jar archive %s: No such file.\n", string));
        if (!file.canWrite()) throw new ScilabJavaException(String.format("Cannot delete jar archive %s: File is write protected.\n", string));
        if (file.delete()) return;
        throw new ScilabJavaException(String.format("Cannot delete jar archive %s.\n", string));
    }
}

