/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor.celleditor;

import org.scilab.modules.ui_data.variableeditor.celleditor.ScilabGenericCellEditor;

public class ScilabComplexCellEditor
extends ScilabGenericCellEditor {
    private static final long serialVersionUID = 3866044279955696250L;
    private static final String I = "*%i";
    private static final String PLUS = "+";

    @Override
    public String getDataAsScilabString(Object object) {
        String string = "";
        if (object != null && object instanceof Double[]) {
            string = ScilabComplexCellEditor.convertComplex((Double[])object);
        } else if (object instanceof String) {
            string = (String)object;
        }
        return string;
    }

    protected static String convertDouble(Double d) {
        if (d.isNaN()) {
            return "%nan";
        }
        if (d.isInfinite()) {
            if (d < 0.0) {
                return "-%inf";
            }
            return "%inf";
        }
        return d.toString();
    }

    private static String convertComplex(Double[] doubleArray) {
        String string = "";
        String string2 = "";
        if (doubleArray[0] == 0.0 && doubleArray[1] == 0.0) {
            string = "0";
        } else {
            if (doubleArray[1] != 0.0) {
                string2 = doubleArray[1] == 1.0 ? "+%i" : (doubleArray[1] == -1.0 ? "-%i" : (doubleArray[1] < 0.0 ? ScilabComplexCellEditor.convertDouble(doubleArray[1]) + I : PLUS + ScilabComplexCellEditor.convertDouble(doubleArray[1]) + I));
            }
            if (doubleArray[0] != 0.0) {
                string = ScilabComplexCellEditor.convertDouble(doubleArray[0]);
            } else if (string2.startsWith(PLUS)) {
                string2 = string2.substring(1);
            }
        }
        return string + string2;
    }
}

