/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.ui_data.variableeditor.ScilabVariableEditor;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;

public class ScilabTabbedPane
extends JTabbedPane
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
Transferable {
    private static final ImageIcon CLOSEICON = new ImageIcon(System.getenv("SCI") + "/modules/gui/images/icons/close-tab.png");
    private static final int BUTTONSIZE = 18;
    private static DataFlavor DATAFLAVOR;
    private static ScilabTabbedPane currentWhenDragged;
    private SwingScilabVariableEditor editor;
    private int draggedIndex;

    public ScilabTabbedPane(SwingScilabVariableEditor swingScilabVariableEditor) {
        this.editor = swingScilabVariableEditor;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        DropTarget dropTarget = new DropTarget(this, this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (ScilabTabbedPane.this.getSelectedIndex() > 0) {
                    ((JScrollPane)ScilabTabbedPane.this.getComponentAt(ScilabTabbedPane.this.getSelectedIndex())).getViewport().getView().requestFocus();
                }
            }
        });
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        this.setTabComponentAt(n, new CloseTabButton(string));
    }

    @Override
    public Component add(String string, Component component) {
        Component component2 = super.add(string, component);
        this.setTitleAt(this.getTabCount() - 1, string);
        return component2;
    }

    public String getScilabTitleAt(int n) {
        CloseTabButton closeTabButton;
        if (n != -1 && (closeTabButton = (CloseTabButton)this.getTabComponentAt(n)) != null) {
            return closeTabButton.getText();
        }
        return "";
    }

    @Override
    public String getTitleAt(int n) {
        return "";
    }

    @Override
    public void setTitleAt(int n, String string) {
        CloseTabButton closeTabButton;
        if (n != -1 && (closeTabButton = (CloseTabButton)this.getTabComponentAt(n)) != null) {
            closeTabButton.setText(string);
        }
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (!dataFlavor.equals(DATAFLAVOR)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DATAFLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DATAFLAVOR);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DATAFLAVOR)) {
            dropTargetDragEvent.acceptDrag(2);
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            if (component instanceof ScilabTabbedPane) {
                currentWhenDragged = (ScilabTabbedPane)component;
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DATAFLAVOR)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (!dropTargetDropEvent.isDataFlavorSupported(DATAFLAVOR) || dropTargetDropEvent.getSourceActions() != 2) {
            dropTargetDropEvent.rejectDrop();
        } else {
            try {
                ScilabTabbedPane scilabTabbedPane = (ScilabTabbedPane)dropTargetDropEvent.getTransferable().getTransferData(DATAFLAVOR);
                int n = this.indexAtLocation(dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y);
                if (scilabTabbedPane == this && n == scilabTabbedPane.draggedIndex) {
                    dropTargetDropEvent.rejectDrop();
                } else {
                    Component component = scilabTabbedPane.getComponentAt(scilabTabbedPane.draggedIndex);
                    String string = scilabTabbedPane.getScilabTitleAt(scilabTabbedPane.draggedIndex);
                    scilabTabbedPane.remove(component);
                    if (n == -1) {
                        n = this.getTabCount();
                    }
                    this.insertTab(string, null, component, null, n);
                    this.setSelectedIndex(n);
                    dropTargetDropEvent.acceptDrop(2);
                }
            }
            catch (IOException iOException) {
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        dragSourceDropEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        Point point = new Point(dragSourceDragEvent.getX(), dragSourceDragEvent.getY());
        JRootPane jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, currentWhenDragged);
        if (jRootPane == null) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        } else {
            SwingUtilities.convertPointFromScreen(point, jRootPane);
            Component component = SwingUtilities.getDeepestComponentAt(jRootPane, point.x, point.y);
            if (component != null && !(component instanceof JTable) && !(component instanceof ScilabTabbedPane)) {
                component = SwingUtilities.getAncestorOfClass(ScilabTabbedPane.class, component);
            }
            if (component instanceof ScilabTabbedPane) {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            } else {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (inputEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)inputEvent;
            int n = this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
            currentWhenDragged = this;
            if (n != -1) {
                this.draggedIndex = n;
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, this, this);
            }
        }
    }

    static {
        try {
            DATAFLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + ScilabTabbedPane.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    class CloseTabButton
    extends JPanel {
        private JLabel label;

        public CloseTabButton(String string) {
            super(new FlowLayout(0, 0, 0));
            this.setOpaque(false);
            this.label = new JLabel(string);
            this.add(this.label);
            this.add(new JLabel("   "));
            this.add(new CloseButton());
        }

        public void setText(String string) {
            this.label.setText(string);
        }

        public String getText() {
            return this.label.getText();
        }

        class CloseButton
        extends JButton {
            CloseButton() {
                super(CLOSEICON);
                this.setFocusable(false);
                this.setContentAreaFilled(true);
                this.setOpaque(false);
                this.setRolloverEnabled(true);
                this.setBorderPainted(false);
                this.setPreferredSize(new Dimension(18, 18));
                this.addActionListener((ActionListener)new CommonCallBack(""){

                    public void callBack() {
                        String string = CloseTabButton.this.getText().substring("Var - ".length());
                        ScilabTabbedPane.this.removeTabAt(ScilabTabbedPane.this.indexOfTabComponent(CloseTabButton.this));
                        ScilabVariableEditor.close(string);
                    }
                });
            }
        }
    }
}

