/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.rowheader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.scilab.modules.ui_data.datatable.SwingEditvarTableModel;
import org.scilab.modules.ui_data.rowheader.HeaderRenderer;
import org.scilab.modules.ui_data.utils.UiDataMessages;
import org.scilab.modules.ui_data.variableeditor.TableVariableEditor;
import org.scilab.modules.ui_data.variableeditor.actions.InsertRowAction;
import org.scilab.modules.ui_data.variableeditor.actions.RemoveRowAction;

public class RowHeader
extends JPanel
implements TableModelListener {
    private static final Insets INSETS = new Insets(1, 0, 0, 0);
    private JTable rowTable;
    private JTable table;
    private DefaultTableModel model;
    private int clickedRow;

    public RowHeader(final JTable jTable) {
        super(new BorderLayout());
        this.table = jTable;
        jTable.getModel().addTableModelListener(this);
        this.model = new DefaultTableModel(0, 1){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.rowTable = new JTable(this.model);
        this.setBorder(new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component component) {
                return INSETS;
            }

            @Override
            public Insets getBorderInsets(Component component, Insets insets) {
                return INSETS;
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(jTable.getGridColor().darker());
                graphics.drawLine(n, n2, n + n3, n2);
            }
        });
        this.rowTable.setDoubleBuffered(true);
        this.rowTable.setDragEnabled(false);
        this.rowTable.setGridColor(jTable.getGridColor().darker());
        this.rowTable.setShowVerticalLines(true);
        this.rowTable.setModel(this.model);
        this.rowTable.setRowHeight(jTable.getRowHeight());
        this.rowTable.setRowMargin(jTable.getRowMargin());
        this.rowTable.setIntercellSpacing(jTable.getIntercellSpacing());
        this.rowTable.setDefaultEditor(Object.class, null);
        this.rowTable.setCellEditor(null);
        this.rowTable.setDefaultRenderer(Object.class, new HeaderRenderer(jTable, true));
        this.rowTable.setComponentPopupMenu(this.createPopupMenu());
        this.rowTable.doLayout();
        this.add(this.rowTable);
        this.doLayout();
        this.rowTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n = RowHeader.this.rowTable.rowAtPoint(mouseEvent.getPoint());
                    ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                    int n2 = ((SwingEditvarTableModel)((TableVariableEditor)jTable).getModel()).getScilabMatrixColCount();
                    if (n2 == 0) {
                        n2 = 1;
                    }
                    if (mouseEvent.isShiftDown()) {
                        listSelectionModel.setSelectionInterval(n, RowHeader.this.clickedRow);
                        jTable.setColumnSelectionInterval(0, n2 - 1);
                    } else {
                        if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            if (jTable.isRowSelected(n)) {
                                listSelectionModel.removeSelectionInterval(n, n);
                            } else {
                                listSelectionModel.addSelectionInterval(n, n);
                                jTable.setColumnSelectionInterval(0, n2 - 1);
                            }
                        } else {
                            listSelectionModel.setSelectionInterval(n, n);
                            jTable.setColumnSelectionInterval(0, n2 - 1);
                        }
                        RowHeader.this.clickedRow = n;
                    }
                    jTable.requestFocus();
                }
            }
        });
        this.rowTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Point point = mouseEvent.getPoint();
                    int n = point.y >= ((RowHeader)RowHeader.this).rowTable.getCellRect((int)(((RowHeader)RowHeader.this).rowTable.getRowCount() - 1), (int)0, (boolean)false).y ? RowHeader.this.rowTable.getRowCount() - 1 : RowHeader.this.rowTable.rowAtPoint(point);
                    ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                    int n2 = listSelectionModel.getLeadSelectionIndex();
                    if (n2 != n) {
                        if (n == RowHeader.this.rowTable.getRowCount() - 1) {
                            ((TableVariableEditor)jTable).addTenRows();
                        }
                        jTable.scrollRectToVisible(jTable.getCellRect(n, 0, false));
                        if (mouseEvent.isShiftDown()) {
                            listSelectionModel.setSelectionInterval(RowHeader.this.clickedRow, n);
                        } else if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            if (listSelectionModel.isSelectedIndex(n)) {
                                listSelectionModel.removeSelectionInterval(n2, n);
                                listSelectionModel.addSelectionInterval(RowHeader.this.clickedRow, n);
                            } else {
                                listSelectionModel.addSelectionInterval(RowHeader.this.clickedRow, n);
                            }
                        } else {
                            listSelectionModel.setSelectionInterval(RowHeader.this.clickedRow, n);
                        }
                        int n3 = ((SwingEditvarTableModel)((TableVariableEditor)jTable).getModel()).getScilabMatrixColCount();
                        if (n3 == 0) {
                            n3 = 1;
                        }
                        jTable.setColumnSelectionInterval(0, n3 - 1);
                        jTable.requestFocus();
                    }
                }
            }
        });
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu(){

            @Override
            public void show(Component component, int n, int n2) {
                ((TableVariableEditor)RowHeader.this.table).setPopupRow(RowHeader.this.rowTable.rowAtPoint(new Point(n, n2)));
                super.show(component, n, n2);
            }
        };
        jPopupMenu.setBorderPainted(true);
        jPopupMenu.add(InsertRowAction.createMenuItem(this.table, UiDataMessages.INSERTR));
        jPopupMenu.add(RemoveRowAction.createMenuItem(this.table, UiDataMessages.REMOVER));
        return jPopupMenu;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)tableModelEvent.getSource();
        int n = defaultTableModel.getRowCount() - this.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.model.addRow(new Object[1]);
        }
    }

    public JTable getTable() {
        return this.rowTable;
    }
}

