/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.newsfeed;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.modules.ui_data.newsfeed.News;
import org.scilab.modules.ui_data.newsfeed.NewsFeedController;
import org.scilab.modules.ui_data.newsfeed.NewsFeedSettings;
import org.scilab.modules.ui_data.newsfeed.NewsMediaContent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NewsFetcher {
    private URL rssURL = null;
    private Worker worker = null;

    public void readSettings() throws Exception {
        this.rssURL = null;
        String string = NewsFeedSettings.getStringSetting("url");
        this.rssURL = new URL(string);
    }

    public URL getURL() {
        return this.rssURL;
    }

    public boolean isOK() {
        return this.rssURL != null;
    }

    public void fetchNews(NewsFeedController newsFeedController, List<News> list) throws Exception {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.worker = new Worker(newsFeedController, this.rssURL, list);
        this.worker.execute();
    }

    private static class Worker
    extends SwingWorker<Object, News> {
        private final NewsFeedController controller;
        private final URL rssURL;
        private final List<News> into;

        private Worker(NewsFeedController newsFeedController, URL uRL, List<News> list) {
            this.controller = newsFeedController;
            this.rssURL = uRL;
            this.into = list;
        }

        @Override
        protected void process(List<News> list) {
            this.into.addAll(list);
        }

        @Override
        protected void done() {
            this.controller.nextNews();
        }

        @Override
        protected Object doInBackground() throws Exception {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(this.rssURL.openStream());
            NodeList nodeList = document.getElementsByTagName("item");
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new Exception("The fetched document has no 'item' element, please check it is a RSS feed.");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Element element = (Element)nodeList.item(i);
                String string2 = Worker.getItemValue(element, "title");
                String string3 = Worker.getItemValue(element, "pubDate");
                Date date = simpleDateFormat.parse(string3);
                String string4 = Worker.getItemValue(element, "description");
                String string5 = Worker.getItemValue(element, "content:encoded");
                NewsMediaContent newsMediaContent = null;
                Node node = Worker.getItemNode(element, "media:content");
                if (node != null) {
                    string = node.getAttributes().getNamedItem("url").getNodeValue();
                    String string6 = node.getAttributes().getNamedItem("width").getNodeValue();
                    String string7 = node.getAttributes().getNamedItem("height").getNodeValue();
                    newsMediaContent = new NewsMediaContent(string, string6, string7);
                }
                string = Worker.getItemValue(element, "link");
                this.publish(new News(string2, date, string4, string5, newsMediaContent, string));
            }
            return null;
        }

        private static Node getItemNode(Element element, String string) {
            NodeList nodeList = element.getElementsByTagName(string);
            if (nodeList.getLength() > 0) {
                return nodeList.item(0);
            }
            return null;
        }

        private static String getItemValue(Element element, String string) {
            Node node = Worker.getItemNode(element, string);
            if (node != null && node.hasChildNodes()) {
                return node.getFirstChild().getNodeValue();
            }
            return null;
        }
    }
}

