/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.newsfeed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.utils.WebBrowser;
import org.scilab.modules.ui_data.newsfeed.News;
import org.scilab.modules.ui_data.newsfeed.NewsFeedController;
import org.scilab.modules.ui_data.newsfeed.NewsFeedErrorEvent;
import org.scilab.modules.ui_data.newsfeed.NewsFeedEvent;
import org.scilab.modules.ui_data.newsfeed.NewsFeedEventListener;
import org.scilab.modules.ui_data.newsfeed.NewsFeedUIMessages;
import org.scilab.modules.ui_data.newsfeed.NewsMediaContent;

public class NewsFeedWidget
extends JPanel
implements NewsFeedEventListener,
HyperlinkListener {
    private static final String NEWS_DATE_HTML_ID = "news_date";
    private static final String NEWS_CONTENT_HTML_ID = "news_content";
    private static final String NEWS_LINK_HTML_ID = "news_link";
    private static final String NEWS_MEDIA_CONTENT_HTML_ID = "news_media_content";
    private static final String NEWS_DESCRIPTION_HTML_ID = "news_description";
    private final NewsFeedController newsFeedController;
    private final JEditorPane editorPane;
    private final JScrollPane scrollPane;
    private final JPanel headerPane;
    private final JButton headerButton;

    public NewsFeedWidget(final NewsFeedController newsFeedController) {
        this.newsFeedController = newsFeedController;
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        Font font = UIManager.getFont("Label.font");
        this.editorPane.setFont(font);
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        this.editorPane.setEditorKit(hTMLEditorKit);
        Document document = hTMLEditorKit.createDefaultDocument();
        this.editorPane.setDocument(document);
        hTMLEditorKit.getStyleSheet().importStyleSheet(this.getStyleSheetURL());
        this.editorPane.addHyperlinkListener(this);
        this.headerButton = new JButton();
        this.headerPane = new JPanel(new BorderLayout());
        this.headerPane.add((Component)new JButton(new AbstractAction(null, new ImageIcon(FindIconHelper.findIcon((String)"go-previous"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                newsFeedController.previousNews();
            }
        }), "West");
        this.headerPane.add((Component)this.headerButton, "Center");
        this.headerPane.add((Component)new JButton(new AbstractAction(null, new ImageIcon(FindIconHelper.findIcon((String)"go-next"))){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                newsFeedController.nextNews();
            }
        }), "East");
        this.scrollPane = new JScrollPane(this.editorPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPane, "North");
        this.add((Component)this.scrollPane, "Center");
        this.displayError(NewsFeedUIMessages.NEWS_FEED_UNAVAILABLE_ERROR);
    }

    @Override
    public void newsFeedEventReceived(NewsFeedEvent newsFeedEvent) {
        switch (newsFeedEvent.getEventType()) {
            case 1: {
                this.displayNews(this.newsFeedController.getCurrentNews());
                break;
            }
            case 3: {
                this.displayError(((NewsFeedErrorEvent)newsFeedEvent).getErrorMessage());
            }
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        URL uRL;
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (uRL = hyperlinkEvent.getURL()) != null) {
            WebBrowser.openUrl((URL)uRL, (String)hyperlinkEvent.getDescription());
        }
    }

    private void displayNews(final News news) {
        StringBuilder stringBuilder = new StringBuilder();
        NewsMediaContent newsMediaContent = news.getMediaContent();
        if (newsMediaContent != null) {
            stringBuilder.append(this.getDivHtml(this.getImageHtml(newsMediaContent.getURL(), newsMediaContent.getWidth(), newsMediaContent.getHeight()), NEWS_MEDIA_CONTENT_HTML_ID));
        }
        if (news.getContent() != null) {
            stringBuilder.append(this.getDivHtml(news.getContent(), NEWS_CONTENT_HTML_ID));
        } else {
            stringBuilder.append(this.getDivHtml(news.getDescription(), NEWS_DESCRIPTION_HTML_ID));
        }
        if (news.getLink() != null) {
            stringBuilder.append(this.getDivHtml(this.getLinkHtml(news.getLink(), news.getLink()), NEWS_LINK_HTML_ID));
        }
        this.display(new AbstractAction(news.getTitle()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WebBrowser.openUrl((URL)new URL(news.getLink()), (String)news.getLink());
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.getLogger(NewsFeedWidget.class.getName()).log(Level.SEVERE, null, malformedURLException);
                }
            }
        }, this.getHTML(stringBuilder));
    }

    private String getImageHtml(String string, String string2, String string3) {
        return String.format("<img src='%s' border='0' width='%s', height='%s'/>", string, string2, string3);
    }

    private String getLinkHtml(String string, String string2) {
        return String.format("<a href='%s'>%s</a>", string, string2);
    }

    private String getSpanHtml(String string, String string2) {
        return String.format("<span id='%s'>%s</span>", string2, string);
    }

    private String getDivHtml(String string, String string2) {
        return String.format("<div id='%s'>%s</div>", string2, string);
    }

    private String getDivHtml(String string) {
        return String.format("<div>%s</div>", string);
    }

    private void displayError(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        this.display(new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = NewsFeedWidget.this.newsFeedController.getNewsFetcher().getURL();
                WebBrowser.openUrl((URL)uRL, (String)uRL.toString());
            }
        }, this.getHTML(stringBuilder));
    }

    private String getHTML(StringBuilder stringBuilder) {
        stringBuilder.insert(0, "<html><body>");
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    private void display(final Action action, final String string) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewsFeedWidget.this.headerButton.setAction(action);
                    NewsFeedWidget.this.headerButton.setToolTipText(action.getValue("Name").toString());
                    NewsFeedWidget.this.editorPane.setText(string);
                    NewsFeedWidget.this.editorPane.setCaretPosition(0);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private URL getStyleSheetURL() {
        File file = new File(ScilabConstants.SCIHOME + "/newsfeed.css");
        if (!file.exists()) {
            file = new File(ScilabConstants.SCI + "/modules/ui_data/etc/newsfeed.css");
        }
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }
}

