/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultEditorKit;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.ui_data.filebrowser.SwingScilabTreeTable;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public class ScilabFileSelectorFilter
extends JPanel {
    private static boolean isWindows = OS.get() == OS.WINDOWS;
    private static final int GAP = 3;
    private static final Icon VALIDATE = new ImageIcon(FindIconHelper.findIcon((String)"filter"));
    private MyJTextField textfield;
    private final SwingScilabTreeTable stt;
    private JCheckBox caseSensitive;
    private JCheckBox regexp;
    private JButton validate;

    public ScilabFileSelectorFilter(SwingScilabTreeTable swingScilabTreeTable) {
        this.stt = swingScilabTreeTable;
        this.initPanel();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(0, 0, 3, 0));
        this.setLayout(new GridBagLayout());
        this.textfield = new MyJTextField();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        this.validate = new JButton((Action)new CommonCallBack(null){

            public void callBack() {
                ScilabFileSelectorFilter.this.stt.setFilter(ScilabFileSelectorFilter.this.getPattern());
            }
        });
        this.validate.setIcon(VALIDATE);
        this.validate.setToolTipText(UiDataMessages.RUNFILTER);
        this.caseSensitive = new JCheckBox(UiDataMessages.CASESENSITIVE, !isWindows);
        this.regexp = new JCheckBox(UiDataMessages.REGEXP, false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.textfield, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.validate, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.caseSensitive, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.regexp, gridBagConstraints);
    }

    private void testPattern() {
        if (this.regexp.isSelected()) {
            if (this.getPattern() == null) {
                this.textfield.setForeground(Color.RED);
            } else {
                this.textfield.setForeground(this.textfield.defaultFg);
            }
        }
    }

    private Pattern getPattern() {
        String string = this.textfield.getText();
        if (string != null && !string.isEmpty()) {
            if (!this.regexp.isSelected()) {
                string = string.replaceAll("\\*", "\\\\E.*\\\\Q").replaceAll("\\?", "\\\\E.?\\\\Q");
                string = "\\Q" + string + "\\E";
            }
            if (!this.caseSensitive.isSelected()) {
                string = "(?i)" + string;
            }
            if (this.regexp.isSelected()) {
                string = "(?m)" + string;
            }
            try {
                return Pattern.compile(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private class MyJTextField
    extends JTextField
    implements DocumentListener,
    FocusListener {
        boolean isEmpty = true;
        Color defaultFg = this.getForeground();

        MyJTextField() {
            this.setEditable(true);
            this.setComponentPopupMenu(this.createPopup());
            this.addFocusListener(this);
            this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ENTER");
            this.getActionMap().put("ENTER", (Action)new CommonCallBack(null){

                public void callBack() {
                    ScilabFileSelectorFilter.this.stt.setFilter(ScilabFileSelectorFilter.this.getPattern());
                }
            });
            this.toggleContents();
        }

        private void toggleContents() {
            if (this.isEmpty) {
                this.setForeground(Color.LIGHT_GRAY);
                this.setText(UiDataMessages.FILEFILTER);
            }
        }

        @Override
        public String getText() {
            if (this.isEmpty) {
                return "";
            }
            return super.getText();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.getDocument().addDocumentListener(this);
            if (this.isEmpty) {
                this.setForeground(this.defaultFg);
                this.setText("");
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.getDocument().removeDocumentListener(this);
            this.isEmpty = super.getText().isEmpty();
            this.toggleContents();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.isEmpty = super.getText().isEmpty();
            ScilabFileSelectorFilter.this.testPattern();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.isEmpty = super.getText().isEmpty();
            ScilabFileSelectorFilter.this.testPattern();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private JPopupMenu createPopup() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(UiDataMessages.CUT);
            jMenuItem.addActionListener(new DefaultEditorKit.CutAction());
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(UiDataMessages.COPY);
            jMenuItem.addActionListener(new DefaultEditorKit.CopyAction());
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(UiDataMessages.PASTE);
            jMenuItem.addActionListener(new DefaultEditorKit.PasteAction());
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(UiDataMessages.CLEAR);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MyJTextField.this.setText("");
                }
            });
            jPopupMenu.add(jMenuItem);
            return jPopupMenu;
        }
    }
}

