/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.SwingWorker;
import org.scilab.modules.ui_data.filebrowser.AbstractScilabTreeTableModel;
import org.scilab.modules.ui_data.filebrowser.FileNode;
import org.scilab.modules.ui_data.filebrowser.FileUtils;
import org.scilab.modules.ui_data.filebrowser.ScilabTreeTableModel;
import org.scilab.modules.ui_data.filebrowser.SwingScilabTreeTable;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public class ScilabFileBrowserModel
extends AbstractScilabTreeTableModel
implements ScilabTreeTableModel {
    private static final String[] names = new String[]{UiDataMessages.NAME_COLUMN, UiDataMessages.SIZE_COLUMN, UiDataMessages.TYPE_COLUMN, UiDataMessages.LASTMODIF_COLUMN};
    private static final Class[] types = new Class[]{ScilabTreeTableModel.class, FileSize.class, String.class, Date.class};
    private static final FileSize MINUSONE = new FileSize(-1);
    private int order = 1;
    private String baseDir = "";

    public void setBaseDir(final String string, final SwingScilabTreeTable swingScilabTreeTable) {
        this.baseDir = string;
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                File file = new File(string);
                ScilabFileBrowserModel.this.setRoot(new FileNode(file, -1));
                File file2 = file.getParentFile();
                ScilabFileBrowserModel.this.parent = file2 != null ? new ParentNode(file2) : null;
                return null;
            }

            @Override
            protected void done() {
                if (!this.isCancelled()) {
                    swingScilabTreeTable.reload(ScilabFileBrowserModel.this);
                    swingScilabTreeTable.setDirRefresher(null, null);
                }
            }
        };
        swingScilabTreeTable.setDirRefresher(swingWorker, this);
        swingWorker.execute();
    }

    @Override
    public void setRoot(Object object) {
        super.setRoot(object);
        ((FileNode)object).getChildrenCount();
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setFilter(Pattern pattern) {
        ((FileNode)this.root).setFilter(pattern);
    }

    protected File getFile(Object object) {
        FileNode fileNode = (FileNode)object;
        return fileNode.getFile();
    }

    protected Object[] getChildren(Object object) {
        FileNode fileNode = (FileNode)object;
        return fileNode.getChildren();
    }

    @Override
    public int getChildCount(Object object) {
        int n = ((FileNode)object).getChildrenCount();
        if (this.parent == null || object != this.getRoot()) {
            return n;
        }
        return n + 1;
    }

    @Override
    public Object getChild(Object object, int n) {
        Object object2 = object == this.getRoot() ? (this.parent == null ? this.getChildren(object)[n] : (n == 0 ? this.parent : this.getChildren(object)[n - 1])) : this.getChildren(object)[n];
        return object2;
    }

    @Override
    public boolean isLeaf(Object object) {
        return object != this.getRoot() && ((FileNode)object).isLeaf();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int n) {
        return names[n];
    }

    @Override
    public Class getColumnClass(int n) {
        return types[n];
    }

    @Override
    public Object getValueAt(Object object, int n) {
        File file = this.getFile(object);
        try {
            switch (n) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return file.isFile() ? new FileSize((int)file.length()) : MINUSONE;
                }
                case 2: {
                    if (file.isFile()) {
                        String string = FileUtils.getFileExtension(file);
                        if (string.isEmpty()) {
                            return UiDataMessages.FILE;
                        }
                        return String.format(UiDataMessages.FILETYPE, FileUtils.getFileExtension(file));
                    }
                    return UiDataMessages.DIRECTORY;
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static class FileSize {
        int size;

        FileSize(int n) {
            this.size = n;
        }

        public String toString() {
            if (this.size < 0) {
                return "";
            }
            if (this.size >= 0 && this.size < 1000) {
                return this.size + " B";
            }
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            if (this.size >= 1000 && this.size < 1000000) {
                return decimalFormat.format((float)this.size / 1000.0f).toString() + " KB";
            }
            if (this.size >= 1000000 && this.size < 1000000000) {
                return decimalFormat.format((float)this.size / 1000000.0f).toString() + " MB";
            }
            return decimalFormat.format((float)this.size / 1.0E9f).toString() + " GB";
        }
    }

    public class ParentNode
    extends FileNode {
        public ParentNode(File file) {
            super(file, -1);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public String toString() {
            return "..";
        }
    }
}

