/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.scilab.modules.commons.gui.FindIconHelper;

public final class FileUtils {
    private static final Icon SCILABICON = new ImageIcon(FindIconHelper.findIcon((String)"scilab"));
    private static final Icon PDFICON = new ImageIcon(FindIconHelper.findIcon((String)"application-pdf"));
    private static final Icon BINARYICON = new ImageIcon(FindIconHelper.findIcon((String)"binary"));
    private static final Icon IMAGEICON = new ImageIcon(FindIconHelper.findIcon((String)"image-x-generic"));
    private static final Icon TEXTICON = new ImageIcon(FindIconHelper.findIcon((String)"text-x-generic"));
    private static final Icon HTMLICON = new ImageIcon(FindIconHelper.findIcon((String)"text-html"));
    private static final Icon XMLICON = new ImageIcon(FindIconHelper.findIcon((String)"text-xml"));
    private static final Icon CSVICON = new ImageIcon(FindIconHelper.findIcon((String)"text-csv"));
    private static final Icon DIRICON = new ImageIcon(FindIconHelper.findIcon((String)"folder"));
    private static final Icon OPENDIRICON = new ImageIcon(FindIconHelper.findIcon((String)"folder-open"));
    private static final Icon READONLYICON = new ImageIcon(FindIconHelper.findIcon((String)"emblem-readonly"));
    private static final Icon CLOSEDUSERHOMEICON = new ImageIcon(FindIconHelper.findIcon((String)"user-home"));
    private static final Icon OPENUSERHOMEICON = new ImageIcon(FindIconHelper.findIcon((String)"user-home-open"));
    private static final Icon UPICON = new ImageIcon(FindIconHelper.findIcon((String)"dynamic-blue-up"));
    private static final Icon SCIICON = new ImageIcon(FindIconHelper.findIcon((String)"scilab-folder"));
    private static final Icon OPENSCIICON = new ImageIcon(FindIconHelper.findIcon((String)"scilab-folder-open"));
    private static final Icon MATICON = new ImageIcon(FindIconHelper.findIcon((String)"application-mat"));
    private static final int CHARTOREAD = 128;
    private static final Map<String, Icon> extToIcon = new HashMap<String, Icon>();

    public static String getFileExtension(File file) {
        String string;
        int n;
        if (file.isFile() && (n = (string = file.getName()).lastIndexOf(".")) != -1) {
            return string.substring(n + 1, string.length());
        }
        return "";
    }

    public static boolean isBinaryFile(File file) {
        if (file.isFile() && file.canRead()) {
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                char[] cArray = new char[128];
                int n2 = bufferedReader.read(cArray, 0, 128);
                bufferedReader.close();
                if (n2 != -1) {
                    for (n = 0; n < n2 && cArray[n] != '\u0000'; ++n) {
                    }
                }
                return n2 != -1 && n != n2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public static Icon getUpDirIcon() {
        return UPICON;
    }

    public static Icon getSCIIcon() {
        return SCIICON;
    }

    public static Icon getOpenSCIIcon() {
        return OPENSCIICON;
    }

    public static Icon getOpenDirIcon() {
        return OPENDIRICON;
    }

    public static Icon getClosedDirIcon() {
        return DIRICON;
    }

    public static Icon getClosedUserHomeIcon() {
        return CLOSEDUSERHOMEICON;
    }

    public static Icon getOpenUserHomeIcon() {
        return OPENUSERHOMEICON;
    }

    public static Icon getIconForFile(File file) {
        if (file.isDirectory()) {
            return DIRICON;
        }
        if (file.canRead() && !file.canWrite()) {
            return READONLYICON;
        }
        String string = FileUtils.getFileExtension(file).toLowerCase();
        Icon icon = extToIcon.get(string);
        if (icon != null) {
            return icon;
        }
        if (file.isFile() && FileUtils.isBinaryFile(file)) {
            return BINARYICON;
        }
        return TEXTICON;
    }

    static {
        extToIcon.put("sce", SCILABICON);
        extToIcon.put("sci", SCILABICON);
        extToIcon.put("scg", SCILABICON);
        extToIcon.put("cos", SCILABICON);
        extToIcon.put("cosf", SCILABICON);
        extToIcon.put("xcos", SCILABICON);
        extToIcon.put("zcos", SCILABICON);
        extToIcon.put("bin", SCILABICON);
        extToIcon.put("sod", SCILABICON);
        extToIcon.put("dem", SCILABICON);
        extToIcon.put("graph", SCILABICON);
        extToIcon.put("sav", SCILABICON);
        extToIcon.put("tst", SCILABICON);
        extToIcon.put("pdf", PDFICON);
        extToIcon.put("png", IMAGEICON);
        extToIcon.put("gif", IMAGEICON);
        extToIcon.put("jpg", IMAGEICON);
        extToIcon.put("jpeg", IMAGEICON);
        extToIcon.put("html", HTMLICON);
        extToIcon.put("htm", HTMLICON);
        extToIcon.put("xml", XMLICON);
        extToIcon.put("csv", CSVICON);
        extToIcon.put("mat", MATICON);
    }
}

