/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.io.File;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.SortOrder;
import org.scilab.modules.commons.CommonFileUtils;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.ui_data.filebrowser.FileComparators;
import org.scilab.modules.ui_data.filebrowser.FileUtils;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public class FileNode {
    public static final int NAMEORDER = 1;
    public static final int SIZEORDER = 2;
    public static final int DATEORDER = 3;
    public static final int TYPEORDER = 4;
    private static final File userHomeDir = new File(ScilabConstants.USERHOME);
    private static final File SCIDIR = new File(System.getenv("SCI"));
    private static Comparator<FileNode> comparator = FileComparators.ASCENDING_ALPHA;
    protected File file;
    protected Icon icon;
    protected FileNode[] children;
    protected long lastModified;
    protected boolean isFile;
    protected boolean canRead;
    protected boolean canWrite;
    protected boolean isEmpty;
    protected boolean userHome;
    protected boolean sci;
    protected long length;
    protected String name;
    protected String extension;
    private int order = 1;
    private Pattern pat;
    private int position;

    public FileNode(File file, int n) {
        this(file, file.getName(), file.canRead(), file.isFile());
        this.position = n;
    }

    public FileNode(File file, String string, boolean bl, boolean bl2) {
        this.file = file;
        this.name = string;
        this.isFile = bl2;
        this.canRead = bl;
        this.canWrite = file.canWrite();
        this.lastModified = file.lastModified();
        this.userHome = file.equals(userHomeDir);
        if (bl2) {
            this.length = file.length();
        }
        this.extension = FileUtils.getFileExtension(file);
        this.sci = file.equals(SCIDIR);
        this.isEmpty = bl2 || CommonFileUtils.isEmptyDirectory((String)file.getAbsolutePath()) == 1;
    }

    public int getPosition() {
        return this.position;
    }

    public void setFilter(Pattern pattern) {
        this.pat = pattern;
        this.resetChildren();
    }

    public void setOrder(int n) {
        this.order = n;
        switch (n) {
            case 1: {
                comparator = FileComparators.ASCENDING_ALPHA;
                break;
            }
            case -1: {
                comparator = FileComparators.DESCENDING_ALPHA;
                break;
            }
            case 4: {
                comparator = FileComparators.ASCENDING_TYPE;
                break;
            }
            case -4: {
                comparator = FileComparators.DESCENDING_TYPE;
                break;
            }
            case 3: {
                comparator = FileComparators.ASCENDING_DATE;
                break;
            }
            case -3: {
                comparator = FileComparators.DESCENDING_DATE;
                break;
            }
            case 2: {
                comparator = FileComparators.ASCENDING_SIZE;
                break;
            }
            case -2: {
                comparator = FileComparators.DESCENDING_SIZE;
            }
        }
    }

    public void setOrder(int n, boolean bl) {
        int n2 = bl ? 1 : -1;
        this.setOrder(n2 * n);
    }

    public SortOrder getOrder() {
        return this.order > 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING;
    }

    public void toggleSortOrder(String string) {
        if (string.equals(UiDataMessages.NAME_COLUMN)) {
            if (Math.abs(this.order) == 1) {
                this.setOrder(-this.order);
            } else {
                this.setOrder(1);
            }
        } else if (string.equals(UiDataMessages.TYPE_COLUMN)) {
            if (Math.abs(this.order) == 4) {
                this.setOrder(-this.order);
            } else {
                this.setOrder(4);
            }
        } else if (string.equals(UiDataMessages.SIZE_COLUMN)) {
            if (Math.abs(this.order) == 2) {
                this.setOrder(-this.order);
            } else {
                this.setOrder(2);
            }
        } else if (string.equals(UiDataMessages.LASTMODIF_COLUMN)) {
            if (Math.abs(this.order) == 3) {
                this.setOrder(-this.order);
            } else {
                this.setOrder(3);
            }
        }
    }

    protected void orderFiles() {
        if (this.children != null) {
            TreeSet<FileNode> treeSet = new TreeSet<FileNode>(comparator);
            for (FileNode fileNode : this.children) {
                treeSet.add(fileNode);
            }
            this.children = treeSet.toArray(this.children);
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].position = i;
            }
        }
    }

    public String toString() {
        String string = this.file.getName();
        if (string.isEmpty()) {
            string = this.file.toString();
        }
        return string;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isUserHome() {
        return this.userHome;
    }

    public boolean isSCI() {
        return this.sci;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = FileUtils.getIconForFile(this.file);
        }
        return this.icon;
    }

    public boolean isLeaf() {
        return this.isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildrenCount() {
        if (this.children == null && !this.isEmpty) {
            File file = this.file;
            synchronized (file) {
                if (this.children == null) {
                    this.children = this.listFiles();
                }
            }
        }
        if (this.children != null) {
            return this.children.length;
        }
        return 0;
    }

    protected Object[] getChildren() {
        if (this.children == null && !this.isEmpty) {
            this.children = this.listFiles();
        }
        return this.children;
    }

    public FileNode[] listFiles() {
        String[] stringArray = this.file.list();
        if (stringArray != null) {
            TreeSet<FileNode> treeSet = new TreeSet<FileNode>(comparator);
            for (String string : stringArray) {
                boolean bl;
                boolean bl2;
                File file = new File(this.file, string);
                if (this.pat != null && !this.pat.matcher(string).matches() || file.isHidden() || !(bl2 = file.canRead()) || !(bl = file.isFile()) && !file.isDirectory()) continue;
                treeSet.add(new FileNode(file, string, bl2, bl));
            }
            Object[] objectArray = new FileNode[treeSet.size()];
            objectArray = (FileNode[])treeSet.toArray(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                ((FileNode)objectArray[i]).position = i;
            }
            return objectArray;
        }
        return null;
    }

    public void resetChildren() {
        this.children = null;
    }

    public boolean equals(Object object) {
        return object instanceof FileNode && ((FileNode)object).file.equals(this.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

