/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.xmlloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.scilab.modules.commons.CommonFileUtils;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graphic_objects.ScilabNativeView;
import org.scilab.modules.graphic_objects.builder.Builder;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicModel.GraphicModel;
import org.scilab.modules.graphic_objects.xmlloader.GOBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlLoader
extends DefaultHandler {
    private String filename = "";
    private Locator locator;
    private Integer uid = 0;
    private String namespace = null;
    private boolean isWaitingModelName = true;
    private String myURI = "";
    private boolean isFirst = false;
    private static HashMap<String, Integer> nameToGO = new HashMap();
    private static HashMap<String, HashMap<String, Map.Entry<Integer, Map<String, String>>>> models = new HashMap();
    private Stack<Integer> stackGO = new Stack();
    private String currentPath = "";
    private GraphicController controller = GraphicController.getController();

    public XmlLoader(String string) {
        this.filename = string;
    }

    public int parse() throws SAXException {
        int n = 0;
        if (this.filename != null && !this.filename.equals("")) {
            n = this.parse(this.filename);
        }
        Set<String> set = models.keySet();
        for (String string : set) {
            HashMap<String, Map.Entry<Integer, Map<String, String>>> hashMap = models.get(string);
            Set<String> set2 = hashMap.keySet();
            for (String string2 : set2) {
                this.deleteObject(hashMap.get(string2).getKey());
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int parse(String string) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        this.filename = string;
        File file = new File(string);
        if (file.exists()) {
            if (file.isAbsolute()) {
                object3 = file.getAbsolutePath();
                this.currentPath = ((String)object3).substring(0, ((String)object3).lastIndexOf(File.separator));
                FindIconHelper.addThemePath((String)this.currentPath);
            } else {
                object3 = CommonFileUtils.getCWD();
                object2 = "";
                object = string.lastIndexOf(File.separator);
                if ((Integer)object != -1) {
                    object2 = string.substring(0, (Integer)object);
                }
                this.currentPath = (String)object3 + File.separator + (String)object2;
                FindIconHelper.addThemePath((String)this.currentPath);
                FindIconHelper.addThemePath((String)object3);
                file = new File((String)object3, string);
            }
        } else {
            if (file.isAbsolute()) {
                return 1;
            }
            file = new File(this.currentPath + File.separator + string);
            if (!file.exists()) {
                return 1;
            }
        }
        object3 = null;
        try {
            object3 = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return 1;
        }
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setValidating(false);
            ((SAXParserFactory)object).setNamespaceAware(true);
            ((SAXParserFactory)object).setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            object2 = ((SAXParserFactory)object).newSAXParser();
        }
        catch (Exception exception) {
            try {
                ((FileInputStream)object3).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return 1;
            }
            throw new SAXException(String.format("Cannot initialize the XML parser: %s", exception.getMessage()));
        }
        try {
            ((SAXParser)object2).parse((InputStream)object3, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            if (this.locator != null) {
                throw new SAXException(String.format("Parse error at line %d: %s", this.locator.getLineNumber(), sAXException.getMessage()));
            }
            throw new SAXException(String.format("Parse error: %s", sAXException.getMessage()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                ((FileInputStream)object3).close();
            }
            catch (IOException iOException) {}
        }
        return this.uid;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Integer n;
        if (string2.equals("modele")) {
            this.namespace = null;
            this.isWaitingModelName = false;
        }
        if (this.stackGO.size() != 0 && (n = this.stackGO.pop()) != null) {
            if (this.stackGO.size() > 0) {
                Integer n2 = this.stackGO.peek();
                this.controller.setGraphicObjectRelationship(n2, n);
            } else {
                this.uid = n;
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.isFirst = true;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("interface")) {
            if (this.isFirst) {
                this.myURI = attributes.getValue("xmlns");
                this.isFirst = false;
            }
        } else if (string2.equals("include")) {
            String string4 = attributes.getValue("path");
            this.parse(string4);
        } else if (string2.equals("modele")) {
            this.namespace = attributes.getValue("namespace");
            this.isWaitingModelName = true;
        } else {
            Object object;
            Object object2;
            Integer n = this.getTypeFromName(string2);
            Integer n2 = 0;
            if (n != null) {
                if (n == 8) {
                    n2 = GOBuilder.figureBuilder(this.controller, attributes);
                } else if (n == 1) {
                    n2 = GOBuilder.axesBuilder(this.controller, attributes);
                } else if (n == 20) {
                    object2 = 0;
                    if (!this.stackGO.isEmpty()) {
                        object2 = this.stackGO.peek();
                    }
                    n2 = GOBuilder.uimenuBuilder(this.controller, attributes, (Integer)object2);
                } else {
                    object2 = 0;
                    if (!this.stackGO.isEmpty()) {
                        object2 = this.stackGO.peek();
                    }
                    n2 = GOBuilder.uicontrolBuilder(this.controller, n, attributes, (Integer)object2);
                }
            } else if (!this.myURI.equals(string) && (object2 = models.get(string)) != null) {
                object = ((HashMap)object2).get(string2);
                n2 = object.getKey();
                Integer n3 = this.cloneObject(n2);
                GOBuilder.uicontrolUpdater(this.controller, n3, attributes, this.stackGO.peek(), (Map)object.getValue());
                n2 = n3;
            }
            if (this.namespace != null && this.isWaitingModelName && (object2 = attributes.getValue("modele-name")) != null) {
                if (models.get(this.namespace) == null) {
                    models.put(this.namespace, new HashMap());
                }
                object = new HashMap();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    object.put(attributes.getLocalName(i), attributes.getValue(i));
                }
                models.get(this.namespace).put((String)object2, new AbstractMap.SimpleEntry<Integer, Object>(n2, object));
            }
            this.stackGO.add(n2);
        }
    }

    Integer cloneObject(Integer n) {
        Integer n2 = this.controller.cloneObject(n);
        Integer[] integerArray = (Integer[])this.controller.getProperty(n, 22);
        for (int i = integerArray.length - 1; i >= 0; --i) {
            Integer n3;
            Integer n4 = (Integer)this.controller.getProperty(integerArray[i], 29);
            if (n4 == 1) {
                n3 = this.controller.cloneObject(GraphicModel.getAxesModel().getIdentifier());
                Builder.createLabel(n3, 116);
                Builder.createLabel(n3, 132);
                Builder.createLabel(n3, 148);
                Builder.createLabel(n3, 161);
                this.controller.setGraphicObjectRelationship(n2, n3);
                this.controller.setProperty(n2, 35, n3);
                this.controller.setProperty(n3, 100, this.controller.getProperty(integerArray[i], 100));
                ScilabNativeView.ScilabNativeView__setCurrentSubWin(n3);
                ScilabNativeView.ScilabNativeView__setCurrentObject(n3);
                continue;
            }
            if (n4 == 379) {
                n3 = this.cloneObject(integerArray[i]);
                this.controller.setGraphicObjectRelationship(n2, n3);
                Integer n5 = (Integer)this.controller.getProperty(n, 29);
                if (n5 == 19) {
                    this.controller.setProperty(n2, 379, n3);
                    continue;
                }
                Integer n6 = (Integer)this.controller.getProperty(n, 389);
                if (n6 == integerArray[i]) {
                    this.controller.setProperty(n2, 389, n3);
                    continue;
                }
                n6 = (Integer)this.controller.getProperty(n, 385);
                if (n6 == integerArray[i]) {
                    this.controller.setProperty(n2, 385, n3);
                    continue;
                }
                n6 = (Integer)this.controller.getProperty(n, 385);
                if (n6 != integerArray[i]) continue;
                this.controller.setProperty(n2, 385, n3);
                continue;
            }
            n3 = this.cloneObject(integerArray[i]);
            this.controller.setGraphicObjectRelationship(n2, n3);
        }
        return n2;
    }

    private void deleteObject(Integer n) {
        this.controller.removeRelationShipAndDelete(n);
    }

    private Integer getTypeFromName(String string) {
        return nameToGO.get(string);
    }

    static {
        nameToGO.put("UIScilabWindow", 8);
        nameToGO.put("UIPanel", 277);
        nameToGO.put("UIFrame", 277);
        nameToGO.put("UILayer", 287);
        nameToGO.put("UIButton", 282);
        nameToGO.put("UILabel", 286);
        nameToGO.put("UILaTeXLabel", -1);
        nameToGO.put("UICheckbox", 274);
        nameToGO.put("UITextfield", 275);
        nameToGO.put("UISplashScreen", 279);
        nameToGO.put("UIList", 280);
        nameToGO.put("UIComboBox", 281);
        nameToGO.put("UIComboColor", 281);
        nameToGO.put("UIRadio", 283);
        nameToGO.put("UISlider", 284);
        nameToGO.put("UITab", 365);
        nameToGO.put("UIScilabPlot", 1);
        nameToGO.put("UINumberSpinner", 276);
        nameToGO.put("UITextarea", -2);
        nameToGO.put("UIMenu", 20);
        nameToGO.put("UIMenuItem", 20);
    }
}

