/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.xmlloader;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.modules.commons.CommonFileUtils;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graphic_objects.ScilabNativeView;
import org.scilab.modules.graphic_objects.builder.Builder;
import org.scilab.modules.graphic_objects.console.Console;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicModel.GraphicModel;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.uicontrol.Uicontrol;
import org.scilab.modules.graphic_objects.uicontrol.frame.border.FrameBorderType;
import org.scilab.modules.graphic_objects.utils.LayoutType;
import org.scilab.modules.graphic_objects.xmlloader.Pair;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDomLoader {
    private static final int __NODE_SCILABGUI__ = -10;
    private static final int __NODE_OUT__ = -20;
    private static final int __NODE_IN__ = -30;
    private static final int __NODE_TITLE__ = -40;
    private static final int __NODE_STRING__ = -50;
    private static final int __NODE_STRINGITEM__ = -50;
    private static final int __NODE_COLORMAP__ = -60;
    private static final int __NODE_COLORMAPITEM__ = -70;
    private static HashMap<String, Integer> nameToGO = new HashMap();
    private static HashMap<String, Pair<Integer, ModelType>> figPropToGO = new HashMap();
    private static HashMap<String, Pair<Integer, ModelType>> UiPropToGO = new HashMap();
    private static HashMap<String, Pair<Integer, ModelType>> MenuPropToGO = new HashMap();
    private static HashMap<String, Pair<Integer, ModelType>> BorderPropToGO = new HashMap();
    private String filename = "";
    private Integer figure = 0;
    private Boolean figVisible = true;

    public XMLDomLoader(String string) {
        this.filename = string;
    }

    public int parse() {
        return this.parse(this.filename);
    }

    public int parse(String string) {
        try {
            Object object;
            Object object2;
            Object object3;
            this.filename = string;
            File file = new File(string);
            String string2 = "";
            if (file.exists()) {
                if (file.isAbsolute()) {
                    object3 = file.getAbsolutePath();
                    string2 = ((String)object3).substring(0, ((String)object3).lastIndexOf(File.separator));
                    FindIconHelper.addThemePath((String)string2);
                } else {
                    object3 = CommonFileUtils.getCWD();
                    object2 = "";
                    object = string.lastIndexOf(File.separator);
                    if ((Integer)object != -1) {
                        object2 = string.substring(0, (Integer)object);
                    }
                    string2 = (String)object3 + File.separator + (String)object2;
                    FindIconHelper.addThemePath((String)string2);
                    FindIconHelper.addThemePath((String)object3);
                    file = new File((String)object3, string);
                }
            } else {
                if (file.isAbsolute()) {
                    return 1;
                }
                object3 = CommonFileUtils.getCWD();
                object2 = "";
                object = string.lastIndexOf(File.separator);
                if ((Integer)object != -1) {
                    object2 = string.substring(0, (Integer)object);
                }
                if (!(file = new File((string2 = (String)object3 + File.separator + (String)object2) + File.separator + string)).exists()) {
                    return 1;
                }
            }
            object3 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object3).setNamespaceAware(true);
            ((DocumentBuilderFactory)object3).setXIncludeAware(true);
            object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            object = ((DocumentBuilder)object2).parse(file);
            object.getDocumentElement().normalize();
            if (object.hasChildNodes()) {
                this.parseNode(0, object.getChildNodes());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GraphicController.getController().setProperty(this.figure, 27, this.figVisible);
        return this.figure;
    }

    private void parseNode(Integer n, NodeList nodeList) {
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node node = nodeList.item(i);
            Integer n2 = 0;
            if (node.getNodeType() != 1) continue;
            int n3 = nameToGO.get(node.getNodeName());
            switch (n3) {
                case 8: {
                    this.figure = n2 = this.createFigure(node);
                    break;
                }
                case 274: 
                case 275: 
                case 276: 
                case 277: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 284: 
                case 285: 
                case 286: 
                case 287: 
                case 365: {
                    n2 = this.createUiControl(n3, n, node);
                    break;
                }
                case 1: {
                    n2 = this.createAxes(n, node);
                    break;
                }
                case 379: {
                    n2 = this.createBorder(node);
                    GraphicController.getController().setProperty(n, 379, n2);
                    break;
                }
                case -50: {
                    n2 = 0;
                    this.createString(n, node);
                    break;
                }
                case -60: {
                    n2 = 0;
                    this.createColorMap(n, node);
                    break;
                }
                case -10: {
                    Node node2 = node.getAttributes().getNamedItem("version");
                    double d = Double.parseDouble(node2.getNodeValue());
                    if (d > 1.0) {
                        // empty if block
                    }
                    Integer n4 = Console.getConsole().getIdentifier();
                    this.setBooleanAttribute(n4, 326, node.getAttributes(), "usedeprecatedskin");
                    break;
                }
                case 21: {
                    break;
                }
                case 20: {
                    n2 = this.createUiMenu(n, node);
                    break;
                }
            }
            if (n != 0 && n2 != 0) {
                GraphicController.getController().setGraphicObjectRelationship(n, n2);
            }
            if (!node.hasChildNodes()) continue;
            this.parseNode(n2, node.getChildNodes());
        }
    }

    private void createColorMap(Integer n, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("size");
        if (node2 == null) {
            return;
        }
        Integer n2 = Integer.parseInt(node2.getNodeValue());
        if (node.hasChildNodes()) {
            Double[] doubleArray = new Double[n2 * 3];
            NodeList nodeList = node.getChildNodes();
            int n3 = 0;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1) continue;
                namedNodeMap = node3.getAttributes();
                Node node4 = namedNodeMap.getNamedItem("color");
                if (node4 == null) {
                    doubleArray[n3] = 0.0;
                    doubleArray[n3 + n2.intValue()] = 0.0;
                    doubleArray[n3 + 2 * n2.intValue()] = 0.0;
                } else {
                    try {
                        Color color = Color.decode(node4.getNodeValue());
                        doubleArray[n3] = (double)color.getRed() / 255.0;
                        doubleArray[n3 + n2.intValue()] = (double)color.getGreen() / 255.0;
                        doubleArray[n3 + 2 * n2.intValue()] = (double)color.getBlue() / 255.0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        doubleArray[n3] = 0.0;
                        doubleArray[n3 + n2.intValue()] = 0.0;
                        doubleArray[n3 + 2 * n2.intValue()] = 0.0;
                    }
                }
                ++n3;
            }
            GraphicController.getController().setProperty(n, 90, doubleArray);
        }
    }

    private void createString(Integer n, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("property");
        if (node2 == null) {
            return;
        }
        String string = node2.getNodeValue();
        Node node3 = namedNodeMap.getNamedItem("rows");
        if (node3 == null) {
            return;
        }
        Integer n2 = Integer.parseInt(node3.getNodeValue());
        Node node4 = namedNodeMap.getNamedItem("cols");
        if (node4 == null) {
            return;
        }
        Integer n3 = Integer.parseInt(node4.getNodeValue());
        if (node.hasChildNodes()) {
            String[] stringArray = new String[n2 * n3];
            NodeList nodeList = node.getChildNodes();
            int n4 = 0;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node5 = nodeList.item(i);
                if (node5.getNodeType() != 1) continue;
                namedNodeMap = node5.getAttributes();
                Node node6 = namedNodeMap.getNamedItem("value");
                stringArray[n4++] = node6 == null ? "" : node6.getNodeValue();
            }
            Integer n5 = UiPropToGO.get(string).getFirst();
            if (n5 == 302 && n3 > 1) {
                GraphicController.getController().setProperty(n, 305, n3);
            }
            GraphicController.getController().setProperty(n, n5, stringArray);
        }
    }

    private Integer createAxes(Integer n, Node node) {
        GraphicController graphicController = GraphicController.getController();
        Integer n2 = Builder.createSubWin(n);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("tag");
        if (node2 != null) {
            graphicController.setProperty(n2, 100, node2.getNodeValue());
            namedNodeMap.removeNamedItem("tag");
        }
        return n2;
    }

    private Integer createBorder(Node node) {
        Object object;
        Object object2;
        GraphicController graphicController = GraphicController.getController();
        Integer n = graphicController.askObject(GraphicObject.getTypeFromName(379));
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("style");
        if (node2 != null) {
            Integer n2 = FrameBorderType.stringToEnum(node2.getNodeValue()).ordinal();
            graphicController.setProperty(n, 391, n2);
            namedNodeMap.removeNamedItem("style");
        }
        graphicController.setProperty(n, 28, true);
        block10: for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node3 = namedNodeMap.item(i);
            object2 = BorderPropToGO.get(node3.getNodeName());
            object = ((Pair)object2).getSecond();
            switch (object) {
                case BOOLEAN: {
                    graphicController.setProperty(n, (Integer)((Pair)object2).getFirst(), this.getAttributeAsBoolean(node3.getNodeValue()));
                    continue block10;
                }
                case BOOLEAN_ARRAY: {
                    graphicController.setProperty(n, (Integer)((Pair)object2).getFirst(), this.getAttributeAsBooleanArray(node3.getNodeValue()));
                    continue block10;
                }
                case DOUBLE: {
                    graphicController.setProperty(n, (Integer)((Pair)object2).getFirst(), this.getAttributeAsDouble(node3.getNodeValue()));
                    continue block10;
                }
                case DOUBLE_ARRAY: {
                    graphicController.setProperty(n, (Integer)((Pair)object2).getFirst(), this.getAttributeAsDoubleArray(node3.getNodeValue()));
                    continue block10;
                }
                case INTEGER: {
                    graphicController.setProperty(n, (Integer)((Pair)object2).getFirst(), this.getAttributeAsInteger(node3.getNodeValue()));
                    continue block10;
                }
                case INTEGER_ARRAY: {
                    graphicController.setProperty(n, (Integer)((Pair)object2).getFirst(), this.getAttributeAsIntegerArray(node3.getNodeValue()));
                    continue block10;
                }
                case STRING: {
                    graphicController.setProperty(n, (Integer)((Pair)object2).getFirst(), this.getAttributeAsString(node3.getNodeValue()));
                    continue block10;
                }
                case STRING_ARRAY: {
                    graphicController.setProperty(n, (Integer)((Pair)object2).getFirst(), this.getAttributeAsStringArray(node3.getNodeValue()));
                    continue block10;
                }
                default: {
                    System.out.println("missing type");
                }
            }
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object2 = nodeList.item(i);
                if (object2.getNodeType() != 1) continue;
                object = this.createBorder((Node)object2);
                String string = object2.getNodeName();
                if (string.equals("title")) {
                    GraphicController.getController().setProperty(n, 389, object);
                    GraphicController.getController().setGraphicObjectRelationship(n, (Integer)object);
                    continue;
                }
                if (string.equals("out")) {
                    GraphicController.getController().setProperty(n, 385, object);
                    GraphicController.getController().setGraphicObjectRelationship(n, (Integer)object);
                    continue;
                }
                if (!string.equals("in")) continue;
                GraphicController.getController().setProperty(n, 383, object);
                GraphicController.getController().setGraphicObjectRelationship(n, (Integer)object);
            }
        }
        return n;
    }

    private Integer createFigure(Node node) {
        GraphicController graphicController = GraphicController.getController();
        Boolean bl = true;
        Integer n = 1;
        Integer n2 = 1;
        Boolean bl2 = true;
        Integer[] integerArray = null;
        Integer[] integerArray2 = null;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("dockable");
        if (node2 != null) {
            bl = this.getAttributeAsBoolean(node2.getNodeValue());
            namedNodeMap.removeNamedItem("dockable");
        }
        if ((node2 = namedNodeMap.getNamedItem("menubar")) != null) {
            n = Figure.BarType.stringToEnum(this.getAttributeAsString(node2.getNodeValue())).ordinal();
            namedNodeMap.removeNamedItem("menubar");
        }
        if ((node2 = namedNodeMap.getNamedItem("toolbar")) != null) {
            n2 = Figure.BarType.stringToEnum(this.getAttributeAsString(node2.getNodeValue())).ordinal();
            namedNodeMap.removeNamedItem("toolbar");
        }
        if ((node2 = namedNodeMap.getNamedItem("default_axes")) != null) {
            bl2 = this.getAttributeAsBoolean(node2.getNodeValue());
            namedNodeMap.removeNamedItem("default_axes");
        }
        if ((node2 = namedNodeMap.getNamedItem("visible")) != null) {
            this.figVisible = this.getAttributeAsBoolean(node2.getNodeValue());
            namedNodeMap.removeNamedItem("visible");
        }
        if ((node2 = namedNodeMap.getNamedItem("axes_size")) != null) {
            integerArray2 = this.getAttributeAsIntegerArray(node2.getNodeValue());
            namedNodeMap.removeNamedItem("axes_size");
        }
        node2 = namedNodeMap.getNamedItem("figure_size");
        if (integerArray2 == null && node2 != null) {
            integerArray = this.getAttributeAsIntegerArray(node2.getNodeValue());
            namedNodeMap.removeNamedItem("figure_size");
        }
        if ((node2 = namedNodeMap.getNamedItem("menubar_visible")) != null) {
            bl3 = this.getAttributeAsBoolean(node2.getNodeValue());
            namedNodeMap.removeNamedItem("menubar_visible");
        }
        if ((node2 = namedNodeMap.getNamedItem("toolbar_visible")) != null) {
            bl4 = this.getAttributeAsBoolean(node2.getNodeValue());
            namedNodeMap.removeNamedItem("toolbar_visible");
        }
        if ((node2 = namedNodeMap.getNamedItem("infobar_visible")) != null) {
            bl5 = this.getAttributeAsBoolean(node2.getNodeValue());
            namedNodeMap.removeNamedItem("infobar_visible");
        }
        Integer n3 = Builder.createFigure(bl, n, n2, bl2, false);
        int n4 = ScilabNativeView.ScilabNativeView__getValidDefaultFigureId();
        graphicController.setProperty(n3, 88, n4);
        block13: for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node3 = namedNodeMap.item(i);
            Pair<Integer, ModelType> pair = figPropToGO.get(node3.getNodeName());
            ModelType modelType = pair.getSecond();
            switch (modelType) {
                case BOOLEAN: {
                    graphicController.setProperty(n3, pair.getFirst(), this.getAttributeAsBoolean(node3.getNodeValue()));
                    continue block13;
                }
                case BOOLEAN_ARRAY: {
                    graphicController.setProperty(n3, pair.getFirst(), this.getAttributeAsBooleanArray(node3.getNodeValue()));
                    continue block13;
                }
                case DOUBLE: {
                    graphicController.setProperty(n3, pair.getFirst(), this.getAttributeAsDouble(node3.getNodeValue()));
                    continue block13;
                }
                case DOUBLE_ARRAY: {
                    graphicController.setProperty(n3, pair.getFirst(), this.getAttributeAsDoubleArray(node3.getNodeValue()));
                    continue block13;
                }
                case INTEGER: {
                    graphicController.setProperty(n3, pair.getFirst(), this.getAttributeAsInteger(node3.getNodeValue()));
                    continue block13;
                }
                case INTEGER_ARRAY: {
                    graphicController.setProperty(n3, pair.getFirst(), this.getAttributeAsIntegerArray(node3.getNodeValue()));
                    continue block13;
                }
                case STRING: {
                    graphicController.setProperty(n3, pair.getFirst(), this.getAttributeAsString(node3.getNodeValue()));
                    continue block13;
                }
                case STRING_ARRAY: {
                    graphicController.setProperty(n3, pair.getFirst(), this.getAttributeAsStringArray(node3.getNodeValue()));
                    continue block13;
                }
                case ROTATIONTYPE: {
                    graphicController.setProperty(n3, pair.getFirst(), Figure.RotationType.stringToEnum(this.getAttributeAsString(node3.getNodeValue())).ordinal());
                    continue block13;
                }
                case BARTYPE: {
                    graphicController.setProperty(n3, pair.getFirst(), Figure.BarType.stringToEnum(this.getAttributeAsString(node3.getNodeValue())).ordinal());
                    continue block13;
                }
                case LAYOUTTYPE: {
                    graphicController.setProperty(n3, pair.getFirst(), LayoutType.stringToEnum(this.getAttributeAsString(node3.getNodeValue())).ordinal());
                    continue block13;
                }
                default: {
                    System.out.println("missing type");
                }
            }
        }
        if (integerArray2 != null) {
            graphicController.setProperty(n3, 85, integerArray2);
        } else if (integerArray != null) {
            graphicController.setProperty(n3, 81, integerArray);
        } else {
            graphicController.setProperty(n3, 85, GraphicModel.getFigureModel().getAxesSize());
        }
        graphicController.setProperty(n3, 360, !bl3);
        graphicController.setProperty(n3, 358, !bl4);
        graphicController.setProperty(n3, 361, !bl5);
        graphicController.setProperty(n3, 360, bl3);
        graphicController.setProperty(n3, 358, bl4);
        graphicController.setProperty(n3, 361, bl5);
        return n3;
    }

    private Integer createUiControl(Integer n, Integer n2, Node node) {
        Object object;
        GraphicController graphicController = GraphicController.getController();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (n == 277 && (object = namedNodeMap.getNamedItem("scrollable")) != null && object.getNodeValue().equals("on")) {
            n = 278;
        }
        object = GraphicController.getController().askObject(GraphicObject.getTypeFromName(n));
        graphicController.setProperty((Integer)object, 27, true);
        block14: for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            Pair<Integer, ModelType> pair = UiPropToGO.get(node2.getNodeName());
            if (pair == null) continue;
            ModelType modelType = pair.getSecond();
            switch (modelType) {
                case BOOLEAN: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), this.getAttributeAsBoolean(node2.getNodeValue()));
                    continue block14;
                }
                case BOOLEAN_ARRAY: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), this.getAttributeAsBooleanArray(node2.getNodeValue()));
                    continue block14;
                }
                case DOUBLE: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), this.getAttributeAsDouble(node2.getNodeValue()));
                    continue block14;
                }
                case DOUBLE_ARRAY: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), this.getAttributeAsDoubleArray(node2.getNodeValue()));
                    continue block14;
                }
                case INTEGER: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), this.getAttributeAsInteger(node2.getNodeValue()));
                    continue block14;
                }
                case INTEGER_ARRAY: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), this.getAttributeAsIntegerArray(node2.getNodeValue()));
                    continue block14;
                }
                case STRING: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), this.getAttributeAsString(node2.getNodeValue()));
                    continue block14;
                }
                case STRING_ARRAY: {
                    continue block14;
                }
                case LAYOUTTYPE: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), LayoutType.stringToEnum(this.getAttributeAsString(node2.getNodeValue())).ordinal());
                    continue block14;
                }
                case FILLTYPE: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), Uicontrol.FillType.stringToEnum(this.getAttributeAsString(node2.getNodeValue())).ordinal());
                    continue block14;
                }
                case ANCHORTYPE: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), Uicontrol.AnchorType.stringToEnum(this.getAttributeAsString(node2.getNodeValue())).ordinal());
                    continue block14;
                }
                case POSITIONTYPE: {
                    graphicController.setProperty((Integer)object, pair.getFirst(), Uicontrol.BorderLayoutType.stringToEnum(this.getAttributeAsString(node2.getNodeValue())).ordinal());
                    continue block14;
                }
                default: {
                    System.out.println("missing type");
                }
            }
        }
        return object;
    }

    private Integer createUiMenu(Integer n, Node node) {
        GraphicController graphicController = GraphicController.getController();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Integer n2 = GraphicController.getController().askObject(GraphicObject.getTypeFromName(20));
        graphicController.setProperty(n2, 27, true);
        block10: for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            Pair<Integer, ModelType> pair = MenuPropToGO.get(node2.getNodeName());
            ModelType modelType = pair.getSecond();
            switch (modelType) {
                case BOOLEAN: {
                    graphicController.setProperty(n2, pair.getFirst(), this.getAttributeAsBoolean(node2.getNodeValue()));
                    continue block10;
                }
                case BOOLEAN_ARRAY: {
                    graphicController.setProperty(n2, pair.getFirst(), this.getAttributeAsBooleanArray(node2.getNodeValue()));
                    continue block10;
                }
                case DOUBLE: {
                    graphicController.setProperty(n2, pair.getFirst(), this.getAttributeAsDouble(node2.getNodeValue()));
                    continue block10;
                }
                case DOUBLE_ARRAY: {
                    graphicController.setProperty(n2, pair.getFirst(), this.getAttributeAsDoubleArray(node2.getNodeValue()));
                    continue block10;
                }
                case INTEGER: {
                    graphicController.setProperty(n2, pair.getFirst(), this.getAttributeAsInteger(node2.getNodeValue()));
                    continue block10;
                }
                case INTEGER_ARRAY: {
                    graphicController.setProperty(n2, pair.getFirst(), this.getAttributeAsIntegerArray(node2.getNodeValue()));
                    continue block10;
                }
                case STRING: {
                    graphicController.setProperty(n2, pair.getFirst(), this.getAttributeAsString(node2.getNodeValue()));
                    continue block10;
                }
                case STRING_ARRAY: {
                    graphicController.setProperty(n2, pair.getFirst(), this.getAttributeAsStringArray(node2.getNodeValue()));
                    continue block10;
                }
                default: {
                    System.out.println("missing type");
                }
            }
        }
        return n2;
    }

    private Boolean getAttributeAsBoolean(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("on")) {
            return true;
        }
        if (string.equals("off")) {
            return false;
        }
        return false;
    }

    private void setBooleanAttribute(Integer n, int n2, NamedNodeMap namedNodeMap, String string) {
        Boolean bl;
        Node node = namedNodeMap.getNamedItem(string);
        if (node != null && (bl = this.getAttributeAsBoolean(node.getNodeValue())) != null) {
            GraphicController.getController().setProperty(n, n2, bl);
        }
    }

    private Double getAttributeAsDouble(String string) {
        if (string == null) {
            return null;
        }
        return Double.parseDouble(string);
    }

    private Integer getAttributeAsInteger(String string) {
        if (string == null) {
            return null;
        }
        return Integer.parseInt(string);
    }

    private String getAttributeAsString(String string) {
        return string;
    }

    private Boolean[] getAttributeAsBooleanArray(String string) {
        if (string == null) {
            return new Boolean[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Boolean[] booleanArray = new Boolean[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("on")) {
                booleanArray[n++] = true;
                continue;
            }
            booleanArray[n++] = false;
        }
        return booleanArray;
    }

    private Double[] getAttributeAsDoubleArray(String string) {
        if (string == null) {
            return new Double[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Double[] doubleArray = new Double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            doubleArray[n++] = Double.parseDouble(string2);
        }
        return doubleArray;
    }

    private Integer[] getAttributeAsIntegerArray(String string) {
        if (string == null) {
            return new Integer[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Integer[] integerArray = new Integer[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            integerArray[n++] = Integer.parseInt(string2);
        }
        return integerArray;
    }

    private String[] getAttributeAsStringArray(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    static {
        nameToGO.put("figure", 8);
        nameToGO.put("frame", 277);
        nameToGO.put("layer", 287);
        nameToGO.put("pushbutton", 282);
        nameToGO.put("text", 286);
        nameToGO.put("checkbox", 274);
        nameToGO.put("textfield", 275);
        nameToGO.put("spinner", 276);
        nameToGO.put("edit", 275);
        nameToGO.put("image", 279);
        nameToGO.put("picture", 279);
        nameToGO.put("listbox", 280);
        nameToGO.put("popupmenu", 281);
        nameToGO.put("radiobutton", 283);
        nameToGO.put("slider", 284);
        nameToGO.put("table", 285);
        nameToGO.put("tab", 365);
        nameToGO.put("menu", 20);
        nameToGO.put("contextmenu", 21);
        nameToGO.put("axes", 1);
        nameToGO.put("border", 379);
        nameToGO.put("out", -20);
        nameToGO.put("in", -30);
        nameToGO.put("title", -40);
        nameToGO.put("string", -50);
        nameToGO.put("stringitem", -50);
        nameToGO.put("colormap", -60);
        nameToGO.put("colormapitem", -70);
        nameToGO.put("scilabgui", -10);
        figPropToGO.put("figure_position", new Pair<Integer, ModelType>(80, ModelType.INTEGER_ARRAY));
        figPropToGO.put("figure_size", new Pair<Integer, ModelType>(81, ModelType.INTEGER_ARRAY));
        figPropToGO.put("axes_size", new Pair<Integer, ModelType>(85, ModelType.INTEGER_ARRAY));
        figPropToGO.put("auto_resize", new Pair<Integer, ModelType>(83, ModelType.BOOLEAN));
        figPropToGO.put("view_port", new Pair<Integer, ModelType>(84, ModelType.INTEGER_ARRAY));
        figPropToGO.put("figure_name", new Pair<Integer, ModelType>(87, ModelType.STRING));
        figPropToGO.put("figure_id", new Pair<Integer, ModelType>(88, ModelType.INTEGER));
        figPropToGO.put("info_message", new Pair<Integer, ModelType>(89, ModelType.STRING));
        figPropToGO.put("pixel_drawing_mode", new Pair<Integer, ModelType>(93, ModelType.STRING));
        figPropToGO.put("anti_aliasing", new Pair<Integer, ModelType>(94, ModelType.BOOLEAN));
        figPropToGO.put("immediate_drawing", new Pair<Integer, ModelType>(95, ModelType.BOOLEAN));
        figPropToGO.put("background", new Pair<Integer, ModelType>(96, ModelType.INTEGER));
        figPropToGO.put("visible", new Pair<Integer, ModelType>(27, ModelType.BOOLEAN));
        figPropToGO.put("rotation_style", new Pair<Integer, ModelType>(101, ModelType.ROTATIONTYPE));
        figPropToGO.put("event_handler", new Pair<Integer, ModelType>(98, ModelType.STRING));
        figPropToGO.put("event_handler_enable", new Pair<Integer, ModelType>(99, ModelType.BOOLEAN));
        figPropToGO.put("resizefcn", new Pair<Integer, ModelType>(102, ModelType.STRING));
        figPropToGO.put("closerequestfcn", new Pair<Integer, ModelType>(103, ModelType.STRING));
        figPropToGO.put("resize", new Pair<Integer, ModelType>(356, ModelType.BOOLEAN));
        figPropToGO.put("toolbar", new Pair<Integer, ModelType>(357, ModelType.BARTYPE));
        figPropToGO.put("toolbar_visible", new Pair<Integer, ModelType>(358, ModelType.BOOLEAN));
        figPropToGO.put("menubar", new Pair<Integer, ModelType>(359, ModelType.BARTYPE));
        figPropToGO.put("menubar_visible", new Pair<Integer, ModelType>(360, ModelType.BOOLEAN));
        figPropToGO.put("infobar_visible", new Pair<Integer, ModelType>(361, ModelType.BOOLEAN));
        figPropToGO.put("dockable", new Pair<Integer, ModelType>(362, ModelType.BOOLEAN));
        figPropToGO.put("layout", new Pair<Integer, ModelType>(363, ModelType.LAYOUTTYPE));
        figPropToGO.put("default_axes", new Pair<Integer, ModelType>(104, ModelType.BOOLEAN));
        figPropToGO.put("icon", new Pair<Integer, ModelType>(322, ModelType.STRING));
        figPropToGO.put("tag", new Pair<Integer, ModelType>(100, ModelType.STRING));
        figPropToGO.put("grid_opt_grid", new Pair<Integer, ModelType>(376, ModelType.INTEGER_ARRAY));
        figPropToGO.put("grid_opt_padding", new Pair<Integer, ModelType>(377, ModelType.INTEGER_ARRAY));
        figPropToGO.put("border_opt_padding", new Pair<Integer, ModelType>(378, ModelType.INTEGER_ARRAY));
        UiPropToGO.put("position", new Pair<Integer, ModelType>(80, ModelType.INTEGER));
        UiPropToGO.put("backgroundcolor", new Pair<Integer, ModelType>(288, ModelType.DOUBLE_ARRAY));
        UiPropToGO.put("enable", new Pair<Integer, ModelType>(289, ModelType.BOOLEAN));
        UiPropToGO.put("fontangle", new Pair<Integer, ModelType>(290, ModelType.STRING));
        UiPropToGO.put("fontname", new Pair<Integer, ModelType>(291, ModelType.STRING));
        UiPropToGO.put("fontsize", new Pair<Integer, ModelType>(292, ModelType.DOUBLE));
        UiPropToGO.put("fontunits", new Pair<Integer, ModelType>(293, ModelType.STRING));
        UiPropToGO.put("fontweight", new Pair<Integer, ModelType>(294, ModelType.STRING));
        UiPropToGO.put("foregroundcolor", new Pair<Integer, ModelType>(295, ModelType.DOUBLE_ARRAY));
        UiPropToGO.put("horizontalalignment", new Pair<Integer, ModelType>(296, ModelType.STRING));
        UiPropToGO.put("listboxtop", new Pair<Integer, ModelType>(297, ModelType.INTEGER_ARRAY));
        UiPropToGO.put("max", new Pair<Integer, ModelType>(299, ModelType.DOUBLE));
        UiPropToGO.put("min", new Pair<Integer, ModelType>(300, ModelType.DOUBLE));
        UiPropToGO.put("position", new Pair<Integer, ModelType>(80, ModelType.DOUBLE_ARRAY));
        UiPropToGO.put("relief", new Pair<Integer, ModelType>(301, ModelType.STRING));
        UiPropToGO.put("sliderstep", new Pair<Integer, ModelType>(308, ModelType.DOUBLE_ARRAY));
        UiPropToGO.put("units", new Pair<Integer, ModelType>(309, ModelType.STRING));
        UiPropToGO.put("value", new Pair<Integer, ModelType>(310, ModelType.DOUBLE_ARRAY));
        UiPropToGO.put("verticalalignment", new Pair<Integer, ModelType>(313, ModelType.STRING));
        UiPropToGO.put("string", new Pair<Integer, ModelType>(302, ModelType.STRING_ARRAY));
        UiPropToGO.put("tooltipstring", new Pair<Integer, ModelType>(306, ModelType.STRING_ARRAY));
        UiPropToGO.put("visible", new Pair<Integer, ModelType>(27, ModelType.BOOLEAN));
        UiPropToGO.put("layout", new Pair<Integer, ModelType>(363, ModelType.LAYOUTTYPE));
        UiPropToGO.put("callback", new Pair<Integer, ModelType>(36, ModelType.STRING));
        UiPropToGO.put("callback_type", new Pair<Integer, ModelType>(37, ModelType.INTEGER));
        UiPropToGO.put("gridbaggrid", new Pair<Integer, ModelType>(366, ModelType.INTEGER_ARRAY));
        UiPropToGO.put("gridbagweight", new Pair<Integer, ModelType>(367, ModelType.DOUBLE_ARRAY));
        UiPropToGO.put("gridbagfill", new Pair<Integer, ModelType>(368, ModelType.FILLTYPE));
        UiPropToGO.put("gridbaganchor", new Pair<Integer, ModelType>(369, ModelType.ANCHORTYPE));
        UiPropToGO.put("gridbagpadding", new Pair<Integer, ModelType>(370, ModelType.INTEGER_ARRAY));
        UiPropToGO.put("gridbagpreferredsize", new Pair<Integer, ModelType>(371, ModelType.INTEGER_ARRAY));
        UiPropToGO.put("borderposition", new Pair<Integer, ModelType>(374, ModelType.POSITIONTYPE));
        UiPropToGO.put("borderpreferredsize", new Pair<Integer, ModelType>(375, ModelType.INTEGER_ARRAY));
        UiPropToGO.put("margins", new Pair<Integer, ModelType>(181, ModelType.DOUBLE_ARRAY));
        UiPropToGO.put("groupname", new Pair<Integer, ModelType>(392, ModelType.STRING));
        UiPropToGO.put("icon", new Pair<Integer, ModelType>(322, ModelType.STRING));
        UiPropToGO.put("scrollable", new Pair<Integer, ModelType>(396, ModelType.BOOLEAN));
        UiPropToGO.put("gridoptgrid", new Pair<Integer, ModelType>(376, ModelType.INTEGER_ARRAY));
        UiPropToGO.put("gridoptpadding", new Pair<Integer, ModelType>(377, ModelType.INTEGER_ARRAY));
        UiPropToGO.put("borderoptpadding", new Pair<Integer, ModelType>(378, ModelType.INTEGER_ARRAY));
        UiPropToGO.put("tag", new Pair<Integer, ModelType>(100, ModelType.STRING));
        BorderPropToGO.put("style", new Pair<Integer, ModelType>(391, ModelType.INTEGER));
        BorderPropToGO.put("type", new Pair<Integer, ModelType>(395, ModelType.INTEGER));
        BorderPropToGO.put("position", new Pair<Integer, ModelType>(80, ModelType.DOUBLE_ARRAY));
        BorderPropToGO.put("hlout", new Pair<Integer, ModelType>(382, ModelType.STRING));
        BorderPropToGO.put("hlin", new Pair<Integer, ModelType>(381, ModelType.STRING));
        BorderPropToGO.put("shadowout", new Pair<Integer, ModelType>(388, ModelType.STRING));
        BorderPropToGO.put("shadowin", new Pair<Integer, ModelType>(387, ModelType.STRING));
        BorderPropToGO.put("titleposition", new Pair<Integer, ModelType>(390, ModelType.DOUBLE_ARRAY));
        BorderPropToGO.put("hl", new Pair<Integer, ModelType>(382, ModelType.STRING));
        BorderPropToGO.put("shadow", new Pair<Integer, ModelType>(388, ModelType.STRING));
        BorderPropToGO.put("color", new Pair<Integer, ModelType>(380, ModelType.STRING));
        BorderPropToGO.put("thickness", new Pair<Integer, ModelType>(191, ModelType.INTEGER));
        BorderPropToGO.put("rounded", new Pair<Integer, ModelType>(386, ModelType.BOOLEAN));
        BorderPropToGO.put("title", new Pair<Integer, ModelType>(161, ModelType.STRING));
        BorderPropToGO.put("justification", new Pair<Integer, ModelType>(384, ModelType.INTEGER));
        BorderPropToGO.put("fontangle", new Pair<Integer, ModelType>(290, ModelType.STRING));
        BorderPropToGO.put("fontname", new Pair<Integer, ModelType>(291, ModelType.STRING));
        BorderPropToGO.put("fontsize", new Pair<Integer, ModelType>(292, ModelType.INTEGER));
        BorderPropToGO.put("fontweight", new Pair<Integer, ModelType>(294, ModelType.STRING));
        MenuPropToGO.put("enable", new Pair<Integer, ModelType>(289, ModelType.BOOLEAN));
        MenuPropToGO.put("foreground", new Pair<Integer, ModelType>(295, ModelType.DOUBLE_ARRAY));
        MenuPropToGO.put("label", new Pair<Integer, ModelType>(318, ModelType.STRING));
        MenuPropToGO.put("hidden", new Pair<Integer, ModelType>(28, ModelType.BOOLEAN));
        MenuPropToGO.put("visible", new Pair<Integer, ModelType>(27, ModelType.BOOLEAN));
        MenuPropToGO.put("callback", new Pair<Integer, ModelType>(36, ModelType.STRING));
        MenuPropToGO.put("callback_type", new Pair<Integer, ModelType>(37, ModelType.INTEGER));
        MenuPropToGO.put("checked", new Pair<Integer, ModelType>(317, ModelType.BOOLEAN));
        MenuPropToGO.put("icon", new Pair<Integer, ModelType>(322, ModelType.STRING));
        MenuPropToGO.put("tag", new Pair<Integer, ModelType>(100, ModelType.STRING));
    }

    private static enum ModelType {
        BOOLEAN,
        BOOLEAN_ARRAY,
        DOUBLE,
        DOUBLE_ARRAY,
        STRING,
        STRING_ARRAY,
        INTEGER,
        INTEGER_ARRAY,
        ROTATIONTYPE,
        BARTYPE,
        LAYOUTTYPE,
        FILLTYPE,
        ANCHORTYPE,
        POSITIONTYPE;

    }
}

