/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.vectfield;

import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.utils.Utils;
import org.scilab.modules.graphic_objects.vectfield.Arrow;
import org.scilab.modules.graphic_objects.vectfield.VectField;

public class Champ
extends VectField {
    private int[] dimensions = new int[2];
    private boolean colored = false;

    public Champ() {
        this.dimensions[0] = 0;
        this.dimensions[1] = 0;
    }

    @Override
    public void accept(Visitor visitor) throws ObjectRemovedException {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 268: {
                return ChampProperty.DIMENSIONS;
            }
            case 256: {
                return Arrow.ArrowProperty.BASEX;
            }
            case 257: {
                return Arrow.ArrowProperty.BASEY;
            }
            case 265: {
                return ChampProperty.COLORED;
            }
            case 269: {
                return ChampProperty.BOUNDINGBOX;
            }
            case 270: {
                return ChampProperty.MAXLENGTH;
            }
            case 271: {
                return ChampProperty.MAXUSABLELENGTH;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == ChampProperty.DIMENSIONS) {
            return this.getDimensions();
        }
        if (object == Arrow.ArrowProperty.BASEX) {
            return this.getBaseX();
        }
        if (object == Arrow.ArrowProperty.BASEY) {
            return this.getBaseY();
        }
        if (object == ChampProperty.COLORED) {
            return this.getColored();
        }
        if (object == ChampProperty.BOUNDINGBOX) {
            return this.getBoundingBox();
        }
        if (object == ChampProperty.MAXLENGTH) {
            return this.getMaxLength();
        }
        if (object == ChampProperty.MAXUSABLELENGTH) {
            return this.getMaxUsableLength();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == ChampProperty.DIMENSIONS) {
            this.setDimensions((Integer[])object2);
        } else if (object == Arrow.ArrowProperty.BASEX) {
            this.setBaseX((Double[])object2);
        } else if (object == Arrow.ArrowProperty.BASEY) {
            this.setBaseY((Double[])object2);
        } else if (object == ChampProperty.COLORED) {
            this.setColored((Boolean)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getDimensions() {
        Integer[] integerArray = new Integer[]{this.dimensions[0], this.dimensions[1]};
        return integerArray;
    }

    public GraphicObject.UpdateStatus setDimensions(Integer[] integerArray) {
        this.dimensions[0] = integerArray[0];
        this.dimensions[1] = integerArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Double[] getBaseX() {
        Double[] doubleArray = new Double[this.dimensions[0]];
        for (int i = 0; i < this.dimensions[0]; ++i) {
            Double[] doubleArray2 = this.getArrow(i, 0).getBase();
            doubleArray[i] = doubleArray2[0];
        }
        return doubleArray;
    }

    @Override
    public GraphicObject.UpdateStatus setBaseX(Double[] doubleArray) {
        for (int i = 0; i < this.dimensions[1]; ++i) {
            for (int j = 0; j < this.dimensions[0]; ++j) {
                Double[] doubleArray2 = this.getArrow(j, i).getBase();
                doubleArray2[0] = doubleArray[j];
                this.getArrow(j, i).setBase(doubleArray2);
            }
        }
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Double[] getBaseY() {
        Double[] doubleArray = new Double[this.dimensions[1]];
        for (int i = 0; i < this.dimensions[1]; ++i) {
            Double[] doubleArray2 = this.getArrow(0, i).getBase();
            doubleArray[i] = doubleArray2[1];
        }
        return doubleArray;
    }

    @Override
    public GraphicObject.UpdateStatus setBaseY(Double[] doubleArray) {
        for (int i = 0; i < this.dimensions[1]; ++i) {
            for (int j = 0; j < this.dimensions[0]; ++j) {
                Double[] doubleArray2 = this.getArrow(j, i).getBase();
                doubleArray2[1] = doubleArray[i];
                this.getArrow(j, i).setBase(doubleArray2);
            }
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getColored() {
        return this.colored;
    }

    public GraphicObject.UpdateStatus setColored(Boolean bl) {
        this.colored = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getBoundingBox() {
        Double[] doubleArray = this.computeBoundingBox();
        return doubleArray;
    }

    public Double getMaxLength() {
        Double d = this.computeMaxLength();
        return d;
    }

    public Double getMaxUsableLength() {
        Double d = this.computeMaxUsableLength();
        return d;
    }

    @Override
    public Integer getType() {
        return 4;
    }

    private Double[] computeBoundingBox() {
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        Double[] doubleArray = new Double[6];
        if (!this.colored) {
            d = this.computeMaxLength();
        }
        d2 = this.computeMaxUsableLength();
        dArray4[0] = ((Arrow)this.arrows.get(0)).getBase()[0];
        dArray4[1] = ((Arrow)this.arrows.get(0)).getBase()[1];
        dArray4[2] = ((Arrow)this.arrows.get(0)).getBase()[2];
        dArray5[0] = ((Arrow)this.arrows.get(0)).getDirection()[0];
        dArray5[1] = ((Arrow)this.arrows.get(0)).getDirection()[1];
        dArray5[2] = ((Arrow)this.arrows.get(0)).getDirection()[2];
        if (this.colored && (d = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2])) <= Double.MIN_VALUE) {
            d = 1.0;
        }
        dArray5[0] = dArray4[0] + dArray5[0] * d2 / d;
        dArray5[1] = dArray4[1] + dArray5[1] * d2 / d;
        dArray5[2] = dArray4[2] + dArray5[2] * d2 / d;
        this.computeMin(dArray, dArray4, dArray5);
        this.computeMax(dArray2, dArray4, dArray5);
        for (int i = 1; i < this.arrows.size(); ++i) {
            dArray4[0] = ((Arrow)this.arrows.get(i)).getBase()[0];
            dArray4[1] = ((Arrow)this.arrows.get(i)).getBase()[1];
            dArray4[2] = ((Arrow)this.arrows.get(i)).getBase()[2];
            dArray5[0] = ((Arrow)this.arrows.get(i)).getDirection()[0];
            dArray5[1] = ((Arrow)this.arrows.get(i)).getDirection()[1];
            dArray5[2] = ((Arrow)this.arrows.get(i)).getDirection()[2];
            if (this.colored && (d = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2])) <= Double.MIN_VALUE) {
                d = 1.0;
            }
            dArray5[0] = dArray4[0] + dArray5[0] * d2 / d;
            dArray5[1] = dArray4[1] + dArray5[1] * d2 / d;
            dArray5[2] = dArray4[2] + dArray5[2] * d2 / d;
            this.computeMin(dArray3, dArray, dArray5);
            this.computeMin(dArray, dArray3, dArray4);
            this.computeMax(dArray3, dArray2, dArray5);
            this.computeMax(dArray2, dArray3, dArray4);
        }
        doubleArray[0] = dArray[0];
        doubleArray[1] = dArray2[0];
        doubleArray[2] = dArray[1];
        doubleArray[3] = dArray2[1];
        doubleArray[4] = dArray[2];
        doubleArray[5] = dArray2[2];
        return doubleArray;
    }

    private double computeMaxUsableLength() {
        double d;
        double d2;
        int n;
        double d3;
        if (this.dimensions[0] < 2) {
            d3 = 1.0;
        } else {
            d3 = Double.MAX_VALUE;
            for (n = 0; n < this.dimensions[0] - 1; ++n) {
                d2 = Math.abs(this.getArrow(n + 1, 0).getBase()[0] - this.getArrow(n, 0).getBase()[0]);
                if (!Utils.isValid(d2) || !(d2 < d3)) continue;
                d3 = d2;
            }
        }
        if (this.dimensions[1] < 2) {
            d = 1.0;
        } else {
            d = Double.MAX_VALUE;
            for (n = 0; n < this.dimensions[1] - 1; ++n) {
                d2 = Math.abs(this.getArrow(0, n + 1).getBase()[1] - this.getArrow(0, n).getBase()[1]);
                if (!Utils.isValid(d2) || !(d2 < d)) continue;
                d = d2;
            }
        }
        return Math.min(d3, d);
    }

    private double computeMaxLength() {
        double[] dArray = new double[]{((Arrow)this.arrows.get(0)).getDirection()[0], ((Arrow)this.arrows.get(0)).getDirection()[1], ((Arrow)this.arrows.get(0)).getDirection()[2]};
        double d = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
        for (int i = 1; i < this.arrows.size(); ++i) {
            dArray[0] = ((Arrow)this.arrows.get(i)).getDirection()[0];
            dArray[1] = ((Arrow)this.arrows.get(i)).getDirection()[1];
            dArray[2] = ((Arrow)this.arrows.get(i)).getDirection()[2];
            double d2 = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
            if (!(d2 > d)) continue;
            d = d2;
        }
        d = Math.sqrt(d);
        return d;
    }

    private void computeMin(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = Math.min(dArray2[0], dArray3[0]);
        dArray[1] = Math.min(dArray2[1], dArray3[1]);
        dArray[2] = Math.min(dArray2[2], dArray3[2]);
    }

    private void computeMax(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = Math.max(dArray2[0], dArray3[0]);
        dArray[1] = Math.max(dArray2[1], dArray3[1]);
        dArray[2] = Math.max(dArray2[2], dArray3[2]);
    }

    private Arrow getArrow(int n, int n2) {
        return (Arrow)this.arrows.get(this.dimensions[0] * n2 + n);
    }

    private static enum ChampProperty {
        DIMENSIONS,
        COLORED,
        BOUNDINGBOX,
        MAXLENGTH,
        MAXUSABLELENGTH;

    }
}

