/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.utils.MenuBarConfiguration;
import org.scilab.modules.localization.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class MenuBarBuilder {
    private static final String MAINMENUBARXMLFILE = ScilabConstants.SCI + "/modules/gui/etc/main_menubar.xml";
    private static final String GRAPHICSMENUBARXMLFILE = ScilabConstants.SCI + "/modules/gui/etc/graphics_menubar.xml";
    private static final String FILE_NOT_FOUND = "Could not find file: ";
    private static final String CANNOT_CREATE_MENUBAR = "Cannot create MenuBar.\nCheck if file *_menubar.xml is available and valid.";
    private static boolean isParentValid = true;

    private MenuBarBuilder() {
        throw new UnsupportedOperationException();
    }

    public static Object buildMenuBar(Class[] classArray, String string) throws SAXException, IOException, ParserConfigurationException {
        MenuBarConfigurationHandler menuBarConfigurationHandler = new MenuBarConfigurationHandler(string);
        return Proxy.newProxyInstance(menuBarConfigurationHandler.getClass().getClassLoader(), classArray, (InvocationHandler)menuBarConfigurationHandler);
    }

    public static void buildConsoleMenuBar(Integer n) {
        MenuBarBuilder.buildMenuBar(MAINMENUBARXMLFILE, n);
    }

    public static void buildFigureMenuBar(Integer n) {
        boolean bl = false;
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("org.scilab.modules.gui.SwingView");
            Method method = clazz.getMethod("isHeadless", new Class[0]);
            bl = (Boolean)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        if (!bl) {
            isParentValid = false;
            MenuBarBuilder.buildMenuBar(GRAPHICSMENUBARXMLFILE, n);
        }
    }

    public static void buildMenuBar(String string, Integer n) {
        try {
            MenuBarConfiguration menuBarConfiguration = (MenuBarConfiguration)MenuBarBuilder.buildMenuBar(new Class[]{MenuBarConfiguration.class}, string);
            menuBarConfiguration.addMenus(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(CANNOT_CREATE_MENUBAR);
            System.err.println(FILE_NOT_FOUND + illegalArgumentException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            System.err.println(CANNOT_CREATE_MENUBAR);
            System.err.println(FILE_NOT_FOUND + sAXException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.err.println(CANNOT_CREATE_MENUBAR);
            System.err.println(FILE_NOT_FOUND + iOException.getLocalizedMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(CANNOT_CREATE_MENUBAR);
            System.err.println(FILE_NOT_FOUND + parserConfigurationException.getLocalizedMessage());
        }
    }

    private static class MenuBarConfigurationHandler
    implements InvocationHandler {
        protected static final String LABEL = "label";
        protected static final String MENU = "menu";
        protected static final String MNEMONIC = "mnemonic";
        protected static final String SUBMENU = "submenu";
        protected static final String SEPARATOR = "separator";
        protected static final String ENABLED = "enabled";
        protected static final String ACCELERATOR = "accelerator";
        protected static final String CALLBACK = "callback";
        protected static final String TYPE = "type";
        protected static final String INSTRUCTION = "instruction";
        protected static final String TRUE = "true";
        protected static final String ICON = "icon";
        protected static final String MACOSX = "macosx";
        private Document dom;
        private Collection<String> internalMethodNames;

        public MenuBarConfigurationHandler(String string) throws SAXException, IOException, ParserConfigurationException {
            Method[] methodArray;
            if (!new File(string).exists()) {
                throw new IOException();
            }
            this.internalMethodNames = new TreeSet<String>();
            for (Method method : methodArray = this.getClass().getMethods()) {
                this.internalMethodNames.add(method.getName());
            }
            this.dom = ScilabDocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(string));
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (this.internalMethodNames.contains(method.getName())) {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, objectArray);
            }
            return null;
        }

        public void addMenus(Integer n) {
            for (Integer object : (Integer[])GraphicController.getController().getProperty(n, 22)) {
                if (!GraphicController.getController().getProperty(object, 29).equals(20)) continue;
                GraphicController.getController().removeRelationShipAndDelete(object);
            }
            NodeList nodeList = this.dom.getElementsByTagName(MENU);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Integer n2 = null;
                n2 = isParentValid ? GraphicController.getController().askObject(GraphicObject.Type.UIMENU) : GraphicController.getController().askObject(GraphicObject.Type.UIMENUMODEL);
                GraphicController.getController().setProperty(n2, 28, true);
                String string2 = Messages.gettext((String)nodeList.item(i).getAttributes().getNamedItem(LABEL).getNodeValue());
                GraphicController.getController().setProperty(n2, 318, string2);
                if (nodeList.item(i).getAttributes().getNamedItem(MNEMONIC) != null) {
                    string = nodeList.item(i).getAttributes().getNamedItem(MNEMONIC).getNodeValue();
                    GraphicController.getController().setProperty(n2, 319, string);
                }
                if (nodeList.item(i).getAttributes().getNamedItem(ICON) != null) {
                    string = nodeList.item(i).getNodeValue();
                    GraphicController.getController().setProperty(n2, 322, string);
                }
                if (nodeList.item(i).getAttributes().getNamedItem(ENABLED) != null) {
                    boolean bl = nodeList.item(i).getAttributes().getNamedItem(ENABLED).getNodeValue().equals(TRUE);
                    GraphicController.getController().setProperty(n2, 289, bl);
                }
                GraphicController.getController().setGraphicObjectRelationship(n, n2);
                this.addSubMenus(n2, i);
            }
        }

        public void addSubMenus(Integer n, int n2) {
            boolean bl = false;
            boolean bl2 = true;
            for (Node node = this.dom.getElementsByTagName(MENU).item(n2).getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeName() == SEPARATOR) {
                    bl = true;
                    continue;
                }
                if (node.getNodeName() != SUBMENU) continue;
                Integer n3 = null;
                n3 = isParentValid ? GraphicController.getController().askObject(GraphicObject.Type.UIMENU) : GraphicController.getController().askObject(GraphicObject.Type.UIMENUMODEL);
                GraphicController.getController().setProperty(n3, 28, true);
                GraphicController.getController().setGraphicObjectRelationship(n, n3);
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    if (namedNodeMap.item(i).getNodeName() == LABEL) {
                        String string = Messages.gettext((String)namedNodeMap.item(i).getNodeValue());
                        GraphicController.getController().setProperty(n3, 318, string);
                        continue;
                    }
                    if (namedNodeMap.item(i).getNodeName() == MNEMONIC) {
                        String string = namedNodeMap.item(i).getNodeValue();
                        GraphicController.getController().setProperty(n3, 319, string);
                        continue;
                    }
                    if (namedNodeMap.item(i).getNodeName() == ENABLED) {
                        boolean bl3 = namedNodeMap.item(i).getNodeValue().equals(TRUE);
                        GraphicController.getController().setProperty(n3, 289, bl3);
                        continue;
                    }
                    if (namedNodeMap.item(i).getNodeName() == ICON) {
                        String string = namedNodeMap.item(i).getNodeValue();
                        GraphicController.getController().setProperty(n3, 322, string);
                        continue;
                    }
                    if (namedNodeMap.item(i).getNodeName() == ACCELERATOR) {
                        String string = namedNodeMap.item(i).getNodeValue();
                        GraphicController.getController().setProperty(n3, 320, string);
                        continue;
                    }
                    if (namedNodeMap.item(i).getNodeName() != MACOSX || (bl2 = namedNodeMap.item(i).getNodeValue().equals(TRUE)) || OS.get() != OS.MAC) continue;
                    GraphicController.getController().removeRelationShipAndDelete(n3);
                    bl = false;
                }
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeName() == CALLBACK) {
                        NamedNodeMap namedNodeMap2 = node2.getAttributes();
                        String string = null;
                        int n4 = -1;
                        for (int i = 0; i < namedNodeMap2.getLength(); ++i) {
                            if (namedNodeMap2.item(i).getNodeName() == INSTRUCTION) {
                                string = namedNodeMap2.item(i).getNodeValue();
                                continue;
                            }
                            if (namedNodeMap2.item(i).getNodeName() != TYPE) continue;
                            n4 = Integer.parseInt(namedNodeMap2.item(i).getNodeValue());
                        }
                        if (string == null || n4 == -1) continue;
                        GraphicController.getController().setProperty(n3, 36, string);
                        GraphicController.getController().setProperty(n3, 37, n4);
                        continue;
                    }
                    if (node2.getNodeName() != SUBMENU) continue;
                    this.addSubMenuItem(n3, node2);
                }
                if (!bl) continue;
                GraphicController.getController().setProperty(n3, 321, true);
                bl = false;
            }
        }

        public void addSubMenuItem(Integer n, Node node) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Integer n2 = null;
            n2 = isParentValid ? GraphicController.getController().askObject(GraphicObject.Type.UIMENU) : GraphicController.getController().askObject(GraphicObject.Type.UIMENUMODEL);
            GraphicController.getController().setProperty(n2, 28, true);
            GraphicController.getController().setGraphicObjectRelationship(n, n2);
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                if (namedNodeMap.item(i).getNodeName() == LABEL) {
                    String string = Messages.gettext((String)namedNodeMap.item(i).getNodeValue());
                    GraphicController.getController().setProperty(n2, 318, string);
                    continue;
                }
                if (namedNodeMap.item(i).getNodeName() == MNEMONIC) {
                    String string = namedNodeMap.item(i).getNodeValue();
                    GraphicController.getController().setProperty(n2, 319, string);
                    continue;
                }
                if (namedNodeMap.item(i).getNodeName() == ICON) {
                    String string = namedNodeMap.item(i).getNodeValue();
                    GraphicController.getController().setProperty(n2, 322, string);
                    continue;
                }
                if (namedNodeMap.item(i).getNodeName() != ENABLED) continue;
                boolean bl = namedNodeMap.item(i).getNodeValue().equals(TRUE);
                GraphicController.getController().setProperty(n2, 289, bl);
            }
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeName() == CALLBACK) {
                    NamedNodeMap namedNodeMap2 = node2.getAttributes();
                    String string = null;
                    int n3 = -1;
                    for (int i = 0; i < namedNodeMap2.getLength(); ++i) {
                        if (namedNodeMap2.item(i).getNodeName() == INSTRUCTION) {
                            string = namedNodeMap2.item(i).getNodeValue();
                            continue;
                        }
                        if (namedNodeMap2.item(i).getNodeName() != TYPE) continue;
                        n3 = Integer.parseInt(namedNodeMap2.item(i).getNodeValue());
                    }
                    if (string == null || n3 == -1) continue;
                    GraphicController.getController().setProperty(n2, 36, string);
                    GraphicController.getController().setProperty(n2, 37, n3);
                    continue;
                }
                if (node2.getNodeName() != SUBMENU) continue;
                this.addSubMenuItem(n2, node2);
            }
        }
    }
}

