/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.uicontrol;

import java.awt.Font;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.scilab.modules.graphic_objects.console.Console;
import org.scilab.modules.graphic_objects.event.EventHandler;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.utils.LayoutType;

public class Uicontrol
extends GraphicObject {
    protected static final String RELIEF_DEFAULT = "default";
    protected static final String RELIEF_FLAT = "flat";
    protected static final String RELIEF_RAISED = "raised";
    protected static final String RELIEF_SUNKEN = "sunken";
    protected static final String RELIEF_GROOVE = "groove";
    protected static final String RELIEF_RIDGE = "ridge";
    protected static final String RELIEF_SOLID = "solid";
    protected static final double DEFAULT_RED_BACKGROUND = 0.8;
    protected static final double DEFAULT_GREEN_BACKGROUND = 0.8;
    protected static final double DEFAULT_BLUE_BACKGROUND = 0.8;
    private static final double DEFAULT_X = 20.0;
    private static final double DEFAULT_Y = 40.0;
    private static final double DEFAULT_WIDTH = 40.0;
    private static final double DEFAULT_HEIGHT = 20.0;
    protected static final double DEFAULT_FONTSIZE = 10.0;
    protected static final String DEFAULT_FONTNAME = "helvetica";
    protected static final String DEFAULT_FONTWEIGHT = "normal";
    protected static final String DEFAULT_FONTANGLE = "normal";
    private static final String STRING_SEPARATOR = "|";
    private static String defaultFontName = "";
    private static String defaultFontWeight = "";
    private static double defaultFontSize = 0.0;
    private static String defaultFontAngle = "";
    private static String defaultFontUnits = "";
    private UicontrolStyle style;
    private Double[] backgroundColor = new Double[]{-1.0, -1.0, -1.0};
    private Boolean enable = true;
    private String fontAngle = "";
    private String fontName = "";
    private double fontSize = 0.0;
    private String fontUnits = "points";
    private String fontWeight = "";
    private Double[] foregroundColor = new Double[]{-1.0, -1.0, -1.0};
    private String horizontalAlignment = "";
    private String verticalAlignment = "";
    private Integer[] listboxTop;
    private double max = 1.0;
    private double min;
    private Double[] position = new Double[]{20.0, 40.0, 40.0, 20.0};
    private String relief = "default";
    private Double[] sliderStep = new Double[]{0.01, 0.1};
    private String[] string = new String[0];
    private int stringColNb = 1;
    private String[] tooltipString = new String[]{""};
    private String units = "pixels";
    private Double[] value;
    private Boolean scrollable = false;
    private LayoutType layout = LayoutType.NONE;
    private Double[] margins = new Double[]{0.0, 0.0, 0.0, 0.0};
    private Integer[] gridbagGrid = new Integer[]{-1, -1, 1, 1};
    private Double[] gridbagWeight = new Double[]{0.0, 0.0};
    private FillType gridbagFill = FillType.NONE;
    private AnchorType gridbagAnchor = AnchorType.CENTER;
    private Integer[] gridbagPadding = new Integer[]{0, 0};
    private Integer[] gridbagPreferredSize = new Integer[]{-1, -1};
    private BorderLayoutType borderPosition = BorderLayoutType.CENTER;
    private Integer[] borderPreferredSize = new Integer[]{-1, -1};
    private String icon = "";
    private Integer[] gridOptGrid = new Integer[]{0, 0};
    private Integer[] gridOptPadding = new Integer[]{0, 0};
    private Integer[] borderOptPadding = new Integer[]{0, 0};
    private Integer frameBorder = 0;
    private String groupName = "";
    private Boolean titleScroll = false;
    private TitlePositionType titlePosition = TitlePositionType.TOP;
    private EventHandler eventHandler = new EventHandler();

    public Uicontrol() {
        this.setVisible(false);
        if (Console.getConsole().getUseDeprecatedLF()) {
            this.setBackgroundColor(new Double[]{0.8, 0.8, 0.8});
            this.setHorizontalAlignment("center");
            this.setVerticalAlignment("middle");
            this.setFontName(DEFAULT_FONTNAME);
            this.setFontSize(10.0);
            this.setFontAngle("normal");
            this.setFontWeight("normal");
        }
    }

    private int styleEnumToInt(UicontrolStyle uicontrolStyle) {
        switch (uicontrolStyle) {
            case CHECKBOX: {
                return 274;
            }
            case EDIT: {
                return 275;
            }
            case FRAME: {
                return 277;
            }
            case IMAGE: {
                return 279;
            }
            case LISTBOX: {
                return 280;
            }
            case POPUPMENU: {
                return 281;
            }
            case PUSHBUTTON: {
                return 282;
            }
            case RADIOBUTTON: {
                return 283;
            }
            case SLIDER: {
                return 284;
            }
            case TABLE: {
                return 285;
            }
            case TEXT: {
                return 286;
            }
            case TAB: {
                return 365;
            }
            case LAYER: {
                return 287;
            }
            case SPINNER: {
                return 276;
            }
        }
        return -1;
    }

    private UicontrolStyle intToStyleEnum(int n) {
        switch (n) {
            case 274: {
                return UicontrolStyle.CHECKBOX;
            }
            case 275: {
                return UicontrolStyle.EDIT;
            }
            case 277: {
                return UicontrolStyle.FRAME;
            }
            case 279: {
                return UicontrolStyle.IMAGE;
            }
            case 280: {
                return UicontrolStyle.LISTBOX;
            }
            case 281: {
                return UicontrolStyle.POPUPMENU;
            }
            case 282: {
                return UicontrolStyle.PUSHBUTTON;
            }
            case 283: {
                return UicontrolStyle.RADIOBUTTON;
            }
            case 284: {
                return UicontrolStyle.SLIDER;
            }
            case 285: {
                return UicontrolStyle.TABLE;
            }
            case 286: {
                return UicontrolStyle.TEXT;
            }
            case 365: {
                return UicontrolStyle.TAB;
            }
            case 287: {
                return UicontrolStyle.LAYER;
            }
            case 276: {
                return UicontrolStyle.SPINNER;
            }
        }
        return null;
    }

    @Override
    public Integer getType() {
        return 19;
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 273: {
                return UicontrolProperty.STYLE;
            }
            case 288: {
                return UicontrolProperty.BACKGROUNDCOLOR;
            }
            case 289: {
                return UicontrolProperty.ENABLE;
            }
            case 290: {
                return UicontrolProperty.FONTANGLE;
            }
            case 291: {
                return UicontrolProperty.FONTNAME;
            }
            case 292: {
                return UicontrolProperty.FONTSIZE;
            }
            case 293: {
                return UicontrolProperty.FONTUNITS;
            }
            case 294: {
                return UicontrolProperty.FONTWEIGHT;
            }
            case 295: {
                return UicontrolProperty.FOREGROUNDCOLOR;
            }
            case 296: {
                return UicontrolProperty.HORIZONTALALIGNMENT;
            }
            case 297: {
                return UicontrolProperty.LISTBOXTOP;
            }
            case 298: {
                return UicontrolProperty.LISTBOXTOP_SIZE;
            }
            case 299: {
                return UicontrolProperty.MAX;
            }
            case 300: {
                return UicontrolProperty.MIN;
            }
            case 80: {
                return UicontrolProperty.POSITION;
            }
            case 301: {
                return UicontrolProperty.RELIEF;
            }
            case 308: {
                return UicontrolProperty.SLIDERSTEP;
            }
            case 302: {
                return UicontrolProperty.STRING;
            }
            case 304: {
                return UicontrolProperty.STRING_SIZE;
            }
            case 305: {
                return UicontrolProperty.STRING_COLNB;
            }
            case 306: {
                return UicontrolProperty.TOOLTIPSTRING;
            }
            case 307: {
                return UicontrolProperty.TOOLTIPSTRING_SIZE;
            }
            case 309: {
                return UicontrolProperty.UNITS;
            }
            case 310: {
                return UicontrolProperty.VALUE;
            }
            case 312: {
                return UicontrolProperty.VALUE_SIZE;
            }
            case 313: {
                return UicontrolProperty.VERTICALALIGNMENT;
            }
            case 363: {
                return UicontrolProperty.LAYOUT;
            }
            case 364: {
                return UicontrolProperty.LAYOUT_SET;
            }
            case 181: {
                return UicontrolProperty.MARGINS;
            }
            case 366: {
                return UicontrolProperty.GRIDBAG_GRID;
            }
            case 367: {
                return UicontrolProperty.GRIDBAG_WEIGHT;
            }
            case 368: {
                return UicontrolProperty.GRIDBAG_FILL;
            }
            case 369: {
                return UicontrolProperty.GRIDBAG_ANCHOR;
            }
            case 370: {
                return UicontrolProperty.GRIDBAG_PADDING;
            }
            case 371: {
                return UicontrolProperty.GRIDBAG_PREFERREDSIZE;
            }
            case 374: {
                return UicontrolProperty.BORDER_POSITION;
            }
            case 375: {
                return UicontrolProperty.BORDER_PREFERREDSIZE;
            }
            case 376: {
                return UicontrolProperty.GRIDOPT_GRID;
            }
            case 377: {
                return UicontrolProperty.GRIDOPT_PADDING;
            }
            case 378: {
                return UicontrolProperty.BORDEROPT_PADDING;
            }
            case 379: {
                return UicontrolProperty.FRAMEBORDER;
            }
            case 392: {
                return UicontrolProperty.GROUPNAME;
            }
            case 393: {
                return UicontrolProperty.TITLE_POSITION;
            }
            case 394: {
                return UicontrolProperty.TITLE_SCROLL;
            }
            case 396: {
                return UicontrolProperty.SCROLLABLE;
            }
            case 322: {
                return UicontrolProperty.ICON;
            }
            case 98: {
                return UicontrolProperty.EVENTHANDLER;
            }
            case 99: {
                return UicontrolProperty.EVENTHANDLERENABLE;
            }
            case 404: {
                return UicontrolProperty.FOCUS;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == UicontrolProperty.STYLE) {
            return this.getStyle();
        }
        if (object == UicontrolProperty.BACKGROUNDCOLOR) {
            return this.getBackgroundColor();
        }
        if (object == UicontrolProperty.ENABLE) {
            return this.getEnable();
        }
        if (object == UicontrolProperty.FONTANGLE) {
            return this.getFontAngle();
        }
        if (object == UicontrolProperty.FONTNAME) {
            return this.getFontName();
        }
        if (object == UicontrolProperty.FONTSIZE) {
            return this.getFontSize();
        }
        if (object == UicontrolProperty.FONTUNITS) {
            return this.getFontUnits();
        }
        if (object == UicontrolProperty.FONTWEIGHT) {
            return this.getFontWeight();
        }
        if (object == UicontrolProperty.FOREGROUNDCOLOR) {
            return this.getForegroundColor();
        }
        if (object == UicontrolProperty.HORIZONTALALIGNMENT) {
            return this.getHorizontalAlignment();
        }
        if (object == UicontrolProperty.LISTBOXTOP) {
            return this.getListboxTop();
        }
        if (object == UicontrolProperty.LISTBOXTOP_SIZE) {
            return this.getListboxTopSize();
        }
        if (object == UicontrolProperty.MAX) {
            return this.getMax();
        }
        if (object == UicontrolProperty.MIN) {
            return this.getMin();
        }
        if (object == UicontrolProperty.POSITION) {
            return this.getUiPosition();
        }
        if (object == UicontrolProperty.RELIEF) {
            return this.getRelief();
        }
        if (object == UicontrolProperty.SLIDERSTEP) {
            return this.getSliderStep();
        }
        if (object == UicontrolProperty.STRING) {
            return this.getString();
        }
        if (object == UicontrolProperty.STRING_SIZE) {
            return this.getString().length;
        }
        if (object == UicontrolProperty.STRING_COLNB) {
            return this.getStringColNb();
        }
        if (object == UicontrolProperty.TOOLTIPSTRING) {
            return this.getTooltipString();
        }
        if (object == UicontrolProperty.TOOLTIPSTRING_SIZE) {
            return this.getTooltipString().length;
        }
        if (object == UicontrolProperty.UNITS) {
            return this.getUnits();
        }
        if (object == UicontrolProperty.VALUE) {
            return this.getUiValue();
        }
        if (object == UicontrolProperty.VALUE_SIZE) {
            return this.getUiValueSize();
        }
        if (object == UicontrolProperty.VERTICALALIGNMENT) {
            return this.getVerticalAlignment();
        }
        if (object == UicontrolProperty.LAYOUT) {
            return this.getLayout();
        }
        if (object == UicontrolProperty.LAYOUT_SET) {
            return this.isLayoutSettable();
        }
        if (object == UicontrolProperty.MARGINS) {
            return this.getMargins();
        }
        if (object == UicontrolProperty.GRIDBAG_GRID) {
            return this.getGridBagGrid();
        }
        if (object == UicontrolProperty.GRIDBAG_WEIGHT) {
            return this.getGridBagWeight();
        }
        if (object == UicontrolProperty.GRIDBAG_FILL) {
            return this.getGridBagFill();
        }
        if (object == UicontrolProperty.GRIDBAG_ANCHOR) {
            return this.getGridBagAnchor();
        }
        if (object == UicontrolProperty.GRIDBAG_PADDING) {
            return this.getGridBagPadding();
        }
        if (object == UicontrolProperty.GRIDBAG_PREFERREDSIZE) {
            return this.getGridBagPreferredSize();
        }
        if (object == UicontrolProperty.BORDER_POSITION) {
            return this.getBorderPosition();
        }
        if (object == UicontrolProperty.BORDER_PREFERREDSIZE) {
            return this.getBorderPreferredSize();
        }
        if (object == UicontrolProperty.GRIDOPT_GRID) {
            return this.getGridOptGrid();
        }
        if (object == UicontrolProperty.GRIDOPT_PADDING) {
            return this.getGridOptPadding();
        }
        if (object == UicontrolProperty.BORDEROPT_PADDING) {
            return this.getBorderOptPadding();
        }
        if (object == UicontrolProperty.FRAMEBORDER) {
            return this.getFrameBorder();
        }
        if (object == UicontrolProperty.GROUPNAME) {
            return this.getGroupName();
        }
        if (object == UicontrolProperty.TITLE_POSITION) {
            return this.getTitlePosition();
        }
        if (object == UicontrolProperty.TITLE_SCROLL) {
            return this.getTitleScroll();
        }
        if (object == UicontrolProperty.SCROLLABLE) {
            return this.getScrollable();
        }
        if (object == UicontrolProperty.ICON) {
            return this.getIcon();
        }
        if (object == UicontrolProperty.EVENTHANDLER) {
            return this.getEventHandler();
        }
        if (object == UicontrolProperty.EVENTHANDLERENABLE) {
            return this.getEventHandlerEnable();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (!(object instanceof UicontrolProperty)) {
            return super.setProperty(object, object2);
        }
        UicontrolProperty uicontrolProperty = (UicontrolProperty)((Object)object);
        switch (uicontrolProperty) {
            case STYLE: {
                return this.setStyle((Integer)object2);
            }
            case BACKGROUNDCOLOR: {
                return this.setBackgroundColor((Double[])object2);
            }
            case ENABLE: {
                return this.setEnable((Boolean)object2);
            }
            case FONTANGLE: {
                return this.setFontAngle((String)object2);
            }
            case FONTNAME: {
                return this.setFontName((String)object2);
            }
            case FONTSIZE: {
                return this.setFontSize((Double)object2);
            }
            case FONTUNITS: {
                return this.setFontUnits((String)object2);
            }
            case FONTWEIGHT: {
                return this.setFontWeight((String)object2);
            }
            case FOREGROUNDCOLOR: {
                return this.setForegroundColor((Double[])object2);
            }
            case HORIZONTALALIGNMENT: {
                return this.setHorizontalAlignment((String)object2);
            }
            case LISTBOXTOP: {
                return this.setListboxTop((Integer[])object2);
            }
            case MAX: {
                return this.setMax((Double)object2);
            }
            case MIN: {
                return this.setMin((Double)object2);
            }
            case POSITION: {
                return this.setUiPosition((Double[])object2);
            }
            case RELIEF: {
                return this.setRelief((String)object2);
            }
            case SLIDERSTEP: {
                return this.setSliderStep((Double[])object2);
            }
            case STRING: {
                return this.setString((String[])object2);
            }
            case STRING_COLNB: {
                return this.setStringColNb((Integer)object2);
            }
            case TOOLTIPSTRING: {
                return this.setTooltipString((String[])object2);
            }
            case UNITS: {
                return this.setUnits((String)object2);
            }
            case VALUE: {
                return this.setUiValue((Double[])object2);
            }
            case VERTICALALIGNMENT: {
                return this.setVerticalAlignment((String)object2);
            }
            case LAYOUT: {
                return this.setLayout((Integer)object2);
            }
            case MARGINS: {
                return this.setMargins((Double[])object2);
            }
            case GRIDBAG_GRID: {
                return this.setGridBagGrid((Integer[])object2);
            }
            case GRIDBAG_WEIGHT: {
                return this.setGridBagWeight((Double[])object2);
            }
            case GRIDBAG_FILL: {
                return this.setGridBagFill((Integer)object2);
            }
            case GRIDBAG_ANCHOR: {
                return this.setGridBagAnchor((Integer)object2);
            }
            case GRIDBAG_PADDING: {
                return this.setGridBagPadding((Integer[])object2);
            }
            case GRIDBAG_PREFERREDSIZE: {
                return this.setGridBagPreferredSize((Integer[])object2);
            }
            case BORDER_POSITION: {
                return this.setBorderPosition((Integer)object2);
            }
            case BORDER_PREFERREDSIZE: {
                return this.setBorderPreferredSize((Integer[])object2);
            }
            case GRIDOPT_GRID: {
                return this.setGridOptGrid((Integer[])object2);
            }
            case GRIDOPT_PADDING: {
                return this.setGridOptPadding((Integer[])object2);
            }
            case BORDEROPT_PADDING: {
                return this.setBorderOptPadding((Integer[])object2);
            }
            case FRAMEBORDER: {
                return this.setFrameBorder((Integer)object2);
            }
            case GROUPNAME: {
                return this.setGroupName((String)object2);
            }
            case TITLE_POSITION: {
                return this.setTitlePosition((Integer)object2);
            }
            case TITLE_SCROLL: {
                return this.setTitleScroll((Boolean)object2);
            }
            case SCROLLABLE: {
                return this.setScrollable((Boolean)object2);
            }
            case ICON: {
                return this.setIcon((String)object2);
            }
            case EVENTHANDLER: {
                return this.setEventHandler((String)object2);
            }
            case EVENTHANDLERENABLE: {
                return this.setEventHandlerEnable((Boolean)object2);
            }
            case FOCUS: {
                return GraphicObject.UpdateStatus.Success;
            }
        }
        return super.setProperty(object, object2);
    }

    public Integer getStyle() {
        return this.styleEnumToInt(this.style);
    }

    public UicontrolStyle getStyleAsEnum() {
        return this.style;
    }

    public GraphicObject.UpdateStatus setStyle(int n) {
        UicontrolStyle uicontrolStyle = this.intToStyleEnum(n);
        if (uicontrolStyle == this.style) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.style = uicontrolStyle;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getBackgroundColor() {
        return this.backgroundColor;
    }

    public GraphicObject.UpdateStatus setBackgroundColor(Double[] doubleArray) {
        if (Arrays.equals((Object[])doubleArray, (Object[])this.backgroundColor)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.backgroundColor = doubleArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public GraphicObject.UpdateStatus setEnable(Boolean bl) {
        if (this.enable.equals(bl)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.enable = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getFontAngle() {
        return this.fontAngle;
    }

    public GraphicObject.UpdateStatus setFontAngle(String string) {
        if (this.fontAngle.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.fontAngle = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getFontName() {
        return this.fontName;
    }

    public GraphicObject.UpdateStatus setFontName(String string) {
        if (this.fontName.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.fontName = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public GraphicObject.UpdateStatus setFontSize(double d) {
        if (this.fontSize == d) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.fontSize = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getFontUnits() {
        return this.fontUnits;
    }

    public GraphicObject.UpdateStatus setFontUnits(String string) {
        if (this.fontUnits.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.fontUnits = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public GraphicObject.UpdateStatus setFontWeight(String string) {
        if (this.fontWeight.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.fontWeight = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getForegroundColor() {
        return this.foregroundColor;
    }

    public GraphicObject.UpdateStatus setForegroundColor(Double[] doubleArray) {
        if (Arrays.equals((Object[])this.foregroundColor, (Object[])doubleArray)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.foregroundColor = doubleArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public GraphicObject.UpdateStatus setHorizontalAlignment(String string) {
        if (this.horizontalAlignment.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.horizontalAlignment = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getListboxTopSize() {
        return this.listboxTop != null ? this.listboxTop.length : 0;
    }

    public Integer[] getListboxTop() {
        return this.listboxTop;
    }

    public GraphicObject.UpdateStatus setListboxTop(Integer[] integerArray) {
        if (Arrays.equals((Object[])this.listboxTop, (Object[])integerArray)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.listboxTop = integerArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getMax() {
        return this.max;
    }

    public GraphicObject.UpdateStatus setMax(double d) {
        if (this.max == d) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.max = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getMin() {
        return this.min;
    }

    public GraphicObject.UpdateStatus setMin(double d) {
        if (this.min == d) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.min = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getUiPosition() {
        return this.position;
    }

    public GraphicObject.UpdateStatus setUiPosition(Double[] doubleArray) {
        if (Arrays.equals((Object[])this.position, (Object[])doubleArray)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.position = doubleArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getRelief() {
        return this.relief;
    }

    public GraphicObject.UpdateStatus setRelief(String string) {
        if (this.relief.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.relief = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public String[] getString() {
        return this.string;
    }

    public GraphicObject.UpdateStatus setString(String[] stringArray) {
        if (this.string == stringArray) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        boolean bl = false;
        if (this.string.length == stringArray.length) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.string[i] == null && stringArray[i] == null) continue;
                if ((this.string[i] == null || stringArray[i] == null) && this.string[i] != stringArray[i]) {
                    bl = true;
                } else {
                    if (this.string[i].equals(stringArray[i])) continue;
                    bl = true;
                }
                break;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        if (this.style == UicontrolStyle.LISTBOX || this.style == UicontrolStyle.POPUPMENU) {
            if (stringArray.length == 0) {
                if (this.string.length == 0) {
                    return GraphicObject.UpdateStatus.NoChange;
                }
                this.string = stringArray;
                return GraphicObject.UpdateStatus.Success;
            }
            if (stringArray.length == 1 && stringArray[0].contains(STRING_SEPARATOR)) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], STRING_SEPARATOR);
                String[] stringArray2 = new String[stringTokenizer.countTokens()];
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray2[stringArray2.length - stringTokenizer.countTokens()] = stringTokenizer.nextToken();
                }
                this.string = stringArray2;
                return GraphicObject.UpdateStatus.Success;
            }
        }
        this.string = stringArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public int getStringColNb() {
        return this.stringColNb;
    }

    public GraphicObject.UpdateStatus setStringColNb(Integer n) {
        if (this.stringColNb == n) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.stringColNb = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public String[] getTooltipString() {
        return this.tooltipString;
    }

    public GraphicObject.UpdateStatus setTooltipString(String[] stringArray) {
        if (Arrays.equals(this.tooltipString, stringArray)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.tooltipString = stringArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getSliderStep() {
        return this.sliderStep;
    }

    public GraphicObject.UpdateStatus setSliderStep(Double[] doubleArray) {
        if (Arrays.equals((Object[])this.sliderStep, (Object[])doubleArray)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.sliderStep = doubleArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getUnits() {
        return this.units;
    }

    public GraphicObject.UpdateStatus setUnits(String string) {
        if (this.units.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.units = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getUiValueSize() {
        return this.value != null ? this.value.length : 0;
    }

    public Double[] getUiValue() {
        return this.value;
    }

    public GraphicObject.UpdateStatus setUiValue(Double[] doubleArray) {
        if (Arrays.equals((Object[])this.value, (Object[])doubleArray)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.value = doubleArray;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public GraphicObject.UpdateStatus setVerticalAlignment(String string) {
        if (this.verticalAlignment.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.verticalAlignment = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getLayout() {
        return this.layout.ordinal();
    }

    public LayoutType getLayoutAsEnum() {
        return this.layout;
    }

    public boolean isLayoutSettable() {
        return this.layout == LayoutType.NONE;
    }

    public GraphicObject.UpdateStatus setLayout(Integer n) {
        return this.setLayout(LayoutType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setLayout(LayoutType layoutType) {
        if (this.layout == LayoutType.NONE) {
            if (layoutType == LayoutType.NONE) {
                return GraphicObject.UpdateStatus.NoChange;
            }
            this.layout = layoutType;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.Fail;
    }

    public Double[] getMargins() {
        return this.margins;
    }

    public GraphicObject.UpdateStatus setMargins(Double[] doubleArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (doubleArray.length != 4) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.margins[i].equals(doubleArray[i])) continue;
            this.margins[i] = doubleArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer getBorderPosition() {
        return this.borderPosition.ordinal();
    }

    public BorderLayoutType getBorderPositionAsEnum() {
        return this.borderPosition;
    }

    public GraphicObject.UpdateStatus setBorderPosition(Integer n) {
        return this.setBorderPosition(BorderLayoutType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setBorderPosition(BorderLayoutType borderLayoutType) {
        if (this.borderPosition == borderLayoutType) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.borderPosition = borderLayoutType;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getGridBagPadding() {
        return this.gridbagPadding;
    }

    public GraphicObject.UpdateStatus setGridBagPadding(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.gridbagPadding.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.gridbagPadding[i] == integerArray[i]) continue;
            this.gridbagPadding[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer[] getGridBagPreferredSize() {
        return this.gridbagPreferredSize;
    }

    public GraphicObject.UpdateStatus setGridBagPreferredSize(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.gridbagPreferredSize.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.gridbagPreferredSize[i] == integerArray[i]) continue;
            this.gridbagPreferredSize[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer[] getBorderPreferredSize() {
        return this.borderPreferredSize;
    }

    public GraphicObject.UpdateStatus setBorderPreferredSize(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.borderPreferredSize.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.borderPreferredSize[i] == integerArray[i]) continue;
            this.borderPreferredSize[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer getGridBagAnchor() {
        return this.gridbagAnchor.ordinal();
    }

    public AnchorType getGridBagAnchorAsEnum() {
        return this.gridbagAnchor;
    }

    public GraphicObject.UpdateStatus setGridBagAnchor(Integer n) {
        return this.setGridBagAnchor(AnchorType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setGridBagAnchor(AnchorType anchorType) {
        if (this.gridbagAnchor == anchorType) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.gridbagAnchor = anchorType;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getGridBagFill() {
        return this.gridbagFill.ordinal();
    }

    public FillType getGridBagFillAsEnum() {
        return this.gridbagFill;
    }

    public GraphicObject.UpdateStatus setGridBagFill(Integer n) {
        return this.setGridBagFill(FillType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setGridBagFill(FillType fillType) {
        if (this.gridbagFill == fillType) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.gridbagFill = fillType;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getGridBagWeight() {
        return this.gridbagWeight;
    }

    public GraphicObject.UpdateStatus setGridBagWeight(Double[] doubleArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.gridbagWeight.length != doubleArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < doubleArray.length; ++i) {
            if (this.gridbagWeight[i] == doubleArray[i]) continue;
            this.gridbagWeight[i] = doubleArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer[] getGridBagGrid() {
        return this.gridbagGrid;
    }

    public GraphicObject.UpdateStatus setGridBagGrid(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.gridbagGrid.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.gridbagGrid[i] == integerArray[i]) continue;
            this.gridbagGrid[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer[] getBorderOptPadding() {
        return this.borderOptPadding;
    }

    public GraphicObject.UpdateStatus setBorderOptPadding(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.borderOptPadding.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.borderOptPadding[i] == integerArray[i]) continue;
            this.borderOptPadding[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer[] getGridOptPadding() {
        return this.gridOptPadding;
    }

    public GraphicObject.UpdateStatus setGridOptPadding(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.gridOptPadding.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.gridOptPadding[i] == integerArray[i]) continue;
            this.gridOptPadding[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer[] getGridOptGrid() {
        return this.gridOptGrid;
    }

    public GraphicObject.UpdateStatus setGridOptGrid(Integer[] integerArray) {
        GraphicObject.UpdateStatus updateStatus = GraphicObject.UpdateStatus.NoChange;
        if (this.gridOptGrid.length != integerArray.length) {
            return GraphicObject.UpdateStatus.Fail;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (this.gridOptGrid[i] == integerArray[i]) continue;
            this.gridOptGrid[i] = integerArray[i];
            updateStatus = GraphicObject.UpdateStatus.Success;
        }
        return updateStatus;
    }

    public Integer getFrameBorder() {
        return this.frameBorder;
    }

    public GraphicObject.UpdateStatus setFrameBorder(Integer n) {
        if (this.frameBorder.equals(n)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.frameBorder = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public GraphicObject.UpdateStatus setGroupName(String string) {
        if (this.groupName.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.groupName = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getTitleScroll() {
        return this.titleScroll;
    }

    public GraphicObject.UpdateStatus setTitleScroll(Boolean bl) {
        if (this.titleScroll == bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.titleScroll = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getTitlePosition() {
        return this.titlePosition.ordinal();
    }

    public TitlePositionType getTitlePositionAsEnum() {
        return this.titlePosition;
    }

    public GraphicObject.UpdateStatus setTitlePosition(Integer n) {
        return this.setTitlePosition(TitlePositionType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setTitlePosition(TitlePositionType titlePositionType) {
        if (this.titlePosition == titlePositionType) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.titlePosition = titlePositionType;
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setScrollable(Boolean bl) {
        if (this.scrollable == bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.scrollable = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getScrollable() {
        return this.scrollable;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (Uicontrol.getDefaultFontName().equals("")) {
            this.setFontName(font.getName());
        } else {
            this.setFontName(Uicontrol.getDefaultFontName());
        }
        if (Uicontrol.getDefaultFontSize() == 0.0) {
            this.setFontSize(font.getSize());
        } else {
            this.setFontSize(Uicontrol.getDefaultFontSize());
        }
        if (Uicontrol.getDefaultFontAngle().equals("")) {
            if (font.isItalic()) {
                this.setFontAngle("italic");
            } else {
                this.setFontAngle("normal");
            }
        } else {
            this.setFontAngle(Uicontrol.getDefaultFontAngle());
        }
        if (Uicontrol.getDefaultFontWeight().equals("")) {
            if (font.isBold()) {
                this.setFontWeight("bold");
            } else {
                this.setFontWeight("normal");
            }
        } else {
            this.setFontWeight(Uicontrol.getDefaultFontWeight());
        }
        if (!Uicontrol.getDefaultFontUnits().equals("")) {
            this.setFontUnits(Uicontrol.getDefaultFontUnits());
        }
    }

    public GraphicObject.UpdateStatus setIcon(String string) {
        if (this.icon.equals(string)) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.icon = string;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getIcon() {
        return this.icon;
    }

    public GraphicObject.UpdateStatus setEventHandler(String string) {
        return this.eventHandler.setEventHandlerString(string);
    }

    public String getEventHandler() {
        return this.eventHandler.getEventHandlerString();
    }

    public GraphicObject.UpdateStatus setEventHandlerEnable(Boolean bl) {
        return this.eventHandler.setEventHandlerEnabled(bl);
    }

    public boolean getEventHandlerEnable() {
        return this.eventHandler.getEventHandlerEnabled();
    }

    @Override
    public void accept(Visitor visitor) {
    }

    public static void setDefaultFontName(String string) {
        defaultFontName = string;
    }

    public static String getDefaultFontName() {
        return defaultFontName;
    }

    public static void setDefaultFontWeight(String string) {
        defaultFontWeight = string;
    }

    public static String getDefaultFontWeight() {
        return defaultFontWeight;
    }

    public static void setDefaultFontSize(double d) {
        defaultFontSize = d;
    }

    public static double getDefaultFontSize() {
        return defaultFontSize;
    }

    public static void setDefaultFontAngle(String string) {
        defaultFontAngle = string;
    }

    public static String getDefaultFontAngle() {
        return defaultFontAngle;
    }

    public static void setDefaultFontUnits(String string) {
        defaultFontUnits = string;
    }

    public static String getDefaultFontUnits() {
        return defaultFontUnits;
    }

    public static enum UicontrolStyle {
        CHECKBOX,
        EDIT,
        FRAME,
        IMAGE,
        LISTBOX,
        POPUPMENU,
        PUSHBUTTON,
        RADIOBUTTON,
        SLIDER,
        TABLE,
        TEXT,
        TABGROUP,
        TAB,
        LAYER,
        SPINNER;

    }

    private static enum UicontrolProperty {
        STYLE,
        BACKGROUNDCOLOR,
        ENABLE,
        FONTANGLE,
        FONTNAME,
        FONTSIZE,
        FONTUNITS,
        FONTWEIGHT,
        FOREGROUNDCOLOR,
        HORIZONTALALIGNMENT,
        LISTBOXTOP,
        LISTBOXTOP_SIZE,
        MAX,
        MIN,
        POSITION,
        SCALE,
        SHEAR,
        SLIDERSTEP,
        STRING,
        STRING_SIZE,
        STRING_COLNB,
        RELIEF,
        TOOLTIPSTRING,
        TOOLTIPSTRING_SIZE,
        UNITS,
        VALUE,
        VALUE_SIZE,
        VERTICALALIGNMENT,
        LAYOUT,
        LAYOUT_SET,
        MARGINS,
        GRIDBAG_GRID,
        GRIDBAG_WEIGHT,
        GRIDBAG_FILL,
        GRIDBAG_ANCHOR,
        GRIDBAG_PADDING,
        GRIDBAG_PREFERREDSIZE,
        BORDER_POSITION,
        BORDER_PREFERREDSIZE,
        GRIDOPT_GRID,
        GRIDOPT_PADDING,
        BORDEROPT_PADDING,
        FRAMEBORDER,
        GROUPNAME,
        TITLE_POSITION,
        TITLE_SCROLL,
        SCROLLABLE,
        ICON,
        EVENTHANDLER,
        EVENTHANDLERENABLE,
        FOCUS;

    }

    public static enum AnchorType {
        CENTER,
        UPPER,
        LOWER,
        RIGHT,
        LEFT,
        UPPER_RIGHT,
        UPPER_LEFT,
        LOWER_RIGHT,
        LOWER_LEFT;


        public static AnchorType intToEnum(Integer n) {
            switch (n) {
                default: {
                    return CENTER;
                }
                case 1: {
                    return UPPER;
                }
                case 2: {
                    return LOWER;
                }
                case 3: {
                    return RIGHT;
                }
                case 4: {
                    return LEFT;
                }
                case 5: {
                    return UPPER_RIGHT;
                }
                case 6: {
                    return UPPER_LEFT;
                }
                case 7: {
                    return LOWER_RIGHT;
                }
                case 8: 
            }
            return LOWER_LEFT;
        }

        public static AnchorType stringToEnum2(String string) {
            if (string == null || string.equals("")) {
                return CENTER;
            }
            char[] cArray = string.toCharArray();
            if (cArray[0] == 'e' || cArray[0] == 'E') {
                return RIGHT;
            }
            if (cArray[0] == 'w' || cArray[0] == 'W') {
                return LEFT;
            }
            if (cArray[0] == 'n' || cArray[0] == 'N') {
                if (cArray.length == 1) {
                    return UPPER;
                }
                if (cArray[1] == 'e' || cArray[1] == 'E') {
                    return UPPER_RIGHT;
                }
                if (cArray[1] == 'w' || cArray[1] == 'W') {
                    return UPPER_LEFT;
                }
                return UPPER;
            }
            if (cArray[0] == 's' || cArray[0] == 'S') {
                if (cArray.length == 1) {
                    return LOWER;
                }
                if (cArray[1] == 'e' || cArray[1] == 'E') {
                    return LOWER_RIGHT;
                }
                if (cArray[1] == 'w' || cArray[1] == 'W') {
                    return LOWER_LEFT;
                }
                return LOWER;
            }
            return CENTER;
        }

        public static String enumToString(AnchorType anchorType) {
            switch (anchorType) {
                default: {
                    return "center";
                }
                case LEFT: {
                    return "left";
                }
                case LOWER: {
                    return "lower";
                }
                case LOWER_LEFT: {
                    return "lower_left";
                }
                case LOWER_RIGHT: {
                    return "lower_right";
                }
                case RIGHT: {
                    return "right";
                }
                case UPPER: {
                    return "upper";
                }
                case UPPER_LEFT: {
                    return "upper_left";
                }
                case UPPER_RIGHT: 
            }
            return "upper_right";
        }

        public static AnchorType stringToEnum(String string) {
            if (string.equals("left")) {
                return LEFT;
            }
            if (string.equals("lower")) {
                return LOWER;
            }
            if (string.equals("lower_left")) {
                return LOWER_LEFT;
            }
            if (string.equals("lower_right")) {
                return LOWER_RIGHT;
            }
            if (string.equals("right")) {
                return RIGHT;
            }
            if (string.equals("upper")) {
                return UPPER;
            }
            if (string.equals("upper_left")) {
                return UPPER_LEFT;
            }
            if (string.equals("upper_right")) {
                return UPPER_RIGHT;
            }
            return CENTER;
        }
    }

    public static enum FillType {
        NONE,
        VERTICAL,
        HORIZONTAL,
        BOTH;


        public static FillType intToEnum(Integer n) {
            switch (n) {
                default: {
                    return NONE;
                }
                case 1: {
                    return VERTICAL;
                }
                case 2: {
                    return HORIZONTAL;
                }
                case 3: 
            }
            return BOTH;
        }

        public static FillType stringToEnum(String string) {
            if (string == null || string.equals("")) {
                return NONE;
            }
            char[] cArray = string.toCharArray();
            if (cArray[0] == 'v' || cArray[0] == 'V') {
                return VERTICAL;
            }
            if (cArray[0] == 'h' || cArray[0] == 'H') {
                return HORIZONTAL;
            }
            if (cArray[0] == 'b' || cArray[0] == 'B') {
                return BOTH;
            }
            return NONE;
        }

        public static String enumToString(FillType fillType) {
            switch (fillType) {
                case BOTH: {
                    return "both";
                }
                case HORIZONTAL: {
                    return "horizontal";
                }
                default: {
                    return "none";
                }
                case VERTICAL: 
            }
            return "vertical";
        }
    }

    public static enum BorderLayoutType {
        BOTTOM,
        TOP,
        CENTER,
        LEFT,
        RIGHT;


        public static BorderLayoutType intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return BOTTOM;
                }
                case 1: {
                    return TOP;
                }
                default: {
                    return CENTER;
                }
                case 3: {
                    return LEFT;
                }
                case 4: 
            }
            return RIGHT;
        }

        public static BorderLayoutType stringToEnum2(String string) {
            if (string == null || string.equals("")) {
                return CENTER;
            }
            char[] cArray = string.toCharArray();
            if (cArray[0] == 'n' || cArray[0] == 'N') {
                return TOP;
            }
            if (cArray[0] == 'e' || cArray[0] == 'E') {
                return RIGHT;
            }
            if (cArray[0] == 's' || cArray[0] == 'S') {
                return BOTTOM;
            }
            if (cArray[0] == 'w' || cArray[0] == 'W') {
                return LEFT;
            }
            return CENTER;
        }

        public static String enumToString(BorderLayoutType borderLayoutType) {
            switch (borderLayoutType) {
                case BOTTOM: {
                    return "bottom";
                }
                default: {
                    return "center";
                }
                case LEFT: {
                    return "left";
                }
                case RIGHT: {
                    return "right";
                }
                case TOP: 
            }
            return "top";
        }

        public static BorderLayoutType stringToEnum(String string) {
            if (string.equals("bottom")) {
                return BOTTOM;
            }
            if (string.equals("left")) {
                return LEFT;
            }
            if (string.equals("right")) {
                return RIGHT;
            }
            if (string.equals("top")) {
                return TOP;
            }
            return CENTER;
        }
    }

    public static enum TitlePositionType {
        TOP,
        LEFT,
        BOTTOM,
        RIGHT;


        public static TitlePositionType intToEnum(Integer n) {
            switch (n) {
                default: {
                    return TOP;
                }
                case 1: {
                    return LEFT;
                }
                case 2: {
                    return BOTTOM;
                }
                case 3: 
            }
            return RIGHT;
        }

        public static TitlePositionType stringToEnum(String string) {
            if (string.equals("left")) {
                return LEFT;
            }
            if (string.equals("bottom")) {
                return BOTTOM;
            }
            if (string.equals("right")) {
                return RIGHT;
            }
            return TOP;
        }

        public static String enumToString(TitlePositionType titlePositionType) {
            switch (titlePositionType) {
                case BOTTOM: {
                    return "bottom";
                }
                case LEFT: {
                    return "left";
                }
                case RIGHT: {
                    return "right";
                }
            }
            return "top";
        }
    }
}

