/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.textObject;

import org.scilab.modules.graphic_objects.contouredObject.ContouredObject;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.textObject.Font;
import org.scilab.modules.graphic_objects.textObject.FormattedText;

public abstract class TextObject
extends ContouredObject {
    protected FormattedText[] text;
    private int[] dimensions = new int[2];

    public TextObject() {
        this.dimensions[0] = 1;
        this.dimensions[1] = 1;
        this.text = new FormattedText[1];
        this.text[0] = new FormattedText();
    }

    @Override
    public TextObject clone() {
        TextObject textObject = (TextObject)super.clone();
        textObject.dimensions = new int[2];
        textObject.dimensions[0] = this.dimensions[0];
        textObject.dimensions[1] = this.dimensions[1];
        textObject.text = new FormattedText[this.dimensions[0] * this.dimensions[1]];
        textObject.setText(this.text);
        return textObject;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            String string = this.text[i].getText();
            if (string == null || string.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 252: {
                return TextObjectProperty.TEXT;
            }
            case 253: {
                return TextObjectProperty.TEXT_ARRAY_DIMENSIONS;
            }
            case 254: {
                return FormattedText.FormattedTextProperty.TEXT;
            }
            case 217: {
                return Font.FontProperty.STYLE;
            }
            case 218: {
                return Font.FontProperty.SIZE;
            }
            case 219: {
                return Font.FontProperty.COLOR;
            }
            case 220: {
                return Font.FontProperty.FRACTIONAL;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == TextObjectProperty.TEXT) {
            return this.getText();
        }
        if (object == TextObjectProperty.TEXT_ARRAY_DIMENSIONS) {
            return this.getTextArrayDimensions();
        }
        if (object == FormattedText.FormattedTextProperty.TEXT) {
            return this.getTextStrings();
        }
        if (object == Font.FontProperty.STYLE) {
            return this.getFontStyle();
        }
        if (object == Font.FontProperty.SIZE) {
            return this.getFontSize();
        }
        if (object == Font.FontProperty.COLOR) {
            return this.getFontColor();
        }
        if (object == Font.FontProperty.FRACTIONAL) {
            return this.getFontFractional();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == TextObjectProperty.TEXT) {
            this.setText((FormattedText[])object2);
        } else if (object == TextObjectProperty.TEXT_ARRAY_DIMENSIONS) {
            this.setTextArrayDimensions((Integer[])object2);
        } else if (object == FormattedText.FormattedTextProperty.TEXT) {
            this.setTextStrings((String[])object2);
        } else if (object == Font.FontProperty.STYLE) {
            this.setFontStyle((Integer)object2);
        } else if (object == Font.FontProperty.SIZE) {
            this.setFontSize((Double)object2);
        } else if (object == Font.FontProperty.COLOR) {
            this.setFontColor((Integer)object2);
        } else if (object == Font.FontProperty.FRACTIONAL) {
            this.setFontFractional((Boolean)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getTextArrayDimensions() {
        Integer[] integerArray = new Integer[]{this.dimensions[0], this.dimensions[1]};
        return integerArray;
    }

    public GraphicObject.UpdateStatus setTextArrayDimensions(Integer[] integerArray) {
        int n = this.dimensions[0] * this.dimensions[1];
        if (integerArray[0] * integerArray[1] != n) {
            FormattedText[] formattedTextArray = new FormattedText[integerArray[0] * integerArray[1]];
            for (int i = 0; i < integerArray[0] * integerArray[1]; ++i) {
                formattedTextArray[i] = new FormattedText();
                if (n < 1) continue;
                formattedTextArray[i].setFont(new Font(this.text[0].getFont()));
            }
            this.text = formattedTextArray;
        }
        this.dimensions[0] = integerArray[0];
        this.dimensions[1] = integerArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    public FormattedText[] getText() {
        FormattedText[] formattedTextArray = new FormattedText[this.dimensions[0] * this.dimensions[1]];
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            formattedTextArray[i] = new FormattedText(this.text[i]);
        }
        return formattedTextArray;
    }

    public GraphicObject.UpdateStatus setText(FormattedText[] formattedTextArray) {
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            this.text[i] = new FormattedText(formattedTextArray[i]);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public String[] getTextStrings() {
        String[] stringArray = new String[this.dimensions[0] * this.dimensions[1]];
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            stringArray[i] = new String(this.text[i].getText());
        }
        return stringArray;
    }

    public GraphicObject.UpdateStatus setTextStrings(String[] stringArray) {
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            this.text[i].setText(stringArray[i]);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Font getFont() {
        return this.text[0].getFont();
    }

    public GraphicObject.UpdateStatus setFont(Font font) {
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            this.text[i].setFont(font);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getFontStyle() {
        return this.text[0].getFont().getStyle();
    }

    public GraphicObject.UpdateStatus setFontStyle(Integer n) {
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            this.text[i].getFont().setStyle(n);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getFontColor() {
        return this.text[0].getFont().getColor();
    }

    public GraphicObject.UpdateStatus setFontColor(Integer n) {
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            this.text[i].getFont().setColor(n);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getFontSize() {
        return this.text[0].getFont().getSize();
    }

    public GraphicObject.UpdateStatus setFontSize(Double d) {
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            this.text[i].getFont().setSize(d);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getFontFractional() {
        return this.text[0].getFont().getFractional();
    }

    public GraphicObject.UpdateStatus setFontFractional(Boolean bl) {
        for (int i = 0; i < this.dimensions[0] * this.dimensions[1]; ++i) {
            this.text[i].getFont().setFractional(bl);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    protected static enum TextObjectProperty {
        TEXT,
        TEXT_ARRAY_DIMENSIONS;

    }
}

