/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.textObject;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.textObject.ClippableTextObject;

public class Text
extends ClippableTextObject {
    private double fontAngle = 0.0;
    private double[] position = new double[3];
    private double[][] corners = new double[4][3];
    private Alignment alignment = Alignment.CENTER;
    private boolean box = false;
    private double[] textBox = new double[2];
    private TextBoxMode textBoxMode = TextBoxMode.OFF;
    private boolean autoDimensioning = false;

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 225: {
                return TextProperty.FONTANGLE;
            }
            case 80: {
                return TextProperty.POSITION;
            }
            case 227: {
                return TextProperty.CORNERS;
            }
            case 247: {
                return TextProperty.ALIGNMENT;
            }
            case 248: {
                return TextProperty.BOX;
            }
            case 249: {
                return TextProperty.TEXTBOX;
            }
            case 250: {
                return TextProperty.TEXTBOXMODE;
            }
            case 251: {
                return TextProperty.AUTODIMENSIONING;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == TextProperty.FONTANGLE) {
            return this.getFontAngle();
        }
        if (object == TextProperty.POSITION) {
            return this.getPosition();
        }
        if (object == TextProperty.CORNERS) {
            return this.getCorners();
        }
        if (object == TextProperty.ALIGNMENT) {
            return this.getAlignment();
        }
        if (object == TextProperty.BOX) {
            return this.getBox();
        }
        if (object == TextProperty.TEXTBOX) {
            return this.getTextBox();
        }
        if (object == TextProperty.TEXTBOXMODE) {
            return this.getTextBoxMode();
        }
        if (object == TextProperty.AUTODIMENSIONING) {
            return this.getAutoDimensioning();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == TextProperty.FONTANGLE) {
            this.setFontAngle((Double)object2);
        } else if (object == TextProperty.POSITION) {
            this.setPosition((Double[])object2);
        } else if (object == TextProperty.CORNERS) {
            this.setCorners((Double[])object2);
        } else if (object == TextProperty.ALIGNMENT) {
            this.setAlignment((Integer)object2);
        } else if (object == TextProperty.BOX) {
            this.setBox((Boolean)object2);
        } else if (object == TextProperty.TEXTBOX) {
            this.setTextBox((Double[])object2);
        } else if (object == TextProperty.TEXTBOXMODE) {
            this.setTextBoxMode((Integer)object2);
        } else if (object == TextProperty.AUTODIMENSIONING) {
            this.setAutoDimensioning((Boolean)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getAlignment() {
        return this.getAlignmentAsEnum().ordinal();
    }

    public Alignment getAlignmentAsEnum() {
        return this.alignment;
    }

    public GraphicObject.UpdateStatus setAlignment(Integer n) {
        return this.setAlignmentAsEnum(Alignment.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setAlignmentAsEnum(Alignment alignment) {
        this.alignment = alignment;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getAutoDimensioning() {
        return this.autoDimensioning;
    }

    public GraphicObject.UpdateStatus setAutoDimensioning(Boolean bl) {
        this.autoDimensioning = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getBox() {
        return this.box;
    }

    public GraphicObject.UpdateStatus setBox(Boolean bl) {
        this.box = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getFontAngle() {
        return this.fontAngle;
    }

    public GraphicObject.UpdateStatus setFontAngle(Double d) {
        this.fontAngle = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getPosition() {
        Double[] doubleArray = new Double[]{this.position[0], this.position[1], this.position[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setPosition(Double[] doubleArray) {
        this.position[0] = doubleArray[0];
        this.position[1] = doubleArray[1];
        this.position[2] = doubleArray[2];
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getCorners() {
        Double[] doubleArray = new Double[12];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                doubleArray[3 * i + j] = this.corners[i][j];
            }
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setCorners(Double[] doubleArray) {
        if (doubleArray.length != 12) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.corners[0][0] = doubleArray[0];
        this.corners[0][1] = doubleArray[1];
        this.corners[0][2] = doubleArray[2];
        this.corners[1][0] = doubleArray[3];
        this.corners[1][1] = doubleArray[4];
        this.corners[1][2] = doubleArray[5];
        this.corners[2][0] = doubleArray[6];
        this.corners[2][1] = doubleArray[7];
        this.corners[2][2] = doubleArray[8];
        this.corners[3][0] = doubleArray[9];
        this.corners[3][1] = doubleArray[10];
        this.corners[3][2] = doubleArray[11];
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getTextBox() {
        Double[] doubleArray = new Double[]{this.textBox[0], this.textBox[1]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setTextBox(Double[] doubleArray) {
        this.textBox[0] = doubleArray[0];
        this.textBox[1] = doubleArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getTextBoxMode() {
        return this.getTextBoxModeAsEnum().ordinal();
    }

    public TextBoxMode getTextBoxModeAsEnum() {
        return this.textBoxMode;
    }

    public GraphicObject.UpdateStatus setTextBoxMode(Integer n) {
        return this.setTextBoxModeAsEnum(TextBoxMode.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setTextBoxModeAsEnum(TextBoxMode textBoxMode) {
        this.textBoxMode = textBoxMode;
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 18;
    }

    private static enum TextBoxMode {
        OFF,
        CENTERED,
        FILLED;


        public static TextBoxMode intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return OFF;
                }
                case 1: {
                    return CENTERED;
                }
                case 2: {
                    return FILLED;
                }
            }
            return null;
        }
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;


        public static Alignment intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return LEFT;
                }
                case 1: {
                    return CENTER;
                }
                case 2: {
                    return RIGHT;
                }
            }
            return null;
        }
    }

    private static enum TextProperty {
        FONTANGLE,
        POSITION,
        CORNERS,
        ALIGNMENT,
        BOX,
        TEXTBOX,
        TEXTBOXMODE,
        AUTODIMENSIONING;

    }
}

