/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.surface;

import org.scilab.modules.graphic_objects.contouredObject.ClippableContouredObject;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.lighting.ColorTriplet;
import org.scilab.modules.graphic_objects.lighting.Material;

public abstract class Surface
extends ClippableContouredObject {
    private boolean surfaceMode = false;
    private int colorMode = 0;
    private int colorFlag = 0;
    private int hiddenColor = 0;
    private Material material = new Material();

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 244: {
                return SurfaceProperty.SURFACEMODE;
            }
            case 245: {
                return SurfaceProperty.COLORMODE;
            }
            case 246: {
                return SurfaceProperty.COLORFLAG;
            }
            case 272: {
                return SurfaceProperty.HIDDENCOLOR;
            }
            case 343: {
                return ColorTriplet.ColorTripletProperty.AMBIENTCOLOR;
            }
            case 344: {
                return ColorTriplet.ColorTripletProperty.DIFFUSECOLOR;
            }
            case 345: {
                return ColorTriplet.ColorTripletProperty.SPECULARCOLOR;
            }
            case 346: {
                return Material.MaterialProperty.COLOR_MATERIAL;
            }
            case 347: {
                return Material.MaterialProperty.SHININESS;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object instanceof SurfaceProperty) {
            SurfaceProperty surfaceProperty = (SurfaceProperty)((Object)object);
            switch (surfaceProperty) {
                case SURFACEMODE: {
                    return this.getSurfaceMode();
                }
                case COLORMODE: {
                    return this.getColorMode();
                }
                case COLORFLAG: {
                    return this.getColorFlag();
                }
                case HIDDENCOLOR: {
                    return this.getHiddenColor();
                }
            }
        } else if (object instanceof Material.MaterialProperty) {
            Material.MaterialProperty materialProperty = (Material.MaterialProperty)((Object)object);
            switch (materialProperty) {
                case COLOR_MATERIAL: {
                    return this.getColorMaterialMode();
                }
                case SHININESS: {
                    return this.getMaterialShininess();
                }
            }
        } else if (object instanceof ColorTriplet.ColorTripletProperty) {
            ColorTriplet.ColorTripletProperty colorTripletProperty = (ColorTriplet.ColorTripletProperty)((Object)object);
            switch (colorTripletProperty) {
                case AMBIENTCOLOR: {
                    return this.getMaterialAmbientColor();
                }
                case DIFFUSECOLOR: {
                    return this.getMaterialDiffuseColor();
                }
                case SPECULARCOLOR: {
                    return this.getMaterialSpecularColor();
                }
            }
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object instanceof SurfaceProperty) {
            SurfaceProperty surfaceProperty = (SurfaceProperty)((Object)object);
            switch (surfaceProperty) {
                case SURFACEMODE: {
                    this.setSurfaceMode((Boolean)object2);
                    break;
                }
                case COLORMODE: {
                    this.setColorMode((Integer)object2);
                    break;
                }
                case COLORFLAG: {
                    this.setColorFlag((Integer)object2);
                    break;
                }
                case HIDDENCOLOR: {
                    this.setHiddenColor((Integer)object2);
                }
            }
        } else if (object instanceof Material.MaterialProperty) {
            Material.MaterialProperty materialProperty = (Material.MaterialProperty)((Object)object);
            switch (materialProperty) {
                case COLOR_MATERIAL: {
                    return this.setColorMaterialMode((Boolean)object2);
                }
                case SHININESS: {
                    return this.setMaterialShininess((Double)object2);
                }
            }
        } else if (object instanceof ColorTriplet.ColorTripletProperty) {
            ColorTriplet.ColorTripletProperty colorTripletProperty = (ColorTriplet.ColorTripletProperty)((Object)object);
            switch (colorTripletProperty) {
                case AMBIENTCOLOR: {
                    return this.setMaterialAmbientColor((Double[])object2);
                }
                case DIFFUSECOLOR: {
                    return this.setMaterialDiffuseColor((Double[])object2);
                }
                case SPECULARCOLOR: {
                    return this.setMaterialSpecularColor((Double[])object2);
                }
            }
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getSurfaceMode() {
        return this.surfaceMode;
    }

    public GraphicObject.UpdateStatus setSurfaceMode(Boolean bl) {
        this.surfaceMode = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getColorMode() {
        return this.colorMode;
    }

    public GraphicObject.UpdateStatus setColorMode(Integer n) {
        this.colorMode = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getColorFlag() {
        return this.colorFlag;
    }

    public GraphicObject.UpdateStatus setColorFlag(Integer n) {
        this.colorFlag = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getHiddenColor() {
        return this.hiddenColor;
    }

    public GraphicObject.UpdateStatus setHiddenColor(Integer n) {
        this.hiddenColor = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setColorMaterialMode(Boolean bl) {
        return this.material.setColorMaterialMode(bl);
    }

    public Boolean getColorMaterialMode() {
        return this.material.getColorMaterialMode();
    }

    public Double[] getMaterialAmbientColor() {
        return this.material.getAmbientColor();
    }

    public GraphicObject.UpdateStatus setMaterialAmbientColor(Double[] doubleArray) {
        return this.material.setAmbientColor(doubleArray);
    }

    public Double[] getMaterialDiffuseColor() {
        return this.material.getDiffuseColor();
    }

    public GraphicObject.UpdateStatus setMaterialDiffuseColor(Double[] doubleArray) {
        return this.material.setDiffuseColor(doubleArray);
    }

    public Double[] getMaterialSpecularColor() {
        return this.material.getSpecularColor();
    }

    public GraphicObject.UpdateStatus setMaterialSpecularColor(Double[] doubleArray) {
        return this.material.setSpecularColor(doubleArray);
    }

    public Double getMaterialShininess() {
        return this.material.getShininess();
    }

    public GraphicObject.UpdateStatus setMaterialShininess(Double d) {
        return this.material.setShininess(d);
    }

    public Material getMaterial() {
        return this.material;
    }

    public GraphicObject.UpdateStatus setMaterial(Material material) {
        if (material != null) {
            this.material = material;
        }
        return GraphicObject.UpdateStatus.Success;
    }

    private static enum SurfaceProperty {
        SURFACEMODE,
        COLORMODE,
        COLORFLAG,
        HIDDENCOLOR;

    }
}

