/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.lighting;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.lighting.ColorTriplet;

public class Light
extends GraphicObject {
    Double[] position;
    Double[] direction;
    LightType type;
    ColorTriplet lightColor;

    public Light() {
        this.lightColor = new ColorTriplet();
        this.position = new Double[]{0.0, 0.0, 1.0};
        this.direction = new Double[]{0.0, 0.0, 1.0};
        this.type = LightType.POINT;
        Double[] doubleArray = new Double[]{0.1, 0.1, 0.1};
        Double[] doubleArray2 = new Double[]{1.0, 1.0, 1.0};
        this.setAmbientColor(doubleArray);
        this.setDiffuseColor(doubleArray2);
        this.setSpecularColor(doubleArray2);
    }

    public Light(Light light) {
        this.position = new Double[3];
        this.direction = new Double[3];
        this.type = light.type;
        this.lightColor = new ColorTriplet(light.lightColor);
        this.setPosition(light.position);
        this.setDirection(light.direction);
    }

    @Override
    public void accept(Visitor visitor) {
    }

    public Double[] getPosition() {
        Double[] doubleArray = new Double[]{this.position[0], this.position[1], this.position[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setPosition(Double[] doubleArray) {
        if (doubleArray.length != 3) {
            return GraphicObject.UpdateStatus.Fail;
        }
        if (this.position[0] != doubleArray[0] || this.position[1] != doubleArray[1] || this.position[2] != doubleArray[2]) {
            this.position[0] = doubleArray[0];
            this.position[1] = doubleArray[1];
            this.position[2] = doubleArray[2];
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double[] getDirection() {
        Double[] doubleArray = new Double[]{this.direction[0], this.direction[1], this.direction[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setDirection(Double[] doubleArray) {
        if (doubleArray.length != 3) {
            return GraphicObject.UpdateStatus.Fail;
        }
        if (this.direction[0] != doubleArray[0] || this.direction[1] != doubleArray[1] || this.direction[2] != doubleArray[2]) {
            this.direction[0] = doubleArray[0];
            this.direction[1] = doubleArray[1];
            this.direction[2] = doubleArray[2];
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public GraphicObject.UpdateStatus setLightTypeAsInteger(Integer n) {
        if (n >= 0 && n < LightType.values().length) {
            if (this.type != LightType.values()[n]) {
                this.type = LightType.values()[n];
                return GraphicObject.UpdateStatus.Success;
            }
            return GraphicObject.UpdateStatus.NoChange;
        }
        return GraphicObject.UpdateStatus.Fail;
    }

    public Integer getLightTypeAsInteger() {
        return this.type.ordinal();
    }

    public GraphicObject.UpdateStatus setLightType(LightType lightType) {
        if (this.type != lightType) {
            this.type = lightType;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public LightType getLightType() {
        return this.type;
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 343: {
                return ColorTriplet.ColorTripletProperty.AMBIENTCOLOR;
            }
            case 344: {
                return ColorTriplet.ColorTripletProperty.DIFFUSECOLOR;
            }
            case 345: {
                return ColorTriplet.ColorTripletProperty.SPECULARCOLOR;
            }
            case 349: {
                return LightProperty.TYPE;
            }
            case 80: {
                return LightProperty.POSITION;
            }
            case 259: {
                return LightProperty.DIRECTION;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object instanceof ColorTriplet.ColorTripletProperty) {
            ColorTriplet.ColorTripletProperty colorTripletProperty = (ColorTriplet.ColorTripletProperty)((Object)object);
            switch (colorTripletProperty) {
                case AMBIENTCOLOR: {
                    return this.getAmbientColor();
                }
                case DIFFUSECOLOR: {
                    return this.getDiffuseColor();
                }
                case SPECULARCOLOR: {
                    return this.getSpecularColor();
                }
            }
        } else if (object instanceof LightProperty) {
            LightProperty lightProperty = (LightProperty)((Object)object);
            switch (lightProperty) {
                case TYPE: {
                    return this.getLightTypeAsInteger();
                }
                case POSITION: {
                    return this.getPosition();
                }
                case DIRECTION: {
                    return this.getDirection();
                }
            }
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object instanceof ColorTriplet.ColorTripletProperty) {
            ColorTriplet.ColorTripletProperty colorTripletProperty = (ColorTriplet.ColorTripletProperty)((Object)object);
            switch (colorTripletProperty) {
                case AMBIENTCOLOR: {
                    return this.setAmbientColor((Double[])object2);
                }
                case DIFFUSECOLOR: {
                    return this.setDiffuseColor((Double[])object2);
                }
                case SPECULARCOLOR: {
                    return this.setSpecularColor((Double[])object2);
                }
            }
        } else if (object instanceof LightProperty) {
            LightProperty lightProperty = (LightProperty)((Object)object);
            switch (lightProperty) {
                case TYPE: {
                    return this.setLightTypeAsInteger((Integer)object2);
                }
                case POSITION: {
                    return this.setPosition((Double[])object2);
                }
                case DIRECTION: {
                    return this.setDirection((Double[])object2);
                }
            }
        }
        return super.setProperty(object, object2);
    }

    public Double[] getAmbientColor() {
        return this.lightColor.getAmbientColor();
    }

    public GraphicObject.UpdateStatus setAmbientColor(Double[] doubleArray) {
        return this.lightColor.setAmbientColor(doubleArray);
    }

    public Double[] getDiffuseColor() {
        return this.lightColor.getDiffuseColor();
    }

    public GraphicObject.UpdateStatus setDiffuseColor(Double[] doubleArray) {
        return this.lightColor.setDiffuseColor(doubleArray);
    }

    public Double[] getSpecularColor() {
        return this.lightColor.getSpecularColor();
    }

    public GraphicObject.UpdateStatus setSpecularColor(Double[] doubleArray) {
        return this.lightColor.setSpecularColor(doubleArray);
    }

    @Override
    public Integer getType() {
        return 348;
    }

    public static enum LightType {
        DIRECTIONAL,
        POINT;


        public static LightType intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return DIRECTIONAL;
                }
                case 1: {
                    return POINT;
                }
            }
            return null;
        }
    }

    public static enum LightProperty {
        POSITION,
        DIRECTION,
        TYPE;

    }
}

