/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.legend;

import java.util.ArrayList;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.textObject.ClippableTextObject;
import org.scilab.modules.graphic_objects.textObject.FormattedText;
import org.scilab.modules.graphic_objects.textObject.TextObject;

public class Legend
extends ClippableTextObject {
    private ArrayList<Integer> links = new ArrayList(0);
    private LegendLocation legendLocation = LegendLocation.LOWER_CAPTION;
    private double[] position = new double[2];
    private double[] size = new double[2];
    private Integer marksCount = 3;
    private Double lineWidth = 0.1;

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 229: {
                return LegendProperty.LINKS;
            }
            case 230: {
                return LegendProperty.LINKSCOUNT;
            }
            case 231: {
                return LegendProperty.LEGENDLOCATION;
            }
            case 80: {
                return LegendProperty.POSITION;
            }
            case 81: {
                return LegendProperty.SIZE;
            }
            case 232: {
                return LegendProperty.MARKSCOUNT;
            }
            case 233: {
                return LegendProperty.LINEWIDTH;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == LegendProperty.LINKS) {
            return this.getValidLinks();
        }
        if (object == LegendProperty.LINKSCOUNT) {
            return this.getValidLinksCount();
        }
        if (object == LegendProperty.LEGENDLOCATION) {
            return this.getLegendLocation();
        }
        if (object == LegendProperty.POSITION) {
            return this.getPosition();
        }
        if (object == TextObject.TextObjectProperty.TEXT_ARRAY_DIMENSIONS) {
            return this.getValidTextArrayDimensions();
        }
        if (object == FormattedText.FormattedTextProperty.TEXT) {
            return this.getValidTextStrings();
        }
        if (object == LegendProperty.SIZE) {
            return this.getSize();
        }
        if (object == LegendProperty.MARKSCOUNT) {
            return this.getMarksCount();
        }
        if (object == LegendProperty.LINEWIDTH) {
            return this.getLineWidth();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == LegendProperty.LINKS) {
            this.setLinks((Integer[])object2);
        } else if (object == LegendProperty.LEGENDLOCATION) {
            this.setLegendLocation((Integer)object2);
        } else if (object == LegendProperty.POSITION) {
            this.setPosition((Double[])object2);
        } else if (object == LegendProperty.MARKSCOUNT) {
            this.setMarksCount((Integer)object2);
        } else if (object == LegendProperty.LINEWIDTH) {
            this.setLineWidth((Double)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getLegendLocation() {
        return this.getLegendLocationAsEnum().ordinal();
    }

    public LegendLocation getLegendLocationAsEnum() {
        return this.legendLocation;
    }

    public GraphicObject.UpdateStatus setLegendLocation(Integer n) {
        this.setLegendLocationAsEnum(LegendLocation.intToEnum(n));
        return GraphicObject.UpdateStatus.Success;
    }

    public GraphicObject.UpdateStatus setLegendLocationAsEnum(LegendLocation legendLocation) {
        this.legendLocation = legendLocation;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer[] getValidLinks() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(0);
        for (int i = 0; i < this.links.size(); ++i) {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(this.links.get(i));
            if (graphicObject == null) continue;
            arrayList.add(this.links.get(i));
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public Integer getValidLinksCount() {
        int n = 0;
        for (int i = 0; i < this.links.size(); ++i) {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(this.links.get(i));
            if (graphicObject == null) continue;
            ++n;
        }
        return n;
    }

    public Integer[] getLinks() {
        Integer[] integerArray = new Integer[this.links.size()];
        for (int i = 0; i < this.links.size(); ++i) {
            integerArray[i] = this.links.get(i);
        }
        return integerArray;
    }

    public Integer getLinksCount() {
        return this.links.size();
    }

    public GraphicObject.UpdateStatus setLinks(Integer[] integerArray) {
        if (!this.links.isEmpty()) {
            this.links.clear();
        }
        for (int i = 0; i < integerArray.length; ++i) {
            this.links.add(integerArray[i]);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getMarksCount() {
        return this.marksCount;
    }

    public GraphicObject.UpdateStatus setMarksCount(Integer n) {
        if (!this.marksCount.equals(n)) {
            this.marksCount = n;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Double getLineWidth() {
        return this.lineWidth;
    }

    public GraphicObject.UpdateStatus setLineWidth(Double d) {
        if (!this.lineWidth.equals(d)) {
            this.lineWidth = d;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Integer[] getValidTextArrayDimensions() {
        return new Integer[]{this.getValidLinksCount(), 1};
    }

    public String[] getValidTextStrings() {
        ArrayList<String> arrayList = new ArrayList<String>(0);
        for (int i = 0; i < this.links.size(); ++i) {
            GraphicObject graphicObject = GraphicController.getController().getObjectFromId(this.links.get(this.links.size() - i - 1));
            if (graphicObject == null) continue;
            arrayList.add(this.text[i].getText());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public GraphicObject.UpdateStatus setLinks(ArrayList<Integer> arrayList) {
        this.links = arrayList;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getPosition() {
        Double[] doubleArray = new Double[]{this.position[0], this.position[1]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setPosition(Double[] doubleArray) {
        this.position[0] = doubleArray[0];
        this.position[1] = doubleArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getSize() {
        Double[] doubleArray = new Double[]{this.size[0], this.size[1]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setSize(Double[] doubleArray) {
        this.size[0] = doubleArray[0];
        this.size[1] = doubleArray[1];
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 12;
    }

    public static enum LegendLocation {
        IN_UPPER_RIGHT,
        IN_UPPER_LEFT,
        IN_LOWER_RIGHT,
        IN_LOWER_LEFT,
        OUT_UPPER_RIGHT,
        OUT_UPPER_LEFT,
        OUT_LOWER_RIGHT,
        OUT_LOWER_LEFT,
        UPPER_CAPTION,
        LOWER_CAPTION,
        BY_COORDINATES;


        public static LegendLocation intToEnum(Integer n) {
            switch (n) {
                case 0: {
                    return IN_UPPER_RIGHT;
                }
                case 1: {
                    return IN_UPPER_LEFT;
                }
                case 2: {
                    return IN_LOWER_RIGHT;
                }
                case 3: {
                    return IN_LOWER_LEFT;
                }
                case 4: {
                    return OUT_UPPER_RIGHT;
                }
                case 5: {
                    return OUT_UPPER_LEFT;
                }
                case 6: {
                    return OUT_LOWER_RIGHT;
                }
                case 7: {
                    return OUT_LOWER_LEFT;
                }
                case 8: {
                    return UPPER_CAPTION;
                }
                case 9: {
                    return LOWER_CAPTION;
                }
                case 10: {
                    return BY_COORDINATES;
                }
            }
            return null;
        }
    }

    private static enum LegendProperty {
        LINKS,
        LINKSCOUNT,
        LEGENDLOCATION,
        POSITION,
        SIZE,
        MARKSCOUNT,
        LINEWIDTH;

    }
}

