/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.label;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicObject.Visitor;
import org.scilab.modules.graphic_objects.textObject.TextObject;

public class Label
extends TextObject {
    private double fontAngle = 0.0;
    private boolean autoPosition = false;
    private double[] position = new double[3];
    private double[][] corners = new double[4][3];
    private boolean autoRotation = false;

    public Label() {
        Integer[] integerArray = new Integer[]{1, 1};
        String[] stringArray = new String[]{""};
        this.setTextArrayDimensions(integerArray);
        this.setTextStrings(stringArray);
    }

    @Override
    public Label clone() {
        Label label = (Label)super.clone();
        label.position = new double[3];
        for (int i = 0; i < this.position.length; ++i) {
            label.position[i] = this.position[i];
        }
        return label;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 225: {
                return LabelProperty.FONTANGLE;
            }
            case 226: {
                return LabelProperty.AUTOPOSITION;
            }
            case 80: {
                return LabelProperty.POSITION;
            }
            case 227: {
                return LabelProperty.CORNERS;
            }
            case 228: {
                return LabelProperty.AUTOROTATION;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == LabelProperty.FONTANGLE) {
            return this.getFontAngle();
        }
        if (object == LabelProperty.AUTOPOSITION) {
            return this.getAutoPosition();
        }
        if (object == LabelProperty.POSITION) {
            return this.getPosition();
        }
        if (object == LabelProperty.CORNERS) {
            return this.getCorners();
        }
        if (object == LabelProperty.AUTOROTATION) {
            return this.getAutoRotation();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == LabelProperty.FONTANGLE) {
            this.setFontAngle((Double)object2);
        } else if (object == LabelProperty.AUTOPOSITION) {
            this.setAutoPosition((Boolean)object2);
        } else if (object == LabelProperty.POSITION) {
            this.setPosition((Double[])object2);
        } else if (object == LabelProperty.CORNERS) {
            this.setCorners((Double[])object2);
        } else if (object == LabelProperty.AUTOROTATION) {
            this.setAutoRotation((Boolean)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getAutoPosition() {
        return this.autoPosition;
    }

    public GraphicObject.UpdateStatus setAutoPosition(Boolean bl) {
        this.autoPosition = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getAutoRotation() {
        return this.autoRotation;
    }

    public GraphicObject.UpdateStatus setAutoRotation(Boolean bl) {
        this.autoRotation = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getFontAngle() {
        return this.fontAngle;
    }

    public GraphicObject.UpdateStatus setFontAngle(Double d) {
        if (this.autoRotation) {
            this.autoRotation = false;
        }
        this.fontAngle = d;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getPosition() {
        Double[] doubleArray = new Double[]{this.position[0], this.position[1], this.position[2]};
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setPosition(Double[] doubleArray) {
        if (this.autoPosition) {
            this.autoPosition = false;
        }
        this.position[0] = doubleArray[0];
        this.position[1] = doubleArray[1];
        this.position[2] = doubleArray[2];
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getCorners() {
        Double[] doubleArray = new Double[12];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                doubleArray[3 * i + j] = this.corners[i][j];
            }
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setCorners(Double[] doubleArray) {
        if (doubleArray.length != 12) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.corners[0][0] = doubleArray[0];
        this.corners[0][1] = doubleArray[1];
        this.corners[0][2] = doubleArray[2];
        this.corners[1][0] = doubleArray[3];
        this.corners[1][1] = doubleArray[4];
        this.corners[1][2] = doubleArray[5];
        this.corners[2][0] = doubleArray[6];
        this.corners[2][1] = doubleArray[7];
        this.corners[2][2] = doubleArray[8];
        this.corners[3][0] = doubleArray[9];
        this.corners[3][1] = doubleArray[10];
        this.corners[3][2] = doubleArray[11];
        return GraphicObject.UpdateStatus.Success;
    }

    @Override
    public Integer getType() {
        return 11;
    }

    public static enum LabelProperty {
        FONTANGLE,
        AUTOPOSITION,
        POSITION,
        CORNERS,
        AUTOROTATION;

    }
}

