/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.graphicModel;

import java.util.HashMap;
import java.util.Map;
import org.scilab.modules.graphic_objects.arc.Arc;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.axis.Axis;
import org.scilab.modules.graphic_objects.compound.Compound;
import org.scilab.modules.graphic_objects.console.Console;
import org.scilab.modules.graphic_objects.datatip.Datatip;
import org.scilab.modules.graphic_objects.fec.Fec;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.imageplot.Grayplot;
import org.scilab.modules.graphic_objects.imageplot.Matplot;
import org.scilab.modules.graphic_objects.label.Label;
import org.scilab.modules.graphic_objects.legend.Legend;
import org.scilab.modules.graphic_objects.lighting.Light;
import org.scilab.modules.graphic_objects.polyline.Polyline;
import org.scilab.modules.graphic_objects.rectangle.Rectangle;
import org.scilab.modules.graphic_objects.surface.Fac3d;
import org.scilab.modules.graphic_objects.surface.Plot3d;
import org.scilab.modules.graphic_objects.textObject.Text;
import org.scilab.modules.graphic_objects.uibar.progressionbar.Progressionbar;
import org.scilab.modules.graphic_objects.uibar.waitbar.Waitbar;
import org.scilab.modules.graphic_objects.uicontextmenu.Uicontextmenu;
import org.scilab.modules.graphic_objects.uicontrol.checkbox.CheckBox;
import org.scilab.modules.graphic_objects.uicontrol.edit.Edit;
import org.scilab.modules.graphic_objects.uicontrol.edit.Spinner;
import org.scilab.modules.graphic_objects.uicontrol.frame.Frame;
import org.scilab.modules.graphic_objects.uicontrol.frame.border.FrameBorder;
import org.scilab.modules.graphic_objects.uicontrol.layer.Layer;
import org.scilab.modules.graphic_objects.uicontrol.listbox.ListBox;
import org.scilab.modules.graphic_objects.uicontrol.popupmenu.PopupMenu;
import org.scilab.modules.graphic_objects.uicontrol.pushbutton.PushButton;
import org.scilab.modules.graphic_objects.uicontrol.radiobutton.RadioButton;
import org.scilab.modules.graphic_objects.uicontrol.slider.Slider;
import org.scilab.modules.graphic_objects.uicontrol.tab.Tab;
import org.scilab.modules.graphic_objects.uicontrol.table.Table;
import org.scilab.modules.graphic_objects.uicontrol.uiimage.UiImage;
import org.scilab.modules.graphic_objects.uicontrol.uitext.UiText;
import org.scilab.modules.graphic_objects.uimenu.Uimenu;
import org.scilab.modules.graphic_objects.vectfield.Champ;
import org.scilab.modules.graphic_objects.vectfield.Segs;

public final class GraphicModel {
    private static GraphicModel me;
    private static GraphicObject figureModel;
    private static GraphicObject axesModel;
    private Map<Integer, GraphicObject> allObjects = new HashMap<Integer, GraphicObject>();

    private GraphicModel() {
    }

    public static GraphicModel getModel() {
        if (me == null) {
            me = new GraphicModel();
        }
        return me;
    }

    public static Figure getFigureModel() {
        return (Figure)figureModel;
    }

    public static Axes getAxesModel() {
        return (Axes)axesModel;
    }

    public GraphicObject getObjectFromId(Integer n) {
        return this.allObjects.get(n);
    }

    public Object getNullProperty(Integer n, String string) {
        GraphicObject graphicObject = this.allObjects.get(n);
        return graphicObject.getNullProperty(string);
    }

    public Object getProperty(Integer n, int n2) {
        GraphicObject graphicObject = this.allObjects.get(n);
        if (graphicObject != null) {
            Object object = graphicObject.getPropertyFromName(n2);
            return graphicObject.getProperty(object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicObject.UpdateStatus setProperty(Integer n, int n2, Object object) {
        GraphicObject graphicObject = this.allObjects.get(n);
        if (graphicObject != null) {
            GraphicObject graphicObject2 = graphicObject;
            synchronized (graphicObject2) {
                Object object2 = graphicObject.getPropertyFromName(n2);
                return graphicObject.setProperty(object2, object);
            }
        }
        return GraphicObject.UpdateStatus.Fail;
    }

    public Integer createObject(Integer n, GraphicObject.Type type) {
        GraphicObject graphicObject = this.createTypedObject(type);
        if (graphicObject != null) {
            this.allObjects.put(n, graphicObject);
            graphicObject.setIdentifier(n);
            return n;
        }
        return 0;
    }

    public Integer cloneObject(Integer n, Integer n2) {
        GraphicObject graphicObject = this.allObjects.get(n);
        GraphicObject graphicObject2 = graphicObject.clone();
        graphicObject2.setIdentifier(n2);
        this.allObjects.put(n2, graphicObject2);
        return n2;
    }

    private GraphicObject createTypedObject(GraphicObject.Type type) {
        GraphicObject graphicObject = null;
        switch (type) {
            case ARC: {
                graphicObject = new Arc();
                break;
            }
            case AXES: {
                graphicObject = new Axes();
                break;
            }
            case AXESMODEL: {
                graphicObject = new Axes();
                graphicObject.setValid(false);
                axesModel = graphicObject;
                break;
            }
            case AXIS: {
                graphicObject = new Axis();
                break;
            }
            case CHAMP: {
                graphicObject = new Champ();
                break;
            }
            case COMPOUND: {
                graphicObject = new Compound();
                break;
            }
            case FAC3D: {
                graphicObject = new Fac3d();
                break;
            }
            case FEC: {
                graphicObject = new Fec();
                break;
            }
            case FIGURE: {
                graphicObject = new Figure();
                break;
            }
            case FIGUREMODEL: {
                graphicObject = new Figure();
                graphicObject.setValid(false);
                figureModel = graphicObject;
                break;
            }
            case GRAYPLOT: {
                graphicObject = new Grayplot();
                break;
            }
            case LABEL: {
                graphicObject = new Label();
                break;
            }
            case LEGEND: {
                graphicObject = new Legend();
                break;
            }
            case MATPLOT: {
                graphicObject = new Matplot();
                break;
            }
            case PLOT3D: {
                graphicObject = new Plot3d();
                break;
            }
            case POLYLINE: {
                graphicObject = new Polyline();
                break;
            }
            case RECTANGLE: {
                graphicObject = new Rectangle();
                break;
            }
            case SEGS: {
                graphicObject = new Segs();
                break;
            }
            case TEXT: {
                graphicObject = new Text();
                break;
            }
            case CHECKBOX: {
                graphicObject = new CheckBox();
                break;
            }
            case EDIT: {
                graphicObject = new Edit();
                break;
            }
            case SPINNER: {
                graphicObject = new Spinner();
                break;
            }
            case FRAME: {
                graphicObject = new Frame();
                break;
            }
            case IMAGE: {
                graphicObject = new UiImage();
                break;
            }
            case LISTBOX: {
                graphicObject = new ListBox();
                break;
            }
            case POPUPMENU: {
                graphicObject = new PopupMenu();
                break;
            }
            case PUSHBUTTON: {
                graphicObject = new PushButton();
                break;
            }
            case RADIOBUTTON: {
                graphicObject = new RadioButton();
                break;
            }
            case SLIDER: {
                graphicObject = new Slider();
                break;
            }
            case TABLE: {
                graphicObject = new Table();
                break;
            }
            case UITEXT: {
                graphicObject = new UiText();
                break;
            }
            case UIMENU: {
                graphicObject = new Uimenu();
                break;
            }
            case UIMENUMODEL: {
                graphicObject = new Uimenu();
                graphicObject.setValid(false);
                break;
            }
            case UICONTEXTMENU: {
                graphicObject = new Uicontextmenu();
                break;
            }
            case CONSOLE: {
                graphicObject = Console.getConsole();
                ((Console)graphicObject).setScilabMode(Console.ScilabMode.NW);
                break;
            }
            case JAVACONSOLE: {
                graphicObject = Console.getConsole();
                ((Console)graphicObject).setScilabMode(Console.ScilabMode.STD);
                break;
            }
            case PROGRESSIONBAR: {
                graphicObject = new Progressionbar();
                break;
            }
            case WAITBAR: {
                graphicObject = new Waitbar();
                break;
            }
            case LIGHT: {
                graphicObject = new Light();
                break;
            }
            case DATATIP: {
                graphicObject = new Datatip();
                break;
            }
            case TAB: {
                graphicObject = new Tab();
                break;
            }
            case LAYER: {
                graphicObject = new Layer();
                break;
            }
            case BORDER: {
                graphicObject = new FrameBorder();
                break;
            }
            case FRAME_SCROLLABLE: {
                graphicObject = new Frame();
                ((Frame)graphicObject).setScrollable(true);
                break;
            }
            default: {
                graphicObject = null;
            }
        }
        return graphicObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(Integer n) {
        GraphicObject graphicObject;
        GraphicObject graphicObject2 = graphicObject = this.allObjects.get(n);
        synchronized (graphicObject2) {
            this.allObjects.remove(n);
        }
    }
}

