/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.graphicController;

import java.awt.GraphicsEnvironment;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.scilab.modules.graphic_objects.graphicModel.GraphicModel;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicView.GedTreeView;
import org.scilab.modules.graphic_objects.graphicView.GraphicView;
import org.scilab.modules.graphic_objects.graphicView.GuiLogView;
import org.scilab.modules.graphic_objects.polyline.Polyline;

public class GraphicController {
    private static boolean MVCViewEnable = false;
    private static boolean debugEnable = false;
    private static boolean infoEnable = false;
    private static Integer lastId = 0;
    private static volatile Set<GraphicView> allViews = Collections.synchronizedSet(new HashSet());
    private static GraphicController me = null;

    private static void INFO(String string) {
        if (infoEnable) {
            System.err.println("[CONTROLLER - INFO] : " + string);
        }
    }

    private static void DEBUG(String string) {
        if (debugEnable) {
            System.err.println("[CONTROLLER - DEBUG] : " + string);
        }
    }

    private GraphicController() {
        if (!GraphicsEnvironment.isHeadless() && MVCViewEnable) {
            this.register(GuiLogView.createGuiLogView());
            this.register(GedTreeView.create());
        }
    }

    public static GraphicController getController() {
        if (me == null) {
            me = new GraphicController();
        }
        return me;
    }

    public void register(GraphicView graphicView) {
        GraphicController.INFO("Register view : " + graphicView.toString());
        allViews.add(graphicView);
    }

    public void unregister(GraphicView graphicView) {
        GraphicController.INFO("Unregister view : " + graphicView.toString());
        allViews.remove(graphicView);
    }

    public Integer createUID() {
        lastId = lastId + 1;
        return lastId;
    }

    public GraphicObject getObjectFromId(Integer n) {
        return GraphicModel.getModel().getObjectFromId(n);
    }

    public boolean setProperty(Integer n, int n2, Object object) {
        try {
            switch (GraphicModel.getModel().setProperty(n, n2, object)) {
                case Success: {
                    this.objectUpdate(n, n2);
                    return true;
                }
                case NoChange: {
                    return true;
                }
                case Fail: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception exception) {
            GraphicController.DEBUG("====== Exception caught ======");
            GraphicController.DEBUG("setProperty : " + n + " " + n2);
            exception.printStackTrace();
            GraphicController.DEBUG("====== Exception caught ======");
            return false;
        }
    }

    public Object getProperty(Integer n, int n2) {
        try {
            return GraphicModel.getModel().getProperty(n, n2);
        }
        catch (Exception exception) {
            GraphicController.DEBUG("====== Exception caught ======");
            GraphicController.DEBUG("getProperty : [" + n + "] " + n2);
            exception.printStackTrace();
            GraphicController.DEBUG("====== Exception caught ======");
            return null;
        }
    }

    public Object getNullProperty(Integer n, String string) {
        return GraphicModel.getModel().getNullProperty(n, string);
    }

    public Integer askObject(GraphicObject.Type type, boolean bl) {
        try {
            Integer n = this.createUID();
            GraphicModel.getModel().createObject(n, type);
            if (bl) {
                this.objectCreated(n);
            }
            return n;
        }
        catch (Exception exception) {
            GraphicController.DEBUG("====== Exception caught ======");
            GraphicController.DEBUG(" askObject type = " + type.name());
            exception.printStackTrace();
            GraphicController.DEBUG("====== Exception caught ======");
            return 0;
        }
    }

    public Integer cloneObject(Integer n, boolean bl) {
        try {
            Integer n2 = this.createUID();
            GraphicModel.getModel().cloneObject(n, n2);
            if (bl) {
                this.objectCreated(n2);
            }
            return n2;
        }
        catch (Exception exception) {
            GraphicController.DEBUG("====== Exception caught ======");
            GraphicController.DEBUG("cloneObject id = " + n);
            exception.printStackTrace();
            GraphicController.DEBUG("====== Exception caught ======");
            return 0;
        }
    }

    public Integer cloneObject(Integer n) {
        return this.cloneObject(n, true);
    }

    public Integer askObject(GraphicObject.Type type) {
        return this.askObject(type, true);
    }

    public void deleteObject(Integer n) {
        try {
            this.objectDeleted(n);
            GraphicModel.getModel().deleteObject(n);
        }
        catch (Exception exception) {
            GraphicController.DEBUG("====== Exception caught ======");
            GraphicController.DEBUG("deleteObject id = " + n);
            exception.printStackTrace();
            GraphicController.DEBUG("====== Exception caught ======");
        }
    }

    public void objectCreated(final Integer n) {
        Vector<1> vector = new Vector<1>();
        try {
            for (final GraphicView object : allViews) {
                vector.add(new Runnable(){

                    @Override
                    public void run() {
                        object.createObject(n);
                    }
                });
            }
            for (Runnable runnable : vector) {
                runnable.run();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
        }
    }

    public void objectUpdate(final Integer n, final int n2) {
        Vector<2> vector = new Vector<2>();
        try {
            for (final GraphicView object : allViews) {
                vector.add(new Runnable(){

                    @Override
                    public void run() {
                        object.updateObject(n, n2);
                    }
                });
            }
            for (Runnable runnable : vector) {
                runnable.run();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
        }
    }

    public void objectDeleted(final Integer n) {
        Vector<3> vector = new Vector<3>();
        try {
            for (final GraphicView object : allViews) {
                vector.add(new Runnable(){

                    @Override
                    public void run() {
                        object.deleteObject(n);
                    }
                });
            }
            for (Runnable runnable : vector) {
                runnable.run();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
        }
    }

    public void setGraphicObjectRelationship(Integer n, Integer n2) {
        Object object;
        Object object2 = this.getProperty(n2, 24);
        if (object2 != null && object2 instanceof Integer) {
            object = (Integer)object2;
            if (object == n) {
                return;
            }
            if ((Integer)object != 0) {
                this.getObjectFromId((Integer)object).removeChild(n2);
            }
        }
        if (n != null && n != 0 && (object = this.getObjectFromId(n)) != null) {
            ((GraphicObject)object).addChild(n2);
        }
        this.setProperty(n2, 24, n);
        if (object2 != null && object2 instanceof Integer && (Integer)object2 != 0) {
            this.objectUpdate((Integer)object2, 22);
        }
        if (n != null && n != 0) {
            this.objectUpdate(n, 22);
        }
    }

    public void removeRelationShipAndDelete(Integer n) {
        Integer[] integerArray;
        GraphicObject graphicObject = this.getObjectFromId(n);
        if (graphicObject == null) {
            return;
        }
        if (graphicObject.getType() == 15) {
            for (Integer n2 : integerArray = ((Polyline)graphicObject).getDatatips()) {
                this.deleteObject(n2);
            }
        }
        if ((integerArray = graphicObject.getParent()) != null && integerArray.intValue() != 0) {
            this.getObjectFromId((Integer)integerArray).removeChild(n);
            this.objectUpdate((Integer)integerArray, 22);
            this.objectUpdate((Integer)integerArray, 350);
        }
        graphicObject.setValid(false);
        this.recursiveDeleteChildren(graphicObject);
        this.deleteObject(n);
    }

    private void recursiveDeleteChildren(GraphicObject graphicObject) {
        Integer[] integerArray = graphicObject.getChildren();
        for (int i = 0; i < integerArray.length; ++i) {
            GraphicObject graphicObject2 = this.getObjectFromId(integerArray[i]);
            graphicObject2.setValid(false);
            this.recursiveDeleteChildren(graphicObject2);
            this.deleteObject(integerArray[i]);
        }
    }
}

